/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorPrepareException;
import org.eclipse.fordiac.ide.model.eval.st.StructuredTextEvaluator;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.ECTransition;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextalgorithm.util.StructuredTextParseUtil;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpressionSource;
import org.eclipse.xtext.EcoreUtil2;

public class ECTransitionEvaluator
extends StructuredTextEvaluator {
    private final ECTransition transition;
    private STExpressionSource parseResult;

    public ECTransitionEvaluator(ECTransition transition, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super("anonymous", context, variables, parent);
        this.transition = transition;
    }

    public void prepare() {
        if (this.parseResult == null) {
            ArrayList errors = new ArrayList();
            ArrayList warnings = new ArrayList();
            ArrayList infos = new ArrayList();
            this.parseResult = StructuredTextParseUtil.parse((String)this.transition.getConditionExpression(), (INamedElement)IecTypes.ElementaryTypes.BOOL, (LibraryElement)((LibraryElement)EcoreUtil2.getContainerOfType((EObject)this.transition, FBType.class)), errors, warnings, infos);
            errors.forEach(arg_0 -> ((ECTransitionEvaluator)this).error(arg_0));
            warnings.forEach(arg_0 -> ((ECTransitionEvaluator)this).warn(arg_0));
            infos.forEach(arg_0 -> ((ECTransitionEvaluator)this).info(arg_0));
            if (this.parseResult == null) {
                throw new EvaluatorPrepareException(errors.stream().collect(Collectors.joining(", ")), (Evaluator)this);
            }
        }
    }

    public void cleanup() {
        this.parseResult = null;
    }

    public Value evaluate() throws InterruptedException {
        this.prepare();
        return this.evaluateExpression((STExpression)this.trap(this.parseResult.getExpression()));
    }

    public ECTransition getSourceElement() {
        return this.transition;
    }

    public Set<String> getDependencies() {
        this.prepare();
        if (this.parseResult != null) {
            return StructuredTextParseUtil.collectUsedTypes((EObject)this.parseResult);
        }
        return Collections.emptySet();
    }
}

