/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.st;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STGlobalConstsSource;
import org.eclipse.fordiac.ide.globalconstantseditor.globalConstants.STVarGlobalDeclarationBlock;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.BoolType;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.EvaluatorFactory;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.function.Functions;
import org.eclipse.fordiac.ide.model.eval.function.StandardFunctions;
import org.eclipse.fordiac.ide.model.eval.st.Messages;
import org.eclipse.fordiac.ide.model.eval.value.AnyStringValue;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.BoolValue;
import org.eclipse.fordiac.ide.model.eval.value.StringValue;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.value.WStringValue;
import org.eclipse.fordiac.ide.model.eval.variable.FBVariable;
import org.eclipse.fordiac.ide.model.eval.variable.GenericVariable;
import org.eclipse.fordiac.ide.model.eval.variable.PartialVariable;
import org.eclipse.fordiac.ide.model.eval.variable.StringCharacterVariable;
import org.eclipse.fordiac.ide.model.eval.variable.StructVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.eval.variable.WStringCharacterVariable;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.BaseFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.GlobalConstants;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeature;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallNamedOutputArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateAndTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STDateLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElseIfPart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElsePart;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STEnumLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNop;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STReturn;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSingleArrayInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitElement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStructInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTimeOfDayLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;

public abstract class StructuredTextEvaluator
extends AbstractEvaluator {
    public static final String RETURN_VARIABLE_NAME = "";
    private final String name;
    private final Map<String, Variable<?>> variables;
    private final Map<String, Variable<?>> cachedGlobalConstants = new HashMap();

    protected StructuredTextEvaluator(String name, Variable<?> context, Iterable<Variable<?>> variables, Evaluator parent) {
        super(context, parent);
        this.name = name;
        this.variables = Stream.concat(StreamSupport.stream(variables.spliterator(), false), Stream.of(context)).filter(Objects::nonNull).collect(Collectors.toMap(Variable::getName, Function.identity(), (oldValue, newValue) -> newValue));
    }

    public Map<? extends ICallable, ? extends Evaluator> getChildren() {
        return Collections.emptyMap();
    }

    public Map<String, Variable<?>> getVariables() {
        return this.variables;
    }

    public void reset(Iterable<Variable<?>> variables) {
    }

    protected Variable<?> findVariable(VarDeclaration variable) {
        FBVariable fbVariable;
        Variable result;
        Variable variable2 = this.getContext();
        if (variable2 instanceof FBVariable && (result = (Variable)(fbVariable = (FBVariable)variable2).getMembers().get(variable.getName())) != null) {
            return result;
        }
        return StructuredTextEvaluator.evaluateConstantInitialization(variable);
    }

    protected Variable<?> findVariable(AdapterDeclaration variable) {
        return (Variable)((FBVariable)this.getContext()).getValue().getMembers().get(variable.getName());
    }

    protected Variable<?> findVariable(FB variable) {
        return (Variable)((FBVariable)this.getContext()).getValue().getMembers().get(variable.getName());
    }

    protected Variable<?> findVariable(STVarDeclaration variable) throws EvaluatorException, InterruptedException {
        String globalConstantName = StructuredTextEvaluator.getGlobalConstantName(variable);
        if (globalConstantName != null) {
            Variable<?> cachedGlobalConstant = this.cachedGlobalConstants.get(globalConstantName);
            if (cachedGlobalConstant != null) {
                return cachedGlobalConstant;
            }
            return this.evaluateGlobalConstantInitialization(variable);
        }
        Variable<?> result = this.variables.get(variable.getName());
        if (result != null) {
            return result;
        }
        return this.evaluateVariableInitialization(variable);
    }

    protected Variable<?> findVariable(ICallable variable) {
        Variable<?> result = this.variables.get(variable.getName());
        if (result != null) {
            return result;
        }
        return this.variables.get(RETURN_VARIABLE_NAME);
    }

    protected Variable<?> evaluateVariableInitialization(STVarDeclaration decl) throws EvaluatorException, InterruptedException {
        Variable variable = VariableOperations.newVariable((String)decl.getName(), (INamedElement)this.evaluateType(decl));
        this.variables.put(variable.getName(), variable);
        return this.evaluateInitializerExpression(variable, decl.getDefaultValue());
    }

    protected Variable<?> evaluateGlobalConstantInitialization(STVarDeclaration decl) throws EvaluatorException, InterruptedException {
        Variable variable = VariableOperations.newVariable((String)StructuredTextEvaluator.getGlobalConstantName(decl), (INamedElement)this.evaluateType(decl));
        this.cachedGlobalConstants.put(variable.getName(), variable);
        return this.evaluateInitializerExpression(variable, decl.getDefaultValue());
    }

    protected static Variable<?> evaluateConstantInitialization(VarDeclaration decl) {
        Variable variable;
        EObject eObject;
        EObject eObject2 = eObject = decl.eContainer();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GlobalConstants.class, BaseFBType.class}, (Object)eObject2, n)) {
                case 0: {
                    GlobalConstants globalConstants = (GlobalConstants)eObject;
                    if (!globalConstants.getConstants().contains((Object)decl)) {
                        eObject2 = eObject;
                        n = 1;
                        continue block4;
                    }
                    variable = VariableOperations.newVariable((VarDeclaration)decl);
                    break block4;
                }
                case 1: {
                    BaseFBType baseFBType = (BaseFBType)eObject;
                    if (!baseFBType.getInternalConstVars().contains((Object)decl)) {
                        eObject2 = eObject;
                        n = 2;
                        continue block4;
                    }
                    variable = VariableOperations.newVariable((VarDeclaration)decl);
                    break block4;
                }
                default: {
                    throw new NoSuchElementException(MessageFormat.format(Messages.StructuredTextEvaluator_DeclarationNotAConstant, decl.getQualifiedName()));
                }
            }
            break;
        }
        return variable;
    }

    protected INamedElement evaluateType(STVarDeclaration declaration) throws EvaluatorException, InterruptedException {
        DataType type;
        INamedElement iNamedElement;
        INamedElement iNamedElement2 = iNamedElement = declaration.getType();
        int n = 0;
        block4: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AnyStringType.class, DataType.class}, (Object)iNamedElement2, n)) {
                case 0: {
                    AnyStringType anyStringType = (AnyStringType)iNamedElement;
                    if (declaration.getMaxLength() == null) {
                        iNamedElement2 = iNamedElement;
                        n = 1;
                        continue block4;
                    }
                    DataType dataType2 = STCoreUtil.newStringType((AnyStringType)anyStringType, (int)ValueOperations.asInteger((Value)this.evaluateExpression(declaration.getMaxLength())));
                    break block4;
                }
                case 1: {
                    DataType dataType;
                    DataType dataType2 = dataType = (DataType)iNamedElement;
                    break block4;
                }
                default: {
                    DataType dataType2 = type = null;
                }
            }
            break;
        }
        if (declaration.isArray()) {
            if (declaration.getRanges().isEmpty()) {
                return STCoreUtil.newArrayType((DataType)type, declaration.getCount().stream().map(unused -> DataFactory.eINSTANCE.createSubrange()).toList());
            }
            ArrayList<Subrange> subranges = new ArrayList<Subrange>(declaration.getRanges().size());
            for (STExpression range : declaration.getRanges()) {
                subranges.add(this.evaluateSubrange(range));
            }
            return STCoreUtil.newArrayType((DataType)type, subranges);
        }
        return type;
    }

    protected Subrange evaluateSubrange(STExpression expr) throws EvaluatorException, InterruptedException {
        Subrange subrange;
        STExpression sTExpression;
        STExpression sTExpression2 = expr;
        Objects.requireNonNull(sTExpression2);
        STExpression sTExpression3 = sTExpression = sTExpression2;
        int n = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STBinaryExpression.class}, (Object)sTExpression3, n)) {
                case 0: {
                    STBinaryExpression binaryExpression = (STBinaryExpression)sTExpression;
                    if (binaryExpression.getOp() != STBinaryOperator.RANGE) {
                        sTExpression3 = sTExpression;
                        n = 1;
                        continue block3;
                    }
                    subrange = STCoreUtil.newSubrange((int)ValueOperations.asInteger((Value)this.evaluateExpression(binaryExpression.getLeft())), (int)ValueOperations.asInteger((Value)this.evaluateExpression(binaryExpression.getRight())));
                    break block3;
                }
                default: {
                    subrange = STCoreUtil.newSubrange((int)0, (int)ValueOperations.asInteger((Value)this.evaluateExpression(expr)));
                }
            }
            break;
        }
        return subrange;
    }

    protected Variable<?> evaluateInitializerExpression(Variable<?> variable, STInitializerExpression expression) throws EvaluatorException, InterruptedException {
        STInitializerExpression sTInitializerExpression = expression;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STElementaryInitializerExpression.class, STArrayInitializerExpression.class, STStructInitializerExpression.class}, (Object)sTInitializerExpression, 0)) {
            case -1 -> variable;
            case 0 -> {
                STElementaryInitializerExpression elementaryInitializerExpression = (STElementaryInitializerExpression)sTInitializerExpression;
                yield this.evaluateInitializerExpression(variable, elementaryInitializerExpression);
            }
            case 1 -> {
                STArrayInitializerExpression arrayInitializerExpression = (STArrayInitializerExpression)sTInitializerExpression;
                yield this.evaluateInitializerExpression(variable, arrayInitializerExpression);
            }
            case 2 -> {
                STStructInitializerExpression structInitializerExpression = (STStructInitializerExpression)sTInitializerExpression;
                yield this.evaluateInitializerExpression(variable, structInitializerExpression);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expression);
        };
    }

    protected Variable<?> evaluateInitializerExpression(Variable<?> variable, STElementaryInitializerExpression expression) throws EvaluatorException, InterruptedException {
        variable.setValue(this.evaluateExpression(expression.getValue()));
        return variable;
    }

    protected Variable<?> evaluateInitializerExpression(Variable<?> variable, STArrayInitializerExpression expression) throws EvaluatorException, InterruptedException {
        if (variable instanceof GenericVariable) {
            variable.setValue((Value)new ArrayValue((ArrayType)expression.getResultType()));
        }
        ArrayValue value = (ArrayValue)variable.getValue();
        int index = 0;
        int size = value.size();
        for (STArrayInitElement elem : expression.getValues()) {
            if (elem instanceof STSingleArrayInitElement) {
                STSingleArrayInitElement singleArrayInitElement = (STSingleArrayInitElement)elem;
                if (index >= size) {
                    return variable;
                }
                this.evaluateInitializerExpression(value.getRaw(index), singleArrayInitElement.getInitExpression());
                ++index;
                continue;
            }
            if (!(elem instanceof STRepeatArrayInitElement)) continue;
            STRepeatArrayInitElement repeatArrayInitElement = (STRepeatArrayInitElement)elem;
            int count = repeatArrayInitElement.getRepetitions().intValueExact();
            int i = 0;
            while (i < count) {
                for (STInitializerExpression initElement : repeatArrayInitElement.getInitExpressions()) {
                    if (index >= size) {
                        return variable;
                    }
                    this.evaluateInitializerExpression(value.getRaw(index), initElement);
                    ++index;
                }
                ++i;
            }
        }
        return variable;
    }

    protected Variable<?> evaluateInitializerExpression(Variable<?> variable, STStructInitializerExpression expression) throws EvaluatorException, InterruptedException {
        if (variable instanceof GenericVariable) {
            variable.setValue((Value)new StructValue((StructuredType)expression.getResultType()));
        }
        StructValue value = (StructValue)variable.getValue();
        for (STStructInitElement elem : expression.getValues()) {
            this.evaluateInitializerExpression(value.get(elem.getVariable().getName()), elem.getValue());
        }
        return variable;
    }

    protected void evaluateStatementList(List<STStatement> statements) throws EvaluatorException, InterruptedException {
        for (STStatement statement : statements) {
            this.evaluateStatement(statement);
        }
    }

    protected void evaluateStatement(STStatement stmt) throws EvaluatorException, InterruptedException {
        STStatement sTStatement = stmt;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STExpression.class, STIfStatement.class, STCaseStatement.class, STForStatement.class, STWhileStatement.class, STRepeatStatement.class, STContinue.class, STReturn.class, STExit.class, STNop.class}, (Object)sTStatement, 0)) {
            case 0: {
                STExpression stExpression = (STExpression)sTStatement;
                this.evaluateStatement(stExpression);
                break;
            }
            case 1: {
                STIfStatement stIfStatement = (STIfStatement)sTStatement;
                this.evaluateStatement(stIfStatement);
                break;
            }
            case 2: {
                STCaseStatement stCaseStatement = (STCaseStatement)sTStatement;
                this.evaluateStatement(stCaseStatement);
                break;
            }
            case 3: {
                STForStatement stForStatement = (STForStatement)sTStatement;
                this.evaluateStatement(stForStatement);
                break;
            }
            case 4: {
                STWhileStatement stWhileStatement = (STWhileStatement)sTStatement;
                this.evaluateStatement(stWhileStatement);
                break;
            }
            case 5: {
                STRepeatStatement stRepeatStatement = (STRepeatStatement)sTStatement;
                this.evaluateStatement(stRepeatStatement);
                break;
            }
            case 6: {
                STContinue stContinue = (STContinue)sTStatement;
                this.evaluateStatement(stContinue);
                break;
            }
            case 7: {
                STReturn stReturn = (STReturn)sTStatement;
                this.evaluateStatement(stReturn);
                break;
            }
            case 8: {
                STExit stExit = (STExit)sTStatement;
                this.evaluateStatement(stExit);
                break;
            }
            case 9: {
                STNop stNop = (STNop)sTStatement;
                this.evaluateStatement(stNop);
                break;
            }
            default: {
                throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)stmt);
            }
        }
    }

    protected void evaluateStatement(STExpression stmt) throws EvaluatorException, InterruptedException {
        this.evaluateExpression((STExpression)this.trap(stmt));
    }

    protected void evaluateStatement(STIfStatement stmt) throws EvaluatorException, InterruptedException {
        if (ValueOperations.asBoolean((Value)this.evaluateExpression((STExpression)this.trap(stmt.getCondition())))) {
            this.evaluateStatementList((List<STStatement>)stmt.getStatements());
        } else {
            for (STElseIfPart elseIfPart : stmt.getElseifs()) {
                if (!ValueOperations.asBoolean((Value)this.evaluateExpression((STExpression)this.trap(elseIfPart.getCondition())))) continue;
                this.evaluateStatementList((List<STStatement>)elseIfPart.getStatements());
                return;
            }
            STElsePart elsePart = stmt.getElse();
            if (elsePart != null) {
                this.evaluateStatementList((List<STStatement>)elsePart.getStatements());
            }
        }
    }

    protected void evaluateStatement(STCaseStatement stmt) throws EvaluatorException, InterruptedException {
        Value value = this.evaluateExpression((STExpression)this.trap(stmt.getSelector()));
        for (STCaseCases caseBlock : stmt.getCases()) {
            for (STExpression condition : caseBlock.getConditions()) {
                if (!this.evaluateCaseCondition((STExpression)this.trap(condition), value)) continue;
                this.evaluateStatementList((List<STStatement>)caseBlock.getStatements());
                return;
            }
        }
        STElsePart elseBlock = stmt.getElse();
        if (elseBlock != null) {
            this.evaluateStatementList((List<STStatement>)elseBlock.getStatements());
        }
    }

    protected boolean evaluateCaseCondition(STExpression expr, Value value) throws EvaluatorException, InterruptedException {
        boolean bl;
        STExpression sTExpression;
        STExpression sTExpression2 = expr;
        Objects.requireNonNull(sTExpression2);
        STExpression sTExpression3 = sTExpression = sTExpression2;
        int n = 0;
        block3: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STBinaryExpression.class}, (Object)sTExpression3, n)) {
                case 0: {
                    STBinaryExpression binaryExpression = (STBinaryExpression)sTExpression;
                    if (binaryExpression.getOp() != STBinaryOperator.RANGE) {
                        sTExpression3 = sTExpression;
                        n = 1;
                        continue block3;
                    }
                    if (ValueOperations.greaterEquals((Value)value, (Value)this.evaluateExpression(binaryExpression.getLeft())) && ValueOperations.lessEquals((Value)value, (Value)this.evaluateExpression(binaryExpression.getRight()))) {
                        bl = true;
                        break block3;
                    }
                    bl = false;
                    break block3;
                }
                default: {
                    bl = ValueOperations.equals((Value)value, (Value)this.evaluateExpression(expr));
                }
            }
            break;
        }
        return bl;
    }

    /*
     * Exception decompiling
     */
    protected void evaluateStatement(STForStatement stmt) throws EvaluatorException, InterruptedException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void evaluateForIteration(Variable<?> variable, Value by, STExpression trapExpression, EList<STStatement> statements) throws EvaluatorException, InterruptedException, ClassCastException {
        try {
            this.evaluateStatementList((List<STStatement>)statements);
        }
        catch (ContinueException continueException) {
            // empty catch block
        }
        this.trap(trapExpression);
        variable.setValue(ValueOperations.add((Value)variable.getValue(), (Value)by));
    }

    protected void evaluateStatement(STWhileStatement stmt) throws EvaluatorException, InterruptedException {
        try {
            STExpression condition = stmt.getCondition();
            EList statements = stmt.getStatements();
            while (ValueOperations.asBoolean((Value)this.evaluateExpression((STExpression)this.trap(condition)))) {
                try {
                    this.evaluateStatementList((List<STStatement>)statements);
                }
                catch (ContinueException continueException) {
                    // empty catch block
                }
            }
        }
        catch (ExitException exitException) {
            // empty catch block
        }
    }

    protected void evaluateStatement(STRepeatStatement stmt) throws EvaluatorException, InterruptedException {
        try {
            STExpression condition = stmt.getCondition();
            EList statements = stmt.getStatements();
            do {
                try {
                    this.evaluateStatementList((List<STStatement>)statements);
                }
                catch (ContinueException continueException) {
                    // empty catch block
                }
            } while (!ValueOperations.asBoolean((Value)this.evaluateExpression((STExpression)this.trap(condition))));
        }
        catch (ExitException exitException) {
            // empty catch block
        }
    }

    protected void evaluateStatement(STContinue stmt) throws EvaluatorException, InterruptedException {
        throw new ContinueException((STStatement)this.trap(stmt), (Evaluator)this);
    }

    protected void evaluateStatement(STReturn stmt) throws EvaluatorException, InterruptedException {
        throw new ReturnException((STStatement)this.trap(stmt), (Evaluator)this);
    }

    protected void evaluateStatement(STExit stmt) throws EvaluatorException, InterruptedException {
        throw new ExitException((STStatement)this.trap(stmt), (Evaluator)this);
    }

    protected void evaluateStatement(STNop stmt) {
    }

    protected Value evaluateExpression(STExpression expr) throws EvaluatorException, InterruptedException {
        STExpression sTExpression = expr;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STAssignment.class, STBinaryExpression.class, STUnaryExpression.class, STNumericLiteral.class, STStringLiteral.class, STDateLiteral.class, STTimeLiteral.class, STTimeOfDayLiteral.class, STDateAndTimeLiteral.class, STEnumLiteral.class, STFeatureExpression.class, STBuiltinFeatureExpression.class, STMemberAccessExpression.class, STArrayAccessExpression.class}, (Object)sTExpression, 0)) {
            case 0 -> {
                STAssignment stAssignment = (STAssignment)sTExpression;
                yield this.evaluateExpression(stAssignment);
            }
            case 1 -> {
                STBinaryExpression stBinaryExpression = (STBinaryExpression)sTExpression;
                yield this.evaluateExpression(stBinaryExpression);
            }
            case 2 -> {
                STUnaryExpression stUnaryExpression = (STUnaryExpression)sTExpression;
                yield this.evaluateExpression(stUnaryExpression);
            }
            case 3 -> {
                STNumericLiteral stNumericLiteral = (STNumericLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stNumericLiteral);
            }
            case 4 -> {
                STStringLiteral stStringLiteral = (STStringLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stStringLiteral);
            }
            case 5 -> {
                STDateLiteral stDateLiteral = (STDateLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stDateLiteral);
            }
            case 6 -> {
                STTimeLiteral stTimeLiteral = (STTimeLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stTimeLiteral);
            }
            case 7 -> {
                STTimeOfDayLiteral stTimeOfDayLiteral = (STTimeOfDayLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stTimeOfDayLiteral);
            }
            case 8 -> {
                STDateAndTimeLiteral stDateAndTimeLiteral = (STDateAndTimeLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stDateAndTimeLiteral);
            }
            case 9 -> {
                STEnumLiteral stEnumLiteral = (STEnumLiteral)sTExpression;
                yield StructuredTextEvaluator.evaluateExpression(stEnumLiteral);
            }
            case 10 -> {
                STFeatureExpression stFeatureExpression = (STFeatureExpression)sTExpression;
                yield this.evaluateExpression(stFeatureExpression);
            }
            case 11 -> {
                STBuiltinFeatureExpression stBuiltinExpression = (STBuiltinFeatureExpression)sTExpression;
                yield this.evaluateExpression(stBuiltinExpression);
            }
            case 12 -> {
                STMemberAccessExpression stMemberAccessExpression = (STMemberAccessExpression)sTExpression;
                yield this.evaluateExpression(stMemberAccessExpression);
            }
            case 13 -> {
                STArrayAccessExpression stArrayAccessExpression = (STArrayAccessExpression)sTExpression;
                yield this.evaluateExpression(stArrayAccessExpression);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr);
        };
    }

    protected Value evaluateExpression(STAssignment expr) throws EvaluatorException, InterruptedException {
        Value value = this.evaluateExpression(expr.getRight());
        this.evaluateVariable(expr.getLeft()).setValue(value);
        return value;
    }

    protected Value evaluateExpression(STBinaryExpression expr) throws EvaluatorException, InterruptedException {
        Value left = this.evaluateExpression(expr.getLeft());
        if (StructuredTextEvaluator.isShortCircuit(expr, left)) {
            return left;
        }
        Value right = this.evaluateExpression(expr.getRight());
        return switch (expr.getOp()) {
            case STBinaryOperator.ADD -> ValueOperations.add((Value)left, (Value)right);
            case STBinaryOperator.SUB -> ValueOperations.subtract((Value)left, (Value)right);
            case STBinaryOperator.MUL -> ValueOperations.multiply((Value)left, (Value)right);
            case STBinaryOperator.DIV -> ValueOperations.divideBy((Value)left, (Value)right);
            case STBinaryOperator.MOD -> ValueOperations.remainderBy((Value)left, (Value)right);
            case STBinaryOperator.POWER -> ValueOperations.power((Value)left, (Value)right);
            case STBinaryOperator.AND, STBinaryOperator.AMPERSAND -> ValueOperations.bitwiseAnd((Value)left, (Value)right);
            case STBinaryOperator.OR -> ValueOperations.bitwiseOr((Value)left, (Value)right);
            case STBinaryOperator.XOR -> ValueOperations.bitwiseXor((Value)left, (Value)right);
            case STBinaryOperator.EQ -> BoolValue.toBoolValue((boolean)ValueOperations.equals((Value)left, (Value)right));
            case STBinaryOperator.NE -> BoolValue.toBoolValue((!ValueOperations.equals((Value)left, (Value)right) ? 1 : 0) != 0);
            case STBinaryOperator.LT -> BoolValue.toBoolValue((boolean)ValueOperations.lessThan((Value)left, (Value)right));
            case STBinaryOperator.LE -> BoolValue.toBoolValue((boolean)ValueOperations.lessEquals((Value)left, (Value)right));
            case STBinaryOperator.GT -> BoolValue.toBoolValue((boolean)ValueOperations.greaterThan((Value)left, (Value)right));
            case STBinaryOperator.GE -> BoolValue.toBoolValue((boolean)ValueOperations.greaterEquals((Value)left, (Value)right));
            case STBinaryOperator.RANGE -> throw new UnsupportedOperationException(Messages.StructuredTextEvaluator_RangeNotSupported);
            default -> throw new MatchException(null, null);
        };
    }

    private static boolean isShortCircuit(STBinaryExpression expr, Value left) {
        return switch (expr.getOp()) {
            case STBinaryOperator.AND, STBinaryOperator.AMPERSAND -> {
                if (expr.getResultType() instanceof BoolType && !ValueOperations.asBoolean((Value)left)) {
                    yield true;
                }
                yield false;
            }
            case STBinaryOperator.OR -> {
                if (expr.getResultType() instanceof BoolType && ValueOperations.asBoolean((Value)left)) {
                    yield true;
                }
                yield false;
            }
            default -> false;
        };
    }

    protected Value evaluateExpression(STUnaryExpression expr) throws EvaluatorException, InterruptedException {
        Value value = this.evaluateExpression(expr.getExpression());
        return switch (expr.getOp()) {
            case STUnaryOperator.PLUS -> ValueOperations.abs((Value)value);
            case STUnaryOperator.MINUS -> ValueOperations.negate((Value)value);
            case STUnaryOperator.NOT -> ValueOperations.bitwiseNot((Value)value);
            default -> throw new MatchException(null, null);
        };
    }

    protected static Value evaluateExpression(STNumericLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STStringLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STDateLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STTimeLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STTimeOfDayLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STDateAndTimeLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected static Value evaluateExpression(STEnumLiteral expr) {
        return ValueOperations.wrapValue((Object)expr.getValue(), (INamedElement)expr.getResultType());
    }

    protected Value evaluateExpression(STFeatureExpression expr) throws EvaluatorException, InterruptedException {
        Value value;
        INamedElement iNamedElement;
        INamedElement iNamedElement2 = iNamedElement = expr.getFeature();
        int n = 0;
        block10: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, STVarDeclaration.class, AdapterDeclaration.class, FB.class, ICallable.class, STStandardFunction.class, FB.class, ICallable.class}, (Object)iNamedElement2, n)) {
                case 0: {
                    VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                    value = this.findVariable(varDeclaration).getValue();
                    break block10;
                }
                case 1: {
                    STVarDeclaration stVarDeclaration = (STVarDeclaration)iNamedElement;
                    value = this.findVariable(stVarDeclaration).getValue();
                    break block10;
                }
                case 2: {
                    AdapterDeclaration adapterDeclaration = (AdapterDeclaration)iNamedElement;
                    value = this.findVariable(adapterDeclaration).getValue();
                    break block10;
                }
                case 3: {
                    FB fb = (FB)iNamedElement;
                    if (expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 4;
                        continue block10;
                    }
                    value = this.findVariable(fb).getValue();
                    break block10;
                }
                case 4: {
                    ICallable callable = (ICallable)iNamedElement;
                    if (expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 5;
                        continue block10;
                    }
                    value = this.findVariable(callable).getValue();
                    break block10;
                }
                case 5: {
                    STStandardFunction standardFunction = (STStandardFunction)iNamedElement;
                    if (!expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 6;
                        continue block10;
                    }
                    value = ValueOperations.castValue((Value)this.evaluateStandardFunctionCall(standardFunction, expr.getMappedInputArguments(), expr.getMappedOutputArguments()), (INamedElement)expr.getResultType());
                    break block10;
                }
                case 6: {
                    FB fb = (FB)iNamedElement;
                    if (!expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 7;
                        continue block10;
                    }
                    FBVariable receiver = (FBVariable)this.findVariable(fb);
                    Event event = (Event)fb.getType().getInterfaceList().getEventInputs().getFirst();
                    value = this.evaluateFBCall(receiver, event, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                    break block10;
                }
                case 7: {
                    ICallable callable = (ICallable)iNamedElement;
                    if (!expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 8;
                        continue block10;
                    }
                    value = this.evaluateCall(this.getContext(), callable, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                    break block10;
                }
                default: {
                    throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr.getFeature());
                }
            }
            break;
        }
        return value;
    }

    protected Value evaluateExpression(STBuiltinFeatureExpression expr) throws EvaluatorException, InterruptedException {
        STBuiltinFeature sTBuiltinFeature = expr.getFeature();
        return switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"THIS"}, (STBuiltinFeature)sTBuiltinFeature, 0)) {
            case 0 -> {
                if (expr.isCall()) {
                    FBVariable receiver = (FBVariable)this.getContext();
                    Event event = (Event)receiver.getType().getInterfaceList().getEventInputs().getFirst();
                    yield this.evaluateFBCall(receiver, event, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                }
                yield this.getContext().getValue();
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException(expr.getFeature());
        };
    }

    protected Value evaluateExpression(STMemberAccessExpression expr) throws EvaluatorException, InterruptedException {
        return this.evaluateExpression(expr.getMember(), this.evaluateVariable(expr.getReceiver()));
    }

    protected Value evaluateExpression(STArrayAccessExpression expr) throws EvaluatorException, InterruptedException {
        Value receiver;
        Value value = receiver = this.evaluateExpression(expr.getReceiver());
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayValue.class, AnyStringValue.class}, (Object)value, 0)) {
            case 0 -> {
                ArrayValue arrayValue = (ArrayValue)value;
                ArrayList<Integer> indices = new ArrayList<Integer>(expr.getIndex().size());
                for (STExpression index : expr.getIndex()) {
                    indices.add(ValueOperations.asInteger((Value)this.evaluateExpression(index)));
                }
                yield arrayValue.get(indices).getValue();
            }
            case 1 -> {
                AnyStringValue stringValue = (AnyStringValue)value;
                yield stringValue.charAt(ValueOperations.asInteger((Value)this.evaluateExpression((STExpression)expr.getIndex().getFirst())));
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException(receiver);
        };
    }

    protected Value evaluateExpression(STExpression expr, Variable<?> receiver) throws EvaluatorException, InterruptedException {
        STExpression sTExpression = expr;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STFeatureExpression.class, STMultibitPartialExpression.class}, (Object)sTExpression, 0)) {
            case 0 -> {
                STFeatureExpression stFeatureExpression = (STFeatureExpression)sTExpression;
                yield this.evaluateExpression(stFeatureExpression, receiver);
            }
            case 1 -> {
                STMultibitPartialExpression stMultibitPartialExpression = (STMultibitPartialExpression)sTExpression;
                yield this.evaluateExpression(stMultibitPartialExpression, receiver);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr);
        };
    }

    protected Value evaluateExpression(STMultibitPartialExpression expr, Variable<?> receiver) throws EvaluatorException, InterruptedException {
        int index = expr.getExpression() != null ? ValueOperations.asInteger((Value)this.evaluateExpression(expr.getExpression())) : expr.getIndex().intValueExact();
        return ValueOperations.partial((Value)receiver.getValue(), (DataType)((DataType)expr.getResultType()), (int)index);
    }

    protected Value evaluateExpression(STFeatureExpression expr, Variable<?> receiver) throws EvaluatorException, InterruptedException {
        Variable<?> variable = receiver;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{StructVariable.class, FBVariable.class}, variable, 0)) {
            case 0 -> {
                StructVariable structVariable = (StructVariable)variable;
                yield ((Variable)structVariable.getMembers().get(expr.getFeature().getName())).getValue();
            }
            case 1 -> {
                INamedElement var6_6;
                FBVariable fbVariable = (FBVariable)variable;
                INamedElement v1 = var6_6 = expr.getFeature();
                int v2 = 0;
                block12: while (true) {
                    switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, AdapterDeclaration.class, FB.class, FB.class, Event.class, ICallable.class}, (Object)v1, v2)) {
                        case 0: {
                            VarDeclaration varDeclaration = (VarDeclaration)var6_6;
                            yield ((Variable)fbVariable.getMembers().get(varDeclaration.getName())).getValue();
                        }
                        case 1: {
                            AdapterDeclaration adapterDeclaration = (AdapterDeclaration)var6_6;
                            yield ((Variable)fbVariable.getMembers().get(adapterDeclaration.getName())).getValue();
                        }
                        case 2: {
                            FB fb = (FB)var6_6;
                            if (expr.isCall()) {
                                v1 = var6_6;
                                v2 = 3;
                                continue block12;
                            }
                            yield ((Variable)fbVariable.getMembers().get(fb.getName())).getValue();
                        }
                        case 3: {
                            FB fb = (FB)var6_6;
                            if (!expr.isCall()) {
                                v1 = var6_6;
                                v2 = 4;
                                continue block12;
                            }
                            FBVariable callReceiver = (FBVariable)fbVariable.getMembers().get(expr.getFeature().getName());
                            Event event = (Event)fb.getType().getInterfaceList().getEventInputs().getFirst();
                            yield this.evaluateFBCall(callReceiver, event, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                        }
                        case 4: {
                            Event event = (Event)var6_6;
                            if (!expr.isCall()) {
                                v1 = var6_6;
                                v2 = 5;
                                continue block12;
                            }
                            yield this.evaluateFBCall(fbVariable, event, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                        }
                        case 5: {
                            ICallable callable = (ICallable)var6_6;
                            if (!expr.isCall()) {
                                v1 = var6_6;
                                v2 = 6;
                                continue block12;
                            }
                            yield this.evaluateCall(receiver, callable, expr.getMappedInputArguments(), expr.getMappedOutputArguments(), expr.getMappedInOutArguments());
                        }
                    }
                    break;
                }
                throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr.getFeature());
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException(receiver);
        };
    }

    protected Variable<?> evaluateVariable(STExpression expr) throws EvaluatorException, InterruptedException {
        STExpression sTExpression = expr;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STArrayAccessExpression.class, STBuiltinFeatureExpression.class, STFeatureExpression.class, STMemberAccessExpression.class}, (Object)sTExpression, 0)) {
            case 0 -> {
                STArrayAccessExpression stArrayAccessExpression = (STArrayAccessExpression)sTExpression;
                yield this.evaluateVariable(stArrayAccessExpression);
            }
            case 1 -> {
                STBuiltinFeatureExpression stBuiltinFeatureExpression = (STBuiltinFeatureExpression)sTExpression;
                yield this.evaluateVariable(stBuiltinFeatureExpression);
            }
            case 2 -> {
                STFeatureExpression stFeatureExpression = (STFeatureExpression)sTExpression;
                yield this.evaluateVariable(stFeatureExpression);
            }
            case 3 -> {
                STMemberAccessExpression stMemberAccessExpression = (STMemberAccessExpression)sTExpression;
                yield this.evaluateVariable(stMemberAccessExpression);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr);
        };
    }

    protected Variable<?> evaluateVariable(STFeatureExpression expr) throws EvaluatorException, InterruptedException {
        Variable<?> variable;
        INamedElement iNamedElement;
        INamedElement iNamedElement2 = iNamedElement = expr.getFeature();
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, AdapterDeclaration.class, STVarDeclaration.class, FB.class, ICallable.class}, (Object)iNamedElement2, n)) {
                case 0: {
                    VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                    variable = this.findVariable(varDeclaration);
                    break block7;
                }
                case 1: {
                    AdapterDeclaration adapterDeclaration = (AdapterDeclaration)iNamedElement;
                    variable = this.findVariable(adapterDeclaration);
                    break block7;
                }
                case 2: {
                    STVarDeclaration stVarDeclaration = (STVarDeclaration)iNamedElement;
                    variable = this.findVariable(stVarDeclaration);
                    break block7;
                }
                case 3: {
                    FB fb = (FB)iNamedElement;
                    variable = this.findVariable(fb);
                    break block7;
                }
                case 4: {
                    ICallable callable = (ICallable)iNamedElement;
                    if (expr.isCall()) {
                        iNamedElement2 = iNamedElement;
                        n = 5;
                        continue block7;
                    }
                    variable = this.findVariable(callable);
                    break block7;
                }
                default: {
                    throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr.getFeature());
                }
            }
            break;
        }
        return variable;
    }

    protected Variable<?> evaluateVariable(STBuiltinFeatureExpression expr) {
        STBuiltinFeature sTBuiltinFeature = expr.getFeature();
        switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"THIS"}, (STBuiltinFeature)sTBuiltinFeature, 0)) {
            case 0: {
                break;
            }
            default: {
                throw StructuredTextEvaluator.createUnsupportedOperationException(expr.getFeature());
            }
        }
        return this.getContext();
    }

    protected Variable<?> evaluateVariable(STMemberAccessExpression expr) throws EvaluatorException, InterruptedException {
        return this.evaluateVariable(expr.getMember(), this.evaluateVariable(expr.getReceiver()));
    }

    protected Variable<?> evaluateVariable(STArrayAccessExpression expr) throws EvaluatorException, InterruptedException {
        Variable<?> receiver = this.evaluateVariable(expr.getReceiver());
        Value value = receiver.getValue();
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayValue.class, StringValue.class, WStringValue.class}, (Object)value, 0)) {
            case 0 -> {
                ArrayValue arrayValue = (ArrayValue)value;
                ArrayList<Integer> indices = new ArrayList<Integer>(expr.getIndex().size());
                for (STExpression index : expr.getIndex()) {
                    indices.add(ValueOperations.asInteger((Value)this.evaluateExpression(index)));
                }
                yield arrayValue.get(indices);
            }
            case 1 -> {
                StringValue unused = (StringValue)value;
                yield new StringCharacterVariable(receiver, ValueOperations.asInteger((Value)this.evaluateExpression((STExpression)expr.getIndex().getFirst())));
            }
            case 2 -> {
                WStringValue unused = (WStringValue)value;
                yield new WStringCharacterVariable(receiver, ValueOperations.asInteger((Value)this.evaluateExpression((STExpression)expr.getIndex().getFirst())));
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException(receiver.getValue());
        };
    }

    protected Variable<?> evaluateVariable(STExpression expr, Variable<?> receiver) throws EvaluatorException, InterruptedException {
        STExpression sTExpression = expr;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STFeatureExpression.class, STBuiltinFeatureExpression.class, STMultibitPartialExpression.class}, (Object)sTExpression, 0)) {
            case 0 -> {
                STFeatureExpression featureExpression = (STFeatureExpression)sTExpression;
                Variable<?> var5_5 = receiver;
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{FBVariable.class, StructVariable.class}, var5_5, 0)) {
                    case 0: {
                        FBVariable fbVariable = (FBVariable)var5_5;
                        yield StructuredTextEvaluator.evaluateVariable(featureExpression, fbVariable);
                    }
                    case 1: {
                        StructVariable structVariable = (StructVariable)var5_5;
                        yield StructuredTextEvaluator.evaluateVariable(featureExpression, structVariable);
                    }
                }
                throw StructuredTextEvaluator.createUnsupportedOperationException(receiver);
            }
            case 1 -> {
                STBuiltinFeatureExpression builtinFeatureExpression = (STBuiltinFeatureExpression)sTExpression;
                yield StructuredTextEvaluator.evaluateVariable(builtinFeatureExpression, receiver);
            }
            case 2 -> {
                STMultibitPartialExpression multibitPartialExpression = (STMultibitPartialExpression)sTExpression;
                yield this.evaluateVariable(multibitPartialExpression, receiver);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)expr);
        };
    }

    protected static Variable<?> evaluateVariable(STFeatureExpression expr, StructVariable receiver) {
        return receiver.getValue().get(expr.getFeature().getName());
    }

    protected static Variable<?> evaluateVariable(STFeatureExpression expr, FBVariable receiver) {
        return receiver.getValue().get(expr.getFeature().getName());
    }

    protected static Variable<?> evaluateVariable(STBuiltinFeatureExpression expr, Variable<?> receiver) {
        throw new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_FeatureNotSupported, expr.getFeature().getName(), receiver.getType().getName()));
    }

    protected Variable<?> evaluateVariable(STMultibitPartialExpression expr, Variable<?> receiver) throws EvaluatorException, InterruptedException {
        int index = 0;
        index = expr.getExpression() != null ? ValueOperations.asInteger((Value)this.evaluateExpression(expr.getExpression())) : expr.getIndex().intValueExact();
        return new PartialVariable(receiver, (AnyBitType)expr.getResultType(), index);
    }

    protected Variable<?> newVariable(INamedElement variable, Value value) throws EvaluatorException, InterruptedException {
        INamedElement iNamedElement = variable;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{VarDeclaration.class, STVarDeclaration.class}, (Object)iNamedElement, 0)) {
            case 0 -> {
                VarDeclaration varDeclaration = (VarDeclaration)iNamedElement;
                yield VariableOperations.newVariable((VarDeclaration)varDeclaration, (Value)value);
            }
            case 1 -> {
                STVarDeclaration stVarDeclaration = (STVarDeclaration)iNamedElement;
                yield VariableOperations.newVariable((String)stVarDeclaration.getName(), (INamedElement)this.evaluateType(stVarDeclaration), (Value)value);
            }
            default -> throw StructuredTextEvaluator.createUnsupportedOperationException((EObject)variable);
        };
    }

    private Value evaluateStandardFunctionCall(STStandardFunction standardFunction, Map<INamedElement, STCallArgument> inputs, Map<INamedElement, STCallArgument> outputs) throws EvaluatorException, InterruptedException {
        ArrayList<Object> arguments = new ArrayList<Object>(inputs.size() + outputs.size());
        for (Map.Entry<INamedElement, STCallArgument> arg : inputs.entrySet()) {
            arguments.add(ValueOperations.castValue((Value)this.evaluateExpression(arg.getValue().getArgument()), (INamedElement)STCoreUtil.getFeatureType((INamedElement)arg.getKey())));
        }
        for (Map.Entry<INamedElement, STCallArgument> arg : outputs.entrySet()) {
            arguments.add(this.evaluateVariable(arg.getValue().getArgument()));
        }
        try {
            return Functions.invoke(StandardFunctions.class, (String)standardFunction.getName(), arguments);
        }
        catch (Throwable e) {
            throw new EvaluatorException(e.getMessage(), e, (Evaluator)this);
        }
    }

    protected Value evaluateCall(Variable<?> receiver, ICallable feature, Map<INamedElement, STCallArgument> inputs, Map<INamedElement, STCallArgument> outputs, Map<INamedElement, STCallArgument> inouts) throws EvaluatorException, InterruptedException {
        ArrayList arguments = new ArrayList(inputs.size() + inouts.size());
        this.createArguments(arguments, inputs);
        this.createArguments(arguments, inouts);
        Evaluator eval = EvaluatorFactory.createEvaluator((Object)feature, (Class)feature.eClass().getInstanceClass(), receiver, arguments, (Evaluator)this);
        if (eval == null) {
            throw new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_CannotCreateEvaluator, feature.eClass().getName()));
        }
        Value result = eval.evaluate();
        this.readArguments(eval, inouts);
        this.readArguments(eval, outputs);
        return result;
    }

    protected Value evaluateFBCall(FBVariable receiver, Event event, Map<INamedElement, STCallArgument> inputs, Map<INamedElement, STCallArgument> outputs, Map<INamedElement, STCallArgument> inouts) throws EvaluatorException, InterruptedException {
        Event typeEvent = receiver.getType().getInterfaceList().getEvent(event.getName());
        if (typeEvent == null) {
            throw new EvaluatorException(MessageFormat.format(Messages.StructuredTextEvaluator_NoSuchTypeEvent, event.getQualifiedName(), PackageNameHelper.getFullTypeName((LibraryElement)receiver.getType())), (Evaluator)this);
        }
        FBEvaluator<?> eval = this.getEvaluator(receiver);
        if (eval == null) {
            throw new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_CannotCreateEvaluator, receiver.getType().eClass().getName()));
        }
        this.writeArguments((Evaluator)eval, inputs);
        this.writeArguments((Evaluator)eval, inouts);
        eval.evaluate(typeEvent);
        this.readArguments((Evaluator)eval, inouts);
        this.readArguments((Evaluator)eval, outputs);
        Variable returnVariable = (Variable)eval.getVariables().get(RETURN_VARIABLE_NAME);
        if (returnVariable != null) {
            return returnVariable.getValue();
        }
        return null;
    }

    protected void createArguments(List<Variable<?>> result, Map<INamedElement, STCallArgument> arguments) throws EvaluatorException, InterruptedException {
        for (Map.Entry<INamedElement, STCallArgument> arg : arguments.entrySet()) {
            if (arg.getValue() == null) continue;
            result.add(this.newVariable(arg.getKey(), this.evaluateExpression(arg.getValue().getArgument())));
        }
    }

    protected void writeArguments(Evaluator eval, Map<INamedElement, STCallArgument> arguments) throws EvaluatorException, InterruptedException {
        for (Map.Entry<INamedElement, STCallArgument> arg : arguments.entrySet()) {
            if (arg.getValue() == null) continue;
            ((Variable)eval.getVariables().get(arg.getKey().getName())).setValue(this.evaluateExpression(arg.getValue().getArgument()));
        }
    }

    protected void readArguments(Evaluator eval, Map<INamedElement, STCallArgument> arguments) throws EvaluatorException, InterruptedException {
        for (Map.Entry<INamedElement, STCallArgument> arg : arguments.entrySet()) {
            STCallArgument sTCallArgument;
            STCallArgument sTCallArgument2 = sTCallArgument = arg.getValue();
            int n = 0;
            block5: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STCallNamedOutputArgument.class}, (Object)sTCallArgument2, n)) {
                    case -1: {
                        break block5;
                    }
                    case 0: {
                        STCallNamedOutputArgument namedOutputArgument = (STCallNamedOutputArgument)sTCallArgument;
                        if (!namedOutputArgument.isNot()) {
                            sTCallArgument2 = sTCallArgument;
                            n = 1;
                            continue block5;
                        }
                        this.evaluateVariable(arg.getValue().getArgument()).setValue(ValueOperations.bitwiseNot((Value)((Variable)eval.getVariables().get(arg.getKey().getName())).getValue()));
                        break block5;
                    }
                    default: {
                        this.evaluateVariable(arg.getValue().getArgument()).setValue(((Variable)eval.getVariables().get(arg.getKey().getName())).getValue());
                    }
                }
                break;
            }
        }
    }

    protected FBEvaluator<?> getEvaluator(FBVariable receiver) {
        Evaluator parent = this.getParent();
        if (parent instanceof FBEvaluator) {
            if ("THIS".equals(receiver.getName())) {
                return (FBEvaluator)this.getParent();
            }
            return (FBEvaluator)parent.getChildren().entrySet().stream().filter(entry -> entry.getKey() instanceof FB && Objects.equals(((ICallable)entry.getKey()).getName(), receiver.getName())).findFirst().orElseThrow().getValue();
        }
        if (parent instanceof StructuredTextEvaluator) {
            StructuredTextEvaluator structuredTextEvaluator = (StructuredTextEvaluator)parent;
            if (parent.getContext() == this.getContext()) {
                return structuredTextEvaluator.getEvaluator(receiver);
            }
        }
        return this.createEvaluator(receiver);
    }

    protected FBEvaluator<?> createEvaluator(FBVariable receiver) {
        FBEvaluator result = (FBEvaluator)EvaluatorFactory.createEvaluator((Object)receiver.getType(), (Class)receiver.getType().eClass().getInstanceClass(), (Variable)receiver, receiver.getMembers().values(), (Evaluator)this);
        result.prepare();
        return result;
    }

    protected static String getGlobalConstantName(STVarDeclaration decl) {
        EObject eObject = decl.eContainer();
        if (eObject instanceof STVarGlobalDeclarationBlock) {
            STGlobalConstsSource source;
            STVarGlobalDeclarationBlock block = (STVarGlobalDeclarationBlock)eObject;
            EObject eObject2 = block.eContainer();
            if (eObject2 instanceof STGlobalConstsSource && (source = (STGlobalConstsSource)eObject2).getName() != null && !source.getName().isEmpty()) {
                return source.getName() + "::" + decl.getName();
            }
            return decl.getName();
        }
        return null;
    }

    protected static UnsupportedOperationException createUnsupportedOperationException(Object element) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_ElementNotSupported, element != null ? element.getClass().getName() : null));
    }

    protected static UnsupportedOperationException createUnsupportedOperationException(EObject element) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_ElementNotSupported, element != null ? element.eClass().getName() : null));
    }

    protected static UnsupportedOperationException createUnsupportedOperationException(Enum<?> element) {
        return new UnsupportedOperationException(MessageFormat.format(Messages.StructuredTextEvaluator_ElementNotSupported, element != null ? element.name() : null));
    }

    public String getName() {
        return this.name;
    }

    public static class ContinueException
    extends StructuredTextException {
        private static final long serialVersionUID = 1L;

        public ContinueException(STStatement statement, Evaluator evaluator) {
            super(statement, evaluator);
        }
    }

    public static class ExitException
    extends StructuredTextException {
        private static final long serialVersionUID = 1L;

        public ExitException(STStatement statement, Evaluator evaluator) {
            super(statement, evaluator);
        }
    }

    public static class ReturnException
    extends StructuredTextException {
        private static final long serialVersionUID = 1L;

        public ReturnException(STStatement statement, Evaluator evaluator) {
            super(statement, evaluator);
        }
    }

    public static class StructuredTextException
    extends EvaluatorException {
        private static final long serialVersionUID = 1L;

        public StructuredTextException(STStatement statement, Evaluator evaluator) {
            super(statement.eClass().getName(), evaluator);
        }
    }
}

