/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.AbstractSubAppInterfaceWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.AnyValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.VariableOperations;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;

public class SubAppVarDeclarationWatch
extends AbstractSubAppInterfaceWatch
implements IVarDeclarationWatch {
    public SubAppVarDeclarationWatch(String name, VarDeclaration varDeclaration, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(VariableOperations.newVariable((String)name, (INamedElement)VariableOperations.evaluateResultType((VarDeclaration)varDeclaration)), (IInterfaceElement)varDeclaration, debugTarget);
    }

    @Override
    public void setValue(String expression) throws DebugException {
        super.setValue(expression);
        this.writeWatch();
    }

    @Override
    public void setValue(IValue value) throws DebugException {
        super.setValue(value);
        this.writeWatch();
    }

    @Override
    public void setValue(Value value) throws DebugException {
        this.getInternalVariable().setValue(value);
        this.fireContentChanged();
        this.writeWatch();
    }

    @Override
    protected void childValueChanged() throws DebugException {
        this.writeWatch();
    }

    protected void writeWatch() throws DebugException {
        for (IVariableWatch watch : this.getWatches()) {
            ((IVarDeclarationWatch)watch).setValue(this.getInternalVariable().getValue());
        }
    }

    @Override
    public void forceValue(String value) throws DebugException {
        super.setValue(value);
        this.writeForce();
    }

    @Override
    public void forceValue(Value value) throws DebugException {
        this.getInternalVariable().setValue(value);
        this.fireContentChanged();
        this.writeForce();
    }

    protected void writeForce() throws DebugException {
        for (IVariableWatch watch : this.getWatches()) {
            ((IVarDeclarationWatch)watch).forceValue(this.getInternalVariable().getValue());
        }
    }

    @Override
    public void clearForce() throws DebugException {
        for (IVariableWatch watch : this.getWatches()) {
            ((IVarDeclarationWatch)watch).clearForce();
        }
    }

    @Override
    public boolean isForced() {
        return this.getWatches().stream().map(IVarDeclarationWatch.class::cast).allMatch(IVarDeclarationWatch::isForced);
    }

    @Override
    protected void updateValue(List<Value> values) {
        if (values.stream().distinct().count() == 1L) {
            this.updateValue(values.getFirst());
        } else {
            this.setError(Messages.AbstractVariableWatch_InconsistentValues);
        }
    }

    @Override
    public VarDeclaration getWatchedElement() {
        return (VarDeclaration)super.getWatchedElement();
    }

    @Override
    public AnyValue getInternalValue() {
        return (AnyValue)super.getInternalValue();
    }
}

