/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.function;

import java.math.BigInteger;
import java.math.RoundingMode;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneOffset;
import java.time.temporal.ChronoUnit;
import java.util.function.BinaryOperator;
import java.util.function.DoubleBinaryOperator;
import java.util.function.DoubleUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.function.Comment;
import org.eclipse.fordiac.ide.model.eval.function.Functions;
import org.eclipse.fordiac.ide.model.eval.function.OnlySupportedBy;
import org.eclipse.fordiac.ide.model.eval.function.ReturnValueComment;
import org.eclipse.fordiac.ide.model.eval.value.AnyBitValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyDurationValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyElementaryValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyIntValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyNumValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyRealValue;
import org.eclipse.fordiac.ide.model.eval.value.AnySCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyStringValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyUnsignedValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyValue;
import org.eclipse.fordiac.ide.model.eval.value.AnyWCharsValue;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.BoolValue;
import org.eclipse.fordiac.ide.model.eval.value.ByteValue;
import org.eclipse.fordiac.ide.model.eval.value.CharValue;
import org.eclipse.fordiac.ide.model.eval.value.DIntValue;
import org.eclipse.fordiac.ide.model.eval.value.DWordValue;
import org.eclipse.fordiac.ide.model.eval.value.DateAndTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.DateValue;
import org.eclipse.fordiac.ide.model.eval.value.IntValue;
import org.eclipse.fordiac.ide.model.eval.value.LDateAndTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.LDateValue;
import org.eclipse.fordiac.ide.model.eval.value.LIntValue;
import org.eclipse.fordiac.ide.model.eval.value.LRealValue;
import org.eclipse.fordiac.ide.model.eval.value.LTimeOfDayValue;
import org.eclipse.fordiac.ide.model.eval.value.LTimeValue;
import org.eclipse.fordiac.ide.model.eval.value.LWordValue;
import org.eclipse.fordiac.ide.model.eval.value.RealValue;
import org.eclipse.fordiac.ide.model.eval.value.SIntValue;
import org.eclipse.fordiac.ide.model.eval.value.StringValue;
import org.eclipse.fordiac.ide.model.eval.value.TimeOfDayValue;
import org.eclipse.fordiac.ide.model.eval.value.TimeValue;
import org.eclipse.fordiac.ide.model.eval.value.UDIntValue;
import org.eclipse.fordiac.ide.model.eval.value.UIntValue;
import org.eclipse.fordiac.ide.model.eval.value.ULIntValue;
import org.eclipse.fordiac.ide.model.eval.value.USIntValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.value.WCharValue;
import org.eclipse.fordiac.ide.model.eval.value.WStringValue;
import org.eclipse.fordiac.ide.model.eval.value.WordValue;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public interface StandardFunctions
extends Functions {
    public static final int BCD_MASK = 15;
    public static final int BCD_BITS = 4;
    public static final int BCD_DIGIT_MAX = 9;

    @Comment(value="Calculates absolute value.")
    public static <T extends AnyNumValue> T ABS(T value) {
        return (T)((AnyNumValue)ValueOperations.abs(value));
    }

    @Comment(value="Returns square root value.")
    public static <T extends AnyRealValue> T SQRT(T value) {
        return (T)((AnyRealValue)ValueOperations.sqrt(value));
    }

    @Comment(value="Returns the natural logarithm.")
    public static <T extends AnyRealValue> T LN(T value) {
        return StandardFunctions.apply(value, Math::log);
    }

    @Comment(value="Returns the logarithm base 10.")
    public static <T extends AnyRealValue> T LOG(T value) {
        return StandardFunctions.apply(value, Math::log10);
    }

    @Comment(value="Returns e exponent of the input.")
    public static <T extends AnyRealValue> T EXP(T value) {
        return StandardFunctions.apply(value, Math::exp);
    }

    @Comment(value="Returns the sine amount.")
    @ReturnValueComment(value="Between -1.0 and 1.0")
    public static <T extends AnyRealValue> T SIN(@Comment(value="Radians unit.") T value) {
        return StandardFunctions.apply(value, Math::sin);
    }

    @Comment(value="Returns the cosine amount.")
    @ReturnValueComment(value="Between -1.0 and 1.0")
    public static <T extends AnyRealValue> T COS(@Comment(value="Radians unit.") T value) {
        return StandardFunctions.apply(value, Math::cos);
    }

    @Comment(value="Returns the tangent amount.")
    public static <T extends AnyRealValue> T TAN(@Comment(value="Radians unit.") T value) {
        return StandardFunctions.apply(value, Math::tan);
    }

    @Comment(value="Returns the principle arc sine.")
    @ReturnValueComment(value="Radians unit.")
    public static <T extends AnyRealValue> T ASIN(@Comment(value="Between -1.0 and 1.0.") T value) {
        return StandardFunctions.apply(value, Math::asin);
    }

    @Comment(value="Returns the principle arc cosine.")
    @ReturnValueComment(value="Radians unit.")
    public static <T extends AnyRealValue> T ACOS(@Comment(value="Between -1.0 and 1.0.") T value) {
        return StandardFunctions.apply(value, Math::acos);
    }

    @Comment(value="Returns the principle arc tangent.")
    @ReturnValueComment(value="Radians unit.")
    public static <T extends AnyRealValue> T ATAN(T value) {
        return StandardFunctions.apply(value, Math::atan);
    }

    @Comment(value="Returns the principle arc tangent between inputs.")
    @ReturnValueComment(value="Radians unit.")
    public static <T extends AnyRealValue> T ATAN2(@Comment(value="The first input.") T x, @Comment(value="The second input.") T y) {
        return StandardFunctions.apply(x, y, Math::atan2);
    }

    @Comment(value="Calculates the addition of inputs.")
    public static <T extends AnyNumValue> T ADD(T ... values) {
        return (T)((AnyNumValue)Stream.of(values).reduce((a, b) -> (AnyNumValue)ValueOperations.add((Value)a, (Value)b)).orElseThrow());
    }

    @Comment(value="Calculates the multiplication of inputs.")
    public static <T extends AnyNumValue> T MUL(T ... values) {
        return (T)((AnyNumValue)Stream.of(values).reduce((a, b) -> (AnyNumValue)ValueOperations.multiply((Value)a, (Value)b)).orElseThrow());
    }

    @Comment(value="Calculates the substraction of inputs.")
    public static <T extends AnyNumValue> T SUB(T first, T second) {
        return (T)((AnyNumValue)ValueOperations.subtract(first, second));
    }

    @Comment(value="Calculates the division of the dividend by the divisor.")
    public static <T extends AnyNumValue> T DIV(@Comment(value="The dividend.") T first, @Comment(value="The divisor, must not be 0.") T second) {
        return (T)((AnyNumValue)ValueOperations.divideBy(first, second));
    }

    @Comment(value="Calculates the remainder after division of the dividend by the divisor.")
    public static <T extends AnyIntValue> T MOD(@Comment(value="The dividend.") T first, @Comment(value="The divisor, must not be 0.") T second) {
        return (T)((AnyIntValue)ValueOperations.remainderBy(first, second));
    }

    @Comment(value="Calculates the base in power of the exponent.")
    public static <T extends AnyRealValue, U extends AnyNumValue> T EXPT(@Comment(value="Base.") T first, @Comment(value="Exponent.") U second) {
        return (T)((AnyRealValue)ValueOperations.power(first, second));
    }

    @Comment(value="Shifts the input value to left by some bits.")
    public static <T extends AnyBitValue, U extends AnyIntValue> T SHL(@Comment(value="The value to be shifted.") T value, @Comment(value="The number of bits to shift.") U moveby) {
        return (T)((AnyBitValue)ValueOperations.shiftLeft(value, moveby));
    }

    @Comment(value="Shifts the input value to right by some bits.")
    public static <T extends AnyBitValue, U extends AnyIntValue> T SHR(@Comment(value="The value to be shifted.") T value, @Comment(value="The number of bits to shift.") U moveby) {
        return (T)((AnyBitValue)ValueOperations.shiftRight(value, moveby));
    }

    @Comment(value="Rotates the input value to left by some bits.")
    public static <T extends AnyBitValue, U extends AnyIntValue> T ROL(@Comment(value="The value to be rotated.") T value, @Comment(value="The number of bits to rotation.") U moveby) {
        return (T)((AnyBitValue)ValueOperations.rotateLeft(value, moveby));
    }

    @Comment(value="Rotates the input vlaue to right by some bits.")
    public static <T extends AnyBitValue, U extends AnyIntValue> T ROR(@Comment(value="The value to be rotated.") T value, @Comment(value="The number of bits to rotation.") U moveby) {
        return (T)((AnyBitValue)ValueOperations.rotateRight(value, moveby));
    }

    @Comment(value="Calculates result of logical AND operation.")
    public static <T extends AnyBitValue> T AND(T ... values) {
        return (T)((AnyBitValue)Stream.of(values).reduce((a, b) -> (AnyBitValue)ValueOperations.bitwiseAnd((Value)a, (Value)b)).orElseThrow());
    }

    @Comment(value="Calculates result of logical OR operation.")
    public static <T extends AnyBitValue> T OR(T ... values) {
        return (T)((AnyBitValue)Stream.of(values).reduce((a, b) -> (AnyBitValue)ValueOperations.bitwiseOr((Value)a, (Value)b)).orElseThrow());
    }

    @Comment(value="Calculates result of logical XOR operation.")
    public static <T extends AnyBitValue> T XOR(T ... values) {
        return (T)((AnyBitValue)Stream.of(values).reduce((a, b) -> (AnyBitValue)ValueOperations.bitwiseXor((Value)a, (Value)b)).orElseThrow());
    }

    @Comment(value="Calculates result of logical NOT operation.")
    public static <T extends AnyBitValue> T NOT(T first) {
        return (T)((AnyBitValue)ValueOperations.bitwiseNot(first));
    }

    @Comment(value="Assigns one value to another.")
    public static <T extends AnyValue> T MOVE(T value) {
        return value;
    }

    @Comment(value="Returns one of two values depending on the value of a BOOL selector value.")
    public static <T extends AnyValue> T SEL(@Comment(value="The selector value.") BoolValue g, @Comment(value="This value will be returned if selector is false") T in0, @Comment(value="This value will be returned if selector is true.") T in1) {
        return g.boolValue() ? in1 : in0;
    }

    @SafeVarargs
    @Comment(value="Returns the highest input value.")
    public static <T extends AnyElementaryValue> T MAX(T ... values) {
        return (T)((AnyElementaryValue)Stream.of(values).max(ValueOperations::compareTo).orElseThrow());
    }

    @SafeVarargs
    @Comment(value="Returns the lowest input value.")
    public static <T extends AnyElementaryValue> T MIN(T ... values) {
        return (T)((AnyElementaryValue)Stream.of(values).min(ValueOperations::compareTo).orElseThrow());
    }

    @Comment(value="Returns a value clamped to a minimum and maximum range.")
    public static <T extends AnyElementaryValue> T LIMIT(@Comment(value="The lowest possible value.") T min, @Comment(value="The input value.") T value, @Comment(value="The highest possible value.") T max) {
        if (ValueOperations.greaterThan(value, max)) {
            return max;
        }
        if (ValueOperations.lessThan(value, min)) {
            return min;
        }
        return value;
    }

    @SafeVarargs
    @Comment(value="Returns one value from a set of input values. An integer selector value chooses which value to return.")
    public static <T extends AnyIntValue, U extends AnyValue> U MUX(@Comment(value="Selector input.") T k, U ... values) {
        return values[k.intValue()];
    }

    @SafeVarargs
    @Comment(value="Identifies if a value is greater than another value and operator can be cascaded to operate on 2 or more parameters.")
    public static <T extends AnyElementaryValue> BoolValue GT(T ... values) {
        Value last = null;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (last != null && !ValueOperations.greaterThan(last, element)) {
                return BoolValue.FALSE;
            }
            last = (Value)element;
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Identifies if a value is greater than or equal to another value and operator can be cascaded to operate on 2 or more parameters.")
    public static <T extends AnyElementaryValue> BoolValue GE(T ... values) {
        Value last = null;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (last != null && !ValueOperations.greaterEquals(last, element)) {
                return BoolValue.FALSE;
            }
            last = (Value)element;
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Identifies if a value is equal to another value and operator can be cascaded to operate on 2 or more parameters.")
    public static <T extends AnyValue> BoolValue EQ(T ... values) {
        Value last = null;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (last != null && !ValueOperations.equals(last, element)) {
                return BoolValue.FALSE;
            }
            last = (Value)element;
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Identifies if a value is less than or equal to another value and operator can be cascaded to operate on 2 or more parameters.")
    public static <T extends AnyElementaryValue> BoolValue LE(T ... values) {
        Value last = null;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (last != null && !ValueOperations.lessEquals(last, element)) {
                return BoolValue.FALSE;
            }
            last = (Value)element;
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Identifies if a value is less than another value and operator can be cascaded to operate on 2 or more parameters.")
    public static <T extends AnyElementaryValue> BoolValue LT(T ... values) {
        Value last = null;
        T[] TArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (last != null && !ValueOperations.lessThan(last, element)) {
                return BoolValue.FALSE;
            }
            last = (Value)element;
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Identifies if a value is unequal to another value.")
    public static <T extends AnyValue> BoolValue NE(T first, T second) {
        return ValueOperations.equals(first, second) ? BoolValue.FALSE : BoolValue.TRUE;
    }

    @Comment(value="Returns the length of a String.")
    public static <T extends AnyStringValue> AnyIntValue LEN(T string) {
        return ULIntValue.toULIntValue(string.length());
    }

    @Comment(value="Returns the left-most n characters of a String.")
    public static <U extends AnyIntValue> StringValue LEFT(StringValue string, @Comment(value="The number of characters to be returned.") U length) {
        return StandardFunctions.apply(string, value -> value.substring(0, length.intValue()));
    }

    @Comment(value="Returns the left-most n characters of a WString.")
    public static <U extends AnyIntValue> WStringValue LEFT(WStringValue string, @Comment(value="The number of characters to be returned.") U length) {
        return StandardFunctions.apply(string, value -> value.substring(0, length.intValue()));
    }

    @Comment(value="Returns the right-most n characters of a String.")
    public static <U extends AnyIntValue> StringValue RIGHT(StringValue string, @Comment(value="The number of characters to be returned.") U length) {
        return StandardFunctions.apply(string, value -> value.substring(value.length() - length.intValue()));
    }

    @Comment(value="Returns the right-most n characters of a WString.")
    public static <U extends AnyIntValue> WStringValue RIGHT(WStringValue string, @Comment(value="The number of characters to be returned.") U length) {
        return StandardFunctions.apply(string, value -> value.substring(value.length() - length.intValue()));
    }

    @Comment(value="Returns the middle n characters of a String starting at an offset.")
    public static <U extends AnyIntValue, V extends AnyIntValue> StringValue MID(StringValue string, @Comment(value="The number of characters to be returned.") U length, @Comment(value="The 1-based starting offset.") V position) {
        return StandardFunctions.apply(string, value -> value.substring(position.intValue() - 1, position.intValue() + length.intValue() - 1));
    }

    @Comment(value="Returns the middle n characters of a WString starting at an offset.")
    public static <U extends AnyIntValue, V extends AnyIntValue> WStringValue MID(WStringValue string, @Comment(value="The number of characters to be returned.") U length, @Comment(value="The 1-based starting offset.") V position) {
        return StandardFunctions.apply(string, value -> value.substring(position.intValue() - 1, position.intValue() + length.intValue() - 1));
    }

    @SafeVarargs
    @Comment(value="Concatenates two or more Strings.")
    public static <T extends AnySCharsValue> StringValue CONCAT(T ... strings) {
        return StringValue.toStringValue((AnyCharsValue)Stream.of(strings).reduce((value1, value2) -> StandardFunctions.apply(value1, value2, String::concat)).orElseThrow());
    }

    @SafeVarargs
    @Comment(value="Concatenates two or more WStrings.")
    public static <T extends AnyWCharsValue> WStringValue CONCAT(T ... strings) {
        return WStringValue.toWStringValue((AnyCharsValue)Stream.of(strings).reduce((value1, value2) -> StandardFunctions.apply(value1, value2, String::concat)).orElseThrow());
    }

    @Comment(value="Deletes characters from a String, then inserts another String at the position of the deleted characters.")
    public static <U extends AnyIntValue, T extends AnySCharsValue> StringValue INSERT(StringValue first, @Comment(value="The String to be inserted.") T second, @Comment(value="The replacement position.") U position) {
        return StandardFunctions.apply(first, value -> value.substring(0, position.intValue()).concat(second.stringValue()).concat(value.substring(position.intValue())));
    }

    @Comment(value="Deletes characters from a WString, then inserts another WString at the position of the deleted characters.")
    public static <U extends AnyIntValue, T extends AnyWCharsValue> WStringValue INSERT(WStringValue first, @Comment(value="The WString to be inserted.") T second, @Comment(value="The replacement position.") U position) {
        return StandardFunctions.apply(first, value -> value.substring(0, position.intValue()).concat(second.stringValue()).concat(value.substring(position.intValue())));
    }

    @Comment(value="Deletes a number of characters from a String starting at a position in the String.")
    public static <U extends AnyIntValue, V extends AnyIntValue> StringValue DELETE(StringValue string, @Comment(value="The number of character to be deleted.") U length, @Comment(value="The delete position.") V position) {
        return StandardFunctions.apply(string, value -> value.substring(0, position.intValue() - 1).concat(value.substring(position.intValue() + length.intValue() - 1)));
    }

    @Comment(value="Deletes a number of characters from a WString starting at a position in the WString.")
    public static <U extends AnyIntValue, V extends AnyIntValue> WStringValue DELETE(WStringValue string, @Comment(value="The number of character to be deleted.") U length, @Comment(value="The delete position.") V position) {
        return StandardFunctions.apply(string, value -> value.substring(0, position.intValue() - 1).concat(value.substring(position.intValue() + length.intValue() - 1)));
    }

    @Comment(value="Deletes characters from a String, then inserts another String at the position of the deleted characters.")
    public static <U extends AnyIntValue, V extends AnyIntValue, T extends AnySCharsValue> StringValue REPLACE(StringValue first, @Comment(value="The String to be inserted.") T second, @Comment(value="The number of character to be deleted before the new String is inserted.") U length, @Comment(value="The replacement position.") V position) {
        return StandardFunctions.apply(first, value -> value.substring(0, position.intValue() - 1).concat(second.stringValue()).concat(value.substring(position.intValue() + length.intValue() - 1)));
    }

    @Comment(value="Deletes characters from a WString, then inserts another WString at the position of the deleted characters.")
    public static <U extends AnyIntValue, V extends AnyIntValue, T extends AnyWCharsValue> WStringValue REPLACE(WStringValue first, @Comment(value="The WString to be inserted.") T second, @Comment(value="The number of character to be deleted before the new WString is inserted.") U length, @Comment(value="The replacement position.") V position) {
        return StandardFunctions.apply(first, value -> value.substring(0, position.intValue() - 1).concat(second.stringValue()).concat(value.substring(position.intValue() + length.intValue() - 1)));
    }

    @Comment(value="Returns the location of the first occurrence a String in a String.")
    public static <T extends AnySCharsValue> AnyIntValue FIND(@Comment(value="The String to be searched.") StringValue first, @Comment(value="The String to be found.") T second) {
        return ULIntValue.toULIntValue((long)first.stringValue().indexOf(second.stringValue()) + 1L);
    }

    @Comment(value="Returns the location of the first occurrence a WString in a WString.")
    public static <T extends AnyWCharsValue> AnyIntValue FIND(@Comment(value="The WString to be searched.") WStringValue first, @Comment(value="The WString to be found.") T second) {
        return ULIntValue.toULIntValue((long)first.stringValue().indexOf(second.stringValue()) + 1L);
    }

    @Comment(value="Returns the lower bound of the dimension of the given array")
    public static <T extends ArrayValue, U extends AnyIntValue> AnyIntValue LOWER_BOUND(T array, U dimension) {
        return DIntValue.toDIntValue(((Subrange)array.getType().getSubranges().get(dimension.intValue() - 1)).getLowerLimit());
    }

    @Comment(value="Returns the upper bound of the dimension of the given array")
    public static <T extends ArrayValue, U extends AnyIntValue> AnyIntValue UPPER_BOUND(T array, U dimension) {
        return DIntValue.toDIntValue(((Subrange)array.getType().getSubranges().get(dimension.intValue() - 1)).getUpperLimit());
    }

    @Comment(value="Returns addition of two DURATION values.")
    public static <T extends AnyDurationValue> T ADD(T first, T second) {
        return (T)((AnyDurationValue)ValueOperations.add(first, second));
    }

    @Comment(value="Returns addition of two TIME values.")
    public static TimeValue ADD_TIME(TimeValue first, TimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns addition of two LTIME values.")
    public static LTimeValue ADD_LTIME(LTimeValue first, LTimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns addition of TIME_OF_DAY value and TIME value as TIME_OF_DAY value.")
    public static TimeOfDayValue ADD(TimeOfDayValue first, TimeValue second) {
        return TimeOfDayValue.toTimeOfDayValue(first.toNanos() + second.longValue());
    }

    @Comment(value="Returns addition of LTIME_OF_DAY value and long LTIME value as LTIME_OF_DAY value.")
    public static LTimeOfDayValue ADD(LTimeOfDayValue first, LTimeValue second) {
        return LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() + second.longValue());
    }

    @Comment(value="Returns addition of TIME_OF_DAY value and TIME value as TIME_OF_DAY value.")
    public static TimeOfDayValue ADD_TOD_TIME(TimeOfDayValue first, TimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns addition of LTIME_OF_DAY value and LTIME value as LTIME_OF_DAY value.")
    public static LTimeOfDayValue ADD_LTOD_LTIME(LTimeOfDayValue first, LTimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns addition of DATE_AND_TIME value and TIME value as DATE_AND_TIME value.")
    public static DateAndTimeValue ADD(DateAndTimeValue first, TimeValue second) {
        return DateAndTimeValue.toDateAndTimeValue(first.toNanos() + second.longValue());
    }

    @Comment(value="Returns addition of LDATE_AND_TIME value and LTIME value as LDATE_AND_TIME value.")
    public static LDateAndTimeValue ADD(LDateAndTimeValue first, LTimeValue second) {
        return LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() + second.longValue());
    }

    @Comment(value="Returns addition of DATE_AND_TIME value and TIME value as DATE_AND_TIME value.")
    public static DateAndTimeValue ADD_DT_TIME(DateAndTimeValue first, TimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns addition of LDATE_AND_TIME value and LTIME value as LDATE_AND_TIME value.")
    public static LDateAndTimeValue ADD_LDT_LTIME(LDateAndTimeValue first, LTimeValue second) {
        return StandardFunctions.ADD(first, second);
    }

    @Comment(value="Returns subtraction of two DURATION values.")
    public static <T extends AnyDurationValue> T SUB(T first, T second) {
        return (T)((AnyDurationValue)ValueOperations.subtract(first, second));
    }

    @Comment(value="Returns subtraction of two TIME values.")
    public static TimeValue SUB_TIME(TimeValue first, TimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two LTIME values.")
    public static LTimeValue SUB_LTIME(LTimeValue first, LTimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two DATE values as TIME value.")
    public static TimeValue SUB(DateValue first, DateValue second) {
        return TimeValue.toTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two LDATE values as LTIME value.")
    public static LTimeValue SUB(LDateValue first, LDateValue second) {
        return LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two DATE values as TIME value.")
    public static TimeValue SUB_DATE_DATE(DateValue first, DateValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two LDATE values as LTIME value.")
    public static LTimeValue SUB_LDATE_LDATE(LDateValue first, LDateValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of TIME_OF_DAY value and TIME value as TIME_OF_DAY value.")
    public static TimeOfDayValue SUB(TimeOfDayValue first, TimeValue second) {
        return TimeOfDayValue.toTimeOfDayValue(first.toNanos() - second.longValue());
    }

    @Comment(value="Returns subtraction of LTIME_OF_DAY value and LTIME value as LTIME_OF_DAY value.")
    public static LTimeOfDayValue SUB(LTimeOfDayValue first, LTimeValue second) {
        return LTimeOfDayValue.toLTimeOfDayValue(first.toNanos() - second.longValue());
    }

    @Comment(value="Returns subtraction of TIME_OF_DAY value and TIME value as TIME_OF_DAY value.")
    public static TimeOfDayValue SUB_TOD_TIME(TimeOfDayValue first, TimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of LTIME_OF_DAY value and LTIME value as LTIME_OF_DAY value.")
    public static LTimeOfDayValue SUB_LTOD_LTIME(LTimeOfDayValue first, LTimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two TIME_OF_DAY values as TIME value.")
    public static TimeValue SUB(TimeOfDayValue first, TimeOfDayValue second) {
        return TimeValue.toTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two LTIME_OF_DAY values as LTIME value.")
    public static LTimeValue SUB(LTimeOfDayValue first, LTimeOfDayValue second) {
        return LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two TIME_OF_DAY values as TIME value.")
    public static TimeValue SUB_TOD_TOD(TimeOfDayValue first, TimeOfDayValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of LTIME_OF_DAY values as LTIME value.")
    public static LTimeValue SUB_LTOD_LTOD(LTimeOfDayValue first, LTimeOfDayValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of DATE_AND_TIME value and TIME value as DATE_AND_TIME value.")
    public static DateAndTimeValue SUB(DateAndTimeValue first, TimeValue second) {
        return DateAndTimeValue.toDateAndTimeValue(first.toNanos() - second.longValue());
    }

    @Comment(value="Returns subtraction of LDATE_AND_TIME value and LTIME value as LDATE_AND_TIME value.")
    public static LDateAndTimeValue SUB(LDateAndTimeValue first, LTimeValue second) {
        return LDateAndTimeValue.toLDateAndTimeValue(first.toNanos() - second.longValue());
    }

    @Comment(value="Returns subtraction of DATE_AND_TIME value and TIME value as DATE_AND_TIME value.")
    public static DateAndTimeValue SUB_DT_TIME(DateAndTimeValue first, TimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of LDATE_AND_TIME value and LTIME value as LDATE_AND_TIME value.")
    public static LDateAndTimeValue SUB_LDT_LTIME(LDateAndTimeValue first, LTimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two DATE_AND_TIME values as TIME value.")
    public static TimeValue SUB(DateAndTimeValue first, DateAndTimeValue second) {
        return TimeValue.toTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two LDATE_AND_TIME values as LTIME value.")
    public static LTimeValue SUB(LDateAndTimeValue first, LDateAndTimeValue second) {
        return LTimeValue.toLTimeValue(first.toNanos() - second.toNanos());
    }

    @Comment(value="Returns subtraction of two DATE_AND_TIME values as TIME value.")
    public static TimeValue SUB_DT_DT(DateAndTimeValue first, DateAndTimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns subtraction of two LDATE_AND_TIME values as LTIME value.")
    public static LTimeValue SUB_LDT_LDT(LDateAndTimeValue first, LDateAndTimeValue second) {
        return StandardFunctions.SUB(first, second);
    }

    @Comment(value="Returns multiplication of DURATION value and ANY_NUM value as DURATION value.")
    public static <T extends AnyDurationValue, U extends AnyNumValue> T MUL(T first, U second) {
        return (T)((AnyDurationValue)ValueOperations.multiply(first, second));
    }

    @Comment(value="Returns multiplication of TIME value and ANY_NUM value as TIME value.")
    public static <U extends AnyNumValue> TimeValue MUL_TIME(TimeValue first, U second) {
        return StandardFunctions.MUL(first, second);
    }

    @Comment(value="Returns multiplication of LTIME value and ANY_NUM value as LTIME value.")
    public static <U extends AnyNumValue> LTimeValue MUL_LTIME(LTimeValue first, U second) {
        return StandardFunctions.MUL(first, second);
    }

    @Comment(value="Returns division of DURATION value and ANY_NUM value as DURATION value.")
    public static <T extends AnyDurationValue, U extends AnyNumValue> T DIV(T first, U second) {
        return (T)((AnyDurationValue)ValueOperations.divideBy(first, second));
    }

    @Comment(value="Returns division of TIME value and ANY_NUM value as TIME value.")
    public static <U extends AnyNumValue> TimeValue DIV_TIME(TimeValue first, U second) {
        return StandardFunctions.DIV(first, second);
    }

    @Comment(value="Returns division of LTIME value and ANY_NUM value as LTIME value.")
    public static <U extends AnyNumValue> LTimeValue DIV_LTIME(LTimeValue first, U second) {
        return StandardFunctions.DIV(first, second);
    }

    @Comment(value="Concatenates DATE value and TIME_OF_DAY value and returns DATE_AND_TIME value.")
    public static DateAndTimeValue CONCAT_DATE_TOD(DateValue first, TimeOfDayValue second) {
        return DateAndTimeValue.toDateAndTimeValue(first.toLocalDate().atTime(second.toLocalTime()));
    }

    @Comment(value="Concatenates LDATE value and LTIME_OF_DAY value and returns LDATE_AND_TIME value.")
    public static LDateAndTimeValue CONCAT_LDATE_LTOD(LDateValue first, LTimeOfDayValue second) {
        return LDateAndTimeValue.toLDateAndTimeValue(first.toLocalDate().atTime(second.toLocalTime()));
    }

    @Comment(value="Concatenates time informations about year, month and day and returns DATE value.")
    public static <T extends AnyIntValue> DateValue CONCAT_DATE(@Comment(value="The year number.") T year, @Comment(value="The month number.") T month, @Comment(value="The day number.") T day) {
        return DateValue.toDateValue(LocalDate.of(year.intValue(), month.intValue(), day.intValue()));
    }

    @Comment(value="Concatenates time informations about hour, minute, second and millisecond and returns TIME_OF_DAY value.")
    public static <T extends AnyIntValue> TimeOfDayValue CONCAT_TOD(@Comment(value="The hour number.") T hour, @Comment(value="The minute number.") T minute, @Comment(value="The second number.") T second, @Comment(value="The millisecond number.") T millisecond) {
        return TimeOfDayValue.toTimeOfDayValue(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue() * 1000000));
    }

    @Comment(value="Concatenates time informations about hour, minute, second and millisecond and returns LTIME_OF_DAY value.")
    public static <T extends AnyIntValue> LTimeOfDayValue CONCAT_LTOD(@Comment(value="The hour number.") T hour, @Comment(value="The minute number.") T minute, @Comment(value="The second number.") T second, @Comment(value="The millisecond number.") T millisecond) {
        return LTimeOfDayValue.toLTimeOfDayValue(LocalTime.of(hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue() * 1000000));
    }

    @Comment(value="Concatenates time informations about year, month, day, hour, minute, second and millisecond and returns DATE_AND_TIME value.")
    public static <T extends AnyIntValue> DateAndTimeValue CONCAT_DT(@Comment(value="The year number.") T year, @Comment(value="The month number.") T month, @Comment(value="The day number.") T day, @Comment(value="The hour number.") T hour, @Comment(value="The minute number.") T minute, @Comment(value="The second number.") T second, @Comment(value="The millisecond number.") T millisecond) {
        return DateAndTimeValue.toDateAndTimeValue(LocalDateTime.of(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue() * 1000000));
    }

    @Comment(value="Concatenates time informations about year, month, day, hour, minute, second and millisecond and returns LDATE_AND_TIME value.")
    public static <T extends AnyIntValue> LDateAndTimeValue CONCAT_LDT(@Comment(value="The year number.") T year, @Comment(value="The month number.") T month, @Comment(value="The day number.") T day, @Comment(value="The hour number.") T hour, @Comment(value="The minute number.") T minute, @Comment(value="The second number.") T second, @Comment(value="The millisecond number.") T millisecond) {
        return LDateAndTimeValue.toLDateAndTimeValue(LocalDateTime.of(year.intValue(), month.intValue(), day.intValue(), hour.intValue(), minute.intValue(), second.intValue(), millisecond.intValue() * 1000000));
    }

    @Comment(value="Splits time informations about year, month and day of DATE value.")
    public static <T extends AnyIntValue, U extends AnyIntValue, V extends AnyIntValue> void SPLIT_DATE(@Comment(value="The input date time.") DateValue in, @Comment(value="The year number.") Variable<T> year, @Comment(value="The month number.") Variable<U> month, @Comment(value="The day number.") Variable<V> day) {
        LocalDate value = in.toLocalDate();
        year.setValue(DIntValue.toDIntValue(value.getYear()));
        month.setValue(DIntValue.toDIntValue(value.getMonthValue()));
        day.setValue(DIntValue.toDIntValue(value.getDayOfMonth()));
    }

    @Comment(value="Splits time informations about day, hour, minute and second of TIME_OF_DAY value.")
    public static <T extends AnyIntValue, U extends AnyIntValue, V extends AnyIntValue, W extends AnyIntValue> void SPLIT_TOD(@Comment(value="The input date time.") TimeOfDayValue in, @Comment(value="The hour number.") Variable<T> hour, @Comment(value="The minute number.") Variable<U> minute, @Comment(value="The second number.") Variable<V> second, @Comment(value="The millisecond number.") Variable<W> millisecond) {
        LocalTime value = in.toLocalTime();
        hour.setValue(DIntValue.toDIntValue(value.getHour()));
        minute.setValue(DIntValue.toDIntValue(value.getMinute()));
        second.setValue(DIntValue.toDIntValue(value.getSecond()));
        millisecond.setValue(DIntValue.toDIntValue(value.getNano() / 1000000));
    }

    @Comment(value="Splits time informations about day, hour, minute and second of LTIME_OF_DAY value.")
    public static <T extends AnyIntValue, U extends AnyIntValue, V extends AnyIntValue, W extends AnyIntValue> void SPLIT_LTOD(@Comment(value="The input date time.") LTimeOfDayValue in, @Comment(value="The hour number.") Variable<T> hour, @Comment(value="The minute number.") Variable<U> minute, @Comment(value="The millisecond number.") Variable<V> second, Variable<W> millisecond) {
        LocalTime value = in.toLocalTime();
        hour.setValue(DIntValue.toDIntValue(value.getHour()));
        minute.setValue(DIntValue.toDIntValue(value.getMinute()));
        second.setValue(DIntValue.toDIntValue(value.getSecond()));
        millisecond.setValue(DIntValue.toDIntValue(value.getNano() / 1000000));
    }

    @Comment(value="Splits time informations about year, month, day, hour, minute and second of DATE_AND_TIME value.")
    public static <T extends AnyIntValue, U extends AnyIntValue, V extends AnyIntValue, W extends AnyIntValue, X extends AnyIntValue, Y extends AnyIntValue, Z extends AnyIntValue> void SPLIT_DT(@Comment(value="The input date time.") DateAndTimeValue in, @Comment(value="The year number.") Variable<T> year, @Comment(value="The month number.") Variable<U> month, @Comment(value="The day number.") Variable<V> day, @Comment(value="The hour number.") Variable<W> hour, @Comment(value="The minute number.") Variable<X> minute, @Comment(value="The second number.") Variable<Y> second, @Comment(value="The millisecond number.") Variable<Z> millisecond) {
        LocalDateTime value = in.toLocalDateTime();
        year.setValue(DIntValue.toDIntValue(value.getYear()));
        month.setValue(DIntValue.toDIntValue(value.getMonthValue()));
        day.setValue(DIntValue.toDIntValue(value.getDayOfMonth()));
        hour.setValue(DIntValue.toDIntValue(value.getHour()));
        minute.setValue(DIntValue.toDIntValue(value.getMinute()));
        second.setValue(DIntValue.toDIntValue(value.getSecond()));
        millisecond.setValue(DIntValue.toDIntValue(value.getNano() / 1000000));
    }

    @Comment(value="Splits time informations about year, month, day, hour, minute and second of LDATE_AND_TIME value.")
    public static <T extends AnyIntValue, U extends AnyIntValue, V extends AnyIntValue, W extends AnyIntValue, X extends AnyIntValue, Y extends AnyIntValue, Z extends AnyIntValue> void SPLIT_LDT(@Comment(value="The input date time.") LDateAndTimeValue in, @Comment(value="The year number.") Variable<T> year, @Comment(value="The month number.") Variable<U> month, @Comment(value="The day number.") Variable<V> day, @Comment(value="The hour number.") Variable<W> hour, @Comment(value="The minute number.") Variable<X> minute, @Comment(value="The second number.") Variable<Y> second, @Comment(value="The millisecond number.") Variable<Z> millisecond) {
        LocalDateTime value = in.toLocalDateTime();
        year.setValue(DIntValue.toDIntValue(value.getYear()));
        month.setValue(DIntValue.toDIntValue(value.getMonthValue()));
        day.setValue(DIntValue.toDIntValue(value.getDayOfMonth()));
        hour.setValue(DIntValue.toDIntValue(value.getHour()));
        minute.setValue(DIntValue.toDIntValue(value.getMinute()));
        second.setValue(DIntValue.toDIntValue(value.getSecond()));
        millisecond.setValue(DIntValue.toDIntValue(value.getNano() / 1000000));
    }

    @Comment(value="Returns the day of week of DATE value.")
    public static AnyIntValue DAY_OF_WEEK(DateValue value) {
        return USIntValue.toUSIntValue((byte)(value.toLocalDate().getDayOfWeek().getValue() % 7));
    }

    @Comment(value="Converts a value into the big-endian format.")
    public static <T extends AnyValue> T TO_BIG_ENDIAN(T value) {
        return value;
    }

    @Comment(value="Converts a value into the little-endian format.")
    public static <T extends AnyValue> T TO_LITTLE_ENDIAN(T value) {
        return (T)((AnyValue)ValueOperations.reverseBytes(value));
    }

    @Comment(value="Converts an entered value in big-endian format into the appropriate endian format of the target system.")
    public static <T extends AnyValue> T FROM_BIG_ENDIAN(T value) {
        return value;
    }

    @Comment(value="Converts an entered value in little-endian format into the appropriate endian format of the target system.")
    public static <T extends AnyValue> T FROM_LITTLE_ENDIAN(T value) {
        return (T)((AnyValue)ValueOperations.reverseBytes(value));
    }

    @Comment(value="Returns TRUE if the parameter is a ANY_REAL number.")
    public static <T extends AnyRealValue> BoolValue IS_VALID(T value) {
        return BoolValue.toBoolValue(Double.isFinite(value.doubleValue()));
    }

    @Comment(value="Returns TRUE if the parameter is valid BCD.")
    public static <T extends AnyBitValue> BoolValue IS_VALID_BCD(T value) {
        byte[] byArray = value.bigIntegerValue().toByteArray();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte packed = byArray[n2];
            int packedInt = Byte.toUnsignedInt(packed);
            int upper = packedInt >>> 4;
            int lower = packedInt & 0xF;
            if (upper > 9 || lower > 9) {
                return BoolValue.FALSE;
            }
            ++n2;
        }
        return BoolValue.TRUE;
    }

    @Comment(value="Converts LREAL value TO REAL value.")
    public static RealValue LREAL_TO_REAL(LRealValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts LREAL value to LINT value.")
    public static LIntValue LREAL_TO_LINT(LRealValue value) {
        return LIntValue.toLIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts LREAL value to DINT value.")
    public static DIntValue LREAL_TO_DINT(LRealValue value) {
        return DIntValue.toDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts LREAL value to INT value.")
    public static IntValue LREAL_TO_INT(LRealValue value) {
        return IntValue.toIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts LREAL value to SINT value.")
    public static SIntValue LREAL_TO_SINT(LRealValue value) {
        return SIntValue.toSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts LREAL value to LINT value.")
    public static ULIntValue LREAL_TO_ULINT(LRealValue value) {
        return ULIntValue.toULIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts LREAL value to UDINT value.")
    public static UDIntValue LREAL_TO_UDINT(LRealValue value) {
        return UDIntValue.toUDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts LREAL value to UINT value.")
    public static UIntValue LREAL_TO_UINT(LRealValue value) {
        return UIntValue.toUIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts LREAL value to USINT value.")
    public static USIntValue LREAL_TO_USINT(LRealValue value) {
        return USIntValue.toUSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts LREAL value to LWORD value.")
    public static LWordValue LREAL_TO_LWORD(LRealValue value) {
        return LWordValue.toLWordValue(Double.doubleToRawLongBits(value.doubleValue()));
    }

    @Comment(value="Converts REAL value to LREAL value.")
    public static LRealValue REAL_TO_LREAL(RealValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts REAL value to LINT value.")
    public static LIntValue REAL_TO_LINT(RealValue value) {
        return LIntValue.toLIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts REAL value to DINT value.")
    public static DIntValue REAL_TO_DINT(RealValue value) {
        return DIntValue.toDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts REAL value to INT value.")
    public static IntValue REAL_TO_INT(RealValue value) {
        return IntValue.toIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts REAL value to SINT value.")
    public static SIntValue REAL_TO_SINT(RealValue value) {
        return SIntValue.toSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts REAL value to ULINT value.")
    public static ULIntValue REAL_TO_ULINT(RealValue value) {
        return ULIntValue.toULIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts REAL value to UDINT value.")
    public static UDIntValue REAL_TO_UDINT(RealValue value) {
        return UDIntValue.toUDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts REAL value to UINT value.")
    public static UIntValue REAL_TO_UINT(RealValue value) {
        return UIntValue.toUIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts REAL value to USINT value.")
    public static USIntValue REAL_TO_USINT(RealValue value) {
        return USIntValue.toUSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts REAL value to DWORD value.")
    public static DWordValue REAL_TO_DWORD(RealValue value) {
        return DWordValue.toDWordValue(Float.floatToRawIntBits(value.floatValue()));
    }

    @Comment(value="Converts LINT value to LREAL value.")
    public static LRealValue LINT_TO_LREAL(LIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts LINT value to REAL value.")
    public static RealValue LINT_TO_REAL(LIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts LINT value to DINT value.")
    public static DIntValue LINT_TO_DINT(LIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts LINT value to INT value.")
    public static IntValue LINT_TO_INT(LIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts LINT value to SINT value.")
    public static SIntValue LINT_TO_SINT(LIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts LINT value to ULINT value.")
    public static ULIntValue LINT_TO_ULINT(LIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts LINT value to UDINT value.")
    public static UDIntValue LINT_TO_UDINT(LIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts LINT value to UINT value.")
    public static UIntValue LINT_TO_UINT(LIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts LINT value to USINT value.")
    public static USIntValue LINT_TO_USINT(LIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts LINT value to long word value.")
    public static LWordValue LINT_TO_LWORD(LIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts LINT value to DWORD value.")
    public static DWordValue LINT_TO_DWORD(LIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts LINT value to WORD value.")
    public static WordValue LINT_TO_WORD(LIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts LINT value to BYTE value.")
    public static ByteValue LINT_TO_BYTE(LIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts DINT value to LREAL value.")
    public static LRealValue DINT_TO_LREAL(DIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts DINT value to REAL value.")
    public static RealValue DINT_TO_REAL(DIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts DINT value to long LINT value.")
    public static LIntValue DINT_TO_LINT(DIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts DINT value to INT value.")
    public static IntValue DINT_TO_INT(DIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts DINT value to SINT value.")
    public static SIntValue DINT_TO_SINT(DIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts DINT value to ULINT value.")
    public static ULIntValue DINT_TO_ULINT(DIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts DINT value to UDINT value.")
    public static UDIntValue DINT_TO_UDINT(DIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts DINT value to UINT value.")
    public static UIntValue DINT_TO_UINT(DIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts DINT value to USINT value.")
    public static USIntValue DINT_TO_USINT(DIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts DINT value to LWORD value.")
    public static LWordValue DINT_TO_LWORD(DIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts DINT value to DWORD value.")
    public static DWordValue DINT_TO_DWORD(DIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts DINT value to WORD value.")
    public static WordValue DINT_TO_WORD(DIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts DINT value to BYTE value.")
    public static ByteValue DINT_TO_BYTE(DIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts INT value to LREAL value.")
    public static LRealValue INT_TO_LREAL(IntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts INT value to REAL value.")
    public static RealValue INT_TO_REAL(IntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts INT value to LINT value.")
    public static LIntValue INT_TO_LINT(IntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts INT value to DINT value.")
    public static DIntValue INT_TO_DINT(IntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts INT value to SINT value.")
    public static SIntValue INT_TO_SINT(IntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts INT value to ULINT value.")
    public static ULIntValue INT_TO_ULINT(IntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts INT value to UDINT value.")
    public static UDIntValue INT_TO_UDINT(IntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts INT value to UINT value.")
    public static UIntValue INT_TO_UINT(IntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts INT value to USINT value.")
    public static USIntValue INT_TO_USINT(IntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts INT value to LWORD value.")
    public static LWordValue INT_TO_LWORD(IntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts INT value to DWORD value.")
    public static DWordValue INT_TO_DWORD(IntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts INT value to WORD value.")
    public static WordValue INT_TO_WORD(IntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts INT value to BYTE value.")
    public static ByteValue INT_TO_BYTE(IntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts SINT value to LREAL value.")
    public static LRealValue SINT_TO_LREAL(SIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts SINT value to REAL value.")
    public static RealValue SINT_TO_REAL(SIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts SINT value to LINT value.")
    public static LIntValue SINT_TO_LINT(SIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts SINT value to DINT value.")
    public static DIntValue SINT_TO_DINT(SIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts SINT value to INT value.")
    public static IntValue SINT_TO_INT(SIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts SINT value to ULINT value.")
    public static ULIntValue SINT_TO_ULINT(SIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts SINT value to UDINT value.")
    public static UDIntValue SINT_TO_UDINT(SIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts SINT value to UINT value.")
    public static UIntValue SINT_TO_UINT(SIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts SINT value to USINT value.")
    public static USIntValue SINT_TO_USINT(SIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts SINT value to LWORD value.")
    public static LWordValue SINT_TO_LWORD(SIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts SINT value to DWORD value.")
    public static DWordValue SINT_TO_DWORD(SIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts SINT value to WORD value.")
    public static WordValue SINT_TO_WORD(SIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts SINT value to BYTE value.")
    public static ByteValue SINT_TO_BYTE(SIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts ULINT value to LREAL value.")
    public static LRealValue ULINT_TO_LREAL(ULIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts ULINT value to REAL value.")
    public static RealValue ULINT_TO_REAL(ULIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts ULINT value to LINT value.")
    public static LIntValue ULINT_TO_LINT(ULIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts ULINT value to DINT value.")
    public static DIntValue ULINT_TO_DINT(ULIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts ULINT value to INT value.")
    public static IntValue ULINT_TO_INT(ULIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts ULINT value to SINT value.")
    public static SIntValue ULINT_TO_SINT(ULIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts ULINT value to UDINT value.")
    public static UDIntValue ULINT_TO_UDINT(ULIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts ULINT value to UINT value.")
    public static UIntValue ULINT_TO_UINT(ULIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts ULINT value to USINT value.")
    public static USIntValue ULINT_TO_USINT(ULIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts ULINT value to LWORD value.")
    public static LWordValue ULINT_TO_LWORD(ULIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts ULINT value to DWORD value.")
    public static DWordValue ULINT_TO_DWORD(ULIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts ULINT value to WORD value.")
    public static WordValue ULINT_TO_WORD(ULIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts ULINT value to BYTE value.")
    public static ByteValue ULINT_TO_BYTE(ULIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts UDINT value to LREAL value.")
    public static LRealValue UDINT_TO_LREAL(UDIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts UDINT value to REAL value.")
    public static RealValue UDINT_TO_REAL(UDIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts UDINT value to LINT value.")
    public static LIntValue UDINT_TO_LINT(UDIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts UDINT value to DINT value.")
    public static DIntValue UDINT_TO_DINT(UDIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts UDINT value to INT value.")
    public static IntValue UDINT_TO_INT(UDIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts UDINT value to SINT value.")
    public static SIntValue UDINT_TO_SINT(UDIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts UDINT value to ULINT value.")
    public static ULIntValue UDINT_TO_ULINT(UDIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts UDINT value to UINT value.")
    public static UIntValue UDINT_TO_UINT(UDIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts UDINT value to USINT value.")
    public static USIntValue UDINT_TO_USINT(UDIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts UDINT value to LWORD value.")
    public static LWordValue UDINT_TO_LWORD(UDIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts UDINT value to DWORD value.")
    public static DWordValue UDINT_TO_DWORD(UDIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts UDINT value to WORD value.")
    public static WordValue UDINT_TO_WORD(UDIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts UDINT value to BYTE value.")
    public static ByteValue UDINT_TO_BYTE(UDIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts UINT value to LREAL value.")
    public static LRealValue UINT_TO_LREAL(UIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts UINT value to REAL value.")
    public static RealValue UINT_TO_REAL(UIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts UINT value to LINT value.")
    public static LIntValue UINT_TO_LINT(UIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts UINT value to DINT value.")
    public static DIntValue UINT_TO_DINT(UIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts UINT value to INT value.")
    public static IntValue UINT_TO_INT(UIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts UINT value to SINT value.")
    public static SIntValue UINT_TO_SINT(UIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts UINT value to ULINT value.")
    public static ULIntValue UINT_TO_ULINT(UIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts UINT value to UDINT value.")
    public static UDIntValue UINT_TO_UDINT(UIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts UINT value to USINT value.")
    public static USIntValue UINT_TO_USINT(UIntValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts UINT value to LWORD value.")
    public static LWordValue UINT_TO_LWORD(UIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts UINT value to DWORD value.")
    public static DWordValue UINT_TO_DWORD(UIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts UINT value to WORD value.")
    public static WordValue UINT_TO_WORD(UIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts UINT value to BYTE value.")
    public static ByteValue UINT_TO_BYTE(UIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts USINT Value to LREAL value.")
    public static LRealValue USINT_TO_LREAL(USIntValue value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts USINT Value to REAL value.")
    public static RealValue USINT_TO_REAL(USIntValue value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts USINT Value to LINT value.")
    public static LIntValue USINT_TO_LINT(USIntValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts USINT Value to DINT value.")
    public static DIntValue USINT_TO_DINT(USIntValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts USINT Value to INT value.")
    public static IntValue USINT_TO_INT(USIntValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts USINT Value to SINT value.")
    public static SIntValue USINT_TO_SINT(USIntValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts USINT Value to ULINT value.")
    public static ULIntValue USINT_TO_ULINT(USIntValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts USINT Value to UDINT value.")
    public static UDIntValue USINT_TO_UDINT(USIntValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts USINT Value to UINT value.")
    public static UIntValue USINT_TO_UINT(USIntValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts USINT Value to LWORD value.")
    public static LWordValue USINT_TO_LWORD(USIntValue value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts USINT Value to DWORD value.")
    public static DWordValue USINT_TO_DWORD(USIntValue value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts USINT Value to WORD value.")
    public static WordValue USINT_TO_WORD(USIntValue value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts USINT Value to BYTE value.")
    public static ByteValue USINT_TO_BYTE(USIntValue value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts LWORD value to LREAL value.")
    public static LRealValue LWORD_TO_LREAL(LWordValue value) {
        return LRealValue.toLRealValue(Double.longBitsToDouble(value.longValue()));
    }

    @Comment(value="Converts LWORD value to LINT value.")
    public static LIntValue LWORD_TO_LINT(LWordValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts LWORD value to DINT value.")
    public static DIntValue LWORD_TO_DINT(LWordValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts LWORD value to INT value.")
    public static IntValue LWORD_TO_INT(LWordValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts LWORD value to SINT value.")
    public static SIntValue LWORD_TO_SINT(LWordValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts LWORD value to ULINT value.")
    public static ULIntValue LWORD_TO_ULINT(LWordValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts LWORD value to UDINT value.")
    public static UDIntValue LWORD_TO_UDINT(LWordValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts LWORD value to UINT value.")
    public static UIntValue LWORD_TO_UINT(LWordValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts LWORD value to USINT value.")
    public static USIntValue LWORD_TO_USINT(LWordValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts LWORD value to DWORD value.")
    public static DWordValue LWORD_TO_DWORD(LWordValue value) {
        return DWordValue.toDWordValue(value);
    }

    @Comment(value="Converts LWORD value to WORD value.")
    public static WordValue LWORD_TO_WORD(LWordValue value) {
        return WordValue.toWordValue(value);
    }

    @Comment(value="Converts LWORD value to BYTE value.")
    public static ByteValue LWORD_TO_BYTE(LWordValue value) {
        return ByteValue.toByteValue(value);
    }

    @Comment(value="Converts LWORD value to BOOL value.")
    public static BoolValue LWORD_TO_BOOL(LWordValue value) {
        return BoolValue.toBoolValue(value);
    }

    @Comment(value="Converts DWORD value to REAL value.")
    public static RealValue DWORD_TO_REAL(DWordValue value) {
        return RealValue.toRealValue(Float.intBitsToFloat(value.intValue()));
    }

    @Comment(value="Converts DWORD value to LINT value.")
    public static LIntValue DWORD_TO_LINT(DWordValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts DWORD value to DINT value.")
    public static DIntValue DWORD_TO_DINT(DWordValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts DWORD value to INT value.")
    public static IntValue DWORD_TO_INT(DWordValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts DWORD value to SINT value.")
    public static SIntValue DWORD_TO_SINT(DWordValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts DWORD value to ULINT value.")
    public static ULIntValue DWORD_TO_ULINT(DWordValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts DWORD value to UDINT value.")
    public static UDIntValue DWORD_TO_UDINT(DWordValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts DWORD value to UINT value.")
    public static UIntValue DWORD_TO_UINT(DWordValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts DWORD value to USINT value.")
    public static USIntValue DWORD_TO_USINT(DWordValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts DWORD value to LWORD value.")
    public static LWordValue DWORD_TO_LWORD(DWordValue value) {
        return LWordValue.toLWordValue(value);
    }

    @Comment(value="Converts DWORD value to WORD value.")
    public static WordValue DWORD_TO_WORD(DWordValue value) {
        return WordValue.toWordValue(value);
    }

    @Comment(value="Converts DWORD value to BYTE value.")
    public static ByteValue DWORD_TO_BYTE(DWordValue value) {
        return ByteValue.toByteValue(value);
    }

    @Comment(value="Converts DWORD value to BOOL value.")
    public static BoolValue DWORD_TO_BOOL(DWordValue value) {
        return BoolValue.toBoolValue(value);
    }

    @Comment(value="Converts WORD value to LINT value.")
    public static LIntValue WORD_TO_LINT(WordValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts WORD value to DINT value.")
    public static DIntValue WORD_TO_DINT(WordValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts WORD value to INT value.")
    public static IntValue WORD_TO_INT(WordValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts WORD value to SINT value.")
    public static SIntValue WORD_TO_SINT(WordValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts WORD value to ULINT value.")
    public static ULIntValue WORD_TO_ULINT(WordValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts WORD value to UDINT value.")
    public static UDIntValue WORD_TO_UDINT(WordValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts WORD value to UINT value.")
    public static UIntValue WORD_TO_UINT(WordValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts WORD value to USINT value.")
    public static USIntValue WORD_TO_USINT(WordValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts WORD value to LWORD value.")
    public static LWordValue WORD_TO_LWORD(WordValue value) {
        return LWordValue.toLWordValue(value);
    }

    @Comment(value="Converts WORD value to DWORD value.")
    public static DWordValue WORD_TO_DWORD(WordValue value) {
        return DWordValue.toDWordValue(value);
    }

    @Comment(value="Converts WORD value to BYTE value.")
    public static ByteValue WORD_TO_BYTE(WordValue value) {
        return ByteValue.toByteValue(value);
    }

    @Comment(value="Converts WORD value to BOOL value.")
    public static BoolValue WORD_TO_BOOL(WordValue value) {
        return BoolValue.toBoolValue(value);
    }

    @Comment(value="Converts BYTE value to LINT value.")
    public static LIntValue BYTE_TO_LINT(ByteValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts BYTE value to DINT value.")
    public static DIntValue BYTE_TO_DINT(ByteValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts BYTE value to INT value.")
    public static IntValue BYTE_TO_INT(ByteValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts BYTE value to SINT value.")
    public static SIntValue BYTE_TO_SINT(ByteValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts BYTE value to ULINT value.")
    public static ULIntValue BYTE_TO_ULINT(ByteValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts BYTE value to UDINT value.")
    public static UDIntValue BYTE_TO_UDINT(ByteValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts BYTE value to UINT value.")
    public static UIntValue BYTE_TO_UINT(ByteValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts BYTE value to USINT value.")
    public static USIntValue BYTE_TO_USINT(ByteValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts BYTE value to LWORD value.")
    public static LWordValue BYTE_TO_LWORD(ByteValue value) {
        return LWordValue.toLWordValue(value);
    }

    @Comment(value="Converts BYTE value to DWORD value.")
    public static DWordValue BYTE_TO_DWORD(ByteValue value) {
        return DWordValue.toDWordValue(value);
    }

    @Comment(value="Converts BYTE value to WORD value.")
    public static WordValue BYTE_TO_WORD(ByteValue value) {
        return WordValue.toWordValue(value);
    }

    @Comment(value="Converts BYTE value to BOOL value.")
    public static BoolValue BYTE_TO_BOOL(ByteValue value) {
        return BoolValue.toBoolValue(value);
    }

    @Comment(value="Converts BYTE value to CHAR value.")
    public static CharValue BYTE_TO_CHAR(ByteValue value) {
        return CharValue.toCharValue(value.byteValue());
    }

    @Comment(value="Converts BOOL value to LINT value.")
    public static LIntValue BOOL_TO_LINT(BoolValue value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts BOOL value to DINT value.")
    public static DIntValue BOOL_TO_DINT(BoolValue value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts BOOL value to INT value.")
    public static IntValue BOOL_TO_INT(BoolValue value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts BOOL value to SINT value.")
    public static SIntValue BOOL_TO_SINT(BoolValue value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts BOOL value to ULINT value.")
    public static ULIntValue BOOL_TO_ULINT(BoolValue value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts BOOL value to UDINT value.")
    public static UDIntValue BOOL_TO_UDINT(BoolValue value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts BOOL value to UINT value.")
    public static UIntValue BOOL_TO_UINT(BoolValue value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts BOOL value to USINT value.")
    public static USIntValue BOOL_TO_USINT(BoolValue value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts BOOL value to LWORD value.")
    public static LWordValue BOOL_TO_LWORD(BoolValue value) {
        return LWordValue.toLWordValue(value);
    }

    @Comment(value="Converts BOOL value to DWORD value.")
    public static DWordValue BOOL_TO_DWORD(BoolValue value) {
        return DWordValue.toDWordValue(value);
    }

    @Comment(value="Converts BOOL value to WORD value.")
    public static WordValue BOOL_TO_WORD(BoolValue value) {
        return WordValue.toWordValue(value);
    }

    @Comment(value="Converts BOOL value to BYTE value.")
    public static ByteValue BOOL_TO_BYTE(BoolValue value) {
        return ByteValue.toByteValue(value);
    }

    @Comment(value="Converts CHAR value to LWORD value.")
    public static LWordValue CHAR_TO_LWORD(CharValue value) {
        return LWordValue.toLWordValue(value.charValue());
    }

    @Comment(value="Converts CHAR value to DWORD value.")
    public static DWordValue CHAR_TO_DWORD(CharValue value) {
        return DWordValue.toDWordValue(value.charValue());
    }

    @Comment(value="Converts CHAR value to WORD value.")
    public static WordValue CHAR_TO_WORD(CharValue value) {
        return WordValue.toWordValue((short)value.charValue());
    }

    @Comment(value="Converts CHAR value to BYTE value.")
    public static ByteValue CHAR_TO_BYTE(CharValue value) {
        return ByteValue.toByteValue((byte)value.charValue());
    }

    @Comment(value="Converts WCHAR value to LWORD value.")
    public static LWordValue WCHAR_TO_LWORD(WCharValue value) {
        return LWordValue.toLWordValue(value.charValue());
    }

    @Comment(value="Converts WCHAR value to double DWORD value.")
    public static DWordValue WCHAR_TO_DWORD(WCharValue value) {
        return DWordValue.toDWordValue(value.charValue());
    }

    @Comment(value="Converts WCHAR value to WORD value.")
    public static WordValue WCHAR_TO_WORD(WCharValue value) {
        return WordValue.toWordValue((short)value.charValue());
    }

    @Comment(value="Truncates the floating point number of REAL value and returns SINT value.")
    public static <T extends AnyRealValue> SIntValue TRUNC_SINT(T value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns INT value.")
    public static <T extends AnyRealValue> IntValue TRUNC_INT(T value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns DINT value.")
    public static <T extends AnyRealValue> DIntValue TRUNC_DINT(T value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns LINT value.")
    public static <T extends AnyRealValue> LIntValue TRUNC_LINT(T value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns USINT value.")
    public static <T extends AnyRealValue> USIntValue TRUNC_USINT(T value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns UINT value.")
    public static <T extends AnyRealValue> UIntValue TRUNC_UINT(T value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns UDINT value.")
    public static <T extends AnyRealValue> UDIntValue TRUNC_UDINT(T value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns ULINT value.")
    public static <T extends AnyRealValue> ULIntValue TRUNC_ULINT(T value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns SINT value.")
    public static SIntValue LREAL_TRUNC_SINT(LRealValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns INT value.")
    public static IntValue LREAL_TRUNC_INT(LRealValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns DINT value.")
    public static DIntValue LREAL_TRUNC_DINT(LRealValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns LINT value.")
    public static LIntValue LREAL_TRUNC_LINT(LRealValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns USINT value.")
    public static USIntValue LREAL_TRUNC_USINT(LRealValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns UINT value.")
    public static UIntValue LREAL_TRUNC_UINT(LRealValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns UDINT value.")
    public static UDIntValue LREAL_TRUNC_UDINT(LRealValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of LREAL value and returns ULINT value.")
    public static ULIntValue LREAL_TRUNC_ULINT(LRealValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns SINT value.")
    public static SIntValue REAL_TRUNC_SINT(RealValue value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns INT value.")
    public static IntValue REAL_TRUNC_INT(RealValue value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns DINT value.")
    public static DIntValue REAL_TRUNC_DINT(RealValue value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns LINT value.")
    public static LIntValue REAL_TRUNC_LINT(RealValue value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns USINT value.")
    public static USIntValue REAL_TRUNC_USINT(RealValue value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns UINT value.")
    public static UIntValue REAL_TRUNC_UINT(RealValue value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns UDINT value.")
    public static UDIntValue REAL_TRUNC_UDINT(RealValue value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Truncates the floating point number of REAL value and returns ULINT value.")
    public static ULIntValue REAL_TRUNC_ULINT(RealValue value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts BCD value to USINT value.")
    public static <T extends AnyBitValue> USIntValue BCD_TO_USINT(T value) {
        return USIntValue.toUSIntValue(StandardFunctions.convertFromBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts BCD value to UINT value.")
    public static <T extends AnyBitValue> UIntValue BCD_TO_UINT(T value) {
        return UIntValue.toUIntValue(StandardFunctions.convertFromBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts BCD value to UDINT value.")
    public static <T extends AnyBitValue> UDIntValue BCD_TO_UDINT(T value) {
        return UDIntValue.toUDIntValue(StandardFunctions.convertFromBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts BCD value to ULINT value.")
    public static <T extends AnyBitValue> ULIntValue BCD_TO_ULINT(T value) {
        return ULIntValue.toULIntValue(StandardFunctions.convertFromBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts any Unsigned value to BYTE BCD value.")
    public static <T extends AnyUnsignedValue> ByteValue TO_BCD_BYTE(T value) {
        return ByteValue.toByteValue(StandardFunctions.convertToBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts any Unsigned value to WORD BCD value.")
    public static <T extends AnyUnsignedValue> WordValue TO_BCD_WORD(T value) {
        return WordValue.toWordValue(StandardFunctions.convertToBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts any Unsigned value to DWORD BCD value.")
    public static <T extends AnyUnsignedValue> DWordValue TO_BCD_DWORD(T value) {
        return DWordValue.toDWordValue(StandardFunctions.convertToBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts any Unsigned value to LWORD BCD value.")
    public static <T extends AnyUnsignedValue> LWordValue TO_BCD_LWORD(T value) {
        return LWordValue.toLWordValue(StandardFunctions.convertToBCD(value.bigIntegerValue()));
    }

    @Comment(value="Converts BYTE BCD value to USINT value.")
    public static USIntValue BYTE_BCD_TO_USINT(ByteValue value) {
        return StandardFunctions.BCD_TO_USINT(value);
    }

    @Comment(value="Converts BYTE BCD value to UINT value.")
    public static UIntValue BYTE_BCD_TO_UINT(ByteValue value) {
        return StandardFunctions.BCD_TO_UINT(value);
    }

    @Comment(value="Converts BYTE BCD value to UDINT value.")
    public static UDIntValue BYTE_BCD_TO_UDINT(ByteValue value) {
        return StandardFunctions.BCD_TO_UDINT(value);
    }

    @Comment(value="Converts BYTE BCD value to ULINT value.")
    public static ULIntValue BYTE_BCD_TO_ULINT(ByteValue value) {
        return StandardFunctions.BCD_TO_ULINT(value);
    }

    @Comment(value="Converts WORD BCD value to USINT value.")
    public static USIntValue WORD_BCD_TO_USINT(WordValue value) {
        return StandardFunctions.BCD_TO_USINT(value);
    }

    @Comment(value="Converts WORD BCD value to UINT value.")
    public static UIntValue WORD_BCD_TO_UINT(WordValue value) {
        return StandardFunctions.BCD_TO_UINT(value);
    }

    @Comment(value="Converts WORD BCD value to UDINT value.")
    public static UDIntValue WORD_BCD_TO_UDINT(WordValue value) {
        return StandardFunctions.BCD_TO_UDINT(value);
    }

    @Comment(value="Converts WORD BCD value to ULINT value.")
    public static ULIntValue WORD_BCD_TO_ULINT(WordValue value) {
        return StandardFunctions.BCD_TO_ULINT(value);
    }

    @Comment(value="Converts DWORD BCD value to USINT value.")
    public static USIntValue DWORD_BCD_TO_USINT(DWordValue value) {
        return StandardFunctions.BCD_TO_USINT(value);
    }

    @Comment(value="Converts DWORD BCD value to UINT value.")
    public static UIntValue DWORD_BCD_TO_UINT(DWordValue value) {
        return StandardFunctions.BCD_TO_UINT(value);
    }

    @Comment(value="Converts DWORD BCD value to UDINT value.")
    public static UDIntValue DWORD_BCD_TO_UDINT(DWordValue value) {
        return StandardFunctions.BCD_TO_UDINT(value);
    }

    @Comment(value="Converts DWORD BCD value to ULINT value.")
    public static ULIntValue DWORD_BCD_TO_ULINT(DWordValue value) {
        return StandardFunctions.BCD_TO_ULINT(value);
    }

    @Comment(value="Converts LWORD BCD value to USINT value.")
    public static USIntValue LWORD_BCD_TO_USINT(LWordValue value) {
        return StandardFunctions.BCD_TO_USINT(value);
    }

    @Comment(value="Converts LWORD BCD value to UINT value.")
    public static UIntValue LWORD_BCD_TO_UINT(LWordValue value) {
        return StandardFunctions.BCD_TO_UINT(value);
    }

    @Comment(value="Converts LWORD BCD value to UDINT value.")
    public static UDIntValue LWORD_BCD_TO_UDINT(LWordValue value) {
        return StandardFunctions.BCD_TO_UDINT(value);
    }

    @Comment(value="Converts LWORD BCD value to ULINT value.")
    public static ULIntValue LWORD_BCD_TO_ULINT(LWordValue value) {
        return StandardFunctions.BCD_TO_ULINT(value);
    }

    @Comment(value="Converts USINT value to BYTE BCD value.")
    public static ByteValue USINT_TO_BCD_BYTE(USIntValue value) {
        return StandardFunctions.TO_BCD_BYTE(value);
    }

    @Comment(value="Converts UINT value to BYTE BCD value.")
    public static ByteValue UINT_TO_BCD_BYTE(UIntValue value) {
        return StandardFunctions.TO_BCD_BYTE(value);
    }

    @Comment(value="Converts UDINT value to BYTE BCD value.")
    public static ByteValue UDINT_TO_BCD_BYTE(UDIntValue value) {
        return StandardFunctions.TO_BCD_BYTE(value);
    }

    @Comment(value="Converts ULINT value to BYTE BCD value.")
    public static ByteValue ULINT_TO_BCD_BYTE(ULIntValue value) {
        return StandardFunctions.TO_BCD_BYTE(value);
    }

    @Comment(value="Converts USINT value to WORD BCD value.")
    public static WordValue USINT_TO_BCD_WORD(USIntValue value) {
        return StandardFunctions.TO_BCD_WORD(value);
    }

    @Comment(value="Converts UINT value to WORD BCD value.")
    public static WordValue UINT_TO_BCD_WORD(UIntValue value) {
        return StandardFunctions.TO_BCD_WORD(value);
    }

    @Comment(value="Converts UDINT value to WORD BCD value.")
    public static WordValue UDINT_TO_BCD_WORD(UDIntValue value) {
        return StandardFunctions.TO_BCD_WORD(value);
    }

    @Comment(value="Converts ULINT value to WORD BCD value.")
    public static WordValue ULINT_TO_BCD_WORD(ULIntValue value) {
        return StandardFunctions.TO_BCD_WORD(value);
    }

    @Comment(value="Converts USINT value to DWORD BCD value.")
    public static DWordValue USINT_TO_BCD_DWORD(USIntValue value) {
        return StandardFunctions.TO_BCD_DWORD(value);
    }

    @Comment(value="Converts UINT value to DWORD BCD value.")
    public static DWordValue UINT_TO_BCD_DWORD(UIntValue value) {
        return StandardFunctions.TO_BCD_DWORD(value);
    }

    @Comment(value="Converts UDINT value to DWORD BCD value.")
    public static DWordValue UDINT_TO_BCD_DWORD(UDIntValue value) {
        return StandardFunctions.TO_BCD_DWORD(value);
    }

    @Comment(value="Converts ULINT value to DWORD BCD value.")
    public static DWordValue ULINT_TO_BCD_DWORD(ULIntValue value) {
        return StandardFunctions.TO_BCD_DWORD(value);
    }

    @Comment(value="Converts USINT value to LWORD BCD value.")
    public static LWordValue USINT_TO_BCD_LWORD(USIntValue value) {
        return StandardFunctions.TO_BCD_LWORD(value);
    }

    @Comment(value="Converts UINT value to LWORD BCD value.")
    public static LWordValue UINT_TO_BCD_LWORD(UIntValue value) {
        return StandardFunctions.TO_BCD_LWORD(value);
    }

    @Comment(value="Converts UDINT value to LWORD BCD value.")
    public static LWordValue UDINT_TO_BCD_LWORD(UDIntValue value) {
        return StandardFunctions.TO_BCD_LWORD(value);
    }

    @Comment(value="Converts ULINT value to LWORD BCD value.")
    public static LWordValue ULINT_TO_BCD_LWORD(ULIntValue value) {
        return StandardFunctions.TO_BCD_LWORD(value);
    }

    private static BigInteger convertToBCD(BigInteger value) {
        BigInteger result = BigInteger.ZERO;
        String digits = value.toString();
        char[] cArray = digits.toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char digit = cArray[n2];
            result = result.shiftLeft(4);
            result = result.or(BigInteger.valueOf(digit & 0xF));
            ++n2;
        }
        return result;
    }

    private static BigInteger convertFromBCD(BigInteger value) {
        if (value.signum() < 0) {
            throw new IllegalArgumentException();
        }
        BigInteger result = BigInteger.ZERO;
        byte[] byArray = value.toByteArray();
        int n = byArray.length;
        int n2 = 0;
        while (n2 < n) {
            byte packed = byArray[n2];
            int packedInt = Byte.toUnsignedInt(packed);
            int upper = packedInt >>> 4;
            int lower = packedInt & 0xF;
            if (upper > 9 || lower > 9) {
                throw new IllegalArgumentException();
            }
            result = result.multiply(BigInteger.TEN);
            result = result.add(BigInteger.valueOf(upper));
            result = result.multiply(BigInteger.TEN);
            result = result.add(BigInteger.valueOf(lower));
            ++n2;
        }
        return result;
    }

    @Comment(value="Returns relative time stamp.")
    public static TimeValue NOW_MONOTONIC() {
        return TimeValue.toTimeValue(Instant.EPOCH.until(AbstractEvaluator.currentMonotonicClock().instant(), ChronoUnit.NANOS));
    }

    public static DateAndTimeValue NOW() {
        return DateAndTimeValue.toDateAndTimeValue(Instant.EPOCH.until(AbstractEvaluator.currentRealtimeClock().instant(), ChronoUnit.NANOS));
    }

    @OnlySupportedBy(value={"4diac IDE"})
    @Comment(value="Override the monotonic clock.")
    public static void OVERRIDE_NOW_MONOTONIC(TimeValue value) {
        Duration duration = value.toDuration();
        Instant instant = Instant.ofEpochSecond(duration.getSeconds(), duration.getNano());
        AbstractEvaluator.setMonotonicClock(Clock.fixed(instant, ZoneOffset.UTC));
    }

    @OnlySupportedBy(value={"4diac IDE"})
    @Comment(value="Override the real-time clock.")
    public static void OVERRIDE_NOW(DateAndTimeValue value) {
        Instant instant = value.toLocalDateTime().toInstant(ZoneOffset.UTC);
        AbstractEvaluator.setRealtimeClock(Clock.fixed(instant, ZoneOffset.UTC));
    }

    @Comment(value="Converts LTIME value to TIME value.")
    public static TimeValue LTIME_TO_TIME(LTimeValue value) {
        return TimeValue.toTimeValue(value);
    }

    @Comment(value="Converts TIME value to LTIME value.")
    public static LTimeValue TIME_TO_LTIME(TimeValue value) {
        return LTimeValue.toLTimeValue(value);
    }

    @Comment(value="Converts LDATE_AND_TIME value to DATE_AND_TIME value.")
    public static DateAndTimeValue LDT_TO_DT(LDateAndTimeValue value) {
        return DateAndTimeValue.toDateAndTimeValue(value);
    }

    @Comment(value="Converts LDATE_AND_TIME value to DATE value.")
    public static DateValue LDT_TO_DATE(LDateAndTimeValue value) {
        return DateValue.toDateValue(value);
    }

    @Comment(value="Converts LDATE_AND_TIME value to LDATE value.")
    public static LDateValue LDT_TO_LDATE(LDateAndTimeValue value) {
        return LDateValue.toLDateValue(value);
    }

    @Comment(value="Converts the a DATE value to an LDATE")
    public static LDateValue DATE_TO_LDATE(DateValue value) {
        return LDateValue.toLDateValue(value);
    }

    @Comment(value="Converts the an LDATE value to a DATE")
    public static DateValue LDATE_TO_DATE(LDateValue value) {
        return DateValue.toDateValue(value);
    }

    @Comment(value="Converts LDATE_AND_TIME value to LTIME_OF_DAY value.")
    public static LTimeOfDayValue LDT_TO_LTOD(LDateAndTimeValue value) {
        return LTimeOfDayValue.toLTimeOfDayValue(value);
    }

    @Comment(value="Converts LDATE_AND_TIME value to TIME_OF_DAY value.")
    public static TimeOfDayValue LDT_TO_TOD(LDateAndTimeValue value) {
        return TimeOfDayValue.toTimeOfDayValue(value);
    }

    @Comment(value="Converts DATE_AND_TIME value to LDATE_AND_TIME value.")
    public static LDateAndTimeValue DT_TO_LDT(DateAndTimeValue value) {
        return LDateAndTimeValue.toLDateAndTimeValue(value);
    }

    @Comment(value="Converts DATE_AND_TIME value to DATE value.")
    public static DateValue DT_TO_DATE(DateAndTimeValue value) {
        return DateValue.toDateValue(value);
    }

    @Comment(value="Converts DATE_AND_TIME value to LDATE value.")
    public static LDateValue DT_TO_LDATE(DateAndTimeValue value) {
        return LDateValue.toLDateValue(value);
    }

    @Comment(value="Converts DATE_AND_TIME value to LTIME_OF_DAY value.")
    public static LTimeOfDayValue DT_TO_LTOD(DateAndTimeValue value) {
        return LTimeOfDayValue.toLTimeOfDayValue(value);
    }

    @Comment(value="Converts DATE_AND_TIME value to TIME_OF_DAY value.")
    public static TimeOfDayValue DT_TO_TOD(DateAndTimeValue value) {
        return TimeOfDayValue.toTimeOfDayValue(value);
    }

    @Comment(value="Converts LTIME_OF_DAY value to TIME_OF_DAY value.")
    public static TimeOfDayValue LTOD_TO_TOD(LTimeOfDayValue value) {
        return TimeOfDayValue.toTimeOfDayValue(value);
    }

    @Comment(value="Converts TIME_OF_DAY value to LTIME_OF_DAY value.")
    public static LTimeOfDayValue TOD_TO_LTOD(TimeOfDayValue value) {
        return LTimeOfDayValue.toLTimeOfDayValue(value);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in second and returns it as LINT value.")
    public static <T extends AnyDurationValue> LIntValue TIME_IN_S_TO_LINT(T value) {
        return LIntValue.toLIntValue(value.toDuration().toSeconds());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in millisecond and returns it as LINT value.")
    public static <T extends AnyDurationValue> LIntValue TIME_IN_MS_TO_LINT(T value) {
        return LIntValue.toLIntValue(value.toDuration().toMillis());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in microsecond and returns it as LINT value.")
    public static <T extends AnyDurationValue> LIntValue TIME_IN_US_TO_LINT(T value) {
        return LIntValue.toLIntValue(value.toDuration().toNanos() / 1000L);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in nanosecond and returns it as LINT value.")
    public static <T extends AnyDurationValue> LIntValue TIME_IN_NS_TO_LINT(T value) {
        return LIntValue.toLIntValue(value.toDuration().toNanos());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in second and returns it as ULINT value.")
    public static ULIntValue TIME_IN_S_TO_ULINT(AnyDurationValue value) {
        return ULIntValue.toULIntValue(value.toDuration().toSeconds());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in millisecond and returns it as ULINT value.")
    public static <T extends AnyDurationValue> ULIntValue TIME_IN_MS_TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value.toDuration().toMillis());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in microsecond and returns it as ULINT value.")
    public static <T extends AnyDurationValue> ULIntValue TIME_IN_US_TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value.toDuration().toNanos() / 1000L);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in nanosecond and returns it as ULINT value.")
    public static <T extends AnyDurationValue> ULIntValue TIME_IN_NS_TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value.toDuration().toNanos());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in second and returns it as LREAL value.")
    public static <T extends AnyDurationValue> LRealValue TIME_IN_S_TO_LREAL(T value) {
        return LRealValue.toLRealValue((double)value.toDuration().toNanos() / 1.0E9);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in millisecond and returns it as LREAL value.")
    public static <T extends AnyDurationValue> LRealValue TIME_IN_MS_TO_LREAL(T value) {
        return LRealValue.toLRealValue((double)value.toDuration().toNanos() / 1000000.0);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in microsecond and returns it as LREAL value.")
    public static <T extends AnyDurationValue> LRealValue TIME_IN_US_TO_LREAL(T value) {
        return LRealValue.toLRealValue((double)value.toDuration().toNanos() / 1000.0);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in nanosecond and returns it as LREAL value.")
    public static <T extends AnyDurationValue> LRealValue TIME_IN_NS_TO_LREAL(T value) {
        return LRealValue.toLRealValue(value.toDuration().toNanos());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in second and returns it as DINT value.")
    public static <T extends AnyDurationValue> DIntValue TIME_IN_S_TO_DINT(T value) {
        return DIntValue.toDIntValue((int)value.toDuration().toSeconds());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in millisecond and returns it as DINT value.")
    public static <T extends AnyDurationValue> DIntValue TIME_IN_MS_TO_DINT(T value) {
        return DIntValue.toDIntValue((int)value.toDuration().toMillis());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in microsecond and returns it as DINT value.")
    public static <T extends AnyDurationValue> DIntValue TIME_IN_US_TO_DINT(T value) {
        return DIntValue.toDIntValue((int)(value.toDuration().toNanos() / 1000L));
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in nanosecond and returns it as DINT value.")
    public static <T extends AnyDurationValue> DIntValue TIME_IN_NS_TO_DINT(T value) {
        return DIntValue.toDIntValue((int)value.toDuration().toNanos());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in second and returns it as UDINT value.")
    public static UDIntValue TIME_IN_S_TO_UDINT(AnyDurationValue value) {
        return UDIntValue.toUDIntValue((int)value.toDuration().toSeconds());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in millisecond and returns it as UDINT value.")
    public static <T extends AnyDurationValue> UDIntValue TIME_IN_MS_TO_UDINT(T value) {
        return UDIntValue.toUDIntValue((int)value.toDuration().toMillis());
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in microsecond and returns it as UDINT value.")
    public static <T extends AnyDurationValue> UDIntValue TIME_IN_US_TO_UDINT(T value) {
        return UDIntValue.toUDIntValue((int)value.toDuration().toNanos() / 1000);
    }

    @OnlySupportedBy(value={"4diac FORTE"})
    @Comment(value="Converts DURATION value in nanosecond and returns it as UDINT value.")
    public static <T extends AnyDurationValue> UDIntValue TIME_IN_NS_TO_UDINT(T value) {
        return UDIntValue.toUDIntValue((int)value.toDuration().toNanos());
    }

    @Comment(value="Converts WString value to String value.")
    public static StringValue WSTRING_TO_STRING(WStringValue value) {
        return StringValue.toStringValue(value);
    }

    @Comment(value="Converts WString value to WChar value.")
    public static WCharValue WSTRING_TO_WCHAR(WStringValue value) {
        return WCharValue.toWCharValue(value);
    }

    @Comment(value="Converts String value to WString value.")
    public static WStringValue STRING_TO_WSTRING(StringValue value) {
        return WStringValue.toWStringValue(value);
    }

    @Comment(value="Converts String value to Char value.")
    public static CharValue STRING_TO_CHAR(StringValue value) {
        return CharValue.toCharValue(value);
    }

    @Comment(value="Converts WChar value to WString value.")
    public static WStringValue WCHAR_TO_WSTRING(WCharValue value) {
        return WStringValue.toWStringValue(value);
    }

    @Comment(value="Converts WChar value to Char value.")
    public static CharValue WCHAR_TO_CHAR(WCharValue value) {
        return CharValue.toCharValue(value);
    }

    @Comment(value="Converts Char value to String value.")
    public static StringValue CHAR_TO_STRING(CharValue value) {
        return StringValue.toStringValue(value);
    }

    @Comment(value="Converts Char to WChar value.")
    public static WCharValue CHAR_TO_WCHAR(CharValue value) {
        return WCharValue.toWCharValue(value);
    }

    @Comment(value="Converts Real to STRING value.")
    public static StringValue REAL_AS_STRING(RealValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Lreal to STRING value.")
    public static StringValue LREAL_AS_STRING(LRealValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Usint to STRING value.")
    public static StringValue USINT_AS_STRING(USIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Uint to STRING value.")
    public static StringValue UINT_AS_STRING(UIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Udint to STRING value.")
    public static StringValue UDINT_AS_STRING(UDIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Ulint to STRING value.")
    public static StringValue ULINT_AS_STRING(ULIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Sint to STRING value.")
    public static StringValue SINT_AS_STRING(SIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Int to STRING value.")
    public static StringValue INT_AS_STRING(IntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Dint to STRING value.")
    public static StringValue DINT_AS_STRING(DIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Lint to STRING value.")
    public static StringValue LINT_AS_STRING(LIntValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Time to STRING value.")
    public static StringValue TIME_AS_STRING(TimeValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Ltime to STRING value.")
    public static StringValue LTIME_AS_STRING(LTimeValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Bool to STRING value.")
    public static StringValue BOOL_AS_STRING(BoolValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Byte to STRING value.")
    public static StringValue BYTE_AS_STRING(ByteValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Word to STRING value.")
    public static StringValue WORD_AS_STRING(WordValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Dword to STRING value.")
    public static StringValue DWORD_AS_STRING(DWordValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts Lword to STRING value.")
    public static StringValue LWORD_AS_STRING(LWordValue value) {
        return StringValue.toStringValue(value.toString());
    }

    @Comment(value="Converts STRING to Real value.")
    public static RealValue STRING_AS_REAL(StringValue value) {
        return RealValue.toRealValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Lreal value.")
    public static LRealValue STRING_AS_LREAL(StringValue value) {
        return LRealValue.toLRealValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Usint value.")
    public static USIntValue STRING_AS_USINT(StringValue value) {
        return USIntValue.toUSIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Uint value.")
    public static UIntValue STRING_AS_UINT(StringValue value) {
        return UIntValue.toUIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Udint value.")
    public static UDIntValue STRING_AS_UDINT(StringValue value) {
        return UDIntValue.toUDIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Ulint value.")
    public static ULIntValue STRING_AS_ULINT(StringValue value) {
        return ULIntValue.toULIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Sint value.")
    public static SIntValue STRING_AS_SINT(StringValue value) {
        return SIntValue.toSIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Int value.")
    public static IntValue STRING_AS_INT(StringValue value) {
        return IntValue.toIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Dint value.")
    public static DIntValue STRING_AS_DINT(StringValue value) {
        return DIntValue.toDIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Lint value.")
    public static LIntValue STRING_AS_LINT(StringValue value) {
        return LIntValue.toLIntValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Time value.")
    public static TimeValue STRING_AS_TIME(StringValue value) {
        return TimeValue.toTimeValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Ltime value.")
    public static LTimeValue STRING_AS_LTIME(StringValue value) {
        return LTimeValue.toLTimeValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Bool value.")
    public static BoolValue STRING_AS_BOOL(StringValue value) {
        return BoolValue.toBoolValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Byte value.")
    public static ByteValue STRING_AS_BYTE(StringValue value) {
        return ByteValue.toByteValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Word value.")
    public static WordValue STRING_AS_WORD(StringValue value) {
        return WordValue.toWordValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Dword value.")
    public static DWordValue STRING_AS_DWORD(StringValue value) {
        return DWordValue.toDWordValue(value.stringValue());
    }

    @Comment(value="Converts STRING to Lword value.")
    public static LWordValue STRING_AS_LWORD(StringValue value) {
        return LWordValue.toLWordValue(value.stringValue());
    }

    @Comment(value="Converts Real to WSTRING value.")
    public static WStringValue REAL_AS_WSTRING(RealValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Lreal to WSTRING value.")
    public static WStringValue LREAL_AS_WSTRING(LRealValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Usint to WSTRING value.")
    public static WStringValue USINT_AS_WSTRING(USIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Uint to WSTRING value.")
    public static WStringValue UINT_AS_WSTRING(UIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Udint to WSTRING value.")
    public static WStringValue UDINT_AS_WSTRING(UDIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Ulint to WSTRING value.")
    public static WStringValue ULINT_AS_WSTRING(ULIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Sint to WSTRING value.")
    public static WStringValue SINT_AS_WSTRING(SIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Int to WSTRING value.")
    public static WStringValue INT_AS_WSTRING(IntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Dint to WSTRING value.")
    public static WStringValue DINT_AS_WSTRING(DIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Lint to WSTRING value.")
    public static WStringValue LINT_AS_WSTRING(LIntValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Time to WSTRING value.")
    public static WStringValue TIME_AS_WSTRING(TimeValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Ltime to WSTRING value.")
    public static WStringValue LTIME_AS_WSTRING(LTimeValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Bool to WSTRING value.")
    public static WStringValue BOOL_AS_WSTRING(BoolValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Byte to WSTRING value.")
    public static WStringValue BYTE_AS_WSTRING(ByteValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Word to WSTRING value.")
    public static WStringValue WORD_AS_WSTRING(WordValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Dword to WSTRING value.")
    public static WStringValue DWORD_AS_WSTRING(DWordValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts Lword to WSTRING value.")
    public static WStringValue LWORD_AS_WSTRING(LWordValue value) {
        return WStringValue.toWStringValue(value.toString());
    }

    @Comment(value="Converts WSTRING to Real value.")
    public static RealValue WSTRING_AS_REAL(WStringValue value) {
        return RealValue.toRealValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Lreal value.")
    public static LRealValue WSTRING_AS_LREAL(WStringValue value) {
        return LRealValue.toLRealValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Usint value.")
    public static USIntValue WSTRING_AS_USINT(WStringValue value) {
        return USIntValue.toUSIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Uint value.")
    public static UIntValue WSTRING_AS_UINT(WStringValue value) {
        return UIntValue.toUIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Udint value.")
    public static UDIntValue WSTRING_AS_UDINT(WStringValue value) {
        return UDIntValue.toUDIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Ulint value.")
    public static ULIntValue WSTRING_AS_ULINT(WStringValue value) {
        return ULIntValue.toULIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Sint value.")
    public static SIntValue WSTRING_AS_SINT(WStringValue value) {
        return SIntValue.toSIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Int value.")
    public static IntValue WSTRING_AS_INT(WStringValue value) {
        return IntValue.toIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Dint value.")
    public static DIntValue WSTRING_AS_DINT(WStringValue value) {
        return DIntValue.toDIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Lint value.")
    public static LIntValue WSTRING_AS_LINT(WStringValue value) {
        return LIntValue.toLIntValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Time value.")
    public static TimeValue WSTRING_AS_TIME(WStringValue value) {
        return TimeValue.toTimeValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Ltime value.")
    public static LTimeValue WSTRING_AS_LTIME(WStringValue value) {
        return LTimeValue.toLTimeValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Bool value.")
    public static BoolValue WSTRING_AS_BOOL(WStringValue value) {
        return BoolValue.toBoolValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Byte value.")
    public static ByteValue WSTRING_AS_BYTE(WStringValue value) {
        return ByteValue.toByteValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Word value.")
    public static WordValue WSTRING_AS_WORD(WStringValue value) {
        return WordValue.toWordValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Dword value.")
    public static DWordValue WSTRING_AS_DWORD(WStringValue value) {
        return DWordValue.toDWordValue(value.stringValue());
    }

    @Comment(value="Converts WSTRING to Lword value.")
    public static LWordValue WSTRING_AS_LWORD(WStringValue value) {
        return LWordValue.toLWordValue(value.stringValue());
    }

    @Comment(value="Converts the supplied value to an LREAL")
    public static <T extends AnyNumValue> LRealValue TO_LREAL(T value) {
        return LRealValue.toLRealValue(value);
    }

    @Comment(value="Converts the supplied value to an LREAL")
    public static LRealValue TO_LREAL(LWordValue value) {
        return StandardFunctions.LWORD_TO_LREAL(value);
    }

    @Comment(value="Converts the supplied value to a REAL")
    public static <T extends AnyNumValue> RealValue TO_REAL(T value) {
        return RealValue.toRealValue(value);
    }

    @Comment(value="Converts the supplied value to a REAL")
    public static RealValue TO_REAL(DWordValue value) {
        return StandardFunctions.DWORD_TO_REAL(value);
    }

    @Comment(value="Converts the supplied value to an LINT")
    public static <T extends AnyIntValue> LIntValue TO_LINT(T value) {
        return LIntValue.toLIntValue(value);
    }

    @Comment(value="Converts the supplied value to an LINT")
    public static <T extends AnyRealValue> LIntValue TO_LINT(T value) {
        return LIntValue.toLIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts the supplied value to an LINT")
    public static <T extends AnyBitValue> LIntValue TO_LINT(T value) {
        return LIntValue.toLIntValue(value.longValue());
    }

    @Comment(value="Converts the supplied value to an DINT")
    public static <T extends AnyIntValue> DIntValue TO_DINT(T value) {
        return DIntValue.toDIntValue(value);
    }

    @Comment(value="Converts the supplied value to an DINT")
    public static <T extends AnyRealValue> DIntValue TO_DINT(T value) {
        return DIntValue.toDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts the supplied value to an DINT")
    public static <T extends AnyBitValue> DIntValue TO_DINT(T value) {
        return DIntValue.toDIntValue(value.intValue());
    }

    @Comment(value="Converts the supplied value to an INT")
    public static <T extends AnyIntValue> IntValue TO_INT(T value) {
        return IntValue.toIntValue(value);
    }

    @Comment(value="Converts the supplied value to an INT")
    public static <T extends AnyRealValue> IntValue TO_INT(T value) {
        return IntValue.toIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts the supplied value to an INT")
    public static <T extends AnyBitValue> IntValue TO_INT(T value) {
        return IntValue.toIntValue(value.shortValue());
    }

    @Comment(value="Converts the supplied value to an SINT")
    public static <T extends AnyIntValue> SIntValue TO_SINT(T value) {
        return SIntValue.toSIntValue(value);
    }

    @Comment(value="Converts the supplied value to an SINT")
    public static <T extends AnyRealValue> SIntValue TO_SINT(T value) {
        return SIntValue.toSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts the supplied value to an SINT")
    public static <T extends AnyBitValue> SIntValue TO_SINT(T value) {
        return SIntValue.toSIntValue(value.byteValue());
    }

    @Comment(value="Converts the supplied value to an ULINT")
    public static <T extends AnyIntValue> ULIntValue TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value);
    }

    @Comment(value="Converts the supplied value to an ULINT")
    public static <T extends AnyRealValue> ULIntValue TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).longValue());
    }

    @Comment(value="Converts the supplied value to an ULINT")
    public static <T extends AnyBitValue> ULIntValue TO_ULINT(T value) {
        return ULIntValue.toULIntValue(value.longValue());
    }

    @Comment(value="Converts the supplied value to an UDINT")
    public static <T extends AnyIntValue> UDIntValue TO_UDINT(T value) {
        return UDIntValue.toUDIntValue(value);
    }

    @Comment(value="Converts the supplied value to an UDINT")
    public static <T extends AnyRealValue> UDIntValue TO_UDINT(T value) {
        return UDIntValue.toUDIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).intValue());
    }

    @Comment(value="Converts the supplied value to an UDINT")
    public static <T extends AnyBitValue> UDIntValue TO_UDINT(T value) {
        return UDIntValue.toUDIntValue(value.intValue());
    }

    @Comment(value="Converts the supplied value to an UINT")
    public static <T extends AnyIntValue> UIntValue TO_UINT(T value) {
        return UIntValue.toUIntValue(value);
    }

    @Comment(value="Converts the supplied value to an UINT")
    public static <T extends AnyRealValue> UIntValue TO_UINT(T value) {
        return UIntValue.toUIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).shortValue());
    }

    @Comment(value="Converts the supplied value to an UINT")
    public static <T extends AnyBitValue> UIntValue TO_UINT(T value) {
        return UIntValue.toUIntValue(value.shortValue());
    }

    @Comment(value="Converts the supplied value to an USINT")
    public static <T extends AnyIntValue> USIntValue TO_USINT(T value) {
        return USIntValue.toUSIntValue(value);
    }

    @Comment(value="Converts the supplied value to an USINT")
    public static <T extends AnyRealValue> USIntValue TO_USINT(T value) {
        return USIntValue.toUSIntValue(value.bigDecimalValue().setScale(0, RoundingMode.HALF_EVEN).byteValue());
    }

    @Comment(value="Converts the supplied value to an USINT")
    public static <T extends AnyBitValue> USIntValue TO_USINT(T value) {
        return USIntValue.toUSIntValue(value.byteValue());
    }

    @Comment(value="Converts the supplied value to an USINT")
    public static USIntValue TO_USINT(CharValue value) {
        return StandardFunctions.CHAR_TO_USINT(value);
    }

    @Comment(value="Converts the CHAR value to an USINT")
    public static USIntValue CHAR_TO_USINT(CharValue value) {
        return USIntValue.toUSIntValue((byte)value.charValue());
    }

    private static <T extends AnyRealValue> T apply(T value, DoubleUnaryOperator operator) {
        if (value instanceof RealValue) {
            return (T)RealValue.toRealValue((float)operator.applyAsDouble(value.doubleValue()));
        }
        return (T)LRealValue.toLRealValue(operator.applyAsDouble(value.doubleValue()));
    }

    @Comment(value="Converts the supplied value to an LWORD")
    public static <T extends AnyIntValue> LWordValue TO_LWORD(T value) {
        return LWordValue.toLWordValue(value.longValue());
    }

    @Comment(value="Converts the supplied value to an LWORD")
    public static <T extends AnyBitValue> LWordValue TO_LWORD(T value) {
        return LWordValue.toLWordValue(value);
    }

    @Comment(value="Converts the supplied value to an LWORD")
    public static LWordValue TO_LWORD(LRealValue value) {
        return StandardFunctions.LREAL_TO_LWORD(value);
    }

    @Comment(value="Converts the supplied value to an LWORD")
    public static LWordValue TO_LWORD(WCharValue value) {
        return StandardFunctions.WCHAR_TO_LWORD(value);
    }

    @Comment(value="Converts the supplied value to an LWORD")
    public static LWordValue TO_LWORD(CharValue value) {
        return StandardFunctions.CHAR_TO_LWORD(value);
    }

    @Comment(value="Converts the supplied value to an DWORD")
    public static <T extends AnyIntValue> DWordValue TO_DWORD(T value) {
        return DWordValue.toDWordValue(value.intValue());
    }

    @Comment(value="Converts the supplied value to a DWORD")
    public static <T extends AnyBitValue> DWordValue TO_DWORD(T value) {
        return DWordValue.toDWordValue(value);
    }

    @Comment(value="Converts the supplied value to a DWORD")
    public static DWordValue TO_DWORD(RealValue value) {
        return StandardFunctions.REAL_TO_DWORD(value);
    }

    @Comment(value="Converts the supplied value to an DWORD")
    public static DWordValue TO_DWORD(WCharValue value) {
        return StandardFunctions.WCHAR_TO_DWORD(value);
    }

    @Comment(value="Converts the supplied value to an DWORD")
    public static DWordValue TO_DWORD(CharValue value) {
        return StandardFunctions.CHAR_TO_DWORD(value);
    }

    @Comment(value="Converts the supplied value to a WORD")
    public static <T extends AnyIntValue> WordValue TO_WORD(T value) {
        return WordValue.toWordValue(value.shortValue());
    }

    @Comment(value="Converts the supplied value to a WORD")
    public static <T extends AnyBitValue> WordValue TO_WORD(T value) {
        return WordValue.toWordValue(value);
    }

    @Comment(value="Converts the supplied value to an WORD")
    public static WordValue TO_WORD(WCharValue value) {
        return StandardFunctions.WCHAR_TO_WORD(value);
    }

    @Comment(value="Converts the supplied value to an WORD")
    public static WordValue TO_WORD(CharValue value) {
        return StandardFunctions.CHAR_TO_WORD(value);
    }

    @Comment(value="Converts the supplied value to an BYTE")
    public static <T extends AnyIntValue> ByteValue TO_BYTE(T value) {
        return ByteValue.toByteValue(value.byteValue());
    }

    @Comment(value="Converts the supplied value to an BYTE")
    public static <T extends AnyBitValue> ByteValue TO_BYTE(T value) {
        return ByteValue.toByteValue(value);
    }

    @Comment(value="Converts the supplied value to an BYTE")
    public static ByteValue TO_BYTE(CharValue value) {
        return StandardFunctions.CHAR_TO_BYTE(value);
    }

    @Comment(value="Converts the supplied value to an LTIME")
    public static LTimeValue TO_LTIME(TimeValue value) {
        return StandardFunctions.TIME_TO_LTIME(value);
    }

    @Comment(value="Converts the supplied value to an TIME")
    public static TimeValue TO_TIME(LTimeValue value) {
        return StandardFunctions.LTIME_TO_TIME(value);
    }

    @Comment(value="Converts the supplied value to an LDT")
    public static LDateAndTimeValue TO_LDT(DateAndTimeValue value) {
        return StandardFunctions.DT_TO_LDT(value);
    }

    @Comment(value="Converts the supplied value to an DT")
    public static DateAndTimeValue TO_DT(LDateAndTimeValue value) {
        return StandardFunctions.LDT_TO_DT(value);
    }

    @Comment(value="Converts the supplied value to an LDATE")
    public static LDateValue TO_LDATE(LDateAndTimeValue value) {
        return StandardFunctions.LDT_TO_LDATE(value);
    }

    @Comment(value="Converts the supplied value to an LDATE")
    public static LDateValue TO_LDATE(DateAndTimeValue value) {
        return StandardFunctions.DT_TO_LDATE(value);
    }

    @Comment(value="Converts the supplied value to an LDATE")
    public static LDateValue TO_LDATE(DateValue value) {
        return StandardFunctions.DATE_TO_LDATE(value);
    }

    @Comment(value="Converts the supplied value to an DATE")
    public static DateValue TO_DATE(LDateAndTimeValue value) {
        return StandardFunctions.LDT_TO_DATE(value);
    }

    @Comment(value="Converts the supplied value to an DATE")
    public static DateValue TO_DATE(DateAndTimeValue value) {
        return StandardFunctions.DT_TO_DATE(value);
    }

    @Comment(value="Converts the supplied value to an DATE")
    public static DateValue TO_DATE(LDateValue value) {
        return StandardFunctions.LDATE_TO_DATE(value);
    }

    @Comment(value="Converts the supplied value to an LTOD")
    public static LTimeOfDayValue TO_LTOD(LDateAndTimeValue value) {
        return StandardFunctions.LDT_TO_LTOD(value);
    }

    @Comment(value="Converts the supplied value to an LTOD")
    public static LTimeOfDayValue TO_LTOD(DateAndTimeValue value) {
        return StandardFunctions.DT_TO_LTOD(value);
    }

    @Comment(value="Converts the supplied value to an LTOD")
    public static LTimeOfDayValue TO_LTOD(TimeOfDayValue value) {
        return StandardFunctions.TOD_TO_LTOD(value);
    }

    @Comment(value="Converts the supplied value to an TOD")
    public static TimeOfDayValue TO_TOD(LDateAndTimeValue value) {
        return StandardFunctions.LDT_TO_TOD(value);
    }

    @Comment(value="Converts the supplied value to an TOD")
    public static TimeOfDayValue TO_TOD(DateAndTimeValue value) {
        return StandardFunctions.DT_TO_TOD(value);
    }

    @Comment(value="Converts the supplied value to an TOD")
    public static TimeOfDayValue TO_TOD(LTimeOfDayValue value) {
        return StandardFunctions.LTOD_TO_TOD(value);
    }

    @Comment(value="Converts the supplied value to a WSTRING")
    public static WStringValue TO_WSTRING(StringValue value) {
        return StandardFunctions.STRING_TO_WSTRING(value);
    }

    @Comment(value="Converts the supplied value to a WSTRING")
    public static WStringValue TO_WSTRING(WCharValue value) {
        return StandardFunctions.WCHAR_TO_WSTRING(value);
    }

    @Comment(value="Converts the supplied value to a STRING")
    public static StringValue TO_STRING(WStringValue value) {
        return StandardFunctions.WSTRING_TO_STRING(value);
    }

    @Comment(value="Converts the supplied value to a STRING")
    public static StringValue TO_STRING(CharValue value) {
        return StandardFunctions.CHAR_TO_STRING(value);
    }

    @Comment(value="Converts the supplied value to a WCHAR")
    public static WCharValue TO_WCHAR(WordValue value) {
        return StandardFunctions.WORD_TO_WCHAR(value);
    }

    public static WCharValue WORD_TO_WCHAR(WordValue value) {
        return WCharValue.toWCharValue((char)value.shortValue());
    }

    @Comment(value="Converts the supplied value to a WCHAR")
    public static WCharValue TO_WCHAR(CharValue value) {
        return StandardFunctions.CHAR_TO_WCHAR(value);
    }

    @Comment(value="Converts the supplied value to a CHAR")
    public static CharValue TO_CHAR(ByteValue value) {
        return StandardFunctions.BYTE_TO_CHAR(value);
    }

    @Comment(value="Converts the supplied value to a CHAR")
    public static CharValue TO_WCHAR(WCharValue value) {
        return StandardFunctions.WCHAR_TO_CHAR(value);
    }

    private static <T extends AnyRealValue> T apply(T value1, T value2, DoubleBinaryOperator operator) {
        if (value1 instanceof RealValue) {
            return (T)RealValue.toRealValue((float)operator.applyAsDouble(value1.doubleValue(), value2.doubleValue()));
        }
        return (T)LRealValue.toLRealValue(operator.applyAsDouble(value1.doubleValue(), value2.doubleValue()));
    }

    private static StringValue apply(StringValue value, UnaryOperator<String> operator) {
        return StringValue.toStringValue((String)operator.apply(value.stringValue()));
    }

    private static WStringValue apply(WStringValue value, UnaryOperator<String> operator) {
        return WStringValue.toWStringValue((String)operator.apply(value.stringValue()));
    }

    private static StringValue apply(AnySCharsValue value1, AnySCharsValue value2, BinaryOperator<String> operator) {
        return StringValue.toStringValue((String)operator.apply(value1.stringValue(), value2.stringValue()));
    }

    private static WStringValue apply(AnyWCharsValue value1, AnyWCharsValue value2, BinaryOperator<String> operator) {
        return WStringValue.toWStringValue((String)operator.apply(value1.stringValue(), value2.stringValue()));
    }
}

