/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.eval.variable;

import java.util.Iterator;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.eval.variable.AbstractVariable;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.value.TypedValue;

public class StructVariable
extends AbstractVariable<StructValue>
implements Iterable<Variable<?>> {
    private final StructValue value;

    public StructVariable(String name, StructuredType type) {
        super(name, (INamedElement)type);
        this.value = new StructValue(type);
    }

    public StructVariable(String name, StructuredType type, String value) {
        super(name, (INamedElement)type);
        this.value = new StructValue((StructValue)ValueOperations.parseValue(value, (INamedElement)type, null));
    }

    public StructVariable(String name, StructuredType type, Value value) {
        super(name, (INamedElement)type);
        this.value = new StructValue(this.checkValue(value));
    }

    @Override
    public void setValue(Value value) {
        this.checkValue(value).getMembers().forEach((? super K name, ? super V variable) -> this.value.get((String)name).setValue((Value)variable.getValue()));
    }

    protected StructValue checkValue(Value value) {
        StructValue structValue;
        block3: {
            block2: {
                if (!(value instanceof StructValue)) break block2;
                structValue = (StructValue)value;
                if (this.getType().isAssignableFrom((DataType)structValue.getType())) break block3;
            }
            throw this.createCastException(value);
        }
        return structValue;
    }

    @Override
    public void setValue(TypedValue value) {
        if (!this.getType().isAssignableFrom(value.type())) {
            this.createCastException(value);
        }
        Map memberValues = (Map)value.value();
        this.value.getMembers().forEach((? super K name, ? super V member) -> {
            Object memberValue = memberValues.get(name);
            if (memberValue != null) {
                member.setValue(new TypedValue((DataType)member.getType(), memberValue));
            } else {
                member.setValue(ValueOperations.defaultValue(member.getType()));
            }
        });
    }

    public StructuredType getType() {
        return (StructuredType)super.getType();
    }

    @Override
    public Iterator<Variable<?>> iterator() {
        return this.value.getMembers().values().iterator();
    }

    public Map<String, Variable<?>> getMembers() {
        return this.value.getMembers();
    }

    @Override
    public Stream<Variable<?>> getChildren() {
        return this.getMembers().values().stream();
    }

    @Override
    public StructValue getValue() {
        return this.value;
    }
}

