/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug;

import java.text.MessageFormat;
import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentSkipListMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.resources.IMarkerDelta;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IMemoryBlock;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugElement;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugResource;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.deployment.debug.IDeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchData;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.deployment.devResponse.Response;
import org.eclipse.fordiac.ide.deployment.exceptions.DeploymentException;
import org.eclipse.fordiac.ide.deployment.interactors.DeviceManagementInteractorFactory;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementExecutorService;
import org.eclipse.fordiac.ide.deployment.interactors.IDeviceManagementInteractor;
import org.eclipse.fordiac.ide.deployment.interactors.SharedWatchDeviceManagementInteractor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorCache;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.Device;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public class DeploymentDebugDevice
extends DeploymentDebugElement
implements IDeploymentDebugTarget {
    private final Device device;
    private final boolean allowTerminate;
    private final Duration pollingInterval;
    private final List<DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint> launchWatches;
    private final IDeviceManagementExecutorService deviceManagementExecutor;
    private final Map<String, DeploymentDebugResource> resources = new ConcurrentSkipListMap<String, DeploymentDebugResource>();
    private final Map<String, IWatch> watches = new ConcurrentSkipListMap<String, IWatch>();
    private final AtomicLong variableUpdateCount = new AtomicLong();
    private boolean terminate;

    public DeploymentDebugDevice(Device device, DeploymentDebugTarget debugTarget, boolean allowTerminate, Duration pollingInterval, List<DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint> launchWatches) {
        super(debugTarget);
        this.device = Objects.requireNonNull(device);
        this.allowTerminate = allowTerminate;
        this.pollingInterval = pollingInterval;
        this.launchWatches = launchWatches;
        this.deviceManagementExecutor = IDeviceManagementExecutorService.of((IDeviceManagementInteractor)new SharedWatchDeviceManagementInteractor(DeviceManagementInteractorFactory.INSTANCE.getDeviceManagementInteractor(device)));
        DebugPlugin.getDefault().getBreakpointManager().addBreakpointListener((IBreakpointListener)this);
        debugTarget.getLaunch().addDebugTarget((IDebugTarget)this);
        this.fireCreationEvent();
    }

    protected void terminated() {
        DebugPlugin.getDefault().getBreakpointManager().removeBreakpointListener((IBreakpointListener)this);
        this.incrementVariableUpdateCount();
        this.getPrimaryDebugTarget().updateWatches(false);
        this.fireTerminateEvent();
    }

    protected void updateResources(List<org.eclipse.fordiac.ide.deployment.devResponse.Resource> response) {
        if (this.resources.keySet().retainAll(response.stream().map(org.eclipse.fordiac.ide.deployment.devResponse.Resource::getName).collect(Collectors.toSet()))) {
            this.fireChangeEvent(512);
        }
        response.forEach(devResource -> {
            DeploymentDebugResource deploymentDebugResource = this.resources.computeIfAbsent(devResource.getName(), name -> Optional.ofNullable(this.device.getResourceNamed(name)).map(resource -> new DeploymentDebugResource((Resource)resource, this, this.allowTerminate)).orElse(null));
        });
    }

    protected void updateWatches(Response response) {
        this.incrementVariableUpdateCount();
        DeploymentDebugWatchData watchData = new DeploymentDebugWatchData(response);
        Throwable throwable = null;
        Object var4_5 = null;
        try (EvaluatorCache cache = EvaluatorCache.open();){
            this.watches.values().forEach(watch -> watch.updateValue(watchData));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        this.getPrimaryDebugTarget().updateWatches(false);
    }

    protected void handleDeviceError(DeploymentException exception) {
        FordiacLogHelper.logWarning((String)exception.getLocalizedMessage(), (Exception)((Object)exception));
        if (this.canDisconnect()) {
            this.deviceManagementExecutor.shutdown();
            this.terminated();
        }
    }

    public void connect() throws DebugException {
        try {
            try {
                this.deviceManagementExecutor.connect();
                this.deviceManagementExecutor.queryResourcesPeriodically(this::updateResources, this::handleDeviceError, this.pollingInterval.toMillis(), TimeUnit.MILLISECONDS);
                this.deviceManagementExecutor.readWatchesPeriodically(this::updateWatches, this::handleDeviceError, this.pollingInterval.toMillis(), TimeUnit.MILLISECONDS);
                Throwable throwable = null;
                Object var6_3 = null;
                try (EvaluatorCache cache = EvaluatorCache.open();){
                    this.launchWatches.forEach(this::addWatch);
                    Stream.of(DebugPlugin.getDefault().getBreakpointManager().getBreakpoints()).forEachOrdered(this::breakpointAdded);
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (DeploymentException e) {
                throw new DebugException(Status.error((String)MessageFormat.format(Messages.DeploymentDebugDevice_ConnectError, this.device.getName()), (Throwable)e));
            }
        }
        finally {
            this.fireChangeEvent(256);
        }
    }

    public void disconnect() throws DebugException {
        try {
            try {
                this.deviceManagementExecutor.close();
            }
            catch (Exception e) {
                throw new DebugException(Status.error((String)MessageFormat.format(Messages.DeploymentDebugDevice_DisconnectError, this.device.getName()), (Throwable)e));
            }
        }
        finally {
            this.terminated();
        }
    }

    public void terminate() throws DebugException {
        this.deviceManagementExecutor.killDeviceAsync(this.device);
        this.terminate = true;
        this.disconnect();
    }

    public long getVariableUpdateCount() {
        return this.variableUpdateCount.get();
    }

    public long incrementVariableUpdateCount() {
        return this.variableUpdateCount.incrementAndGet();
    }

    public TypeLibrary getTypeLibrary() {
        return this.device.getAutomationSystem().getTypeLibrary();
    }

    public EvaluatorDebugVariable createVariable(Variable<?> variable, String expression) {
        return new DeploymentDebugVariable(variable, expression, this);
    }

    @Override
    public Map<String, IWatch> getWatches() {
        return Collections.unmodifiableMap(this.watches);
    }

    public boolean canResume() {
        return this.resources.values().stream().anyMatch(DeploymentDebugResource::canResume);
    }

    public boolean canSuspend() {
        return this.resources.values().stream().anyMatch(DeploymentDebugResource::canSuspend);
    }

    public boolean isSuspended() {
        return !this.resources.isEmpty() && this.resources.values().stream().allMatch(DeploymentDebugResource::isSuspended);
    }

    public void resume() throws DebugException {
        for (DeploymentDebugResource resource : this.resources.values()) {
            if (!resource.canResume()) continue;
            resource.resume();
        }
    }

    public void suspend() throws DebugException {
        for (DeploymentDebugResource resource : this.resources.values()) {
            if (!resource.canSuspend()) continue;
            resource.suspend();
        }
    }

    public boolean supportsBreakpoint(IBreakpoint breakpoint) {
        DeploymentWatchpoint watchpoint;
        return breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).isRelevant(this.getSystem());
    }

    public void breakpointAdded(IBreakpoint breakpoint) {
        DeploymentWatchpoint watchpoint;
        if (breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).isEnabled() && watchpoint.isRelevant(this.getSystem())) {
            this.addWatch(watchpoint);
        }
    }

    public void breakpointRemoved(IBreakpoint breakpoint, IMarkerDelta delta) {
        DeploymentWatchpoint watchpoint;
        if (breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).isRelevant(this.getSystem())) {
            this.removeWatch(watchpoint);
        }
    }

    public void breakpointChanged(IBreakpoint breakpoint, IMarkerDelta delta) {
        DeploymentWatchpoint watchpoint;
        if (breakpoint instanceof DeploymentWatchpoint && (watchpoint = (DeploymentWatchpoint)breakpoint).isRelevant(this.getSystem())) {
            if (watchpoint.isEnabledChanged(delta)) {
                if (watchpoint.isEnabled()) {
                    this.addWatch(watchpoint);
                } else {
                    this.removeWatch(watchpoint);
                }
            } else {
                if (watchpoint.isForceChanged(delta)) {
                    this.updateForce(watchpoint);
                }
                if (watchpoint.isPinnedChanged(delta)) {
                    this.updatePinned(watchpoint);
                }
            }
        }
    }

    protected void addWatch(DeploymentLaunchConfigurationAttributes.DeploymentLaunchWatchpoint watchpoint) {
        Optional<INamedElement> element = watchpoint.getTarget(this.device);
        if (element.isPresent()) {
            try {
                IWatch watch = this.watches.computeIfAbsent(element.get().getQualifiedName(), name -> IWatch.watchFor(name, (INamedElement)element.get(), this));
                watch.setSource(IWatch.Source.LAUNCH);
                this.getPrimaryDebugTarget().updateWatches(true);
                watch.addWatch();
                if (watchpoint.isForceEnabled() && watch instanceof IVarDeclarationWatch) {
                    IVarDeclarationWatch variableWatch = (IVarDeclarationWatch)watch;
                    variableWatch.forceValue(watchpoint.forceValue());
                }
            }
            catch (CoreException | EvaluatorException e) {
                FordiacLogHelper.logWarning((String)("Cannot create watch for watchpoint: " + String.valueOf(watchpoint)), (Exception)e);
            }
        }
    }

    protected void addWatch(DeploymentWatchpoint watchpoint) {
        Optional<INamedElement> element = watchpoint.getTarget(this.device);
        if (element.isPresent()) {
            try {
                IWatch watch = this.watches.computeIfAbsent(element.get().getQualifiedName(), name -> IWatch.watchFor(name, (INamedElement)element.get(), this));
                watch.setSource(IWatch.Source.BREAKPOINT);
                watch.setPinned(watchpoint.isPinned());
                this.getPrimaryDebugTarget().updateWatches(true);
                watch.addWatch();
                if (watchpoint.isForceEnabled() && watch instanceof IVarDeclarationWatch) {
                    IVarDeclarationWatch variableWatch = (IVarDeclarationWatch)watch;
                    variableWatch.forceValue(watchpoint.getForceValue());
                }
                watchpoint.setInstalled(true);
            }
            catch (CoreException | EvaluatorException e) {
                FordiacLogHelper.logWarning((String)("Cannot create watch for watchpoint: " + String.valueOf((Object)watchpoint)), (Exception)e);
            }
        }
    }

    protected void removeWatch(DeploymentWatchpoint watchpoint) {
        IWatch watch = this.watches.remove(watchpoint.getLocation());
        if (watch != null) {
            try {
                IVarDeclarationWatch variableWatch;
                this.getPrimaryDebugTarget().updateWatches(true);
                if (watch instanceof IVarDeclarationWatch && (variableWatch = (IVarDeclarationWatch)watch).isForced()) {
                    variableWatch.clearForce();
                }
                watch.removeWatch();
            }
            catch (DebugException e) {
                FordiacLogHelper.logWarning((String)("Cannot remove watch for watchpoint: " + String.valueOf((Object)watchpoint)), (Exception)((Object)e));
            }
        }
    }

    protected void updateForce(DeploymentWatchpoint watchpoint) {
        IWatch watch = this.watches.get(watchpoint.getLocation());
        if (watch instanceof IVarDeclarationWatch) {
            IVarDeclarationWatch variableWatch = (IVarDeclarationWatch)watch;
            try {
                this.getPrimaryDebugTarget().updateWatches(false);
                if (watchpoint.isForceEnabled()) {
                    variableWatch.forceValue(watchpoint.getForceValue());
                } else {
                    variableWatch.clearForce();
                }
            }
            catch (DebugException e) {
                FordiacLogHelper.logWarning((String)("Cannot update watch for watchpoint: " + String.valueOf((Object)watchpoint)), (Exception)((Object)e));
            }
        }
    }

    protected void updatePinned(DeploymentWatchpoint watchpoint) {
        IWatch watch = this.watches.get(watchpoint.getLocation());
        if (watch != null) {
            watch.setPinned(watchpoint.isPinned());
            this.getPrimaryDebugTarget().updateWatches(true);
        }
    }

    @Override
    public String getName() {
        return this.device.getName();
    }

    @Override
    public IDeploymentDebugTarget getDebugTarget() {
        return this;
    }

    public DeploymentDebugTarget getPrimaryDebugTarget() {
        return (DeploymentDebugTarget)super.getDebugTarget();
    }

    public Device getDevice() {
        return this.device;
    }

    public ILaunch getLaunch() {
        return this.getPrimaryDebugTarget().getLaunch();
    }

    @Override
    public AutomationSystem getSystem() {
        return this.device.getAutomationSystem();
    }

    public IDeviceManagementExecutorService getDeviceManagementExecutorService() {
        return this.deviceManagementExecutor;
    }

    public Duration getPollingInterval() {
        return this.pollingInterval;
    }

    public boolean isAllowTerminate() {
        return this.allowTerminate;
    }

    public boolean canTerminate() {
        return !this.deviceManagementExecutor.isTerminated() && this.allowTerminate;
    }

    public boolean isTerminated() {
        return this.terminate && this.deviceManagementExecutor.isTerminated();
    }

    public boolean canDisconnect() {
        return !this.isDisconnected();
    }

    public boolean isDisconnected() {
        return !this.terminate && this.deviceManagementExecutor.isTerminated();
    }

    public boolean isAlive() {
        return !this.deviceManagementExecutor.isShutdown() && this.deviceManagementExecutor.isConnected();
    }

    public boolean supportsStorageRetrieval() {
        return false;
    }

    public IMemoryBlock getMemoryBlock(long startAddress, long length) throws DebugException {
        throw DeploymentDebugDevice.createUnsupportedOperationException();
    }

    public IProcess getProcess() {
        return null;
    }

    public IThread[] getThreads() {
        return (IThread[])this.resources.values().toArray(IThread[]::new);
    }

    public boolean hasThreads() {
        return this.isAlive() && !this.resources.isEmpty();
    }
}

