/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.watch;

import java.text.MessageFormat;
import java.util.Objects;
import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.DebugException;
import org.eclipse.fordiac.ide.debug.value.IEvaluatorDebugValue;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugDevice;
import org.eclipse.fordiac.ide.deployment.debug.DeploymentDebugVariable;
import org.eclipse.fordiac.ide.deployment.debug.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugErrorValue;
import org.eclipse.fordiac.ide.deployment.debug.watch.DeploymentDebugWatchUtils;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVariableWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.model.eval.EvaluatorException;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Resource;

public abstract class AbstractVariableWatch
extends DeploymentDebugVariable
implements IVariableWatch {
    private final Resource resource;
    private final ITypedElement element;
    private long aliveCount;
    private String invalidValue;
    private DeploymentDebugErrorValue cachedErrorValue;
    private boolean pinned;
    private IWatch.Source source = IWatch.Source.BREAKPOINT;

    protected AbstractVariableWatch(Variable<?> variable, ITypedElement element, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        this(variable, element, DeploymentDebugWatchUtils.getResource((INamedElement)element), debugTarget);
    }

    protected AbstractVariableWatch(Variable<?> variable, ITypedElement element, Resource resource, DeploymentDebugDevice debugTarget) throws EvaluatorException {
        super(variable, element.getQualifiedName(), debugTarget);
        this.resource = resource;
        this.element = element;
    }

    public IEvaluatorDebugValue getValue() {
        if (this.hasError()) {
            return this.getErrorValue();
        }
        return super.getValue();
    }

    protected void updateValue(String value) {
        this.aliveCount = this.getDebugTarget().getVariableUpdateCount();
        try {
            this.getInternalVariable().setValue(value, this.getDebugTarget().getTypeLibrary());
            this.invalidValue = null;
        }
        catch (Exception e) {
            this.invalidValue = value;
        }
    }

    protected void updateValue(Value value) {
        this.aliveCount = this.getDebugTarget().getVariableUpdateCount();
        try {
            this.getInternalVariable().setValue(value);
            this.invalidValue = null;
        }
        catch (Exception e) {
            this.invalidValue = value.toString();
        }
    }

    @Override
    public boolean isAlive() {
        return this.aliveCount == this.getDebugTarget().getVariableUpdateCount();
    }

    @Override
    public boolean hasError() {
        return !this.isAlive() || this.invalidValue != null;
    }

    protected IEvaluatorDebugValue getErrorValue() {
        String errorMessage = this.getErrorMessage();
        if (this.cachedErrorValue == null || !this.cachedErrorValue.getMessage().equals(errorMessage)) {
            this.cachedErrorValue = new DeploymentDebugErrorValue(errorMessage, this.getDebugTarget());
        }
        return this.cachedErrorValue;
    }

    protected String getErrorMessage() {
        if (!this.isAlive()) {
            if (!this.getDebugTarget().isAlive()) {
                return Messages.AbstractVariableWatch_Disconnected;
            }
            return Messages.AbstractVariableWatch_NoValue;
        }
        if (this.invalidValue != null) {
            return MessageFormat.format(Messages.AbstractVariableWatch_InvalidValue, this.invalidValue);
        }
        return Messages.AbstractVariableWatch_UnknownError;
    }

    @Override
    public boolean isPinned() {
        return this.pinned;
    }

    @Override
    public void setPinned(boolean pinned) {
        this.pinned = pinned;
    }

    @Override
    public IWatch.Source getSource() {
        return this.source;
    }

    @Override
    public void setSource(IWatch.Source source) {
        this.source = Objects.requireNonNull(source);
    }

    @Override
    public String getQualifiedName() {
        return this.getExpression();
    }

    @Override
    public Resource getResource() {
        return this.resource;
    }

    protected Resource getResourceChecked() throws DebugException {
        if (this.resource == null) {
            throw new DebugException(Status.error((String)MessageFormat.format(Messages.AbstractVariableWatch_ElementNotInResource, this.getQualifiedName())));
        }
        return this.resource;
    }

    @Override
    public ITypedElement getWatchedElement() {
        return this.element;
    }

    @Override
    public Value getInternalValue() {
        return this.getInternalVariable().getValue();
    }

    @Override
    public DeploymentDebugDevice getDebugTarget() {
        return (DeploymentDebugDevice)super.getDebugTarget();
    }

    public int hashCode() {
        return this.getQualifiedName().hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        AbstractVariableWatch other = (AbstractVariableWatch)obj;
        return Objects.equals(this.getQualifiedName(), other.getQualifiedName());
    }
}

