/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextfunctioneditor.validation;

import com.google.common.base.Objects;
import com.google.inject.Inject;
import com.google.inject.Provider;
import java.text.MessageFormat;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreControlFlowValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreImportValidator;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreTypeUsageCollector;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreVariableUsageValidator;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.Messages;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.resource.STFunctionResource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunction;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionPackage;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.stfunction.STFunctionSource;
import org.eclipse.fordiac.ide.structuredtextfunctioneditor.validation.AbstractSTFunctionValidator;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STFunctionValidator
extends AbstractSTFunctionValidator {
    @Inject
    private Provider<STCoreTypeUsageCollector> typeUsageCollectorProvider;
    @Inject
    private STCoreImportValidator importValidator;
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.fordiac.ide.structuredtextfunction.";
    public static final String FUNCTION_NAME_MISMATCH = "org.eclipse.fordiac.ide.structuredtextfunction.functionNameMismatch";
    public static final String MULTIPLE_FUNCTIONS = "org.eclipse.fordiac.ide.structuredtextfunction.multipleFunctions";

    @Check
    public void checkPackageDeclaration(STFunctionSource source) {
        this.checkPackageDeclaration((STSource)source, (EStructuralFeature)STFunctionPackage.Literals.ST_FUNCTION_SOURCE__NAME, source.getName());
    }

    @Check
    public void checkImports(STFunctionSource source) {
        if (!source.getImports().isEmpty()) {
            this.importValidator.validateImports(source.getName(), (List)source.getImports(), ((STCoreTypeUsageCollector)this.typeUsageCollectorProvider.get()).collectUsedTypes((EObject)source), (ValidationMessageAcceptor)this);
        }
    }

    @Check
    public void checkControlFlow(STFunction function) {
        STCoreControlFlowValidator controlFlowValidator = new STCoreControlFlowValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)function));
        controlFlowValidator.validateVariableBlocks((List)function.getVarDeclarations());
        controlFlowValidator.validateStatements((List)function.getCode());
    }

    @Check
    public void checkUnusedVariables(STFunction function) {
        STCoreVariableUsageValidator variableUsageValidator = new STCoreVariableUsageValidator((ValidationMessageAcceptor)this, this.getIssueSeverities(this.getContext(), (EObject)function));
        variableUsageValidator.addVariableBlocks((List)function.getVarDeclarations());
        variableUsageValidator.addReturnVariable((ICallable)function);
        variableUsageValidator.addReferences((EObject)function);
        variableUsageValidator.validateUnused();
    }

    @Check
    public void checkFirstFunctionNameMatchesTypeName(STFunction function) {
        STFunctionResource resource;
        LibraryElement libraryElement;
        Resource resource2 = function.eResource();
        if (resource2 instanceof STFunctionResource && (libraryElement = (resource = (STFunctionResource)resource2).getInternalLibraryElement()) instanceof FunctionFBType) {
            STFunctionSource source;
            FunctionFBType fbType = (FunctionFBType)libraryElement;
            EObject eObject = function.eContainer();
            if (eObject instanceof STFunctionSource && (source = (STFunctionSource)eObject).getFunctions().indexOf((Object)function) == 0 && !Objects.equal((Object)fbType.getName(), (Object)function.getName())) {
                this.error(MessageFormat.format(Messages.STFunctionValidator_FunctionNameMismatch, function.getName(), fbType.getName()), (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, FUNCTION_NAME_MISMATCH, new String[]{function.getName(), fbType.getName()});
            }
        }
    }

    @Check
    public void checkMultipleFunctions(STFunction function) {
        STFunctionResource resource;
        LibraryElement libraryElement;
        Resource resource2 = function.eResource();
        if (resource2 instanceof STFunctionResource && (libraryElement = (resource = (STFunctionResource)resource2).getInternalLibraryElement()) instanceof FunctionFBType) {
            STFunctionSource source;
            FunctionFBType fbType = (FunctionFBType)libraryElement;
            EObject eObject = function.eContainer();
            if (eObject instanceof STFunctionSource && (source = (STFunctionSource)eObject).getFunctions().indexOf((Object)function) != 0) {
                this.error(MessageFormat.format(Messages.STFunctionValidator_MultipleFunctions, fbType.getName()), (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, MULTIPLE_FUNCTIONS, new String[0]);
            }
        }
    }
}

