/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.deployment.debug.ui;

import java.text.MessageFormat;
import org.eclipse.core.resources.IResource;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.fordiac.ide.debug.ui.EvaluatorDebugModelPresentation;
import org.eclipse.fordiac.ide.deployment.debug.IDeploymentDebugTarget;
import org.eclipse.fordiac.ide.deployment.debug.breakpoint.DeploymentWatchpoint;
import org.eclipse.fordiac.ide.deployment.debug.ui.Messages;
import org.eclipse.fordiac.ide.deployment.debug.watch.IVarDeclarationWatch;
import org.eclipse.fordiac.ide.deployment.debug.watch.IWatch;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;

public class DeploymentDebugModelPresentation
extends EvaluatorDebugModelPresentation
implements IColorProvider {
    public static final String FORCE_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.forceColor";
    public static final String WATCH_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.watchColor";
    public static final String WATCH_ERROR_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.watchErrorColor";
    public static final String FORCE_TEXT_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.forceTextColor";
    public static final String WATCH_TEXT_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.watchTextColor";
    public static final String WATCH_ERROR_TEXT_COLOR = "org.eclipse.fordiac.ide.deployment.debug.ui.watchErrorTextColor";
    private Image watchPinnedImage;
    private Image watchLaunchImage;

    public Color getForeground(Object element) {
        if (element instanceof IWatch) {
            IVarDeclarationWatch variableWatch;
            IWatch watch = (IWatch)element;
            if (watch.hasError()) {
                return DeploymentDebugModelPresentation.getWatchErrorTextColor();
            }
            if (element instanceof IVarDeclarationWatch && (variableWatch = (IVarDeclarationWatch)element).isForced()) {
                return DeploymentDebugModelPresentation.getForceTextColor();
            }
        }
        return null;
    }

    public Color getBackground(Object element) {
        if (element instanceof IWatch) {
            IVarDeclarationWatch variableWatch;
            IWatch watch = (IWatch)element;
            if (watch.hasError()) {
                return DeploymentDebugModelPresentation.getWatchErrorColor();
            }
            if (element instanceof IVarDeclarationWatch && (variableWatch = (IVarDeclarationWatch)element).isForced()) {
                return DeploymentDebugModelPresentation.getForceColor();
            }
        }
        return null;
    }

    public Image getImage(Object element) {
        if (element instanceof IWatch) {
            IWatch watch = (IWatch)element;
            return this.getWatchImage(watch);
        }
        if (element instanceof DeploymentWatchpoint) {
            DeploymentWatchpoint watchpoint = (DeploymentWatchpoint)element;
            return DebugUITools.getImage((String)DeploymentDebugModelPresentation.getWatchpointImageKey(watchpoint));
        }
        return super.getImage(element);
    }

    private Image getWatchImage(IWatch watch) {
        if (watch.getSource() == IWatch.Source.LAUNCH) {
            return this.getWatchLaunchImage();
        }
        if (watch.isPinned()) {
            return this.getWatchPinnedImage();
        }
        return DebugUITools.getImage((String)"IMG_OBJS_VARIABLE");
    }

    private static String getWatchpointImageKey(DeploymentWatchpoint watchpoint) {
        if (watchpoint.isForceEnabled()) {
            if (watchpoint.isEnabled()) {
                return "IMG_OBJS_MODIFICATION_WATCHPOINT";
            }
            return "IMG_OBJS_MODIFICATION_WATCHPOINT_DISABLED";
        }
        if (watchpoint.isEnabled()) {
            return "IMG_OBJS_ACCESS_WATCHPOINT";
        }
        return "IMG_OBJS_ACCESS_WATCHPOINT_DISABLED";
    }

    public String getText(Object element) {
        if (element instanceof IDeploymentDebugTarget) {
            IDeploymentDebugTarget target = (IDeploymentDebugTarget)element;
            StringBuilder label = new StringBuilder(target.getName());
            if (target.isTerminated()) {
                label.insert(0, Messages.DeploymentDebugModelPresentation_Terminated);
            } else if (target.isDisconnected()) {
                label.insert(0, Messages.DeploymentDebugModelPresentation_Disconnected);
            }
            return label.toString();
        }
        if (element instanceof DeploymentWatchpoint) {
            DeploymentWatchpoint watchpoint = (DeploymentWatchpoint)element;
            return DeploymentDebugModelPresentation.getWatchpointText(watchpoint);
        }
        return super.getText(element);
    }

    private static String getWatchpointText(DeploymentWatchpoint watchpoint) {
        IResource resource = watchpoint.getMarker().getResource();
        if (resource == null) {
            return "";
        }
        String location = watchpoint.getLocation();
        if (location.isEmpty()) {
            return resource.getName();
        }
        return MessageFormat.format(Messages.DeploymentDebugModelPresentation_WatchpointText, resource.getName(), location);
    }

    public static Color getForceColor() {
        return JFaceResources.getColorRegistry().get(FORCE_COLOR);
    }

    public static Color getWatchColor() {
        return JFaceResources.getColorRegistry().get(WATCH_COLOR);
    }

    public static Color getWatchErrorColor() {
        return JFaceResources.getColorRegistry().get(WATCH_ERROR_COLOR);
    }

    public static Color getForceTextColor() {
        return JFaceResources.getColorRegistry().get(FORCE_TEXT_COLOR);
    }

    public static Color getWatchTextColor() {
        return JFaceResources.getColorRegistry().get(WATCH_TEXT_COLOR);
    }

    public static Color getWatchErrorTextColor() {
        return JFaceResources.getColorRegistry().get(WATCH_ERROR_TEXT_COLOR);
    }

    private Image getWatchPinnedImage() {
        Image baseImage;
        if (this.watchPinnedImage == null && (baseImage = DebugUITools.getImage((String)"IMG_OBJS_VARIABLE")) != null) {
            this.watchPinnedImage = FordiacImage.createOverlayImage((Image)baseImage, (ImageDescriptor)FordiacImage.ICON_PINNED.getImageDescriptor(), (int)3).createImage();
        }
        return this.watchPinnedImage;
    }

    private Image getWatchLaunchImage() {
        Image baseImage;
        if (this.watchLaunchImage == null && (baseImage = DebugUITools.getImage((String)"IMG_OBJS_VARIABLE")) != null) {
            this.watchLaunchImage = FordiacImage.createOverlayImage((Image)baseImage, (ImageDescriptor)FordiacImage.ICON_LAUNCH_CONFIG_OVERLAY.getImageDescriptor(), (int)3).createImage();
        }
        return this.watchLaunchImage;
    }

    public void dispose() {
        if (this.watchPinnedImage != null) {
            this.watchPinnedImage.dispose();
        }
        if (this.watchLaunchImage != null) {
            this.watchLaunchImage.dispose();
        }
        super.dispose();
    }
}

