/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.move;

import java.text.MessageFormat;
import java.util.List;
import java.util.Optional;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.impl.ConfigurableFBManagement;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.DataTypeChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.UpdateFBInstanceChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.MoveTypeChange;
import org.eclipse.fordiac.ide.typemanagement.refactoring.move.UpdateTypeEntryFileChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.ltk.core.refactoring.Change;
import org.eclipse.ltk.core.refactoring.CompositeChange;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;
import org.eclipse.ltk.core.refactoring.participants.CheckConditionsContext;
import org.eclipse.ltk.core.refactoring.participants.MoveParticipant;

public class MoveTypeRefactoringParticipant
extends MoveParticipant {
    private String oldPackageName;
    private String newPackageName;
    private TypeEntry type;
    private IFile destinationFile;
    private IFile currentFile;

    protected boolean initialize(Object element) {
        if (element instanceof IFile) {
            IFile file;
            this.currentFile = file = (IFile)element;
            this.type = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file);
            this.oldPackageName = this.type.getPackageName();
            Object object = this.getArguments().getDestination();
            if (object instanceof IResource) {
                IResource folder = (IResource)object;
                URI destinationURI = URI.createPlatformResourceURI((String)folder.getFullPath().toString(), (boolean)true).appendSegment(this.type.getURI().lastSegment());
                this.destinationFile = MoveTypeRefactoringParticipant.getFileFromURI(destinationURI);
                this.newPackageName = PackageNameHelper.getPackageNameFromFile((IFile)this.destinationFile);
                return true;
            }
        }
        return false;
    }

    public String getName() {
        return MessageFormat.format(Messages.MoveTypeToPackage_RenamePackageTo, this.newPackageName);
    }

    public RefactoringStatus checkConditions(IProgressMonitor pm, CheckConditionsContext context) throws OperationCanceledException {
        Optional errorMessage;
        RefactoringStatus status = new RefactoringStatus();
        if (this.oldPackageName.contentEquals(this.newPackageName)) {
            status.addWarning(Messages.MoveTypeToPackage_PackageNameIsTheSame);
        }
        if (!(this.getArguments().getDestination() instanceof IResource)) {
            status.addError(Messages.MoveTypeToPackage_InvalidDestination);
        }
        if ((errorMessage = IdentifierVerifier.verifyPackageName((String)this.newPackageName)).isPresent()) {
            status.addFatalError((String)errorMessage.get());
        }
        return status;
    }

    public Change createPreChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        CompositeChange parentChange = new CompositeChange(Messages.MoveTypeToPackage);
        parentChange.add((Change)new MoveTypeChange(this.newPackageName, this.getName(), this.type.getURI()));
        parentChange.add((Change)new UpdateTypeEntryFileChange(this.currentFile, this.type, this.destinationFile));
        return parentChange;
    }

    public Change createChange(IProgressMonitor pm) throws CoreException, OperationCanceledException {
        TypeEntry typeEntry = this.type;
        if (typeEntry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
            return this.getDataTypeInstanceChanges(dtEntry);
        }
        return MoveTypeRefactoringParticipant.getInstanceChanges(this.type);
    }

    static IFile getFileFromURI(URI uri) {
        if (uri.isPlatformResource()) {
            Path filePath = new Path(uri.toPlatformString(true));
            return ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)filePath);
        }
        return null;
    }

    private CompositeChange getDataTypeInstanceChanges(DataTypeEntry dtEntry) {
        CompositeChange change = new CompositeChange(Messages.MoveTypeToPackage_UpdateInstances);
        List searchResult = new DataTypeInstanceSearch(dtEntry).performSearch();
        for (EObject eObject : searchResult) {
            if (eObject instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)eObject;
                change.add((Change)new DataTypeChange(Messages.MoveTypeToPackage_UpdateDataTypeInstance, EcoreUtil.getURI((EObject)eObject), this.getNewTypeDeclaration(varDecl)));
            }
            if (!(eObject instanceof FBNetworkElement)) continue;
            FBNetworkElement elem = (FBNetworkElement)eObject;
            change.add((Change)new UpdateInstanceChange(elem, (TypeEntry)dtEntry));
        }
        return change;
    }

    private static CompositeChange getInstanceChanges(TypeEntry typeEntry) {
        CompositeChange change = new CompositeChange(Messages.MoveTypeToPackage_UpdateInstances);
        List result = new BlockTypeInstanceSearch(typeEntry).performSearch();
        for (EObject eObject : result) {
            if (!(eObject instanceof FBNetworkElement)) continue;
            FBNetworkElement elem = (FBNetworkElement)eObject;
            change.add((Change)new UpdateFBInstanceChange(elem, typeEntry));
        }
        return change;
    }

    private String getNewTypeDeclaration(VarDeclaration varDeclaration) {
        StringBuilder typeDeclaration = new StringBuilder(varDeclaration.getFullTypeName());
        int packageNameEnd = typeDeclaration.lastIndexOf("::");
        if (packageNameEnd == -1) {
            typeDeclaration.insert(typeDeclaration.indexOf(varDeclaration.getTypeName()), this.newPackageName + "::");
        } else {
            typeDeclaration.replace(packageNameEnd - this.oldPackageName.length(), packageNameEnd, this.newPackageName);
        }
        return typeDeclaration.toString();
    }

    class UpdateInstanceChange
    extends UpdateFBInstanceChange {
        final String visibleChildrenString;

        public UpdateInstanceChange(FBNetworkElement instance, TypeEntry typeEntry) {
            String string;
            super(instance, typeEntry);
            if (instance instanceof StructManipulator) {
                StructManipulator structManipulator = (StructManipulator)instance;
                string = ConfigurableFBManagement.buildVisibleChildrenString((EList)structManipulator.getMemberVars());
            } else {
                string = "";
            }
            this.visibleChildrenString = string;
        }

        @Override
        protected Command createCommand(FBNetworkElement element) {
            if (element instanceof StructManipulator) {
                StructManipulator demux = (StructManipulator)element;
                LibraryElement libraryElement = this.typeEntry.getType();
                if (libraryElement instanceof StructuredType) {
                    StructuredType structuredType = (StructuredType)libraryElement;
                    return new ChangeStructCommand(demux, (DataType)structuredType, this.visibleChildrenString, true);
                }
            }
            return super.createCommand(element);
        }
    }
}

