/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.typemanagement.refactoring.RefactoringUtil;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameElementRefactoringProcessor;
import org.eclipse.fordiac.ide.typemanagement.refactoring.rename.RenameElementRefactoringWizard;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.EditPart;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ltk.core.refactoring.participants.RenameProcessor;
import org.eclipse.ltk.core.refactoring.participants.RenameRefactoring;
import org.eclipse.ltk.ui.refactoring.RefactoringWizard;
import org.eclipse.ltk.ui.refactoring.RefactoringWizardOpenOperation;
import org.eclipse.ui.handlers.HandlerUtil;

public class RenameElementRefactoringHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        try {
            RefactoringUtil.saveAllAndBuild();
            IStructuredSelection selection = HandlerUtil.getCurrentStructuredSelection((ExecutionEvent)event);
            if (selection.size() == 1) {
                Object firstElement = selection.getFirstElement();
                URI elementURI = this.getElementURI(firstElement);
                String elementName = this.getElementName(firstElement);
                if (elementURI != null && !elementName.isEmpty()) {
                    RenameRefactoring refactoring = new RenameRefactoring((RenameProcessor)new RenameElementRefactoringProcessor(elementURI, elementName));
                    RenameElementRefactoringWizard wizard = new RenameElementRefactoringWizard(refactoring);
                    RefactoringWizardOpenOperation openOperation = new RefactoringWizardOpenOperation((RefactoringWizard)wizard);
                    openOperation.run(HandlerUtil.getActiveShell((ExecutionEvent)event), refactoring.getName());
                }
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        catch (Exception e) {
            FordiacLogHelper.logError((String)"Error during refactoring", (Throwable)e);
        }
        return null;
    }

    protected URI getElementURI(Object element) {
        IInterfaceElement interfaceElement;
        FBNetworkElement fbNetworkElement;
        if (element instanceof EditPart) {
            EditPart editPart = (EditPart)element;
            return this.getElementURI(editPart.getModel());
        }
        if (element instanceof IInterfaceElement && (fbNetworkElement = (interfaceElement = (IInterfaceElement)element).getFBNetworkElement()) != null && fbNetworkElement.getTypeEntry() != null) {
            FBType fbType = fbNetworkElement.getType();
            if (fbType != null) {
                return this.getElementURI(fbType.getInterfaceList().getInterfaceElement(interfaceElement.getName()));
            }
            return null;
        }
        if (element instanceof EObject) {
            EObject eObject = (EObject)element;
            return EcoreUtil.getURI((EObject)eObject);
        }
        return null;
    }

    protected String getElementName(Object element) {
        if (element instanceof EditPart) {
            EditPart editPart = (EditPart)element;
            return this.getElementName(editPart.getModel());
        }
        if (element instanceof INamedElement) {
            INamedElement namedElement = (INamedElement)element;
            return namedElement.getName();
        }
        return "";
    }
}

