/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.refactoring.rename;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.typemanagement.Messages;
import org.eclipse.fordiac.ide.typemanagement.refactoring.AbstractCommandChange;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.ltk.core.refactoring.RefactoringStatus;

public class RenameUpdateFBTypeInterfaceChange
extends AbstractCommandChange<FBType> {
    private final List<String> affectedVarNames = new ArrayList<String>();
    private final String oldTypeName;
    private final String newTypeName;
    private final String packageName;

    public RenameUpdateFBTypeInterfaceChange(FBType type, String oldTypeName, String newTypeName, String packageName) {
        super(MessageFormat.format(Messages.DeleteFBTypeParticipant_Change_DeleteFBTypeInterface, type.getName(), oldTypeName), EcoreUtil.getURI((EObject)type), FBType.class);
        this.oldTypeName = oldTypeName;
        this.newTypeName = newTypeName;
        this.packageName = packageName;
    }

    @Override
    public void initializeValidationData(FBType element, IProgressMonitor pm) {
    }

    @Override
    public RefactoringStatus isValid(FBType element, IProgressMonitor pm) throws CoreException, OperationCanceledException {
        RefactoringStatus status = new RefactoringStatus();
        this.affectedVarNames.clear();
        String oldQualName = this.packageName + "::" + this.oldTypeName;
        for (IInterfaceElement elem : element.getInterfaceList().getAllInterfaceElements()) {
            VarDeclaration vd;
            if (!(elem instanceof VarDeclaration) || !(this.packageName + "::" + (vd = (VarDeclaration)elem).getType().getName()).equals(oldQualName)) continue;
            this.affectedVarNames.add(vd.getName());
        }
        if (this.affectedVarNames.isEmpty()) {
            status.addError(this.oldTypeName + " is not part of the interface of " + this.getName());
        }
        if (element.getTypeLibrary() == null || element.getTypeLibrary().getDataTypeLibrary() == null) {
            status.addError("Type Library is null");
        }
        return status;
    }

    @Override
    protected Command createCommand(FBType type) {
        CompoundCommand cmd = new CompoundCommand();
        for (String varName : this.affectedVarNames) {
            IInterfaceElement iie = type.getInterfaceList().getInterfaceElement(varName);
            if (!(iie instanceof VarDeclaration)) continue;
            VarDeclaration vd = (VarDeclaration)iie;
            cmd.add((Command)ChangeDataTypeCommand.forTypeName((IInterfaceElement)vd, (String)this.newTypeName));
        }
        return cmd;
    }
}

