/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.buildpath.util;

import java.io.IOException;
import java.nio.file.FileSystems;
import java.nio.file.PathMatcher;
import java.nio.file.Paths;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.fordiac.ide.model.buildpath.Attribute;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathAttributes;
import org.eclipse.fordiac.ide.model.buildpath.BuildpathFactory;
import org.eclipse.fordiac.ide.model.buildpath.DocumentRoot;
import org.eclipse.fordiac.ide.model.buildpath.Pattern;
import org.eclipse.fordiac.ide.model.buildpath.PatternType;
import org.eclipse.fordiac.ide.model.buildpath.SourceFolder;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class BuildpathUtil {
    public static final String BUILDPATH_FILE_NAME = ".buildpath";
    private static final List<String> DEFAULT_SOURCE_FOLDERS = List.of("Type Library");
    private static final List<String> EXTERNAL_SOURCE_FOLDERS = List.of("Standard Libraries", "External Libraries");

    public static Buildpath createDefaultBuildpath(IProject project) {
        Buildpath buildpath = BuildpathFactory.eINSTANCE.createBuildpath();
        SourceFolder projectFolder = BuildpathUtil.createSourceFolder("");
        buildpath.getSourceFolders().add((Object)projectFolder);
        DEFAULT_SOURCE_FOLDERS.stream().map(BuildpathUtil::createSourceFolder).forEachOrdered(arg_0 -> buildpath.getSourceFolders().add(arg_0));
        EXTERNAL_SOURCE_FOLDERS.stream().map(BuildpathUtil::createExternalSourceFolder).forEachOrdered(arg_0 -> buildpath.getSourceFolders().add(arg_0));
        Stream.of(DEFAULT_SOURCE_FOLDERS, EXTERNAL_SOURCE_FOLDERS).flatMap(Collection::stream).map(BuildpathUtil::createPattern).forEachOrdered(arg_0 -> projectFolder.getExcludes().add(arg_0));
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        resourceSet.createResource(BuildpathUtil.getBuildpathURI(project)).getContents().add((Object)buildpath);
        return buildpath;
    }

    public static Buildpath loadBuildpath(IProject project) {
        if (project != null && project.isAccessible() && BuildpathUtil.getBuildpathFile(project).exists()) {
            try {
                Object object;
                ResourceSetImpl resourceSet = new ResourceSetImpl();
                Resource resource = resourceSet.getResource(BuildpathUtil.getBuildpathURI(project), true);
                if (!resource.getContents().isEmpty() && (object = resource.getContents().get(0)) instanceof DocumentRoot) {
                    DocumentRoot documentRoot = (DocumentRoot)object;
                    return documentRoot.getBuildpath();
                }
            }
            catch (Exception e) {
                FordiacLogHelper.logWarning((String)("Exception loading buildpath file " + BuildpathUtil.getBuildpathFile(project).getFullPath().toString()), (Exception)e);
            }
        }
        return BuildpathUtil.createDefaultBuildpath(project);
    }

    public static void saveBuildpath(Buildpath buildpath) throws IOException {
        Objects.requireNonNull(buildpath);
        Resource resource = buildpath.eResource();
        if (resource == null) {
            throw new IOException("The buildpath argument must be contained in a resource");
        }
        resource.save(Collections.emptyMap());
    }

    public static boolean isNestedIn(SourceFolder sourceFolder, SourceFolder other) {
        Objects.requireNonNull(sourceFolder);
        Objects.requireNonNull(other);
        IPath path = BuildpathUtil.getRelativePath(sourceFolder);
        IPath otherPath = BuildpathUtil.getRelativePath(other);
        return otherPath.isPrefixOf(path);
    }

    public static void acceptMatches(Buildpath buildpath, IProject project, IResourceVisitor visitor) throws CoreException {
        Objects.requireNonNull(buildpath);
        Objects.requireNonNull(project);
        Objects.requireNonNull(visitor);
        for (SourceFolder sourceFolder : buildpath.getSourceFolders()) {
            BuildpathUtil.acceptMatches(sourceFolder, project, visitor);
        }
    }

    public static void acceptMatches(SourceFolder sourceFolder, IProject project, IResourceVisitor visitor) throws CoreException {
        Objects.requireNonNull(sourceFolder);
        Objects.requireNonNull(project);
        Objects.requireNonNull(visitor);
        IContainer container = BuildpathUtil.findContainer(sourceFolder, project);
        if (container == null) {
            return;
        }
        List<PathMatcher> includes = BuildpathUtil.getPathMatchers(sourceFolder.getIncludes());
        List<PathMatcher> excludes = BuildpathUtil.getPathMatchers(sourceFolder.getExcludes());
        container.accept(resource -> {
            java.nio.file.Path path = Paths.get(resource.getFullPath().makeRelativeTo(container.getFullPath()).toString(), new String[0]);
            if ((includes.isEmpty() || includes.stream().anyMatch(matcher -> matcher.matches(path))) && excludes.stream().noneMatch(matcher -> matcher.matches(path))) {
                return visitor.visit(resource);
            }
            return true;
        });
    }

    public static Optional<SourceFolder> findSourceFolder(Buildpath buildpath, IResource resource) {
        Objects.requireNonNull(buildpath);
        if (resource == null) {
            return Optional.empty();
        }
        return buildpath.getSourceFolders().stream().filter(candidate -> BuildpathUtil.matches(candidate, resource)).findFirst();
    }

    public static Optional<IPath> findRelativePath(Buildpath buildpath, IResource resource) {
        Objects.requireNonNull(buildpath);
        if (resource == null) {
            return Optional.empty();
        }
        return buildpath.getSourceFolders().stream().map(candidate -> BuildpathUtil.getRelativePath(candidate, resource).filter(path -> BuildpathUtil.matches(candidate, path))).flatMap(Optional::stream).findFirst();
    }

    public static boolean matches(SourceFolder sourceFolder, IResource resource) {
        return BuildpathUtil.getRelativePath(sourceFolder, resource).filter(path -> BuildpathUtil.matches(sourceFolder, path)).isPresent();
    }

    public static boolean matches(SourceFolder sourceFolder, IPath relativePath) {
        Objects.requireNonNull(sourceFolder);
        if (relativePath == null) {
            return false;
        }
        java.nio.file.Path path = Paths.get(relativePath.toString(), new String[0]);
        List<PathMatcher> includes = BuildpathUtil.getPathMatchers(sourceFolder.getIncludes());
        List<PathMatcher> excludes = BuildpathUtil.getPathMatchers(sourceFolder.getExcludes());
        return (includes.isEmpty() || includes.stream().anyMatch(matcher -> matcher.matches(path))) && excludes.stream().noneMatch(matcher -> matcher.matches(path));
    }

    public static Optional<IPath> getRelativePath(SourceFolder sourceFolder, IResource resource) {
        Objects.requireNonNull(sourceFolder);
        if (resource == null) {
            return Optional.empty();
        }
        IContainer container = BuildpathUtil.findContainer(sourceFolder, resource.getProject());
        if (container == null || !container.getFullPath().isPrefixOf(resource.getFullPath())) {
            return Optional.empty();
        }
        return Optional.of(resource.getFullPath().makeRelativeTo(container.getFullPath()));
    }

    private static IContainer findContainer(SourceFolder sourceFolder, IProject project) {
        IContainer container;
        IResource iResource = project.findMember(sourceFolder.getName());
        return iResource instanceof IContainer ? (container = (IContainer)iResource) : null;
    }

    private static IPath getRelativePath(SourceFolder sourceFolder) {
        return new Path(sourceFolder.getName());
    }

    private static List<PathMatcher> getPathMatchers(List<Pattern> patterns) {
        return patterns.stream().map(BuildpathUtil::getPathMatcher).toList();
    }

    private static PathMatcher getPathMatcher(Pattern pattern) {
        return switch (pattern.getSyntax()) {
            case PatternType.GLOB -> FileSystems.getDefault().getPathMatcher(String.valueOf((Object)pattern.getSyntax()) + ":" + BuildpathUtil.convertGlobPattern(pattern.getValue()));
            default -> FileSystems.getDefault().getPathMatcher(String.valueOf((Object)pattern.getSyntax()) + ":" + pattern.getValue());
        };
    }

    private static String convertGlobPattern(String pattern) {
        pattern = ((String)pattern).startsWith("/") ? ((String)pattern).substring(1) : "{**/,}" + (String)pattern;
        pattern = ((String)pattern).endsWith("/") ? (String)pattern + "**" : (String)pattern + "{,/**}";
        return pattern;
    }

    private static URI getBuildpathURI(IProject project) {
        if (project == null) {
            return URI.createFileURI((String)BUILDPATH_FILE_NAME);
        }
        return URI.createPlatformResourceURI((String)BuildpathUtil.getBuildpathFile(project).getFullPath().toString(), (boolean)true);
    }

    private static IFile getBuildpathFile(IProject project) {
        return project.getFile(BUILDPATH_FILE_NAME);
    }

    private static SourceFolder createSourceFolder(String name) {
        SourceFolder sourceFolder = BuildpathFactory.eINSTANCE.createSourceFolder();
        sourceFolder.setName(name);
        return sourceFolder;
    }

    private static SourceFolder createExternalSourceFolder(String name) {
        SourceFolder sourceFolder = BuildpathUtil.createSourceFolder(name);
        sourceFolder.getAttributes().add((Object)BuildpathUtil.createAttribute("ignore_warnings", String.valueOf(true)));
        sourceFolder.getAttributes().add((Object)BuildpathUtil.createAttribute("export", String.valueOf(false)));
        return sourceFolder;
    }

    private static Attribute createAttribute(String name, String value) {
        Attribute attribute = BuildpathAttributes.createAttribute(name);
        attribute.setValue(value);
        return attribute;
    }

    private static Pattern createPattern(String value) {
        Pattern pattern = BuildpathFactory.eINSTANCE.createPattern();
        pattern.setValue(value);
        return pattern;
    }

    private BuildpathUtil() {
        throw new UnsupportedOperationException();
    }
}

