/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;

public class PreferenceProvider {
    public static final String PROJECT_STORE_ACTIVE = "ProjectStoreActive";

    private static IScopeContext[] getContexts(String qualifier, IProject project) {
        if (project != null) {
            ProjectScope projectScope = new ProjectScope(project);
            if (Platform.getPreferencesService().getBoolean(qualifier, PROJECT_STORE_ACTIVE, false, new IScopeContext[]{projectScope})) {
                return new IScopeContext[]{projectScope, InstanceScope.INSTANCE};
            }
        }
        return new IScopeContext[]{InstanceScope.INSTANCE};
    }

    public static boolean getBoolean(String qualifier, String key, boolean defaultValue, IProject project) {
        return Platform.getPreferencesService().getBoolean(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static byte[] getByteArray(String qualifier, String key, byte[] defaultValue, IProject project) {
        return Platform.getPreferencesService().getByteArray(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static double getDouble(String qualifier, String key, double defaultValue, IProject project) {
        return Platform.getPreferencesService().getDouble(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static float getFloat(String qualifier, String key, float defaultValue, IProject project) {
        return Platform.getPreferencesService().getFloat(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static int getInt(String qualifier, String key, int defaultValue, IProject project) {
        return Platform.getPreferencesService().getInt(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static long getLong(String qualifier, String key, long defaultValue, IProject project) {
        return Platform.getPreferencesService().getLong(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    public static String getString(String qualifier, String key, String defaultValue, IProject project) {
        return Platform.getPreferencesService().getString(qualifier, key, defaultValue, PreferenceProvider.getContexts(qualifier, project));
    }

    private PreferenceProvider() {
        throw new UnsupportedOperationException();
    }
}

