/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.lang.runtime.SwitchBootstraps;
import java.text.Collator;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.fordiac.ide.model.IdentifierVerifier;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.buildpath.Buildpath;
import org.eclipse.fordiac.ide.model.buildpath.util.BuildpathUtil;
import org.eclipse.fordiac.ide.model.data.DataFactory;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementFactory;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.AdapterTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.DeviceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.GlobalConstantsEntry;
import org.eclipse.fordiac.ide.model.typelibrary.ResourceTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SegmentTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.impl.ErrorAdapterTypeEntryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.impl.ErrorAttributeTypeEntryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.impl.ErrorFBTypeEntryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.impl.ErrorSubAppTypeEntryImpl;
import org.eclipse.fordiac.ide.model.typelibrary.impl.TypeEntryFactory;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public final class TypeLibrary {
    private IProject project;
    private Buildpath buildpath;
    private final DataTypeLibrary dataTypeLib = new DataTypeLibrary();
    private final Map<String, AdapterTypeEntry> adapterTypes = new ConcurrentHashMap<String, AdapterTypeEntry>();
    private final Map<String, AttributeTypeEntry> attributeTypes = new ConcurrentHashMap<String, AttributeTypeEntry>();
    private final Map<String, DeviceTypeEntry> deviceTypes = new ConcurrentHashMap<String, DeviceTypeEntry>();
    private final Map<String, FBTypeEntry> fbTypes = new ConcurrentHashMap<String, FBTypeEntry>();
    private final Map<String, ResourceTypeEntry> resourceTypes = new ConcurrentHashMap<String, ResourceTypeEntry>();
    private final Map<String, SegmentTypeEntry> segmentTypes = new ConcurrentHashMap<String, SegmentTypeEntry>();
    private final Map<String, SubAppTypeEntry> subAppTypes = new ConcurrentHashMap<String, SubAppTypeEntry>();
    private final Map<String, SystemEntry> systems = new ConcurrentHashMap<String, SystemEntry>();
    private final Map<String, GlobalConstantsEntry> globalConstants = new ConcurrentHashMap<String, GlobalConstantsEntry>();
    private final Map<String, TypeEntry> programTypes = new ConcurrentHashMap<String, TypeEntry>();
    private final Map<String, TypeEntry> errorTypes = new ConcurrentHashMap<String, TypeEntry>();
    private final Map<IFile, TypeEntry> fileMap = new ConcurrentHashMap<IFile, TypeEntry>();
    private final Map<String, AtomicInteger> packages = new ConcurrentHashMap<String, AtomicInteger>();
    private final Queue<TypeEntry> duplicates = new ConcurrentLinkedQueue<TypeEntry>();

    public Collection<AdapterTypeEntry> getAdapterTypes() {
        return Collections.unmodifiableCollection(this.adapterTypes.values());
    }

    public List<AdapterTypeEntry> getAdapterTypesSorted() {
        return this.adapterTypes.values().stream().sorted((o1, o2) -> Collator.getInstance().compare(o1.getFullTypeName(), o2.getFullTypeName())).toList();
    }

    public Collection<AttributeTypeEntry> getAttributeTypes() {
        return Collections.unmodifiableCollection(this.attributeTypes.values());
    }

    public Collection<DeviceTypeEntry> getDeviceTypes() {
        return Collections.unmodifiableCollection(this.deviceTypes.values());
    }

    public Collection<FBTypeEntry> getFbTypes() {
        return Collections.unmodifiableCollection(this.fbTypes.values());
    }

    public Collection<ResourceTypeEntry> getResourceTypes() {
        return Collections.unmodifiableCollection(this.resourceTypes.values());
    }

    public Collection<SegmentTypeEntry> getSegmentTypes() {
        return Collections.unmodifiableCollection(this.segmentTypes.values());
    }

    public Collection<SubAppTypeEntry> getSubAppTypes() {
        return Collections.unmodifiableCollection(this.subAppTypes.values());
    }

    public Collection<SystemEntry> getSystems() {
        return Collections.unmodifiableCollection(this.systems.values());
    }

    public Collection<GlobalConstantsEntry> getGlobalConstants() {
        return Collections.unmodifiableCollection(this.globalConstants.values());
    }

    public Collection<TypeEntry> getProgramTypes() {
        return Collections.unmodifiableCollection(this.programTypes.values());
    }

    public Set<String> getPackages() {
        return Collections.unmodifiableSet(this.packages.keySet());
    }

    public Collection<TypeEntry> getAllTypes() {
        return Collections.unmodifiableCollection(this.fileMap.values());
    }

    public Stream<FBTypeEntry> getCompositeFBTypes() {
        return this.fbTypes.values().stream().filter(entry -> LibraryElementPackage.Literals.COMPOSITE_FB_TYPE.equals(entry.getTypeEClass()));
    }

    public AdapterTypeEntry getAdapterTypeEntry(String typeName) {
        return this.adapterTypes.get(typeName.toLowerCase());
    }

    public AttributeTypeEntry getAttributeTypeEntry(String typeName) {
        return this.attributeTypes.get(typeName.toLowerCase());
    }

    public DeviceTypeEntry getDeviceTypeEntry(String typeName) {
        return this.deviceTypes.get(typeName.toLowerCase());
    }

    public FBTypeEntry getFBTypeEntry(String typeName) {
        return this.fbTypes.get(typeName.toLowerCase());
    }

    public ResourceTypeEntry getResourceTypeEntry(String typeName) {
        return this.resourceTypes.get(typeName.toLowerCase());
    }

    public SegmentTypeEntry getSegmentTypeEntry(String typeName) {
        return this.segmentTypes.get(typeName.toLowerCase());
    }

    public SubAppTypeEntry getSubAppTypeEntry(String typeName) {
        return this.subAppTypes.get(typeName.toLowerCase());
    }

    public SystemEntry getSystemEntry(String name) {
        return this.systems.get(name.toLowerCase());
    }

    public GlobalConstantsEntry getGlobalConstantsEntry(String name) {
        return this.globalConstants.get(name.toLowerCase());
    }

    public TypeEntry getFBOrSubAppType(String typeName) {
        FBTypeEntry fb = this.getFBTypeEntry(typeName);
        return fb != null ? fb : this.getSubAppTypeEntry(typeName);
    }

    public TypeEntry getTypeEntry(IFile typeFile) {
        return this.fileMap.get(typeFile);
    }

    public void reload() {
        this.adapterTypes.clear();
        this.attributeTypes.clear();
        this.deviceTypes.clear();
        this.fbTypes.clear();
        this.resourceTypes.clear();
        this.segmentTypes.clear();
        this.subAppTypes.clear();
        this.systems.clear();
        this.globalConstants.clear();
        this.dataTypeLib.clear();
        this.programTypes.clear();
        this.fileMap.clear();
        this.packages.clear();
        TypeLibrary.deleteTypeLibraryMarkers((IResource)this.project);
        this.buildpath = BuildpathUtil.loadBuildpath(this.project);
        this.checkAdditions((IContainer)this.project);
    }

    public DataTypeLibrary getDataTypeLibrary() {
        return this.dataTypeLib;
    }

    public IProject getProject() {
        return this.project;
    }

    public Buildpath getBuildpath() {
        return this.buildpath;
    }

    TypeLibrary(IProject project) {
        this.project = project;
        this.buildpath = BuildpathUtil.loadBuildpath(project);
        if (project != null && project.isAccessible()) {
            this.checkAdditions((IContainer)project);
        }
    }

    public TypeEntry createTypeEntry(IFile file) {
        if (BuildpathUtil.findSourceFolder(this.buildpath, (IResource)file).isEmpty()) {
            return null;
        }
        TypeEntry entry = this.fileMap.computeIfAbsent(file, TypeEntryFactory.INSTANCE::createTypeEntry);
        if (entry != null) {
            Optional<String> message = IdentifierVerifier.verifyIdentifier(entry.getTypeName());
            if (message.isEmpty()) {
                this.addTypeEntry(entry);
            } else {
                TypeLibrary.createTypeLibraryMarker((IResource)file, message.get());
            }
        }
        return entry;
    }

    public TypeEntry createErrorTypeEntry(String typeName, EClass typeClass) {
        String resolvedTypeName = typeName == null ? "" : typeName;
        return this.errorTypes.computeIfAbsent(resolvedTypeName.toLowerCase(), name -> {
            LibraryElement libraryElement = TypeLibrary.createErrorType(resolvedTypeName, typeClass);
            TypeEntry entry = TypeLibrary.createErrorTypeEntry(libraryElement);
            entry.setType(libraryElement);
            entry.setTypeLibrary(this);
            return entry;
        });
    }

    private static LibraryElement createErrorType(String typeName, EClass typeClass) {
        LibraryElement libraryElement = (LibraryElement)LibraryElementFactory.eINSTANCE.create(typeClass);
        PackageNameHelper.setFullTypeName(libraryElement, typeName);
        if (libraryElement instanceof FBType) {
            FBType fbType = (FBType)libraryElement;
            fbType.setInterfaceList(LibraryElementFactory.eINSTANCE.createInterfaceList());
        } else if (libraryElement instanceof AttributeDeclaration) {
            AttributeDeclaration attributeDeclaration = (AttributeDeclaration)libraryElement;
            DirectlyDerivedType type = DataFactory.eINSTANCE.createDirectlyDerivedType();
            type.setName(libraryElement.getName());
            type.setBaseType(IecTypes.ElementaryTypes.STRING);
            attributeDeclaration.setType(type);
        }
        return libraryElement;
    }

    private static TypeEntry createErrorTypeEntry(LibraryElement libraryElement) {
        if (libraryElement instanceof AdapterType) {
            return new ErrorAdapterTypeEntryImpl();
        }
        if (libraryElement instanceof SubAppType) {
            return new ErrorSubAppTypeEntryImpl();
        }
        if (libraryElement instanceof FBType) {
            return new ErrorFBTypeEntryImpl();
        }
        if (libraryElement instanceof AttributeDeclaration) {
            return new ErrorAttributeTypeEntryImpl();
        }
        throw new UnsupportedOperationException("Cannot create error type entry for " + libraryElement.eClass().getName());
    }

    private void removeErrorTypeEntry(String typeName) {
        TypeEntry entry = this.errorTypes.remove(typeName.toLowerCase());
        if (entry != null) {
            entry.setTypeLibrary(null);
        }
    }

    public void addTypeEntry(TypeEntry entry) {
        if (entry.getTypeLibrary() != null) {
            entry.getTypeLibrary().removeTypeEntry(entry);
        }
        entry.setTypeLibrary(this);
        if (entry.getFile() != null) {
            this.fileMap.put(entry.getFile(), entry);
        }
        this.addTypeEntryNameReference(entry);
    }

    public void addTypeEntryNameReference(TypeEntry entry) {
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            if (!this.dataTypeLib.addTypeEntry(dtEntry)) {
                this.handleDuplicateTypeName(entry);
            }
        } else {
            this.removeErrorTypeEntry(entry.getFullTypeName());
            if (!this.addBlockTypeEntry(entry)) {
                this.handleDuplicateTypeName(entry);
            }
        }
        if (TypeLibrary.isProgramTypeEntry(entry) && !this.addProgramTypeEntry(entry)) {
            this.handleDuplicateTypeName(entry);
        }
        this.addPackageNameReference(PackageNameHelper.extractPackageName(entry.getFullTypeName()));
    }

    private void handleDuplicateTypeName(TypeEntry entry) {
        if (entry.getFile() != null && entry.getFile().exists()) {
            this.duplicates.add(entry);
            TypeLibrary.createTypeLibraryMarker((IResource)entry.getFile(), MessageFormat.format(Messages.TypeLibrary_TypeExists, entry.getFullTypeName()));
        } else {
            FordiacLogHelper.logWarning((String)MessageFormat.format(Messages.TypeLibrary_TypeExists, entry.getFullTypeName()));
        }
    }

    public void removeTypeEntry(TypeEntry entry) {
        this.removeTypeEntryNameReference(entry);
        if (entry.getFile() != null) {
            this.fileMap.remove(entry.getFile());
        }
        entry.setTypeLibrary(null);
    }

    public void removeTypeEntryNameReference(TypeEntry entry) {
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            this.dataTypeLib.removeTypeEntry(dtEntry);
        } else {
            this.removeBlockTypeEntry(entry);
        }
        if (TypeLibrary.isProgramTypeEntry(entry)) {
            this.removeProgramTypeEntry(entry);
        }
        this.removePackageNameReference(PackageNameHelper.extractPackageName(entry.getFullTypeName()));
        TypeLibrary.deleteTypeLibraryMarkers((IResource)entry.getFile());
        this.retryDuplicates();
    }

    private void retryDuplicates() {
        this.duplicates.removeIf(this::retryDuplicate);
    }

    private boolean retryDuplicate(TypeEntry entry) {
        if (!this.exists(entry)) {
            return true;
        }
        if (entry instanceof DataTypeEntry) {
            DataTypeEntry dtEntry = (DataTypeEntry)entry;
            if (this.dataTypeLib.addTypeEntry(dtEntry)) {
                TypeLibrary.deleteTypeLibraryMarkers((IResource)entry.getFile());
                return true;
            }
        } else if (this.addBlockTypeEntry(entry)) {
            TypeLibrary.deleteTypeLibraryMarkers((IResource)entry.getFile());
            return true;
        }
        return false;
    }

    protected void addPackageNameReference(String packageName) {
        if (packageName != null && !packageName.isEmpty()) {
            this.packages.computeIfAbsent(packageName.toLowerCase(), key -> new AtomicInteger()).incrementAndGet();
        }
    }

    protected void removePackageNameReference(String packageName) {
        if (packageName != null && !packageName.isEmpty()) {
            this.packages.computeIfPresent(packageName.toLowerCase(), (key, value) -> value.decrementAndGet() > 0 ? value : null);
        }
    }

    protected boolean addProgramTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        return this.programTypes.putIfAbsent(fullTypeName, entry) == null;
    }

    protected boolean removeProgramTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        return this.programTypes.remove(fullTypeName, entry);
    }

    public void refresh() {
        this.buildpath = BuildpathUtil.loadBuildpath(this.project);
        this.checkDeletions();
        this.checkAdditions((IContainer)this.project);
    }

    private void checkDeletions() {
        this.checkDeletionsForTypeGroup(this.adapterTypes.values());
        this.checkDeletionsForTypeGroup(this.attributeTypes.values());
        this.checkDeletionsForTypeGroup(this.deviceTypes.values());
        this.checkDeletionsForTypeGroup(this.fbTypes.values());
        this.checkDeletionsForTypeGroup(this.resourceTypes.values());
        this.checkDeletionsForTypeGroup(this.segmentTypes.values());
        this.checkDeletionsForTypeGroup(this.subAppTypes.values());
        this.checkDeletionsForTypeGroup(this.systems.values());
        this.checkDeletionsForTypeGroup(this.globalConstants.values());
        this.checkDeletionsForTypeGroup(this.dataTypeLib.getDerivedDataTypes());
        this.fileMap.values().removeIf(Predicate.not(this::exists));
    }

    private void checkDeletionsForTypeGroup(Collection<? extends TypeEntry> typeEntries) {
        typeEntries.stream().filter(Predicate.not(this::exists)).forEachOrdered(this::removeTypeEntry);
    }

    private boolean exists(TypeEntry entry) {
        return entry.getFile() != null && entry.getFile().exists() && BuildpathUtil.findSourceFolder(this.buildpath, (IResource)entry.getFile()).isPresent();
    }

    private void checkAdditions(IContainer container) {
        try {
            IResource[] members;
            IResource[] iResourceArray = members = container.members();
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFile file;
                IResource resource = iResourceArray[n2];
                if (resource instanceof IFolder) {
                    IFolder folder = (IFolder)resource;
                    this.checkAdditions((IContainer)folder);
                }
                if (resource instanceof IFile && !this.containsType(file = (IFile)resource)) {
                    this.createTypeEntry(file);
                }
                ++n2;
            }
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    public boolean containsType(IFile file) {
        return this.getTypeEntry(file) != null;
    }

    public TypeEntry find(String name) {
        return this.programTypes.get(name.toLowerCase());
    }

    public List<TypeEntry> findUnqualified(String name) {
        String unqualifiedName = PackageNameHelper.extractPlainTypeName(name);
        return this.programTypes.values().stream().filter(entry -> unqualifiedName.equalsIgnoreCase(entry.getTypeName())).toList();
    }

    private boolean addBlockTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        TypeEntry typeEntry = entry;
        Objects.requireNonNull(typeEntry);
        TypeEntry typeEntry2 = typeEntry;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, AttributeTypeEntry.class, DeviceTypeEntry.class, FBTypeEntry.class, ResourceTypeEntry.class, SegmentTypeEntry.class, SubAppTypeEntry.class, SystemEntry.class, GlobalConstantsEntry.class}, (Object)typeEntry2, n)) {
            case 0 -> {
                AdapterTypeEntry adpEntry = (AdapterTypeEntry)typeEntry2;
                if (this.adapterTypes.putIfAbsent(fullTypeName, adpEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 1 -> {
                AttributeTypeEntry atpEntry = (AttributeTypeEntry)typeEntry2;
                if (this.attributeTypes.putIfAbsent(fullTypeName, atpEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 2 -> {
                DeviceTypeEntry devEntry = (DeviceTypeEntry)typeEntry2;
                if (this.deviceTypes.putIfAbsent(fullTypeName, devEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 3 -> {
                FBTypeEntry fbtEntry = (FBTypeEntry)typeEntry2;
                if (this.fbTypes.putIfAbsent(fullTypeName, fbtEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 4 -> {
                ResourceTypeEntry resEntry = (ResourceTypeEntry)typeEntry2;
                if (this.resourceTypes.putIfAbsent(fullTypeName, resEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 5 -> {
                SegmentTypeEntry segEntry = (SegmentTypeEntry)typeEntry2;
                if (this.segmentTypes.putIfAbsent(fullTypeName, segEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 6 -> {
                SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry2;
                if (this.subAppTypes.putIfAbsent(fullTypeName, subAppEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 7 -> {
                SystemEntry sysEntry = (SystemEntry)typeEntry2;
                if (this.systems.putIfAbsent(fullTypeName, sysEntry) == null) {
                    yield true;
                }
                yield false;
            }
            case 8 -> {
                GlobalConstantsEntry globalConstEntry = (GlobalConstantsEntry)typeEntry2;
                if (this.globalConstants.putIfAbsent(fullTypeName, globalConstEntry) == null) {
                    yield true;
                }
                yield false;
            }
            default -> {
                FordiacLogHelper.logError((String)("Unknown type entry to be added to library: " + entry.getClass().getName()));
                yield true;
            }
        };
    }

    private boolean removeBlockTypeEntry(TypeEntry entry) {
        String fullTypeName = entry.getFullTypeName().toLowerCase();
        TypeEntry typeEntry = entry;
        Objects.requireNonNull(typeEntry);
        TypeEntry typeEntry2 = typeEntry;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AdapterTypeEntry.class, AttributeTypeEntry.class, DeviceTypeEntry.class, FBTypeEntry.class, ResourceTypeEntry.class, SegmentTypeEntry.class, SubAppTypeEntry.class, SystemEntry.class, GlobalConstantsEntry.class}, (Object)typeEntry2, n)) {
            case 0 -> {
                AdapterTypeEntry adpEntry = (AdapterTypeEntry)typeEntry2;
                yield this.adapterTypes.remove(fullTypeName, adpEntry);
            }
            case 1 -> {
                AttributeTypeEntry atpEntry = (AttributeTypeEntry)typeEntry2;
                yield this.attributeTypes.remove(fullTypeName, atpEntry);
            }
            case 2 -> {
                DeviceTypeEntry devEntry = (DeviceTypeEntry)typeEntry2;
                yield this.deviceTypes.remove(fullTypeName, devEntry);
            }
            case 3 -> {
                FBTypeEntry fbtEntry = (FBTypeEntry)typeEntry2;
                yield this.fbTypes.remove(fullTypeName, fbtEntry);
            }
            case 4 -> {
                ResourceTypeEntry resEntry = (ResourceTypeEntry)typeEntry2;
                yield this.resourceTypes.remove(fullTypeName, resEntry);
            }
            case 5 -> {
                SegmentTypeEntry segEntry = (SegmentTypeEntry)typeEntry2;
                yield this.segmentTypes.remove(fullTypeName, segEntry);
            }
            case 6 -> {
                SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry2;
                yield this.subAppTypes.remove(fullTypeName, subAppEntry);
            }
            case 7 -> {
                SystemEntry sysEntry = (SystemEntry)typeEntry2;
                yield this.systems.remove(fullTypeName, sysEntry);
            }
            case 8 -> {
                GlobalConstantsEntry globalConstEntry = (GlobalConstantsEntry)typeEntry2;
                yield this.globalConstants.remove(fullTypeName, globalConstEntry);
            }
            default -> {
                FordiacLogHelper.logError((String)("Unknown type entry to be removed from library: " + entry.getClass().getName()));
                yield true;
            }
        };
    }

    private static boolean isProgramTypeEntry(TypeEntry entry) {
        return entry instanceof FBTypeEntry || entry instanceof SubAppTypeEntry || entry instanceof DataTypeEntry;
    }

    private static void createTypeLibraryMarker(IResource resource, String message) {
        FordiacMarkerHelper.createMarkers(resource, List.of(ErrorMarkerBuilder.createErrorMarkerBuilder(message).setType("org.eclipse.fordiac.ide.model.typeLibrary")));
    }

    private static void deleteTypeLibraryMarkers(IResource resource) {
        FordiacMarkerHelper.updateMarkers(resource, "org.eclipse.fordiac.ide.model.typeLibrary", Collections.emptyList(), true);
    }

    void setProject(IProject newProject) {
        this.project = newProject;
        this.reload();
    }
}

