/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.validation;

import java.text.MessageFormat;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.Messages;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.EventType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.datatype.helper.TypeDeclarationParser;
import org.eclipse.fordiac.ide.model.helpers.ArraySizeHelper;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerFBNElement;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.EventTypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.errormessages.ErrorMessenger;

public final class LinkConstraints {
    public static boolean canCreateDataConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        return LinkConstraints.canExistDataConnection(source, target, parent, null);
    }

    public static boolean canExistDataConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent, Connection con) {
        VarDeclaration sourceData;
        VarDeclaration targetData;
        if (!LinkConstraints.isDataPin(source) || !LinkConstraints.isDataPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (!LinkConstraints.sourceAndDestCheck(source, target, parent)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (target instanceof VarDeclaration && (targetData = (VarDeclaration)target).isInOutVar() && source instanceof VarDeclaration && !(sourceData = (VarDeclaration)source).isInOutVar()) {
            ErrorMessenger.popUpErrorMessage((String)Messages.ConnectionValidator_OutputsCannotBeConnectedToVarInOuts);
            return false;
        }
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck(source, target, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, target.getName()));
            return false;
        }
        if (!LinkConstraints.typeCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, source.getFullTypeName() != null ? source.getFullTypeName() : FordiacMessages.NA, target.getFullTypeName() != null ? target.getFullTypeName() : FordiacMessages.NA));
            return false;
        }
        return LinkConstraints.isWithConstraintOK(source) && LinkConstraints.isWithConstraintOK(target);
    }

    public static boolean isWithConstraintOK(IInterfaceElement varDecl) {
        if (!(varDecl instanceof ErrorMarkerInterface) && ((VarDeclaration)varDecl).getWiths().isEmpty()) {
            EObject obj;
            if (varDecl.eContainer() != null && ((obj = varDecl.eContainer().eContainer()) instanceof CompositeFBType || obj instanceof SubApp || obj instanceof ErrorMarkerFBNElement)) {
                return true;
            }
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_ERROR_NotConnectedToAnEventByAWithConstruct, varDecl.getName()));
            return false;
        }
        return true;
    }

    public static boolean hasAlreadyOutputConnectionsCheck(IInterfaceElement source, Connection con) {
        return source.getOutputConnections().stream().anyMatch(connection2 -> !connection2.equals(con));
    }

    public static boolean typeCheck(IInterfaceElement source, IInterfaceElement target) {
        VarDeclaration sourceVar;
        DataType sourceType = LinkConstraints.getFullDataType(source);
        DataType targetType = LinkConstraints.getFullDataType(target);
        if (source instanceof VarDeclaration && (sourceVar = (VarDeclaration)source).isInOutVar()) {
            return targetType.isAssignableFrom(sourceType) || sourceType.isAssignableFrom(targetType);
        }
        if (source instanceof AdapterDeclaration) {
            AdapterDeclaration sourceAdapter = (AdapterDeclaration)source;
            if (target instanceof AdapterDeclaration) {
                AdapterDeclaration targetAdapter = (AdapterDeclaration)target;
                return LinkConstraints.adapaterTypeCompatibilityCheck(sourceAdapter.getType(), targetAdapter.getType());
            }
        }
        if ((IecTypes.GenericTypes.isAnyType(sourceType) || EventTypeLibrary.isGenericEventType(sourceType)) && sourceType.isAssignableFrom(targetType)) {
            return true;
        }
        return targetType.isAssignableFrom(sourceType);
    }

    public static DataType getFullDataType(IInterfaceElement element) {
        VarDeclaration varDeclaration;
        if (element instanceof VarDeclaration && (varDeclaration = (VarDeclaration)element).isArray()) {
            return TypeDeclarationParser.parseTypeDeclaration(varDeclaration.getType(), ArraySizeHelper.getArraySize(varDeclaration));
        }
        return element.getType();
    }

    public static boolean hasAlreadyInputConnectionsCheck(IInterfaceElement src, IInterfaceElement target, Connection con) {
        if (!target.getInputConnections().isEmpty()) {
            FBNetwork fbNetworkTarget = LinkConstraints.getContainingFBNetwork(target);
            FBNetwork fbNetworkSrc = LinkConstraints.getContainingFBNetwork(src);
            if (fbNetworkTarget != null && fbNetworkTarget != fbNetworkSrc) {
                return target.getInputConnections().stream().noneMatch(connection2 -> !connection2.isBrokenConnection() && !connection2.equals(con));
            }
            return target.getInputConnections().stream().noneMatch(connection2 -> !connection2.equals(con));
        }
        return true;
    }

    public static boolean isSwapNeeded(IInterfaceElement source, FBNetwork parent) {
        if (source.eContainer() != null && source.eContainer().eContainer() instanceof CompositeFBType || source.getFBNetworkElement() != null && source.getFBNetworkElement().getFbNetwork() != parent) {
            return !source.isIsInput();
        }
        return source.isIsInput();
    }

    private static FBNetwork getContainingFBNetwork(IInterfaceElement target) {
        EObject eObject;
        if (target.eContainer() != null && target.eContainer().eContainer() != null && (eObject = target.eContainer().eContainer().eContainer()) instanceof FBNetwork) {
            FBNetwork fbNetwork = (FBNetwork)eObject;
            return fbNetwork;
        }
        return null;
    }

    public static boolean sourceAndDestCheck(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        return LinkConstraints.isValidConnSource(source, parent) && LinkConstraints.isValidConnDestination(target, parent);
    }

    public static boolean isValidConnSource(IInterfaceElement source, FBNetwork parent) {
        EObject sourceCont = source.eContainer().eContainer();
        if (!source.isIsInput()) {
            return sourceCont != null && parent == sourceCont.eContainer();
        }
        return LinkConstraints.isTypeContainer(sourceCont) || LinkConstraints.isInsideSubapp(sourceCont, parent);
    }

    public static boolean isValidConnDestination(IInterfaceElement dst, FBNetwork parent) {
        EObject dstCont = dst.eContainer().eContainer();
        if (dst.isIsInput()) {
            return dstCont != null && parent == dstCont.eContainer();
        }
        return LinkConstraints.isTypeContainer(dstCont) || LinkConstraints.isInsideSubapp(dstCont, parent);
    }

    private static boolean isTypeContainer(EObject cont) {
        return cont instanceof SubAppType || cont instanceof CompositeFBType;
    }

    private static boolean isInsideSubapp(EObject cont, FBNetwork parent) {
        SubApp subApp;
        return cont instanceof SubApp && (subApp = (SubApp)cont).getSubAppNetwork() == parent;
    }

    public static boolean canExistEventConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        if (!LinkConstraints.isEventPin(source) || !LinkConstraints.isEventPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (LinkConstraints.duplicateConnection(source, target)) {
            return false;
        }
        return LinkConstraints.sourceAndDestCheck(source, target, parent);
    }

    public static boolean duplicateConnection(IInterfaceElement source, IInterfaceElement destination) {
        for (Connection con : source.getOutputConnections()) {
            if (con.getDestination() != destination) continue;
            return true;
        }
        return false;
    }

    private static boolean isEventPin(IInterfaceElement pin) {
        return pin != null && pin.getType() instanceof EventType;
    }

    public static boolean isDataPin(IInterfaceElement pin) {
        return pin != null && !(pin.getType() instanceof EventType) && !(pin.getType() instanceof AdapterType);
    }

    private static boolean isAdapterPin(IInterfaceElement pin) {
        return pin != null && pin.getType() instanceof AdapterType;
    }

    public static boolean canExistAdapterConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent, Connection con) {
        if (!LinkConstraints.isAdapterPin(source) || !LinkConstraints.isAdapterPin(target)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_ConnectingIncompatibleInterfaceTypes);
            return false;
        }
        if (LinkConstraints.isSwapNeeded(source, parent)) {
            IInterfaceElement temp = source;
            source = target;
            target = temp;
        }
        if (!LinkConstraints.sourceAndDestCheck(source, target, parent)) {
            ErrorMessenger.popUpErrorMessage((String)Messages.LinkConstraints_STATUSMessage_IN_IN_OUT_OUT_notAllowed);
            return false;
        }
        if (!LinkConstraints.hasAlreadyInputConnectionsCheck(source, target, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyInputConnection, target.getName()));
            return false;
        }
        if (LinkConstraints.hasAlreadyOutputConnectionsCheck(source, con)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_hasAlreadyOutputConnection, source.getName()));
            return false;
        }
        if (!LinkConstraints.adapaterTypeCompatibilityCheck(source, target)) {
            ErrorMessenger.popUpErrorMessage((String)MessageFormat.format(Messages.LinkConstraints_STATUSMessage_NotCompatible, source.getType() != null ? source.getType().getName() : FordiacMessages.ND, target.getType() != null ? target.getType().getName() : FordiacMessages.ND));
            return false;
        }
        return true;
    }

    public static boolean canCreateAdapterConnection(IInterfaceElement source, IInterfaceElement target, FBNetwork parent) {
        return LinkConstraints.canExistAdapterConnection(source, target, parent, null);
    }

    public static boolean adapaterTypeCompatibilityCheck(IInterfaceElement source, IInterfaceElement target) {
        if (source instanceof AdapterDeclaration) {
            AdapterDeclaration sourceAdapter = (AdapterDeclaration)source;
            if (target instanceof AdapterDeclaration) {
                AdapterDeclaration targetAdapter = (AdapterDeclaration)target;
                return LinkConstraints.adapaterTypeCompatibilityCheck(sourceAdapter.getType(), targetAdapter.getType());
            }
        }
        return false;
    }

    public static boolean adapaterTypeCompatibilityCheck(AdapterType source, AdapterType target) {
        return source != null && source.getName().equalsIgnoreCase(target.getName()) || LinkConstraints.isAnyAdapter(source) ^ LinkConstraints.isAnyAdapter(target);
    }

    public static boolean isAnyAdapter(AdapterType type) {
        return type != null && "ANY_ADAPTER".equals(type.getName());
    }

    private LinkConstraints() {
        throw new UnsupportedOperationException(Messages.LinkConstraints_ClassLinkconstraintsShouldNotBeCreated);
    }
}

