/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.ui.editors;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.RangeModel;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.fordiac.ide.model.ui.preferences.IGraphicalPreferencesCache;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.graphics.Rectangle;

public class AdvancedScrollingGraphicalViewer
extends ScrollingGraphicalViewer {
    private final IGraphicalPreferencesCache cache;

    public AdvancedScrollingGraphicalViewer(IGraphicalPreferencesCache cache) {
        this.cache = cache;
    }

    public void reveal(EditPart part) {
    }

    public void revealEditPart(EditPart part) {
        if (!(part instanceof ConnectionEditPart)) {
            super.reveal(part);
            if (part instanceof GraphicalEditPart) {
                GraphicalEditPart graphicalEP = (GraphicalEditPart)part;
                this.centerPartPositionInViewport(graphicalEP);
            }
        }
    }

    private void centerPartPositionInViewport(GraphicalEditPart part) {
        org.eclipse.draw2d.geometry.Rectangle visibleArea = this.getFigureCanvas().getViewport().getBounds();
        Point currentCenter = new Point(this.getViewLocation().x + visibleArea.width / 2, this.getViewLocation().y + visibleArea.height / 2);
        Point partCenter = this.getTranslatedPartCenter(part.getFigure());
        int dx = currentCenter.x - partCenter.x;
        int dy = currentCenter.y - partCenter.y;
        this.getFigureCanvas().scrollTo(this.getViewLocation().x - dx, this.getViewLocation().y - dy);
    }

    private Point getTranslatedPartCenter(IFigure partFigure) {
        org.eclipse.draw2d.geometry.Rectangle partExtent = this.translateBoundsToRoute(partFigure);
        return new Point(partExtent.x + partExtent.width / 2, partExtent.y + partExtent.height / 2);
    }

    public org.eclipse.draw2d.geometry.Rectangle translateBoundsToRoute(IFigure partFigure) {
        Viewport viewPort = this.getFigureCanvas().getViewport();
        org.eclipse.draw2d.geometry.Rectangle partExtent = partFigure.getBounds().getCopy();
        IFigure runner = partFigure.getParent();
        while (runner != null && runner != viewPort) {
            runner.translateToParent((Translatable)partExtent);
            runner = runner.getParent();
        }
        return partExtent;
    }

    public void selectAndRevealEditPart(EditPart part) {
        this.select(part);
        this.revealEditPart(part);
    }

    public void checkScrollPositionDuringDrag(MouseEvent me) {
        Rectangle controlBounds = this.getControl().getBounds();
        Point relativePos = new Point(me.x + controlBounds.x, me.y + controlBounds.y);
        if (!controlBounds.contains(relativePos.x, relativePos.y)) {
            Point newLocation = this.getNewScrollPosition(relativePos);
            this.getFigureCanvas().scrollSmoothTo(newLocation.x, newLocation.y);
        }
    }

    public void checkScrollPositionDuringDragBounded(MouseEvent me, Point border) {
        this.checkScrollPositionDuringDrag(me);
        me.x = AdvancedScrollingGraphicalViewer.boundCoordinate(me.x, border.x, this.getFigureCanvas().getViewport().getHorizontalRangeModel());
        me.y = AdvancedScrollingGraphicalViewer.boundCoordinate(me.y, border.y, this.getFigureCanvas().getViewport().getVerticalRangeModel());
    }

    private static int boundCoordinate(int mousePos, int border, RangeModel rangeModel) {
        int retVal = mousePos;
        int min = rangeModel.getMinimum() - rangeModel.getValue();
        int max = rangeModel.getMaximum() - rangeModel.getMinimum() - rangeModel.getValue();
        if (retVal < min) {
            retVal = min + border;
        } else if (retVal > max) {
            retVal = max - border;
        }
        return retVal;
    }

    private Point getNewScrollPosition(Point pos) {
        Point newLocation = this.getViewLocation();
        newLocation.x += AdvancedScrollingGraphicalViewer.getScrollDelta(pos.x, this.getControl().getBounds().x, this.getControl().getBounds().width);
        newLocation.y += AdvancedScrollingGraphicalViewer.getScrollDelta(pos.y, this.getControl().getBounds().y, this.getControl().getBounds().height);
        return newLocation;
    }

    public Point getViewLocation() {
        return this.getFigureCanvas().getViewport().getViewLocation();
    }

    private static int getScrollDelta(int mousePos, int controlPos, int length) {
        if (mousePos < controlPos) {
            return mousePos - controlPos;
        }
        if (controlPos + length < mousePos) {
            return mousePos - (controlPos + length);
        }
        return 0;
    }

    public void scrollByOffset(int dx, int dy) {
        Point location = this.getViewLocation();
        this.getFigureCanvas().scrollSmoothTo(location.x + dx, location.y + dy);
    }

    public org.eclipse.swt.graphics.Point getFigureCanvasSize() {
        return this.getFigureCanvas().getSize();
    }

    public IGraphicalPreferencesCache getPreferencesCache() {
        return this.cache;
    }
}

