/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.ui.preferences;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ProjectScope;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.fordiac.ide.ui.preferences.FixedScopedPreferenceStore;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public class PreferenceStoreProvider {
    public static final String PROJECT_STORE_ACTIVE = "ProjectStoreActive";
    private final IPreferenceStore instanceStore;
    private final IPreferenceStore projectStore;

    public PreferenceStoreProvider(String qualifier, IProject project) {
        this.instanceStore = new FixedScopedPreferenceStore(InstanceScope.INSTANCE, qualifier);
        this.projectStore = project != null ? new FixedScopedPreferenceStore((IScopeContext)new ProjectScope(project), qualifier) : null;
    }

    public IPreferenceStore getStore() {
        if (this.isProjectStoreActive()) {
            return this.projectStore;
        }
        return this.instanceStore;
    }

    public IPreferenceStore getInstanceStore() {
        return this.instanceStore;
    }

    public IPreferenceStore getProjectStore() {
        return this.projectStore;
    }

    public boolean isProjectStoreActive() {
        return this.projectStore != null && this.projectStore.getBoolean(PROJECT_STORE_ACTIVE);
    }

    public void setProjectStoreActive(boolean active) {
        if (this.projectStore != null) {
            this.projectStore.setValue(PROJECT_STORE_ACTIVE, active);
        }
    }

    public void addPropertyChangeListener(IPropertyChangeListener listener) {
        this.instanceStore.addPropertyChangeListener(listener);
        if (this.projectStore != null) {
            this.projectStore.addPropertyChangeListener(listener);
        }
    }

    public void removePropertyChangeListener(IPropertyChangeListener listener) {
        this.instanceStore.removePropertyChangeListener(listener);
        if (this.projectStore != null) {
            this.projectStore.removePropertyChangeListener(listener);
        }
    }

    public static IPreferenceStore getStore(String qualifier, IProject project) {
        FixedScopedPreferenceStore projectScope = new FixedScopedPreferenceStore((IScopeContext)new ProjectScope(project), qualifier);
        if (projectScope.getBoolean(PROJECT_STORE_ACTIVE)) {
            return projectScope;
        }
        return new FixedScopedPreferenceStore(InstanceScope.INSTANCE, qualifier);
    }

    public static IPreferenceStore getStoreFromContext(String qualifier, EObject context) {
        Resource resource = context.eResource();
        if (resource != null) {
            return PreferenceStoreProvider.getStoreFromURI(qualifier, resource.getURI());
        }
        return null;
    }

    public static IPreferenceStore getStoreFromURI(String qualifier, URI uri) {
        if (uri != null) {
            IFile file;
            if (uri.isPlatformResource()) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            } else if (uri.isFile() && uri.segmentCount() >= 2) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toFileString()));
            } else {
                return null;
            }
            if (file.getProject() != null) {
                return PreferenceStoreProvider.getStore(qualifier, file.getProject());
            }
        }
        return null;
    }
}

