/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.typemanagement.commands;

import java.util.Collection;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.search.ISearchFactory;
import org.eclipse.fordiac.ide.model.search.ISearchSupport;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.gef.commands.Command;

public class OrganizeImportsCommand
extends Command
implements ScopedCommand {
    private final LibraryElement libraryElement;
    private EList<Import> oldImports;
    private EList<Import> newImports;
    private boolean incompleteResult;

    public OrganizeImportsCommand(LibraryElement libraryElement) {
        this.libraryElement = Objects.requireNonNull(libraryElement);
    }

    public void execute() {
        this.oldImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        try {
            try {
                Set<String> importedNamespaces = this.getAllImportedNamespaces((EObject)this.libraryElement);
                ImportHelper.organizeImports((LibraryElement)this.libraryElement, importedNamespaces, (!this.incompleteResult ? 1 : 0) != 0);
            }
            catch (Exception e) {
                FordiacLogHelper.logError((String)"Error organizing imports", (Throwable)e);
                this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
            }
        }
        finally {
            this.newImports = ECollections.newBasicEList((Iterable)ImportHelper.getImports((LibraryElement)this.libraryElement));
        }
    }

    private Set<String> getAllImportedNamespaces(EObject object) {
        return StreamSupport.stream(Spliterators.spliteratorUnknownSize(object.eAllContents(), 0), false).map(this::getImportedNamespaces).flatMap(Collection::stream).collect(Collectors.toSet());
    }

    private Set<String> getImportedNamespaces(EObject object) {
        ISearchSupport support = ISearchFactory.createSearchSupport((Object)object, (Class)object.eClass().getInstanceClass());
        if (support != null) {
            Set dependencies = support.getImportedNamespaces();
            this.incompleteResult |= support.isIncompleteResult();
            return dependencies;
        }
        return Set.of();
    }

    public void redo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.newImports);
    }

    public void undo() {
        ECollections.setEList((EList)ImportHelper.getMutableImports((LibraryElement)this.libraryElement), this.oldImports);
    }

    public Set<EObject> getAffectedObjects() {
        return Set.of(this.libraryElement);
    }
}

