/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.fb;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationAttributes;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.ui.MainLaunchConfigurationTab;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.debug.ui.widgets.DebugClockWidget;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.BasicFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.FunctionFBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.SimpleFBType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.ComboViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;

public class FBLaunchConfigurationTab
extends MainLaunchConfigurationTab {
    private ComboViewer eventCombo;
    private Button repeatEventCheckbox;
    private Button keepDebuggerRunningCheckbox;
    private final DebugClockWidget clockWidget = new DebugClockWidget(() -> ((FBLaunchConfigurationTab)this).updateLaunchConfigurationDialog());

    @Override
    public void createControl(Composite parent) {
        super.createControl(parent);
        Composite comp = (Composite)this.getControl();
        Composite eventComponent = this.createEventComponent(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)eventComponent);
        Composite argumentsComponent = this.createArgumentsComponent(comp);
        GridDataFactory.fillDefaults().grab(true, true).applyTo((Control)argumentsComponent);
        Composite clockComponent = this.clockWidget.createControl(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)clockComponent);
    }

    @Override
    protected Composite createOptionsComponent(Composite parent) {
        Group group = (Group)super.createOptionsComponent(parent);
        Composite comp = (Composite)group.getChildren()[0];
        this.repeatEventCheckbox = new Button(comp, 32);
        this.repeatEventCheckbox.setText(Messages.FBLaunchConfigurationTab_RepeatEvent);
        this.repeatEventCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        GridDataFactory.fillDefaults().applyTo((Control)this.repeatEventCheckbox);
        this.keepDebuggerRunningCheckbox = new Button(comp, 32);
        this.keepDebuggerRunningCheckbox.setText(Messages.FBLaunchConfigurationTab_KeepDebuggerRunningWhenIdle);
        this.keepDebuggerRunningCheckbox.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.updateLaunchConfigurationDialog()));
        GridDataFactory.fillDefaults().applyTo((Control)this.keepDebuggerRunningCheckbox);
        return group;
    }

    protected Composite createEventComponent(Composite parent) {
        Group group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().applyTo((Composite)group);
        group.setText(Messages.FBLaunchConfigurationTab_Event);
        Composite comp = new Composite((Composite)group, 0);
        GridLayoutFactory.swtDefaults().numColumns(1).applyTo(comp);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)comp);
        this.eventCombo = new ComboViewer(comp, 12);
        this.eventCombo.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.eventCombo.setLabelProvider((IBaseLabelProvider)new EventsLabelProvider());
        this.eventCombo.addSelectionChangedListener(e -> this.updateLaunchConfigurationDialog());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.eventCombo.getCombo());
        return group;
    }

    @Override
    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        super.setDefaults(configuration);
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.event");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.repeatEvent");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.keepRunningWhenIdle");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.clockMode");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.clockInterval");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.clockRealtimeOffset");
        configuration.removeAttribute("org.eclipse.fordiac.ide.debug.clockMonotonicOffset");
    }

    @Override
    public void initializeFrom(ILaunchConfiguration configuration) {
        super.initializeFrom(configuration);
        try {
            FBType fbType = this.getFBType();
            List<Event> events = FBLaunchConfigurationTab.getInputEvents(fbType);
            this.eventCombo.setInput(events);
            if (!events.isEmpty()) {
                Event event = FBLaunchConfigurationAttributes.getEvent((ILaunchConfiguration)configuration, (FBType)fbType, (Event)events.get(0));
                this.eventCombo.setSelection((ISelection)new StructuredSelection((Object)event), true);
            }
            this.repeatEventCheckbox.setSelection(FBLaunchConfigurationAttributes.isRepeatEvent((ILaunchConfiguration)configuration));
            this.keepDebuggerRunningCheckbox.setSelection(FBLaunchConfigurationAttributes.isKeepRunningWhenIdle((ILaunchConfiguration)configuration));
            this.clockWidget.setSelectedClockMode(FBLaunchConfigurationAttributes.getClockMode((ILaunchConfiguration)configuration));
            this.clockWidget.setClockIntervalText(FBLaunchConfigurationAttributes.getClockIntervalText((ILaunchConfiguration)configuration));
            this.clockWidget.setRealtimeClockText(FBLaunchConfigurationAttributes.getClockRealtimeOffsetText((ILaunchConfiguration)configuration));
            this.clockWidget.setMonotonicClockText(FBLaunchConfigurationAttributes.getClockMonotonicOffsetText((ILaunchConfiguration)configuration));
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        this.initializeArgumentsFrom(configuration);
    }

    @Override
    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        super.performApply(configuration);
        Event event = (Event)this.eventCombo.getStructuredSelection().getFirstElement();
        if (event != null) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.event", FBLaunchConfigurationTab.getEventName(event));
        } else {
            configuration.removeAttribute("org.eclipse.fordiac.ide.debug.event");
        }
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.repeatEvent", this.repeatEventCheckbox.getSelection());
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.keepRunningWhenIdle", this.keepDebuggerRunningCheckbox.getSelection());
        FBDebugClockMode clockMode = this.clockWidget.getSelectedClockMode();
        configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockMode", clockMode.toString());
        if (clockMode == FBDebugClockMode.INTERVAL) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockInterval", this.clockWidget.getClockIntervalText());
        }
        if (clockMode == FBDebugClockMode.INTERVAL || clockMode == FBDebugClockMode.FIXED) {
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockRealtimeOffset", this.clockWidget.getRealtimeClockText());
            configuration.setAttribute("org.eclipse.fordiac.ide.debug.clockMonotonicOffset", this.clockWidget.getMonotonicClockText());
        }
    }

    @Override
    protected void handleResourceUpdated() {
        FBType fbType = this.getFBType();
        Event oldEvent = (Event)this.eventCombo.getStructuredSelection().getFirstElement();
        List<Event> events = FBLaunchConfigurationTab.getInputEvents(fbType);
        this.eventCombo.setInput(events);
        if (!events.isEmpty()) {
            Event event = oldEvent != null ? events.stream().filter(e -> e.getName().equals(oldEvent.getName())).findFirst().orElse(events.get(0)) : events.get(0);
            this.eventCombo.setSelection((ISelection)new StructuredSelection((Object)event), true);
        }
        this.updateArguments();
        super.handleResourceUpdated();
    }

    protected static List<Event> getInputEvents(FBType fbType) {
        ArrayList<Event> result = new ArrayList<Event>();
        if (fbType != null) {
            result.addAll((Collection<Event>)fbType.getInterfaceList().getEventInputs());
            Stream.concat(fbType.getInterfaceList().getSockets().stream(), fbType.getInterfaceList().getPlugs().stream()).map(AdapterDeclaration::getAdapterFB).map(FBNetworkElement::getInterface).map(InterfaceList::getEventOutputs).forEachOrdered(result::addAll);
        }
        return result;
    }

    @Override
    protected List<Variable<?>> getDefaultArguments() throws CoreException {
        FBType fbType = this.getFBType();
        if (fbType != null) {
            return FBLaunchConfigurationDelegate.getDefaultArguments((FBType)fbType);
        }
        return Collections.emptyList();
    }

    @Override
    protected boolean filterTargetResource(IResource resource) throws CoreException {
        if (resource instanceof IFile) {
            LibraryElement libraryElement;
            TypeEntry typeEntry;
            IFile file = (IFile)resource;
            if (resource.getFileExtension() != null && resource.getFileExtension().equalsIgnoreCase("FBT") && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file)) != null && (libraryElement = typeEntry.getType()) instanceof FBType) {
                FBType fbType = (FBType)libraryElement;
                return this.filterTargetFBType(fbType);
            }
        }
        return super.filterTargetResource(resource);
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        Optional<String> clockValid = this.clockWidget.validate();
        this.setErrorMessage(clockValid.orElse(null));
        return clockValid.isEmpty();
    }

    protected boolean filterTargetFBType(FBType fbType) {
        return fbType instanceof BasicFBType || fbType instanceof FunctionFBType || fbType instanceof SimpleFBType;
    }

    protected FBType getFBType() {
        LibraryElement libraryElement;
        IFile file;
        TypeEntry typeEntry;
        IResource resource = this.getResource();
        if (resource instanceof IFile && (typeEntry = TypeLibraryManager.INSTANCE.getTypeEntryForFile(file = (IFile)resource)) != null && (libraryElement = typeEntry.getType()) instanceof FBType) {
            FBType fbType = (FBType)libraryElement;
            return fbType;
        }
        return null;
    }

    protected static String getEventName(Event event) {
        if (event.getFBNetworkElement() instanceof AdapterFB) {
            return event.getFBNetworkElement().getName() + "." + event.getName();
        }
        return event.getName();
    }

    private static class EventsLabelProvider
    extends LabelProvider {
        private EventsLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof Event) {
                Event event = (Event)element;
                return FBLaunchConfigurationTab.getEventName(event);
            }
            return super.getText(element);
        }
    }
}

