/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.view;

import java.lang.runtime.SwitchBootstraps;
import java.time.Clock;
import java.time.Duration;
import java.time.Instant;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.eclipse.fordiac.ide.debug.EvaluatorProcess;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.fb.FBLaunchConfigurationDelegate;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.debug.ui.widgets.DebugClockWidget;
import org.eclipse.fordiac.ide.model.eval.AbstractEvaluator;
import org.eclipse.fordiac.ide.model.eval.Evaluator;
import org.eclipse.fordiac.ide.model.eval.EvaluatorMonitor;
import org.eclipse.fordiac.ide.model.eval.EvaluatorThreadPoolExecutor;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluator;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorCountingEventQueue;
import org.eclipse.fordiac.ide.model.eval.fb.FBEvaluatorEventQueue;
import org.eclipse.fordiac.ide.model.eval.variable.Variable;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public class FBDebugViewClockWidget
extends DebugClockWidget {
    private EvaluatorProcess process;
    private boolean dirty;
    private boolean refreshing;
    private Button applyButton;
    private final EvaluatorMonitor evaluatorMonitor = new EvaluatorMonitor.NullEvaluatorMonitor(){

        public void update(Collection<? extends Variable<?>> variables, Evaluator evaluator) {
            if (FBDebugViewClockWidget.this.process != null && evaluator == FBDebugViewClockWidget.this.process.getEvaluator() && !FBDebugViewClockWidget.this.refreshing) {
                FBDebugViewClockWidget.this.refreshing = true;
                Display.getDefault().asyncExec(FBDebugViewClockWidget.this::refresh);
            }
        }

        public void terminated(EvaluatorThreadPoolExecutor executor) {
            Display.getDefault().asyncExec(FBDebugViewClockWidget.this::refresh);
        }
    };

    @Override
    public Composite createControl(Composite parent) {
        Composite composite = super.createControl(parent);
        this.applyButton = new Button(composite, 8);
        this.applyButton.setText(Messages.FBDebugViewClockWidget_Apply);
        this.applyButton.setEnabled(false);
        this.applyButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.performApply()));
        GridDataFactory.swtDefaults().applyTo((Control)this.applyButton);
        return composite;
    }

    private void performApply() {
        if (this.process == null || this.process.isTerminated()) {
            return;
        }
        Optional<String> error = this.validate();
        if (error.isPresent()) {
            MessageDialog.openError((Shell)this.getControl().getShell(), (String)Messages.FBDebugViewClockWidget_InvalidValues, (String)error.get());
            return;
        }
        FBDebugClockMode clockMode = this.getSelectedClockMode();
        Duration clockInterval = this.getClockInterval();
        FBEvaluatorCountingEventQueue eventQueue = this.getEventQueue();
        this.process.getExecutor().setRealtimeClock(FBLaunchConfigurationDelegate.createClock((FBDebugClockMode)clockMode, (Instant)this.getRealtimeClockValue(), (Duration)clockInterval, (FBEvaluatorCountingEventQueue)eventQueue));
        this.process.getExecutor().setMonotonicClock(FBLaunchConfigurationDelegate.createClock((FBDebugClockMode)clockMode, (Instant)this.getMonotonicClockValue(), (Duration)clockInterval, (FBEvaluatorCountingEventQueue)eventQueue));
        this.setDirty(false);
    }

    public void refresh() {
        this.refresh(false);
    }

    public void refresh(boolean force) {
        if (this.process != null && (force || !this.isDirty())) {
            Clock realtimeClock = this.process.getExecutor().getRealtimeClock();
            Clock monotonicClock = this.process.getExecutor().getMonotonicClock();
            this.setRealtimeClockValue(realtimeClock.instant());
            this.setMonotonicClockValue(monotonicClock.instant());
            Clock clock = monotonicClock;
            Objects.requireNonNull(clock);
            Clock clock2 = clock;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{AbstractEvaluator.MonotonicClock.class, AbstractEvaluator.IntervalClock.class}, (Object)clock2, n)) {
                case 0: {
                    AbstractEvaluator.MonotonicClock unused = (AbstractEvaluator.MonotonicClock)clock2;
                    this.setSelectedClockMode(FBDebugClockMode.SYSTEM);
                    break;
                }
                case 1: {
                    AbstractEvaluator.IntervalClock intervalClock = (AbstractEvaluator.IntervalClock)clock2;
                    this.setClockInterval(intervalClock.getInterval());
                    this.setSelectedClockMode(FBDebugClockMode.INTERVAL);
                    break;
                }
                default: {
                    this.setSelectedClockMode(FBDebugClockMode.FIXED);
                }
            }
            this.setDirty(false);
        }
        this.refreshing = false;
    }

    protected FBEvaluatorCountingEventQueue getEventQueue() {
        FBEvaluatorCountingEventQueue queue;
        FBEvaluator evaluator;
        FBEvaluatorEventQueue fBEvaluatorEventQueue;
        Evaluator evaluator2;
        return this.process != null && (evaluator2 = this.process.getEvaluator()) instanceof FBEvaluator && (fBEvaluatorEventQueue = (evaluator = (FBEvaluator)evaluator2).getEventQueue()) instanceof FBEvaluatorCountingEventQueue ? (queue = (FBEvaluatorCountingEventQueue)fBEvaluatorEventQueue) : null;
    }

    @Override
    protected void handleClockUpdated() {
        this.setDirty(true);
        super.handleClockUpdated();
    }

    public EvaluatorProcess getProcess() {
        return this.process;
    }

    public void setProcess(EvaluatorProcess process) {
        if (this.process != null) {
            this.process.getExecutor().removeMonitor(this.evaluatorMonitor);
        }
        this.process = process;
        if (this.process != null) {
            this.process.getExecutor().addMonitor(this.evaluatorMonitor);
        }
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.applyButton.setEnabled(dirty);
    }
}

