/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.ui.widgets;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.time.Duration;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.Optional;
import java.util.stream.Stream;
import org.eclipse.fordiac.ide.debug.fb.FBDebugClockMode;
import org.eclipse.fordiac.ide.debug.ui.Messages;
import org.eclipse.fordiac.ide.model.value.DateAndTimeValueConverter;
import org.eclipse.fordiac.ide.model.value.TimeValueConverter;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Text;

public class DebugClockWidget {
    private Group group;
    private Button systemClockRadio;
    private Button intervalClockRadio;
    private Button fixedClockRadio;
    private Text clockIntervalText;
    private Text realtimeClockText;
    private Text monotonicClockText;
    private Runnable updateRunnable;
    private static volatile /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$fordiac$ide$debug$fb$FBDebugClockMode;

    public DebugClockWidget() {
    }

    public DebugClockWidget(Runnable updateRunnable) {
        this.updateRunnable = updateRunnable;
    }

    public Composite createControl(Composite parent) {
        this.group = new Group(parent, 2048);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo((Composite)this.group);
        this.group.setText(Messages.DebugClockWidget_Title);
        Composite clockModes = new Composite((Composite)this.group, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(clockModes);
        GridDataFactory.fillDefaults().grab(true, false).span(2, 1).applyTo((Control)clockModes);
        this.systemClockRadio = new Button(clockModes, 16);
        this.systemClockRadio.setText(Messages.DebugClockWidget_SystemClock);
        this.systemClockRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleClockModeUpdated()));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.systemClockRadio);
        this.intervalClockRadio = new Button(clockModes, 16);
        this.intervalClockRadio.setText(Messages.DebugClockWidget_IntervalClock);
        this.intervalClockRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleClockModeUpdated()));
        GridDataFactory.swtDefaults().applyTo((Control)this.intervalClockRadio);
        Composite clockIntervalComposite = this.createClockIntervalComposite(clockModes);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)clockIntervalComposite);
        this.fixedClockRadio = new Button(clockModes, 16);
        this.fixedClockRadio.setText(Messages.DebugClockWidget_FixedClock);
        this.fixedClockRadio.addSelectionListener(SelectionListener.widgetSelectedAdapter(e -> this.handleClockModeUpdated()));
        GridDataFactory.fillDefaults().span(2, 1).applyTo((Control)this.fixedClockRadio);
        Label realtimeClockLabel = new Label((Composite)this.group, 0);
        realtimeClockLabel.setText(Messages.DebugClockWidget_RealtimeClock);
        GridDataFactory.swtDefaults().applyTo((Control)realtimeClockLabel);
        Composite realtimeClockTextComposite = this.createRealtimeClockTextComposite((Composite)this.group);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)realtimeClockTextComposite);
        Label monotonicClockLabel = new Label((Composite)this.group, 0);
        monotonicClockLabel.setText(Messages.DebugClockWidget_MonotonicClock);
        GridDataFactory.swtDefaults().applyTo((Control)monotonicClockLabel);
        Composite monotonicClockTextComposite = this.createMonotonicClockTextComposite((Composite)this.group);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)monotonicClockTextComposite);
        return this.group;
    }

    public Composite createClockIntervalComposite(Composite parent) {
        Composite clockIntervalComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(clockIntervalComposite);
        Label clockIntervalTextLabel = new Label(clockIntervalComposite, 0);
        clockIntervalTextLabel.setText(Messages.DebugClockWidget_ClockIntervalTextLabel);
        GridDataFactory.swtDefaults().applyTo((Control)clockIntervalTextLabel);
        this.clockIntervalText = new Text(clockIntervalComposite, 2048);
        this.clockIntervalText.setEditable(false);
        this.clockIntervalText.addModifyListener(e -> this.handleClockUpdated());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.clockIntervalText);
        return clockIntervalComposite;
    }

    public Composite createRealtimeClockTextComposite(Composite parent) {
        Composite realtimeClockComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(realtimeClockComposite);
        Label realtimeClockTextLabel = new Label(realtimeClockComposite, 0);
        realtimeClockTextLabel.setText(Messages.DebugClockWidget_RealtimeClockTextLabel);
        GridDataFactory.swtDefaults().applyTo((Control)realtimeClockTextLabel);
        this.realtimeClockText = new Text(realtimeClockComposite, 2048);
        this.realtimeClockText.setEditable(false);
        this.realtimeClockText.addModifyListener(e -> this.handleClockUpdated());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.realtimeClockText);
        return realtimeClockComposite;
    }

    public Composite createMonotonicClockTextComposite(Composite parent) {
        Composite monotonicClockComposite = new Composite(parent, 0);
        GridLayoutFactory.swtDefaults().numColumns(2).applyTo(monotonicClockComposite);
        Label monotonicClockTextLabel = new Label(monotonicClockComposite, 0);
        monotonicClockTextLabel.setText(Messages.DebugClockWidget_MonotonicClockTextLabel);
        GridDataFactory.swtDefaults().applyTo((Control)monotonicClockTextLabel);
        this.monotonicClockText = new Text(monotonicClockComposite, 2048);
        this.monotonicClockText.setEditable(false);
        this.monotonicClockText.addModifyListener(e -> this.handleClockUpdated());
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.monotonicClockText);
        return monotonicClockComposite;
    }

    public FBDebugClockMode getSelectedClockMode() {
        if (this.systemClockRadio.getSelection()) {
            return FBDebugClockMode.SYSTEM;
        }
        if (this.fixedClockRadio.getSelection()) {
            return FBDebugClockMode.FIXED;
        }
        if (this.intervalClockRadio.getSelection()) {
            return FBDebugClockMode.INTERVAL;
        }
        return FBDebugClockMode.SYSTEM;
    }

    public void setSelectedClockMode(FBDebugClockMode clockMode) {
        FBDebugClockMode fBDebugClockMode = clockMode;
        int n = 0;
        Button selected = switch (SwitchBootstraps.enumSwitch("enumSwitch", new Object[]{"SYSTEM", "INTERVAL", "FIXED"}, (FBDebugClockMode)fBDebugClockMode, n)) {
            case 0 -> this.systemClockRadio;
            case 1 -> this.intervalClockRadio;
            case 2 -> this.fixedClockRadio;
            default -> null;
        };
        Stream.of(this.systemClockRadio, this.intervalClockRadio, this.fixedClockRadio).forEach(radio -> radio.setSelection(radio == selected));
        this.clockIntervalText.setEditable(selected == this.intervalClockRadio);
        this.realtimeClockText.setEditable(selected == this.intervalClockRadio || selected == this.fixedClockRadio);
        this.monotonicClockText.setEditable(selected == this.intervalClockRadio || selected == this.fixedClockRadio);
    }

    protected void handleClockModeUpdated() {
        this.clockIntervalText.setEditable(this.intervalClockRadio.getSelection());
        this.realtimeClockText.setEditable(this.intervalClockRadio.getSelection() || this.fixedClockRadio.getSelection());
        this.monotonicClockText.setEditable(this.intervalClockRadio.getSelection() || this.fixedClockRadio.getSelection());
        this.handleClockUpdated();
    }

    protected void handleClockUpdated() {
        if (this.updateRunnable != null) {
            this.updateRunnable.run();
        }
    }

    public Optional<String> validate() {
        FBDebugClockMode clockMode = this.getSelectedClockMode();
        if (clockMode == FBDebugClockMode.INTERVAL) {
            try {
                TimeValueConverter.INSTANCE.toValue(this.getClockIntervalText());
            }
            catch (IllegalArgumentException e) {
                return Optional.of(MessageFormat.format(Messages.DebugClockWidget_InvalidInterval, e.getLocalizedMessage()));
            }
        }
        if (clockMode == FBDebugClockMode.INTERVAL || clockMode == FBDebugClockMode.FIXED) {
            try {
                DateAndTimeValueConverter.INSTANCE.toValue(this.getRealtimeClockText());
            }
            catch (IllegalArgumentException e) {
                return Optional.of(MessageFormat.format(Messages.DebugClockWidget_InvalidRealtimeClockValue, e.getLocalizedMessage()));
            }
            try {
                TimeValueConverter.INSTANCE.toValue(this.getMonotonicClockText());
            }
            catch (IllegalArgumentException e) {
                return Optional.of(MessageFormat.format(Messages.DebugClockWidget_InvalidMonotonicClockValue, e.getLocalizedMessage()));
            }
        }
        return Optional.empty();
    }

    public Group getControl() {
        return this.group;
    }

    public void setControl(Group control) {
        this.group = control;
    }

    public Duration getClockInterval() {
        try {
            return TimeValueConverter.INSTANCE.toValue(this.getClockIntervalText());
        }
        catch (IllegalArgumentException e) {
            return Duration.ZERO;
        }
    }

    public void setClockInterval(Duration value) {
        this.setClockIntervalText(TimeValueConverter.INSTANCE.toString(value));
    }

    public String getClockIntervalText() {
        return this.clockIntervalText.getText();
    }

    public void setClockIntervalText(String value) {
        this.clockIntervalText.setText(value);
    }

    public Instant getRealtimeClockValue() {
        try {
            return DateAndTimeValueConverter.INSTANCE.toValue(this.getRealtimeClockText()).toInstant(ZoneOffset.UTC);
        }
        catch (Exception e) {
            return Instant.EPOCH;
        }
    }

    public void setRealtimeClockValue(Instant value) {
        this.setRealtimeClockText(DateAndTimeValueConverter.INSTANCE.toString(LocalDateTime.ofInstant(value, ZoneOffset.UTC)));
    }

    public String getRealtimeClockText() {
        return this.realtimeClockText.getText();
    }

    public void setRealtimeClockText(String value) {
        this.realtimeClockText.setText(value);
    }

    public Instant getMonotonicClockValue() {
        try {
            Duration value = TimeValueConverter.INSTANCE.toValue(this.getMonotonicClockText());
            return Instant.ofEpochSecond(value.getSeconds(), value.getNano());
        }
        catch (Exception e) {
            return Instant.EPOCH;
        }
    }

    public void setMonotonicClockValue(Instant value) {
        this.setMonotonicClockText(TimeValueConverter.INSTANCE.toString(Duration.ofSeconds(value.getEpochSecond(), value.getNano())));
    }

    public String getMonotonicClockText() {
        return this.monotonicClockText.getText();
    }

    public void setMonotonicClockText(String value) {
        this.monotonicClockText.setText(value);
    }

    public Runnable getUpdateRunnable() {
        return this.updateRunnable;
    }

    public void setUpdateRunnable(Runnable updateRunnable) {
        this.updateRunnable = updateRunnable;
    }

    static /* synthetic */ int[] $SWITCH_TABLE$org$eclipse$fordiac$ide$debug$fb$FBDebugClockMode() {
        if ($SWITCH_TABLE$org$eclipse$fordiac$ide$debug$fb$FBDebugClockMode != null) {
            return $SWITCH_TABLE$org$eclipse$fordiac$ide$debug$fb$FBDebugClockMode;
        }
        int[] nArray = new int[FBDebugClockMode.values().length];
        try {
            nArray[FBDebugClockMode.FIXED.ordinal()] = 3;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FBDebugClockMode.INTERVAL.ordinal()] = 2;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        try {
            nArray[FBDebugClockMode.SYSTEM.ordinal()] = 1;
        }
        catch (NoSuchFieldError noSuchFieldError) {}
        $SWITCH_TABLE$org$eclipse$fordiac$ide$debug$fb$FBDebugClockMode = nArray;
        return nArray;
    }
}

