/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.elk.alg.layered.options.ConstraintCalculationStrategy;
import org.eclipse.elk.alg.layered.options.CrossingMinimizationStrategy;
import org.eclipse.elk.alg.layered.options.CuttingStrategy;
import org.eclipse.elk.alg.layered.options.EdgeStraighteningStrategy;
import org.eclipse.elk.alg.layered.options.FixedAlignment;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.GreedySwitchType;
import org.eclipse.elk.alg.layered.options.LayeredMetaDataProvider;
import org.eclipse.elk.alg.layered.options.LayeringStrategy;
import org.eclipse.elk.alg.layered.options.NodePlacementStrategy;
import org.eclipse.elk.alg.layered.options.NodePromotionStrategy;
import org.eclipse.elk.alg.layered.options.ValidifyStrategy;
import org.eclipse.elk.alg.layered.options.WrappingStrategy;
import org.eclipse.elk.alg.libavoid.options.LibavoidMetaDataProvider;
import org.eclipse.elk.alg.libavoid.server.LibavoidServerException;
import org.eclipse.elk.core.RecursiveGraphLayoutEngine;
import org.eclipse.elk.core.math.ElkPadding;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.util.IElkProgressMonitor;
import org.eclipse.elk.core.util.NullElkProgressMonitor;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.fordiac.ide.application.editors.FBNetworkContextMenuProvider;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.utilities.GetEditPartFromGraficalViewerHelper;
import org.eclipse.fordiac.ide.elk.FordiacGraphBuilder;
import org.eclipse.fordiac.ide.elk.FordiacGraphDataHelper;
import org.eclipse.fordiac.ide.elk.FordiacLayoutMapping;
import org.eclipse.fordiac.ide.elk.Messages;
import org.eclipse.fordiac.ide.elk.commands.BlockLayoutCommand;
import org.eclipse.fordiac.ide.elk.commands.ConnectionLayoutCommand;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CompoundCommand;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;

public class FordiacLayout {
    public static void blockLayout(IEditorPart part, AbstractFBNetworkEditPart ep) {
        FordiacLayout.executeLayout(part, ep, true);
    }

    public static void connectionLayout(IEditorPart part, AbstractFBNetworkEditPart ep) {
        FordiacLayout.executeLayout(part, ep, false);
    }

    public static Command getConnectionLayoutCommand(IEditorPart part) {
        return FordiacLayout.layout(part, FordiacLayout.findRootEditPart((IWorkbenchPart)part), false);
    }

    private static void executeLayout(IEditorPart part, AbstractFBNetworkEditPart ep, boolean isBlockLayout) {
        Command command = FordiacLayout.layout(part, ep, isBlockLayout);
        ((CommandStack)part.getAdapter(CommandStack.class)).execute(command);
    }

    private static Command layout(IEditorPart part, AbstractFBNetworkEditPart ep, boolean isBlockLayout) {
        RecursiveGraphLayoutEngine engine = new RecursiveGraphLayoutEngine();
        CompoundCommand command = new CompoundCommand();
        command.add(FordiacLayout.performLayoutRun(part, ep, engine, isBlockLayout));
        if (ep instanceof UnfoldedSubappContentEditPart) {
            List<UnfoldedSubappContentEditPart> subapps = FordiacLayout.collectSubapps(ep);
            subapps.forEach(subapp -> command.add(FordiacLayout.performLayoutRun(part, (AbstractFBNetworkEditPart)subapp, engine, isBlockLayout)));
        }
        return command;
    }

    private static Command performLayoutRun(IEditorPart part, AbstractFBNetworkEditPart ep, RecursiveGraphLayoutEngine engine, boolean isBlockLayout) {
        FordiacLayoutMapping mapping = new FordiacLayoutMapping(part, ep);
        FordiacGraphBuilder.build(mapping);
        if (isBlockLayout) {
            FordiacLayout.performBlockLayout(mapping, engine);
        }
        FordiacLayout.performConnectionLayout(mapping, engine);
        FordiacGraphDataHelper.calculate(mapping);
        return FordiacLayout.createCompoundCommand(mapping, isBlockLayout);
    }

    private static void performBlockLayout(FordiacLayoutMapping mapping, RecursiveGraphLayoutEngine engine) {
        FordiacLayout.configureBlockLayoutGraph(mapping.getLayoutGraph());
        engine.layout(mapping.getLayoutGraph(), (IElkProgressMonitor)new NullElkProgressMonitor());
        FordiacLayout.applySnapToGridIfEnabled(mapping);
    }

    private static void performConnectionLayout(FordiacLayoutMapping mapping, RecursiveGraphLayoutEngine engine) {
        FordiacLayout.configureConnectionLayoutGraph((ElkGraphElement)mapping.getLayoutGraph());
        try {
            engine.layout(mapping.getLayoutGraph(), (IElkProgressMonitor)new NullElkProgressMonitor());
        }
        catch (LibavoidServerException e) {
            FordiacLayout.showConnectionLayoutWarning(e);
        }
    }

    private static void applySnapToGridIfEnabled(FordiacLayoutMapping mapping) {
        AdvancedScrollingGraphicalViewer viewer = (AdvancedScrollingGraphicalViewer)mapping.getWorkbenchPart().getAdapter(GraphicalViewer.class);
        if (viewer.getPreferencesCache().isSnapToGrid()) {
            Dimension gridSpacing = (Dimension)viewer.getProperty("SnapToGrid.GridSpacing");
            double gridSize = gridSpacing.preciseHeight();
            mapping.getLayoutGraph().getChildren().forEach(node -> {
                double x = (double)Math.round(node.getX() / gridSize) * gridSize;
                double y = (double)Math.round(node.getY() / gridSize) * gridSize;
                node.setLocation(x, y);
            });
        }
    }

    private static Command createCompoundCommand(FordiacLayoutMapping mapping, boolean isBlockLayout) {
        CompoundCommand command = new CompoundCommand();
        if (isBlockLayout) {
            command.add((Command)new BlockLayoutCommand(mapping.getLayoutData()));
        }
        command.add((Command)new ConnectionLayoutCommand(mapping.getLayoutData()));
        return command;
    }

    private static void configureBlockLayoutGraph(ElkNode graph) {
        graph.setProperty(CoreOptions.INTERACTIVE, (Object)Boolean.FALSE).setProperty(CoreOptions.ALGORITHM, (Object)"org.eclipse.elk.layered").setProperty(CoreOptions.DIRECTION, (Object)Direction.RIGHT).setProperty(CoreOptions.ASPECT_RATIO, (Object)1.0).setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS).setProperty(CoreOptions.PADDING, (Object)new ElkPadding(5.0, 20.0, 20.0, 20.0)).setProperty(CoreOptions.SPACING_NODE_NODE, (Object)50.0).setProperty(LayeredMetaDataProvider.SPACING_NODE_NODE_BETWEEN_LAYERS, (Object)40.0).setProperty(LayeredMetaDataProvider.THOROUGHNESS, (Object)10).setProperty(LayeredMetaDataProvider.LAYERING_STRATEGY, (Object)LayeringStrategy.MIN_WIDTH).setProperty(LayeredMetaDataProvider.LAYERING_MIN_WIDTH_UPPER_BOUND_ON_WIDTH, (Object)-1).setProperty(LayeredMetaDataProvider.LAYERING_MIN_WIDTH_UPPER_LAYER_ESTIMATION_SCALING_FACTOR, (Object)-1).setProperty(LayeredMetaDataProvider.LAYERING_NODE_PROMOTION_STRATEGY, (Object)NodePromotionStrategy.NO_BOUNDARY).setProperty(LayeredMetaDataProvider.NODE_PLACEMENT_STRATEGY, (Object)NodePlacementStrategy.BRANDES_KOEPF).setProperty(LayeredMetaDataProvider.NODE_PLACEMENT_BK_FIXED_ALIGNMENT, (Object)FixedAlignment.BALANCED).setProperty(LayeredMetaDataProvider.NODE_PLACEMENT_BK_EDGE_STRAIGHTENING, (Object)EdgeStraighteningStrategy.IMPROVE_STRAIGHTNESS).setProperty(LayeredMetaDataProvider.CROSSING_MINIMIZATION_STRATEGY, (Object)CrossingMinimizationStrategy.LAYER_SWEEP).setProperty(LayeredMetaDataProvider.CROSSING_MINIMIZATION_GREEDY_SWITCH_TYPE, (Object)GreedySwitchType.TWO_SIDED).setProperty(LayeredMetaDataProvider.COMPACTION_CONNECTED_COMPONENTS, (Object)Boolean.TRUE).setProperty(CoreOptions.SEPARATE_CONNECTED_COMPONENTS, (Object)Boolean.TRUE).setProperty(LayeredMetaDataProvider.WRAPPING_VALIDIFY_STRATEGY, (Object)ValidifyStrategy.LOOK_BACK).setProperty(LayeredMetaDataProvider.WRAPPING_CUTTING_STRATEGY, (Object)CuttingStrategy.ARD).setProperty(LayeredMetaDataProvider.WRAPPING_STRATEGY, (Object)WrappingStrategy.MULTI_EDGE).setProperty(LayeredMetaDataProvider.COMPACTION_POST_COMPACTION_STRATEGY, (Object)GraphCompactionStrategy.LEFT).setProperty(LayeredMetaDataProvider.COMPACTION_POST_COMPACTION_CONSTRAINTS, (Object)ConstraintCalculationStrategy.QUADRATIC);
    }

    private static void configureConnectionLayoutGraph(ElkGraphElement graph) {
        graph.setProperty(CoreOptions.ALGORITHM, (Object)"org.eclipse.elk.alg.libavoid").setProperty(LibavoidMetaDataProvider.SHAPE_BUFFER_DISTANCE, (Object)10.0).setProperty(LibavoidMetaDataProvider.IDEAL_NUDGING_DISTANCE, (Object)5.0).setProperty(LibavoidMetaDataProvider.NUDGE_SHARED_PATHS_WITH_COMMON_END_POINT, (Object)Boolean.FALSE).setProperty(LibavoidMetaDataProvider.ENABLE_HYPEREDGES_FROM_COMMON_SOURCE, (Object)Boolean.TRUE).setProperty(LibavoidMetaDataProvider.IMPROVE_HYPEREDGE_ROUTES_MOVING_ADDING_AND_DELETING_JUNCTIONS, (Object)Boolean.TRUE).setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS).setProperty(CoreOptions.DIRECTION, (Object)Direction.RIGHT);
    }

    private static void showConnectionLayoutWarning(LibavoidServerException e) {
        MessageDialog.openWarning((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.ConnectionLayout_TimeoutTitle, (String)MessageFormat.format(Messages.ConnectionLayout_TimeoutMessage, e.getMessage()));
    }

    private static List<UnfoldedSubappContentEditPart> collectSubapps(AbstractFBNetworkEditPart ep) {
        ArrayList<UnfoldedSubappContentEditPart> subapps = new ArrayList<UnfoldedSubappContentEditPart>();
        ep.getChildren().stream().filter(SubAppForFBNetworkEditPart.class::isInstance).map(SubAppForFBNetworkEditPart.class::cast).filter(sub -> sub.getModel().isUnfolded()).map(SubAppForFBNetworkEditPart::getContentEP).map(UnfoldedSubappContentEditPart.class::cast).forEach(subapps::add);
        return subapps;
    }

    private static AbstractFBNetworkEditPart findRootEditPart(IWorkbenchPart workbenchPart) {
        GraphicalViewer viewer = (GraphicalViewer)workbenchPart.getAdapter(GraphicalViewer.class);
        AbstractFBNetworkEditPart networkEP = (AbstractFBNetworkEditPart)viewer.getRootEditPart().getChildren().get(0);
        Point point = ((FBNetworkContextMenuProvider)viewer.getContextMenu()).getTranslatedAndZoomedPoint();
        AbstractContainerContentEditPart containerEP = GetEditPartFromGraficalViewerHelper.findAbstractContainerContentEditPartAtPosition((IEditorPart)((IEditorPart)workbenchPart), (Point)point, (FBNetwork)networkEP.getModel());
        return containerEP != null ? containerEP : networkEP;
    }
}

