/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import org.eclipse.fordiac.ide.gef.dialogs.VariableDialog;
import org.eclipse.fordiac.ide.gef.nat.InitialValueCellEditor;
import org.eclipse.fordiac.ide.model.libraryElement.ITypedElement;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.editor.AbstractCellEditor;
import org.eclipse.nebula.widgets.nattable.widget.EditModeEnum;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;

public class InitialValueStructuredCellEditor
extends InitialValueCellEditor {
    protected final FocusListener compositeFocusListener = new CompositeFocusListener();
    private Composite composite;
    private StyledText textControl;
    private Button dialogButton;

    public InitialValueStructuredCellEditor(IRowDataProvider<? extends ITypedElement> dataProvider) {
        super(dataProvider);
    }

    public InitialValueStructuredCellEditor(IRowDataProvider<? extends ITypedElement> dataProvider, boolean moveSelectionOnEnter) {
        super(dataProvider, moveSelectionOnEnter);
    }

    @Override
    protected Control activateCell(Composite parent, Object originalCanonicalValue) {
        super.activateCell(parent, originalCanonicalValue);
        return this.composite;
    }

    @Override
    protected StyledText createEditorControl(Composite parent, int style) {
        this.composite = new Composite(parent, 0);
        GridLayoutFactory.fillDefaults().numColumns(2).applyTo(this.composite);
        this.textControl = super.createEditorControl(this.composite, style);
        GridDataFactory.fillDefaults().grab(true, false).applyTo((Control)this.textControl);
        this.dialogButton = new Button(this.composite, 0x800000);
        this.dialogButton.setText("\u2026");
        this.dialogButton.addSelectionListener(SelectionListener.widgetSelectedAdapter(event -> this.openDialog()));
        GridDataFactory.swtDefaults().applyTo((Control)this.dialogButton);
        return this.textControl;
    }

    protected void openDialog() {
        FocusListener focusListener;
        try {
            FocusListener focusListener2 = this.focusListener;
            if (focusListener2 instanceof AbstractCellEditor.InlineFocusListener) {
                AbstractCellEditor.InlineFocusListener inlineFL = (AbstractCellEditor.InlineFocusListener)focusListener2;
                inlineFL.handleFocusChanges = false;
            }
            String initialValue = FordiacMessages.ValueTooLarge.equals(this.getEditorValue()) ? null : this.getEditorValue();
            VariableDialog.open(this.composite.getShell(), this.getRowObject(), initialValue).ifPresent(this::setEditorValue);
        }
        catch (Throwable throwable) {
            FocusListener focusListener3;
            if (this.textControl != null && !this.textControl.isDisposed()) {
                this.textControl.forceFocus();
            }
            if ((focusListener3 = this.focusListener) instanceof AbstractCellEditor.InlineFocusListener) {
                AbstractCellEditor.InlineFocusListener inlineFL = (AbstractCellEditor.InlineFocusListener)focusListener3;
                inlineFL.handleFocusChanges = true;
            }
            throw throwable;
        }
        if (this.textControl != null && !this.textControl.isDisposed()) {
            this.textControl.forceFocus();
        }
        if ((focusListener = this.focusListener) instanceof AbstractCellEditor.InlineFocusListener) {
            AbstractCellEditor.InlineFocusListener inlineFL = (AbstractCellEditor.InlineFocusListener)focusListener;
            inlineFL.handleFocusChanges = true;
        }
    }

    public void addEditorControlListeners() {
        super.addEditorControlListeners();
        if (this.editMode == EditModeEnum.INLINE) {
            if (this.textControl != null && !this.textControl.isDisposed()) {
                this.textControl.addFocusListener(this.compositeFocusListener);
            }
            if (this.dialogButton != null && !this.dialogButton.isDisposed()) {
                this.dialogButton.addFocusListener(this.compositeFocusListener);
            }
        }
    }

    public void removeEditorControlListeners() {
        super.removeEditorControlListeners();
        if (this.textControl != null && !this.textControl.isDisposed()) {
            this.textControl.removeFocusListener(this.compositeFocusListener);
        }
        if (this.dialogButton != null && !this.dialogButton.isDisposed()) {
            this.dialogButton.removeFocusListener(this.compositeFocusListener);
        }
    }

    @Override
    public Control getEditorControl() {
        return this.composite;
    }

    protected class CompositeFocusListener
    implements FocusListener {
        private boolean hasFocus;

        protected CompositeFocusListener() {
        }

        public void focusGained(FocusEvent e) {
            this.hasFocus = true;
            InitialValueStructuredCellEditor.this.focusListener.focusGained(e);
        }

        public void focusLost(FocusEvent e) {
            this.hasFocus = false;
            Display.getCurrent().timerExec(100, () -> {
                if (!this.hasFocus) {
                    InitialValueStructuredCellEditor.this.focusListener.focusLost(e);
                }
            });
        }
    }
}

