/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.elk;

import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Objects;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.elk.core.options.CoreOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.graph.ElkConnectableShape;
import org.eclipse.elk.graph.ElkEdge;
import org.eclipse.elk.graph.ElkGraphElement;
import org.eclipse.elk.graph.ElkLabel;
import org.eclipse.elk.graph.ElkNode;
import org.eclipse.elk.graph.ElkPort;
import org.eclipse.elk.graph.util.ElkGraphUtil;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editparts.AbstractFBNElementEditPart;
import org.eclipse.fordiac.ide.application.editparts.CommentEditPart;
import org.eclipse.fordiac.ide.application.editparts.ConnectionEditPart;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.UntypedSubAppInterfaceElementEditPart;
import org.eclipse.fordiac.ide.application.figures.FBNetworkConnection;
import org.eclipse.fordiac.ide.elk.FordiacLayoutMapping;
import org.eclipse.fordiac.ide.gef.editparts.AbstractFBNetworkEditPart;
import org.eclipse.fordiac.ide.gef.editparts.InterfaceEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.ui.IEditorPart;

public final class FordiacGraphBuilder {
    private final FordiacLayoutMapping mapping;

    public FordiacGraphBuilder(IEditorPart part, AbstractFBNetworkEditPart ep) {
        this.mapping = FordiacGraphBuilder.createFordiacLayoutMapping(part, ep);
    }

    public FordiacLayoutMapping build() {
        if (FordiacGraphBuilder.isParentInterfaceLayout(this.mapping.getParentElement())) {
            this.processParentInterfaces();
        }
        for (Object child : this.mapping.getParentElement().getChildren()) {
            this.processChild(child);
        }
        this.processConnections();
        return this.mapping;
    }

    private void processParentInterfaces() {
        ElkNode inputInterfaceBarNode = this.createInputIBNode();
        ElkNode outputInterfaceBarNode = this.createOutputIBNode();
        GraphicalEditPart graphicalEditPart = this.mapping.getParentElement();
        Objects.requireNonNull(graphicalEditPart);
        GraphicalEditPart graphicalEditPart2 = graphicalEditPart;
        List children = switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EditorWithInterfaceEditPart.class, UnfoldedSubappContentEditPart.class}, (Object)graphicalEditPart2, 0)) {
            case 0 -> {
                EditorWithInterfaceEditPart edWithEp = (EditorWithInterfaceEditPart)graphicalEditPart2;
                yield edWithEp.getChildren();
            }
            case 1 -> {
                UnfoldedSubappContentEditPart unfoldedSubappContentEP = (UnfoldedSubappContentEditPart)graphicalEditPart2;
                yield unfoldedSubappContentEP.getParent().getChildren();
            }
            default -> throw new IllegalArgumentException("Wrong parent editpart given");
        };
        children.stream().filter(InterfaceEditPart.class::isInstance).map(InterfaceEditPart.class::cast).forEach(ie -> {
            this.createParentElementPort((InterfaceEditPart)ie, inputInterfaceBarNode, outputInterfaceBarNode);
            this.processInterface(ie);
        });
    }

    private ElkNode createInputIBNode() {
        ElkNode inputNode = this.createNode(this.getInputIBFigure());
        inputNode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        return inputNode;
    }

    private ElkNode createOutputIBNode() {
        ElkNode outputNode = this.createNode(this.getOutputIBFigure());
        outputNode.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        return outputNode;
    }

    private IFigure getInputIBFigure() {
        GraphicalEditPart graphicalEditPart = this.mapping.getParentElement();
        Objects.requireNonNull(graphicalEditPart);
        GraphicalEditPart graphicalEditPart2 = graphicalEditPart;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EditorWithInterfaceEditPart.class, UnfoldedSubappContentEditPart.class}, (Object)graphicalEditPart2, 0)) {
            case 0 -> {
                EditorWithInterfaceEditPart edWithEp = (EditorWithInterfaceEditPart)graphicalEditPart2;
                yield edWithEp.getLeftInterfaceContainer();
            }
            case 1 -> {
                UnfoldedSubappContentEditPart unfoldedSubappContentEP = (UnfoldedSubappContentEditPart)graphicalEditPart2;
                yield unfoldedSubappContentEP.getParent().getFigure().getExpandedInputFigure();
            }
            default -> throw new IllegalArgumentException("Wrong parent editpart given");
        };
    }

    private IFigure getOutputIBFigure() {
        GraphicalEditPart graphicalEditPart = this.mapping.getParentElement();
        Objects.requireNonNull(graphicalEditPart);
        GraphicalEditPart graphicalEditPart2 = graphicalEditPart;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EditorWithInterfaceEditPart.class, UnfoldedSubappContentEditPart.class}, (Object)graphicalEditPart2, 0)) {
            case 0 -> {
                EditorWithInterfaceEditPart edWithEp = (EditorWithInterfaceEditPart)graphicalEditPart2;
                yield edWithEp.getRightInterfaceContainer();
            }
            case 1 -> {
                UnfoldedSubappContentEditPart unfoldedSubappContentEP = (UnfoldedSubappContentEditPart)graphicalEditPart2;
                yield unfoldedSubappContentEP.getParent().getFigure().getExpandedOutputFigure();
            }
            default -> throw new IllegalArgumentException("Wrong parent editpart given");
        };
    }

    private void processChild(Object child) {
        Object object = child;
        Objects.requireNonNull(object);
        Object object2 = object;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{GroupEditPart.class, CommentEditPart.class, AbstractFBNElementEditPart.class, ValueEditPart.class}, (Object)object2, 0)) {
            case 0: {
                GroupEditPart group = (GroupEditPart)object2;
                break;
            }
            case 1: {
                CommentEditPart commentEp = (CommentEditPart)object2;
                this.processComment(commentEp);
                break;
            }
            case 2: {
                AbstractFBNElementEditPart fbnEl = (AbstractFBNElementEditPart)object2;
                this.processFB(fbnEl);
                break;
            }
            case 3: {
                ValueEditPart value = (ValueEditPart)object2;
                this.processValue(value);
                break;
            }
        }
    }

    private void processComment(CommentEditPart commentEp) {
        this.createNode((GraphicalEditPart)commentEp);
    }

    private void processFB(AbstractFBNElementEditPart ep) {
        this.createFBNode(ep);
        for (Object child : ep.getChildren()) {
            if (!(child instanceof InterfaceEditPart)) continue;
            InterfaceEditPart ie = (InterfaceEditPart)child;
            this.processInterface(ie);
        }
    }

    private void processInterface(Object child) {
        UntypedSubAppInterfaceElementEditPart ie;
        UntypedSubAppInterfaceElementEditPart ie2;
        if (child instanceof UntypedSubAppInterfaceElementEditPart && !(ie2 = (UntypedSubAppInterfaceElementEditPart)child).isInput() && ie2.getParent() != this.mapping.getNetworkEditPart().getParent()) {
            return;
        }
        if (child instanceof UntypedSubAppInterfaceElementEditPart && (ie = (UntypedSubAppInterfaceElementEditPart)child).isInput() && ie.getParent() == this.mapping.getNetworkEditPart().getParent()) {
            return;
        }
        ((InterfaceEditPart)child).getTargetConnections().stream().filter(ConnectionEditPart.class::isInstance).filter(con -> FordiacGraphBuilder.isVisible((ConnectionEditPart)con)).forEach(conn -> this.saveConnection((ConnectionEditPart)conn));
    }

    private void processValue(ValueEditPart valueEditPart) {
        VarDeclaration varDecl;
        EObject eObject = valueEditPart.getModel().eContainer();
        if (eObject instanceof VarDeclaration && !(varDecl = (VarDeclaration)eObject).getInputConnections().isEmpty()) {
            return;
        }
        EditPart iePart = valueEditPart.getViewer().getEditPartForModel((Object)valueEditPart.getModel().getParentIE());
        ElkPort port = this.getPort((InterfaceEditPart)iePart);
        ElkLabel label = ElkGraphUtil.createLabel((String)valueEditPart.getModel().getValue(), (ElkGraphElement)port);
        Rectangle bounds = valueEditPart.getFigure().getBounds();
        label.setLocation(bounds.preciseX() - port.getX() - port.getParent().getX(), bounds.preciseY() - port.getY() - port.getParent().getY());
        label.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
    }

    private static boolean isParentInterfaceLayout(GraphicalEditPart parentElement) {
        return parentElement instanceof EditorWithInterfaceEditPart || parentElement instanceof UnfoldedSubappContentEditPart;
    }

    private static boolean isVisible(ConnectionEditPart con) {
        FBNetworkConnection conFigure = con.getFigure();
        return conFigure.isVisible() && !conFigure.isHidden();
    }

    private void saveConnection(ConnectionEditPart conn) {
        if (!this.mapping.getConnections().contains(conn)) {
            EditPart sourceContainer = conn.getSource().getParent().getParent();
            EditPart targetContainer = conn.getTarget().getParent().getParent();
            if (sourceContainer instanceof UnfoldedSubappContentEditPart || targetContainer instanceof UnfoldedSubappContentEditPart) {
                this.mapping.getConnections().add(conn);
            } else if (!(sourceContainer instanceof GroupContentEditPart) && !(targetContainer instanceof GroupContentEditPart) || sourceContainer == targetContainer) {
                this.mapping.getConnections().add(conn);
            }
        }
    }

    private ElkNode createNode(IFigure figure) {
        ElkNode node = ElkGraphUtil.createNode((ElkNode)this.mapping.getLayoutGraph());
        Rectangle bounds = figure.getBounds();
        node.setLocation((double)bounds.x, (double)bounds.y);
        node.setDimensions(bounds.preciseWidth(), bounds.preciseHeight());
        return node;
    }

    private ElkNode createNode(GraphicalEditPart editPart) {
        ElkNode node = this.createNode(editPart.getFigure());
        this.mapping.getGraphMap().put((Object)node, (Object)editPart);
        this.mapping.getReverseMapping().put(editPart, (ElkGraphElement)node);
        return node;
    }

    private void createFBNode(AbstractFBNElementEditPart editPart) {
        ElkNode node = this.createNode((GraphicalEditPart)editPart);
        node.setProperty(CoreOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_POS);
        ElkLabel label = ElkGraphUtil.createLabel((String)editPart.getModel().getName(), (ElkGraphElement)node);
        Rectangle labelBounds = editPart.getFigure().getLabelBounds();
        label.setDimensions((double)labelBounds.width(), (double)labelBounds.height());
    }

    private void processConnections() {
        for (ConnectionEditPart conn : this.mapping.getConnections()) {
            ElkPort sourcePort = this.getPort((InterfaceEditPart)conn.getSource());
            ElkPort destinationPort = this.getPort((InterfaceEditPart)conn.getTarget());
            ElkEdge edge = ElkGraphUtil.createSimpleEdge((ElkConnectableShape)sourcePort, (ElkConnectableShape)destinationPort);
            this.mapping.getGraphMap().put((Object)edge, (Object)conn);
            this.mapping.getReverseMapping().put((GraphicalEditPart)conn, (ElkGraphElement)edge);
        }
    }

    private ElkPort getPort(InterfaceEditPart interfaceEditPart) {
        return (ElkPort)this.mapping.getReverseMapping().computeIfAbsent((GraphicalEditPart)interfaceEditPart, ie -> this.createPort(interfaceEditPart));
    }

    private ElkPort createPort(InterfaceEditPart interfaceEditPart) {
        EditPart parent = interfaceEditPart.getParent();
        ElkNode parentNode = this.determineParentNode(parent);
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parentNode);
        FordiacGraphBuilder.configurePortDimensions(port, interfaceEditPart);
        FordiacGraphBuilder.setPortLocation(port, interfaceEditPart, parentNode);
        port.setProperty(CoreOptions.PORT_SIDE, (Object)(interfaceEditPart.isInput() ? PortSide.WEST : PortSide.EAST));
        this.mapping.getGraphMap().put((Object)port, (Object)interfaceEditPart.getModel());
        return port;
    }

    private ElkNode determineParentNode(EditPart parent) {
        ElkNode parentNode = (ElkNode)this.mapping.getReverseMapping().get(parent);
        if (parent == this.mapping.getParentElement().getParent()) {
            parentNode = this.mapping.getLayoutGraph();
        }
        return parentNode;
    }

    private static void configurePortDimensions(ElkPort port, InterfaceEditPart interfaceEditPart) {
        IFigure figure = interfaceEditPart.getFigure();
        port.setDimensions(1.0, figure.getBounds().preciseHeight());
    }

    private static void setPortLocation(ElkPort port, InterfaceEditPart interfaceEditPart, ElkNode parentNode) {
        int x = interfaceEditPart.isInput() ? 0 : (int)parentNode.getWidth() - 1;
        int y = interfaceEditPart.getFigure().getLocation().y - (int)parentNode.getY();
        port.setLocation((double)x, (double)y);
    }

    private ElkPort createParentElementPort(InterfaceEditPart ie, ElkNode inputInterfaceBarNode, ElkNode outputInterfaceBarNode) {
        boolean isInput = ie.getModel().isIsInput();
        ElkNode parentNode = isInput ? inputInterfaceBarNode : outputInterfaceBarNode;
        ElkPort port = ElkGraphUtil.createPort((ElkNode)parentNode);
        port.setDimensions(1.0, (double)ie.getFigure().getBounds().height);
        int y = ie.getFigure().getLocation().y;
        if (isInput) {
            port.setLocation(parentNode.getWidth() - 1.0, (double)y - parentNode.getY());
        } else {
            port.setLocation(0.0, (double)y - parentNode.getY());
        }
        port.setProperty(CoreOptions.PORT_SIDE, (Object)(isInput ? PortSide.EAST : PortSide.WEST));
        this.mapping.getGraphMap().put((Object)port, (Object)ie.getModel());
        this.mapping.getReverseMapping().put((GraphicalEditPart)ie, (ElkGraphElement)port);
        return port;
    }

    private static FordiacLayoutMapping createFordiacLayoutMapping(IEditorPart part, AbstractFBNetworkEditPart ep) {
        FordiacLayoutMapping newMapping = new FordiacLayoutMapping(part, ep);
        ElkNode graph = ElkGraphUtil.createGraph();
        newMapping.setLayoutGraph(graph);
        newMapping.setParentElement(ep);
        newMapping.getGraphMap().put((Object)graph, (Object)ep);
        newMapping.getReverseMapping().put((GraphicalEditPart)ep, (ElkGraphElement)graph);
        return newMapping;
    }
}

