/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.fbtypeeditor.editors;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.fbtypeeditor.FBInterfacePaletteFactory;
import org.eclipse.fordiac.ide.fbtypeeditor.FBTypeEditDomain;
import org.eclipse.fordiac.ide.fbtypeeditor.contentprovider.InterfaceContextMenuProvider;
import org.eclipse.fordiac.ide.fbtypeeditor.editors.IFBTEditorPart;
import org.eclipse.fordiac.ide.fbtypeeditor.editparts.FBInterfaceEditPartFactory;
import org.eclipse.fordiac.ide.gef.DiagramEditorWithFlyoutPalette;
import org.eclipse.fordiac.ide.gef.editparts.ZoomScalableFreeformRootEditPart;
import org.eclipse.fordiac.ide.gef.figures.AbstractFreeformFigure;
import org.eclipse.fordiac.ide.gef.figures.MinSpaceFreeformFigure;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterType;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.SubAppType;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.typeeditor.TypeEditorInput;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.GridLayer;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.editparts.ZoomManager;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditor;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.views.contentoutline.IContentOutlinePage;

public class FBInterfaceEditor
extends DiagramEditorWithFlyoutPalette
implements IFBTEditorPart {
    private CommandStack commandStack;
    private PaletteRoot paletteRoot;
    private TypeLibrary typeLib;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        if (input instanceof TypeEditorInput) {
            TypeEditorInput untypedInput = (TypeEditorInput)input;
            this.typeLib = untypedInput.getTypeEntry().getTypeLibrary();
        }
        super.init(site, input);
        this.setPartName(FordiacMessages.Interface);
        this.setTitleImage(FordiacImage.ICON_INTERFACE_EDITOR.getImage());
    }

    protected DefaultEditDomain createEditDomain() {
        return new FBTypeEditDomain((IEditorPart)this, this.commandStack);
    }

    protected void createActions() {
        ActionRegistry registry = this.getActionRegistry();
        InterfaceContextMenuProvider.createInterfaceEditingActions((IWorkbenchPart)this, registry, this.getModel());
        super.createActions();
    }

    protected EditPartFactory getEditPartFactory() {
        return new FBInterfaceEditPartFactory((GraphicalEditor)this, this.typeLib);
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.paletteRoot = FBInterfacePaletteFactory.createPalette(this.typeLib, !(this.getType() instanceof AdapterType));
        }
        return this.paletteRoot;
    }

    public <T> T getAdapter(Class<T> type) {
        if (type == IContentOutlinePage.class) {
            return null;
        }
        if (type == InterfaceList.class) {
            return type.cast(this.getModel().getInterfaceList());
        }
        if (type == SubAppType.class) {
            T t;
            FBType fBType = this.getType();
            if (fBType instanceof SubAppType) {
                SubAppType subApp = (SubAppType)fBType;
                t = type.cast(subApp);
            } else {
                t = null;
            }
            return t;
        }
        return (T)super.getAdapter(type);
    }

    protected TypeLibrary getTypeLib() {
        return this.typeLib;
    }

    public void doSave(IProgressMonitor monitor) {
    }

    public boolean outlineSelectionChanged(Object selectedElement) {
        EditPart ep = this.getGraphicalViewer().getEditPartForModel(selectedElement);
        this.getGraphicalViewer().flush();
        if (ep != null && ep.isSelectable()) {
            this.getGraphicalViewer().select(ep);
            return true;
        }
        return selectedElement instanceof InterfaceList;
    }

    public void setCommonCommandStack(CommandStack commandStack) {
        this.commandStack = commandStack;
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return FBInterfacePaletteFactory.PALETTE_PREFERENCES;
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }
        };
    }

    public FBType getModel() {
        return this.getType();
    }

    protected ContextMenuProvider getContextMenuProvider(ScrollingGraphicalViewer viewer, ZoomManager zoomManager) {
        return new InterfaceContextMenuProvider((EditPartViewer)viewer, zoomManager, this.getActionRegistry(), this.typeLib.getDataTypeLibrary());
    }

    protected TransferDropTargetListener createTransferDropTargetListener() {
        return null;
    }

    public AutomationSystem getSystem() {
        return null;
    }

    public void doSaveAs() {
    }

    public void gotoMarker(IMarker marker) {
    }

    public boolean isMarkerTarget(IMarker marker) {
        return false;
    }

    public void reloadType() {
        this.getGraphicalViewer().setContents((Object)this.getType());
    }

    protected ScalableFreeformRootEditPart createRootEditPart() {
        return new ZoomScalableFreeformRootEditPart(this.getSite(), this.getActionRegistry()){

            protected AbstractFreeformFigure createDrawingAreaContainer() {
                return new MinSpaceFreeformFigure();
            }

            protected IFigure createFigure() {
                IFigure rootFigure = super.createFigure();
                GridLayer grid = (GridLayer)this.getLayer("Grid Layer");
                if (grid != null) {
                    grid.setVisible(false);
                }
                return rootFigure;
            }

            protected void refreshGridLayer() {
            }
        };
    }

    protected org.eclipse.swt.graphics.Point getInitialScrollPos(GraphicalEditPart rootEditPart) {
        org.eclipse.swt.graphics.Point figureCanvasSize = this.getViewer().getFigureCanvasSize();
        Rectangle drawingAreaBounds = rootEditPart.getContentPane().getBounds();
        Point center = drawingAreaBounds.getCenter();
        return new org.eclipse.swt.graphics.Point(center.x - figureCanvasSize.x / 2, center.y - figureCanvasSize.y / 2);
    }

    public Object getSelectableObject() {
        if (this.getGraphicalViewer() == null) {
            return null;
        }
        return this.getGraphicalViewer().getEditPartForModel((Object)this.getType());
    }

    public void setInput(IEditorInput input) {
        this.checkEditorInput(input);
        super.setInput(input);
    }
}

