/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators;

import java.text.MessageFormat;
import org.eclipse.fordiac.ide.comgeneration.implementation.ChannelEnd;
import org.eclipse.fordiac.ide.comgeneration.implementation.mediagenerators.MediaSpecificGenerator;
import org.eclipse.fordiac.ide.comgeneration.plugin.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;

public abstract class AbstractMediaSpecificGenerator
implements MediaSpecificGenerator {
    private static final String[] PALETTE_ENTRY_SOURCE_LOCAL = new String[]{"PUBL_0", "PUBL_1", "PUBL_2", "PUBL_3", "PUBL_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION_LOCAL = new String[]{"SUBL_0", "SUBL_1", "SUBL_2", "net/SUBL_3", "net/SUBL_4"};
    private static final String[] PALETTE_ENTRY_SOURCE = new String[]{"PUBLISH_0", "PUBLISH_1", "PUBLISH_2", "PUBLISH_3", "PUBLISH_4"};
    private static final String[] PALETTE_ENTRY_DESTINATION = new String[]{"SUBSCRIBE_0", "SUBSCRIBE_1", "SUBSCRIBE_2", "SUBSCRIBE_3", "SUBSCRIBE_4"};
    private final TypeLibrary typeLib;

    protected AbstractMediaSpecificGenerator(TypeLibrary typeLib) {
        this.typeLib = typeLib;
    }

    public TypeLibrary getTypeLibrary() {
        return this.typeLib;
    }

    @Override
    public FBTypeEntry getPaletteType(ChannelEnd end, int numDataPorts, boolean local) {
        String[] paletteEntries = local ? (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE_LOCAL : PALETTE_ENTRY_DESTINATION_LOCAL) : (end == ChannelEnd.SOURCE ? PALETTE_ENTRY_SOURCE : PALETTE_ENTRY_DESTINATION);
        FBTypeEntry entry = this.getTypeLibrary().getFBTypeEntry(paletteEntries[numDataPorts]);
        if (entry == null) {
            FordiacLogHelper.logError((String)MessageFormat.format(Messages.CommGenerator_FBTypeEntryNotFound, paletteEntries[numDataPorts]));
        }
        return entry;
    }

    @Override
    public VarDeclaration getTargetInputData(int index, FB fb) {
        String dataName = "SD_" + (index + 1);
        for (VarDeclaration inputVar : fb.getInterface().getInputVars()) {
            if (!inputVar.getName().equals(dataName)) continue;
            return inputVar;
        }
        return null;
    }

    @Override
    public VarDeclaration getTargetOutputData(int index, FB fb) {
        String dataName = "RD_" + (index + 1);
        for (VarDeclaration outputVar : fb.getInterface().getOutputVars()) {
            if (!outputVar.getName().equals(dataName)) continue;
            return outputVar;
        }
        return null;
    }
}

