/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.export.forte_ng.composite;

import com.google.common.collect.Iterables;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.export.forte_ng.ForteFBTemplate;
import org.eclipse.fordiac.ide.export.forte_ng.util.ForteNgExportUtil;
import org.eclipse.fordiac.ide.export.language.ILanguageSupport;
import org.eclipse.fordiac.ide.export.language.ILanguageSupportFactory;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterConnection;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterFB;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.DataConnection;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.EventConnection;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.With;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;
import org.eclipse.xtext.xbase.lib.XbaseGenerated;

public class CompositeFBImplTemplate
extends ForteFBTemplate<CompositeFBType> {
    private final List<FB> fbs;
    private int eConnNumber = 0;
    private int fannedOutEventConns = 0;
    private int dataConnNumber = 0;
    private int fannedOutDataConns = 0;
    private final Map<VarDeclaration, ILanguageSupport> fbNetworkInitialVariableLanguageSupport;

    public CompositeFBImplTemplate(CompositeFBType type, String name, Path prefix, Map<?, ?> options) {
        super(type, name, prefix, "CCompositeFB", options);
        this.fbs = IterableExtensions.toList((Iterable)IterableExtensions.reject((Iterable)Iterables.filter((Iterable)type.getFBNetwork().getNetworkElements(), FB.class), AdapterFB.class));
        Functions.Function1 _function = it -> it.getInterface().getInputVars();
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty;
            Value _value = it.getValue();
            String _value_1 = null;
            if (_value != null) {
                _value_1 = _value.getValue();
            }
            return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
        };
        Functions.Function1 _function_2 = it -> ILanguageSupportFactory.createLanguageSupport((String)"forte_ng", (EObject)it, (Map)options);
        this.fbNetworkInitialVariableLanguageSupport = IterableExtensions.toInvertedMap((Iterable)IterableExtensions.filter((Iterable)IterableExtensions.flatMap(this.fbs, (Functions.Function1)_function), (Functions.Function1)_function_1), (Functions.Function1)_function_2);
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateHeader = this.generateHeader();
        _builder.append((Object)_generateHeader);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateImplIncludes = this.generateImplIncludes();
        _builder.append((Object)_generateImplIncludes);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _generateFBDefinition = this.generateFBDefinition();
        _builder.append((Object)_generateFBDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateFBInterfaceDefinition = this.generateFBInterfaceDefinition();
        _builder.append((Object)_generateFBInterfaceDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateFBInterfaceSpecDefinition = this.generateFBInterfaceSpecDefinition();
        _builder.append((Object)_generateFBInterfaceSpecDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::");
        CharSequence _fBClassName_1 = this.getFBClassName();
        _builder.append((Object)_fBClassName_1);
        _builder.append("(const CStringDictionary::TStringId paInstanceNameId, forte::core::CFBContainer &paContainer) :");
        _builder.newLineIfNotEmpty();
        _builder.append("    ");
        String _baseClass = this.baseClass();
        _builder.append(_baseClass, "    ");
        _builder.append("(paContainer, scmFBInterfaceSpec, paInstanceNameId, scmFBNData)");
        CharSequence _generateInternalFBInitializer = this.generateInternalFBInitializer(this.fbs);
        _builder.append((Object)_generateInternalFBInitializer, "    ");
        EList _inputVars = ((CompositeFBType)this.getType()).getInterfaceList().getInputVars();
        EList _inOutVars = ((CompositeFBType)this.getType()).getInterfaceList().getInOutVars();
        Iterable _plus = Iterables.concat((Iterable)_inputVars, (Iterable)_inOutVars);
        EList _outputVars = ((CompositeFBType)this.getType()).getInterfaceList().getOutputVars();
        CharSequence _generateVariableInitializer = this.generateVariableInitializer(Iterables.concat((Iterable)_plus, (Iterable)_outputVars));
        _builder.append((Object)_generateVariableInitializer, "    ");
        EList _sockets = ((CompositeFBType)this.getType()).getInterfaceList().getSockets();
        EList _plugs = ((CompositeFBType)this.getType()).getInterfaceList().getPlugs();
        CharSequence _generateAdapterInitializer = this.generateAdapterInitializer(Iterables.concat((Iterable)_sockets, (Iterable)_plugs));
        _builder.append((Object)_generateAdapterInitializer, "    ");
        CharSequence _generateConnectionInitializer = this.generateConnectionInitializer();
        _builder.append((Object)_generateConnectionInitializer, "    ");
        _builder.append(" {");
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        CharSequence _generateInitializeDefinition = this.generateInitializeDefinition();
        _builder.append((Object)_generateInitializeDefinition);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _inputVars_1 = ((CompositeFBType)this.getType()).getInterfaceList().getInputVars();
        EList _inOutVars_1 = ((CompositeFBType)this.getType()).getInterfaceList().getInOutVars();
        Iterable _plus_1 = Iterables.concat((Iterable)_inputVars_1, (Iterable)_inOutVars_1);
        EList _outputVars_1 = ((CompositeFBType)this.getType()).getInterfaceList().getOutputVars();
        CharSequence _generateSetInitialValuesDefinition = this.generateSetInitialValuesDefinition(Iterables.concat((Iterable)_plus_1, (Iterable)_outputVars_1));
        _builder.append((Object)_generateSetInitialValuesDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateSetFBNetworkInitialValuesDefinition = this.generateSetFBNetworkInitialValuesDefinition();
        _builder.append((Object)_generateSetFBNetworkInitialValuesDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateFBNetwork = this.generateFBNetwork();
        _builder.append((Object)_generateFBNetwork);
        _builder.newLineIfNotEmpty();
        CharSequence _generateReadInternal2InterfaceOutputDataDefinition = this.generateReadInternal2InterfaceOutputDataDefinition();
        _builder.append((Object)_generateReadInternal2InterfaceOutputDataDefinition);
        _builder.newLineIfNotEmpty();
        CharSequence _generateInterfaceDefinitions = this.generateInterfaceDefinitions();
        _builder.append((Object)_generateInterfaceDefinitions);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence generateInterfaceDefinitions() {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateInterfaceDefinitions = super.generateInterfaceDefinitions();
        _builder.append((Object)_generateInterfaceDefinitions);
        _builder.newLineIfNotEmpty();
        boolean _isEmpty = ((CompositeFBType)this.getType()).getInterfaceList().getInOutVars().isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            CharSequence _generateConnectionAccessorsDefinition = this.generateConnectionAccessorsDefinition((List<INamedElement>)((CompositeFBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), "getDIOOutConInternalUnchecked", "CInOutDataConnection *", true);
            _builder.append((Object)_generateConnectionAccessorsDefinition);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    protected CharSequence generateReadInternal2InterfaceOutputDataDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("void ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::readInternal2InterfaceOutputData(");
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists((Iterable)((CompositeFBType)this.getType()).getInterfaceList().getEventOutputs(), (Functions.Function1)_function);
        if (_exists) {
            _builder.append("const TEventID paEOID");
        } else {
            _builder.append("TEventID");
        }
        _builder.append(") {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        CharSequence _generateReadInternal2InterfaceOutputDataBody = this.generateReadInternal2InterfaceOutputDataBody((List<Event>)((CompositeFBType)this.getType()).getInterfaceList().getEventOutputs());
        _builder.append((Object)_generateReadInternal2InterfaceOutputDataBody, "  ");
        _builder.newLineIfNotEmpty();
        _builder.append("}");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence generateReadInternal2InterfaceOutputDataBody(List<Event> events) {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> {
            boolean _isEmpty = it.getWith().isEmpty();
            return !_isEmpty;
        };
        boolean _exists = IterableExtensions.exists(events, (Functions.Function1)_function);
        if (_exists) {
            _builder.append("switch(paEOID) {");
            _builder.newLine();
            Functions.Function1 _function_1 = it -> {
                boolean _isEmpty = it.getWith().isEmpty();
                return !_isEmpty;
            };
            Iterable _filter = IterableExtensions.filter(events, (Functions.Function1)_function_1);
            for (Event event : _filter) {
                _builder.append("  ");
                _builder.append("case ");
                CharSequence _generateEventID = this.generateEventID(event);
                _builder.append((Object)_generateEventID, "  ");
                _builder.append(": {");
                _builder.newLineIfNotEmpty();
                Functions.Function1 _function_2 = it -> this.getWithVariable((With)it);
                Functions.Function1 _function_3 = it -> {
                    boolean _isInOutVar = it.isInOutVar();
                    return !_isInOutVar;
                };
                Iterable _filter_1 = IterableExtensions.filter((Iterable)ListExtensions.map((List)event.getWith(), (Functions.Function1)_function_2), (Functions.Function1)_function_3);
                for (VarDeclaration variable : _filter_1) {
                    _builder.append("  ");
                    _builder.append("  ");
                    _builder.append("if(CDataConnection *conn = getIn2IfConUnchecked(");
                    int _interfaceElementIndex = ForteNgExportUtil.getInterfaceElementIndex((IInterfaceElement)variable);
                    _builder.append((Object)_interfaceElementIndex, "    ");
                    _builder.append("); conn) { conn->readData(");
                    CharSequence _generateName = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                    _builder.append((Object)_generateName, "    ");
                    _builder.append("); }");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append("  ");
                _builder.append("  ");
                _builder.append("break;");
                _builder.newLine();
                _builder.append("  ");
                _builder.append("}");
                _builder.newLine();
            }
            _builder.append("  ");
            _builder.append("default:");
            _builder.newLine();
            _builder.append("    ");
            _builder.append("break;");
            _builder.newLine();
            _builder.append("}");
            _builder.newLine();
        } else {
            _builder.append("// nothing to do");
            _builder.newLine();
        }
        return _builder;
    }

    protected CharSequence generateFBNetwork() {
        boolean _isEmpty_3;
        boolean _not_3;
        boolean _isEmpty_2;
        boolean _not_2;
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        boolean _isEmpty = this.fbs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("const SCFB_FBInstanceData ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::scmInternalFBs[] = {");
            _builder.newLineIfNotEmpty();
            _builder.append("  ");
            boolean _hasElements = false;
            for (FB elem : this.fbs) {
                if (!_hasElements) {
                    _hasElements = true;
                } else {
                    _builder.appendImmediate((Object)",\n", "  ");
                }
                _builder.append("{");
                CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(elem.getName());
                _builder.append((Object)_fORTEStringId, "  ");
                _builder.append(", ");
                CharSequence _generateTypeSpec = ForteNgExportUtil.generateTypeSpec((INamedElement)elem.getType());
                _builder.append((Object)_generateTypeSpec, "  ");
                _builder.append("}");
            }
            _builder.newLineIfNotEmpty();
            _builder.append("};");
            _builder.newLine();
        }
        _builder.newLine();
        boolean _isEmpty_1 = ((CompositeFBType)this.getType()).getFBNetwork().getEventConnections().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            StringBuilder _exportEventConns = this.exportEventConns((EList<EventConnection>)((CompositeFBType)this.getType()).getFBNetwork().getEventConnections());
            _builder.append((Object)_exportEventConns);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl3 = _not_2 = !(_isEmpty_2 = ((CompositeFBType)this.getType()).getFBNetwork().getDataConnections().isEmpty());
        if (_not_2) {
            StringBuilder _exportDataConns = this.exportDataConns((EList<DataConnection>)((CompositeFBType)this.getType()).getFBNetwork().getDataConnections());
            _builder.append((Object)_exportDataConns);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        boolean bl4 = _not_3 = !(_isEmpty_3 = ((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections().isEmpty());
        if (_not_3) {
            CharSequence _exportAdapterConns = this.exportAdapterConns((EList<AdapterConnection>)((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections());
            _builder.append((Object)_exportAdapterConns);
            _builder.newLineIfNotEmpty();
            _builder.newLine();
        }
        CharSequence _generateFBNDataStruct = this.generateFBNDataStruct();
        _builder.append((Object)_generateFBNDataStruct);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence generateFBNDataStruct() {
        boolean _not_1;
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SCFB_FBNData ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scmFBNData = {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size = this.fbs.size();
        _builder.append((Object)_size, "  ");
        _builder.append(", ");
        boolean _isEmpty = this.fbs.isEmpty();
        boolean bl = _not = !_isEmpty;
        if (_not) {
            _builder.append("scmInternalFBs");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.eConnNumber, "  ");
        _builder.append(", ");
        if (this.eConnNumber != 0) {
            _builder.append("scmEventConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.fannedOutEventConns, "  ");
        _builder.append(", ");
        if (this.fannedOutEventConns != 0) {
            _builder.append("scmFannedOutEventConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.dataConnNumber, "  ");
        _builder.append(", ");
        if (this.dataConnNumber != 0) {
            _builder.append("scmDataConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        _builder.append((Object)this.fannedOutDataConns, "  ");
        _builder.append(", ");
        if (this.fannedOutDataConns != 0) {
            _builder.append("scmFannedOutDataConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.append(",");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        int _size_1 = ((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections().size();
        _builder.append((Object)_size_1, "  ");
        _builder.append(", ");
        boolean _isEmpty_1 = ((CompositeFBType)this.getType()).getFBNetwork().getAdapterConnections().isEmpty();
        boolean bl2 = _not_1 = !_isEmpty_1;
        if (_not_1) {
            _builder.append("scmAdapterConnections");
        } else {
            _builder.append("nullptr");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        _builder.newLine();
        return _builder;
    }

    protected String generateConnectionPortID(IInterfaceElement iface, FBNetworkElement elem) {
        String _xifexpression = null;
        boolean _contains = ((CompositeFBType)this.getType()).getFBNetwork().getNetworkElements().contains((Object)elem);
        if (_contains) {
            StringConcatenation _builder = new StringConcatenation();
            _builder.append("GENERATE_CONNECTION_PORT_ID_2_ARG(");
            CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(elem.getName());
            _builder.append((Object)_fORTEStringId);
            _builder.append(", ");
            CharSequence _fORTEStringId_1 = ForteNgExportUtil.getFORTEStringId(iface.getName());
            _builder.append((Object)_fORTEStringId_1);
            _builder.append("), ");
            CharSequence _fbId = this.fbId(elem);
            _builder.append((Object)_fbId);
            _xifexpression = _builder.toString();
        } else {
            StringConcatenation _builder_1 = new StringConcatenation();
            _builder_1.append("GENERATE_CONNECTION_PORT_ID_1_ARG(");
            CharSequence _fORTEStringId_2 = ForteNgExportUtil.getFORTEStringId(iface.getName());
            _builder_1.append((Object)_fORTEStringId_2);
            _builder_1.append("), -1");
            _xifexpression = _builder_1.toString();
        }
        return _xifexpression;
    }

    protected CharSequence _fbId(FBNetworkElement elem) {
        StringConcatenation _builder = new StringConcatenation();
        int _indexOf = this.fbs.indexOf(elem);
        _builder.append((Object)_indexOf);
        return _builder;
    }

    protected CharSequence _fbId(AdapterFB elem) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("CCompositeFB::scmAdapterMarker | ");
        boolean _isPlug = elem.isPlug();
        if (_isPlug) {
            int _plugIndex = this.getPlugIndex(elem);
            _builder.append((Object)_plugIndex);
        } else {
            int _indexOf = ((CompositeFBType)this.getType()).getInterfaceList().getSockets().indexOf((Object)elem.getAdapterDecl());
            _builder.append((Object)_indexOf);
        }
        return _builder;
    }

    protected int getPlugIndex(AdapterFB elem) {
        int _size = ((CompositeFBType)this.getType()).getInterfaceList().getSockets().size();
        int _indexOf = ((CompositeFBType)this.getType()).getInterfaceList().getPlugs().indexOf((Object)elem.getAdapterDecl());
        return _size + _indexOf;
    }

    protected StringBuilder exportEventConns(EList<EventConnection> eConns) {
        StringBuilder retVal = new StringBuilder();
        HashSet<Connection> conSet = new HashSet<Connection>();
        StringBuilder fannedOutConns = new StringBuilder();
        CharSequence _fBClassName = this.getFBClassName();
        String _plus = "const SCFB_FBConnectionData " + String.valueOf(_fBClassName);
        String _plus_1 = _plus + "::scmEventConnections[] = {\n";
        retVal.append(_plus_1);
        for (Connection eConn : eConns) {
            boolean _greaterThan;
            boolean _not;
            boolean _contains = conSet.contains(eConn);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            conSet.add(eConn);
            retVal.append(this.getConnListEntry(eConn));
            int _size = eConn.getSource().getOutputConnections().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                Functions.Function1 _function = it -> {
                    boolean _equals = Objects.equals(it, eConn);
                    return !_equals;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)eConn.getSource().getOutputConnections(), (Functions.Function1)_function);
                for (Connection fannedConn : _filter) {
                    conSet.add(fannedConn);
                    fannedOutConns.append(this.genFannedOutConnString(fannedConn, this.eConnNumber));
                    ++this.fannedOutEventConns;
                }
            }
            ++this.eConnNumber;
        }
        retVal.append("};\n");
        if (this.fannedOutEventConns != 0) {
            CharSequence _fBClassName_1 = this.getFBClassName();
            String _plus_2 = "\nconst SCFB_FBFannedOutConnectionData " + String.valueOf(_fBClassName_1);
            String _plus_3 = _plus_2 + "::scmFannedOutEventConnections[] = {\n";
            retVal.append(_plus_3);
            retVal.append((CharSequence)fannedOutConns);
            retVal.append("};\n");
        }
        return retVal;
    }

    protected StringBuilder exportDataConns(EList<DataConnection> dataConns) {
        StringBuilder retVal = new StringBuilder();
        HashSet<Connection> conSet = new HashSet<Connection>();
        StringBuilder fannedOutConns = new StringBuilder();
        CharSequence _fBClassName = this.getFBClassName();
        String _plus = "const SCFB_FBConnectionData " + String.valueOf(_fBClassName);
        String _plus_1 = _plus + "::scmDataConnections[] = {\n";
        retVal.append(_plus_1);
        for (DataConnection dConn : dataConns) {
            boolean _greaterThan;
            boolean _not;
            boolean _contains = conSet.contains(dConn);
            boolean bl = _not = !_contains;
            if (!_not) continue;
            Connection primConn = this.getPrimaryDataConn(dConn);
            conSet.add(primConn);
            retVal.append(this.getConnListEntry(primConn));
            int _size = primConn.getSource().getOutputConnections().size();
            boolean bl2 = _greaterThan = _size > 1;
            if (_greaterThan) {
                Functions.Function1 _function = it -> {
                    boolean _equals = Objects.equals(it, primConn);
                    return !_equals;
                };
                Iterable _filter = IterableExtensions.filter((Iterable)primConn.getSource().getOutputConnections(), (Functions.Function1)_function);
                for (Connection fannedConn : _filter) {
                    conSet.add(fannedConn);
                    if (this.hasCFBInterfaceDestination(fannedConn) && this.hasCFBInterfaceDestination(primConn)) {
                        fannedOutConns.append("#error a fanout to several composite FB's outputs is currently not supported: ");
                        String _name = this.getName();
                        String _plus_2 = " - " + _name;
                        String _plus_3 = _plus_2 + " FORTE does currently not allow that a data a composite's data connection may be connected to several data outputs of the composite FB.";
                        this.errors.add(_plus_3);
                    }
                    fannedOutConns.append(this.genFannedOutConnString(fannedConn, this.dataConnNumber));
                    ++this.fannedOutDataConns;
                }
            }
            ++this.dataConnNumber;
        }
        retVal.append("};\n");
        if (this.fannedOutDataConns != 0) {
            CharSequence _fBClassName_1 = this.getFBClassName();
            String _plus_2 = "\nconst SCFB_FBFannedOutConnectionData " + String.valueOf(_fBClassName_1);
            String _plus_3 = _plus_2 + "::scmFannedOutDataConnections[] = {\n";
            retVal.append(_plus_3);
            retVal.append((CharSequence)fannedOutConns);
            retVal.append("};\n");
        }
        return retVal;
    }

    protected CharSequence exportAdapterConns(EList<AdapterConnection> adapterConns) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("const SCFB_FBConnectionData ");
        CharSequence _fBClassName = this.getFBClassName();
        _builder.append((Object)_fBClassName);
        _builder.append("::scmAdapterConnections[] = {");
        _builder.newLineIfNotEmpty();
        _builder.append("  ");
        for (AdapterConnection aConn : adapterConns) {
            CharSequence _connListEntry = this.getConnListEntry((Connection)aConn);
            _builder.append((Object)_connListEntry, "  ");
        }
        _builder.newLineIfNotEmpty();
        _builder.append("};");
        _builder.newLine();
        return _builder;
    }

    protected CharSequence getConnListEntry(Connection con) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("  ");
        _builder.append("{");
        String _generateConnectionPortID = this.generateConnectionPortID(con.getSource(), con.getSourceElement());
        _builder.append(_generateConnectionPortID, "  ");
        _builder.append(", ");
        String _generateConnectionPortID_1 = this.generateConnectionPortID(con.getDestination(), con.getDestinationElement());
        _builder.append(_generateConnectionPortID_1, "  ");
        _builder.append("},");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    protected CharSequence genFannedOutConnString(Connection con, int connNum) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("  ");
        _builder.append("{");
        _builder.append((Object)connNum, "  ");
        _builder.append(", ");
        String _generateConnectionPortID = this.generateConnectionPortID(con.getDestination(), con.getDestinationElement());
        _builder.append(_generateConnectionPortID, "  ");
        _builder.append("},");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    @Override
    protected CharSequence generateConnectionInitializer() {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _generateConnectionInitializer = super.generateConnectionInitializer();
        _builder.append((Object)_generateConnectionInitializer);
        CharSequence _generateDataConnectionInitializer = this.generateDataConnectionInitializer((List<VarDeclaration>)((CompositeFBType)this.getType()).getInterfaceList().getOutMappedInOutVars(), true);
        _builder.append((Object)_generateDataConnectionInitializer);
        return _builder;
    }

    private Connection getPrimaryDataConn(DataConnection dataConn) {
        EList _outputConnections = dataConn.getSource().getOutputConnections();
        for (Connection dc : _outputConnections) {
            boolean _hasCFBInterfaceDestination = this.hasCFBInterfaceDestination(dc);
            if (!_hasCFBInterfaceDestination) continue;
            return dc;
        }
        return dataConn;
    }

    private boolean hasCFBInterfaceDestination(Connection conn) {
        IInterfaceElement _destination = null;
        if (conn != null) {
            _destination = conn.getDestination();
        }
        EObject _eContainer = null;
        if (_destination != null) {
            _eContainer = _destination.eContainer();
        }
        EObject _eContainer_1 = null;
        if (_eContainer != null) {
            _eContainer_1 = _eContainer.eContainer();
        }
        return _eContainer_1 instanceof CompositeFBType;
    }

    public CharSequence generateSetFBNetworkInitialValuesDefinition() {
        StringConcatenation _builder = new StringConcatenation();
        Functions.Function1 _function = it -> it.getInterface().getInputVars();
        Functions.Function1 _function_1 = it -> {
            boolean _isNullOrEmpty;
            Value _value = it.getValue();
            String _value_1 = null;
            if (_value != null) {
                _value_1 = _value.getValue();
            }
            return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
        };
        boolean _exists = IterableExtensions.exists((Iterable)IterableExtensions.flatMap(this.fbs, (Functions.Function1)_function), (Functions.Function1)_function_1);
        if (_exists) {
            _builder.append("void ");
            CharSequence _fBClassName = this.getFBClassName();
            _builder.append((Object)_fBClassName);
            _builder.append("::setFBNetworkInitialValues() {");
            _builder.newLineIfNotEmpty();
            for (FB fb : this.fbs) {
                Functions.Function1 _function_2 = it -> {
                    boolean _isNullOrEmpty;
                    Value _value = it.getValue();
                    String _value_1 = null;
                    if (_value != null) {
                        _value_1 = _value.getValue();
                    }
                    return !(_isNullOrEmpty = StringExtensions.isNullOrEmpty(_value_1));
                };
                Iterable _filter = IterableExtensions.filter((Iterable)fb.getInterface().getInputVars(), (Functions.Function1)_function_2);
                for (VarDeclaration variable : _filter) {
                    boolean _isGenericType = ForteNgExportUtil.isGenericType(fb.getType());
                    if (_isGenericType) {
                        _builder.append("  ");
                        _builder.append("if (auto v = ");
                        CharSequence _generateName = ForteNgExportUtil.generateName(fb);
                        _builder.append((Object)_generateName, "  ");
                        _builder.append("->getDataInput(");
                        CharSequence _fORTEStringId = ForteNgExportUtil.getFORTEStringId(variable.getName());
                        _builder.append((Object)_fORTEStringId, "  ");
                        _builder.append(")) { v->setValue(");
                        CharSequence _generateFBNetworkInitialValue = this.generateFBNetworkInitialValue(variable);
                        _builder.append((Object)_generateFBNetworkInitialValue, "  ");
                        _builder.append("); }");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append("  ");
                    CharSequence _generateName_1 = ForteNgExportUtil.generateName(fb);
                    _builder.append((Object)_generateName_1, "  ");
                    _builder.append("->");
                    CharSequence _generateName_2 = ForteNgExportUtil.generateName((IInterfaceElement)variable);
                    _builder.append((Object)_generateName_2, "  ");
                    _builder.append(" = ");
                    CharSequence _generateFBNetworkInitialValue_1 = this.generateFBNetworkInitialValue(variable);
                    _builder.append((Object)_generateFBNetworkInitialValue_1, "  ");
                    _builder.append(";");
                    _builder.newLineIfNotEmpty();
                }
            }
            _builder.append("}");
            _builder.newLine();
            _builder.newLine();
        }
        return _builder;
    }

    public CharSequence generateFBNetworkInitialValue(VarDeclaration decl) {
        try {
            ILanguageSupport _get = this.fbNetworkInitialVariableLanguageSupport.get(decl);
            CharSequence _generate = null;
            if (_get != null) {
                _generate = _get.generate(CollectionLiterals.emptyMap());
            }
            return _generate;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    @Override
    public List<String> getErrors() {
        List<String> _errors = super.getErrors();
        Functions.Function1 _function = it -> it.getErrors();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_errors, (Iterable)_set));
    }

    @Override
    public List<String> getWarnings() {
        List<String> _warnings = super.getWarnings();
        Functions.Function1 _function = it -> it.getWarnings();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_warnings, (Iterable)_set));
    }

    @Override
    public List<String> getInfos() {
        List<String> _infos = super.getInfos();
        Functions.Function1 _function = it -> it.getInfos();
        Set _set = IterableExtensions.toSet((Iterable)IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function));
        return IterableExtensions.toList((Iterable)Iterables.concat(_infos, (Iterable)_set));
    }

    @Override
    public Set<INamedElement> getDependencies(Map<?, ?> options) {
        Set<INamedElement> _dependencies = super.getDependencies(options);
        Functions.Function1 _function = it -> it.getDependencies(options);
        Iterable _flatMap = IterableExtensions.flatMap((Iterable)IterableExtensions.filterNull(this.fbNetworkInitialVariableLanguageSupport.values()), (Functions.Function1)_function);
        return IterableExtensions.toSet((Iterable)Iterables.concat(_dependencies, (Iterable)_flatMap));
    }

    @XbaseGenerated
    protected CharSequence fbId(FBNetworkElement elem) {
        if (elem instanceof AdapterFB) {
            return this._fbId((AdapterFB)elem);
        }
        if (elem != null) {
            return this._fbId(elem);
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(elem).toString());
    }
}

