/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.ui.refactoring;

import com.google.inject.Inject;
import java.util.Comparator;
import java.util.Optional;
import java.util.function.BiConsumer;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Import;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STImport;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.xtext.ide.serializer.hooks.IReferenceUpdaterContext;
import org.eclipse.xtext.ide.serializer.impl.EObjectDescriptionDeltaProvider;
import org.eclipse.xtext.naming.IQualifiedNameConverter;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.resource.IEObjectDescription;
import org.eclipse.xtext.resource.XtextResource;

public class STCoreImportUpdater {
    @Inject
    private IQualifiedNameConverter nameConverter;

    public void updateImports(IReferenceUpdaterContext context) {
        XtextResource xtextResource;
        EObject eObject = context.getResource().getParseResult().getRootASTElement();
        if (eObject instanceof STSource) {
            STSource source = (STSource)eObject;
            this.updateImports(context.getEObjectDescriptionDeltas(), source, Import::setImportedNamespace);
        }
        if ((xtextResource = context.getResource()) instanceof LibraryElementXtextResource) {
            LibraryElementXtextResource libResource = (LibraryElementXtextResource)xtextResource;
            this.updateImports(context.getEObjectDescriptionDeltas(), libResource.getInternalLibraryElement(), Import::setImportedNamespace);
        }
    }

    public void updateImports(EObjectDescriptionDeltaProvider.Deltas deltas, STSource source, BiConsumer<? super Import, String> updater) {
        source.eContents().stream().filter(STImport.class::isInstance).map(STImport.class::cast).forEach(imp -> this.updateImport(deltas, (Import)imp, updater));
    }

    public void updateImports(EObjectDescriptionDeltaProvider.Deltas deltas, LibraryElement libraryElement, BiConsumer<? super Import, String> updater) {
        ImportHelper.getImports((LibraryElement)libraryElement).stream().forEach(imp -> this.updateImport(deltas, (Import)imp, updater));
    }

    protected void updateImport(EObjectDescriptionDeltaProvider.Deltas deltas, Import imp, BiConsumer<? super Import, String> updater) {
        QualifiedName imported = this.nameConverter.toQualifiedName(imp.getImportedNamespace());
        if (STCoreImportUpdater.isWildcardImport(imported)) {
            return;
        }
        Optional<EObjectDescriptionDeltaProvider.Delta> delta = STCoreImportUpdater.findDelta(deltas, imported);
        delta.flatMap(STCoreImportUpdater::findLongestQualifiedName).map(arg_0 -> ((IQualifiedNameConverter)this.nameConverter).toString(arg_0)).ifPresent(s -> updater.accept((Import)imp, (String)s));
    }

    protected static Optional<EObjectDescriptionDeltaProvider.Delta> findDelta(EObjectDescriptionDeltaProvider.Deltas deltas, QualifiedName imported) {
        return deltas.getDeltas().stream().filter(candidate -> candidate.hasQualifiedNameChanged() && STCoreImportUpdater.matchesImport(candidate, imported)).findFirst();
    }

    protected static boolean matchesImport(EObjectDescriptionDeltaProvider.Delta delta, QualifiedName imported) {
        return delta.getSnapshot() != null && delta.getSnapshot().getDescriptions().stream().anyMatch(desc -> desc.getQualifiedName().equals((Object)imported));
    }

    protected static boolean isWildcardImport(QualifiedName imported) {
        return "*".equals(imported.getLastSegment());
    }

    protected static Optional<QualifiedName> findLongestQualifiedName(EObjectDescriptionDeltaProvider.Delta delta) {
        return delta.getDescriptions().stream().map(IEObjectDescription::getQualifiedName).max(Comparator.comparingInt(QualifiedName::getSegmentCount));
    }
}

