/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.commands;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.application.editparts.AbstractContainerContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupContentEditPart;
import org.eclipse.fordiac.ide.application.editparts.GroupEditPart;
import org.eclipse.fordiac.ide.application.editparts.IContainerEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.editparts.UnfoldedSubappContentEditPart;
import org.eclipse.fordiac.ide.application.figures.SubAppForFbNetworkFigure;
import org.eclipse.fordiac.ide.application.policies.ContainerContentLayoutPolicy;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.commands.QualNameAffectedCommand;
import org.eclipse.fordiac.ide.model.commands.change.AbstractChangeContainerBoundsCommand;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.commands.Command;

public class ResizeGroupOrSubappCommand
extends Command
implements ConnectionLayoutTagger,
QualNameAffectedCommand {
    final GraphicalEditPart graphicalEditPart;
    List<FBNetworkElement> fbnetworkElements;
    private Command cmdToExecuteBefore;
    List<AbstractChangeContainerBoundsCommand> changeContainerBoundsCommandList = new ArrayList<AbstractChangeContainerBoundsCommand>();

    public ResizeGroupOrSubappCommand(GraphicalEditPart groupOrSubAppContentGraphicalEditPart) {
        this.graphicalEditPart = groupOrSubAppContentGraphicalEditPart;
    }

    public ResizeGroupOrSubappCommand(GraphicalEditPart groupOrSubAppContentGraphicalEditPart, Command commandToExecuteBefore) {
        this(groupOrSubAppContentGraphicalEditPart);
        this.cmdToExecuteBefore = commandToExecuteBefore;
    }

    public ResizeGroupOrSubappCommand(GraphicalEditPart groupOrSubAppContentGraphicalEditPart, List<FBNetworkElement> fbnetworkElements) {
        this(groupOrSubAppContentGraphicalEditPart);
        this.fbnetworkElements = fbnetworkElements;
    }

    public ResizeGroupOrSubappCommand(GraphicalEditPart groupOrSubAppContentGraphicalEditPart, List<FBNetworkElement> fbnetworkElements, Command commandToExecuteBefore) {
        this(groupOrSubAppContentGraphicalEditPart, fbnetworkElements);
        this.cmdToExecuteBefore = commandToExecuteBefore;
    }

    public void execute() {
        if (this.cmdToExecuteBefore != null && this.cmdToExecuteBefore.canExecute()) {
            this.cmdToExecuteBefore.execute();
            this.getViewer().flush();
        } else {
            this.cmdToExecuteBefore = null;
        }
        if (this.isUnlockedGroup() || this.isExpandedAndUnlockedSubapp()) {
            GraphicalEditPart parent = this.getTargetContainerEP();
            while (parent != null) {
                this.addChangeContainerBoundCommand(this.checkAndCreateResizeCommand(parent, this.fbnetworkElements));
                this.addChangeContainerBoundCommand(ResizeGroupOrSubappCommand.checkAndCreateResizeInterfaceContentCommand(parent));
                parent = ResizeGroupOrSubappCommand.findNestedGraphicalEditPart(parent);
                this.fbnetworkElements = null;
            }
        }
    }

    public boolean canExecute() {
        return this.graphicalEditPart != null;
    }

    public void undo() {
        int i = this.changeContainerBoundsCommandList.size() - 1;
        while (i >= 0) {
            if (this.changeContainerBoundsCommandList.get(i) != null && this.changeContainerBoundsCommandList.get(i).canUndo()) {
                this.changeContainerBoundsCommandList.get(i).undo();
            }
            --i;
        }
        if (this.cmdToExecuteBefore != null) {
            this.cmdToExecuteBefore.undo();
        }
    }

    public boolean canUndo() {
        return this.cmdToExecuteBefore != null && this.cmdToExecuteBefore.canUndo() || !this.changeContainerBoundsCommandList.isEmpty();
    }

    public void redo() {
        if (this.cmdToExecuteBefore != null) {
            this.cmdToExecuteBefore.redo();
        }
        for (AbstractChangeContainerBoundsCommand changeBoundscmd : this.changeContainerBoundsCommandList) {
            if (changeBoundscmd == null || !changeBoundscmd.canRedo()) continue;
            changeBoundscmd.redo();
        }
    }

    public boolean canRedo() {
        return this.cmdToExecuteBefore != null && this.cmdToExecuteBefore.canRedo() || !this.changeContainerBoundsCommandList.isEmpty();
    }

    private boolean isUnlockedGroup() {
        GroupEditPart group;
        GraphicalEditPart graphicalEditPart;
        GroupContentEditPart groupContent;
        GraphicalEditPart graphicalEditPart2 = this.graphicalEditPart;
        return graphicalEditPart2 instanceof GroupContentEditPart && !(groupContent = (GroupContentEditPart)graphicalEditPart2).getModel().getGroup().isLocked() || (graphicalEditPart = this.graphicalEditPart) instanceof GroupEditPart && !(group = (GroupEditPart)graphicalEditPart).getModel().isLocked();
    }

    private boolean isExpandedAndUnlockedSubapp() {
        SubAppForFBNetworkEditPart subAppEP;
        GraphicalEditPart graphicalEditPart;
        UnfoldedSubappContentEditPart subAppContent;
        GraphicalEditPart graphicalEditPart2 = this.graphicalEditPart;
        return graphicalEditPart2 instanceof UnfoldedSubappContentEditPart && (subAppContent = (UnfoldedSubappContentEditPart)graphicalEditPart2).getContainerElement().isUnfolded() && !subAppContent.getContainerElement().isLocked() || (graphicalEditPart = this.graphicalEditPart) instanceof SubAppForFBNetworkEditPart && (subAppEP = (SubAppForFBNetworkEditPart)graphicalEditPart).getModel().isUnfolded() && !subAppEP.getModel().isLocked();
    }

    private GraphicalEditPart getTargetContainerEP() {
        GraphicalEditPart graphicalEditPart = this.graphicalEditPart;
        if (graphicalEditPart instanceof IContainerEditPart) {
            IContainerEditPart iContainerEP = (IContainerEditPart)graphicalEditPart;
            return iContainerEP.getContentEP();
        }
        return this.graphicalEditPart;
    }

    private static GraphicalEditPart findNestedGraphicalEditPart(GraphicalEditPart child) {
        if (child.getParent() != null && child.getParent().getParent() instanceof AbstractContainerContentEditPart) {
            return (GraphicalEditPart)child.getParent().getParent();
        }
        return null;
    }

    private AbstractChangeContainerBoundsCommand checkAndCreateResizeCommand(GraphicalEditPart containerEP, List<FBNetworkElement> children) {
        this.getViewer().flush();
        if (children == null && containerEP instanceof AbstractContainerContentEditPart) {
            AbstractContainerContentEditPart abstractContainerContentEditPart = (AbstractContainerContentEditPart)containerEP;
            children = abstractContainerContentEditPart.getModel().getNetworkElements();
        }
        if (children != null) {
            Rectangle fbBounds = this.getFBBounds((List<FBNetworkElement>)children);
            Rectangle containerBounds = ContainerContentLayoutPolicy.getContainerAreaBounds(containerEP);
            if (fbBounds != null && !containerBounds.contains(fbBounds)) {
                fbBounds.union(containerBounds);
                FBNetworkElement container = ResizeGroupOrSubappCommand.getContainer(containerEP);
                if (container != null) {
                    return ContainerContentLayoutPolicy.createChangeBoundsCommand(container, containerBounds, fbBounds);
                }
            }
        }
        return null;
    }

    private static AbstractChangeContainerBoundsCommand checkAndCreateResizeInterfaceContentCommand(GraphicalEditPart containerEP) {
        GraphicalEditPart fullContentGraphicalEditPart;
        IFigure iFigure;
        EditPart editPart = containerEP.getParent();
        if (editPart instanceof GraphicalEditPart && (iFigure = (fullContentGraphicalEditPart = (GraphicalEditPart)editPart).getFigure()) instanceof SubAppForFbNetworkFigure) {
            SubAppForFbNetworkFigure subappFigure = (SubAppForFbNetworkFigure)iFigure;
            Rectangle fullContainerBounds = ContainerContentLayoutPolicy.getContainerAreaBounds(fullContentGraphicalEditPart);
            Rectangle mainFig = subappFigure.getExpandedContentArea().getBounds();
            Rectangle leftFig = subappFigure.getExpandedInputFigure().getBounds();
            Rectangle rightFig = subappFigure.getExpandedOutputFigure().getBounds();
            Rectangle newFig1 = fullContainerBounds.getCopy();
            newFig1.width = mainFig.width + leftFig.width + rightFig.width + subappFigure.getInsets().left + subappFigure.getInsets().right;
            if (fullContainerBounds.width < newFig1.width) {
                FBNetworkElement container = ResizeGroupOrSubappCommand.getSubappContainer(fullContentGraphicalEditPart);
                return ContainerContentLayoutPolicy.createChangeBoundsCommand(container, fullContainerBounds, newFig1);
            }
        }
        return null;
    }

    private static FBNetworkElement getContainer(GraphicalEditPart containerEP) {
        FBNetworkElement fBNetworkElement;
        if (containerEP instanceof AbstractContainerContentEditPart) {
            AbstractContainerContentEditPart abstractContainerEP = (AbstractContainerContentEditPart)containerEP;
            fBNetworkElement = abstractContainerEP.getContainerElement();
        } else {
            fBNetworkElement = null;
        }
        return fBNetworkElement;
    }

    private static FBNetworkElement getSubappContainer(GraphicalEditPart containerEP) {
        if (containerEP instanceof SubAppForFBNetworkEditPart) {
            SubAppForFBNetworkEditPart subAppForFBNetworkEditPart = (SubAppForFBNetworkEditPart)containerEP;
            return subAppForFBNetworkEditPart.getModel();
        }
        return null;
    }

    private void addChangeContainerBoundCommand(AbstractChangeContainerBoundsCommand cmd) {
        if (cmd != null && cmd.canExecute()) {
            this.changeContainerBoundsCommandList.add(cmd);
            cmd.execute();
        }
    }

    private EditPartViewer getViewer() {
        return this.graphicalEditPart.getViewer();
    }

    private Rectangle getFBBounds(List<FBNetworkElement> children) {
        Map editPartRegistry = this.getViewer().getEditPartRegistry();
        Rectangle fbBounds = null;
        for (FBNetworkElement fbe : children) {
            GraphicalEditPart graphicalEP;
            IFigure fbFigure;
            Object v = editPartRegistry.get(fbe);
            if (v instanceof GraphicalEditPart && (fbFigure = (graphicalEP = (GraphicalEditPart)v).getFigure()) != null) {
                if (fbBounds == null) {
                    fbBounds = fbFigure.getBounds().getCopy();
                } else {
                    fbBounds.union(fbFigure.getBounds().getCopy());
                }
            }
            ResizeGroupOrSubappCommand.addValueBounds(fbBounds, fbe, editPartRegistry);
        }
        return fbBounds;
    }

    private static void addValueBounds(Rectangle fbBounds, FBNetworkElement fbe, Map<Object, EditPart> editPartRegistry) {
        fbe.getInterface().getInputVars().stream().filter(Objects::nonNull).map(ie -> (EditPart)editPartRegistry.get(ie.getValue())).filter(GraphicalEditPart.class::isInstance).forEach(ep -> {
            Rectangle pin = ((GraphicalEditPart)ep).getFigure().getBounds().getCopy();
            fbBounds.union(pin);
        });
    }

    public Set<EObject> getAffectedObjects() {
        return Collections.emptySet();
    }

    public String getOldQualName(INamedElement element) {
        QualNameAffectedCommand cmd = this.getQualNameAffectedCommand();
        if (cmd != null) {
            return cmd.getOldQualName(element);
        }
        return null;
    }

    public String getNewQualName(INamedElement element) {
        QualNameAffectedCommand cmd = this.getQualNameAffectedCommand();
        if (cmd != null) {
            return cmd.getNewQualName(element);
        }
        return null;
    }

    public List<INamedElement> getChangedElements() {
        QualNameAffectedCommand cmd = this.getQualNameAffectedCommand();
        if (cmd != null) {
            return cmd.getChangedElements();
        }
        return Collections.emptyList();
    }

    private QualNameAffectedCommand getQualNameAffectedCommand() {
        Command command = this.cmdToExecuteBefore;
        if (command instanceof QualNameAffectedCommand) {
            QualNameAffectedCommand cmd = (QualNameAffectedCommand)command;
            return cmd;
        }
        return null;
    }
}

