/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.editparts;

import org.eclipse.core.runtime.Assert;
import org.eclipse.fordiac.ide.application.editparts.InstanceContract;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.ui.utils.ContractspecResourceProvider;
import org.eclipse.jface.text.contentassist.ContentAssistEvent;
import org.eclipse.jface.text.contentassist.ICompletionListener;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditor;
import org.eclipse.xtext.ui.editor.embedded.EmbeddedEditorModelAccess;

public class ContractCellEditor
extends CellEditor {
    private final InstanceContract contract;
    private EmbeddedEditor editor;
    private EmbeddedEditorModelAccess modelAccess;
    private boolean popupOpen = false;
    private boolean closing = false;

    public ContractCellEditor(Composite composite, InstanceContract contract) {
        this.contract = contract;
        this.setStyle(66);
        this.create(composite);
    }

    public ContractCellEditor(Composite composite, int style, InstanceContract contract) {
        this.contract = contract;
        this.setStyle(style);
        this.create(composite);
    }

    protected Control createControl(Composite parent) {
        this.editor = ContractspecResourceProvider.getEmbeddedEditorBuilder((FBNetworkElement)this.contract.getSubApp()).showLineNumbers().withParent(parent);
        this.modelAccess = this.editor.createPartialEditor();
        this.editor.getViewer().getTextWidget().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ContractCellEditor.this.popupOpen || ContractCellEditor.this.closing) {
                    return;
                }
                Display.getCurrent().timerExec(100, () -> {
                    if (!ContractCellEditor.this.editor.getViewer().getTextWidget().isFocusControl()) {
                        if (!ContractCellEditor.this.contract.getContract().equals(ContractCellEditor.this.modelAccess.getEditablePart())) {
                            ContractCellEditor.this.valueChanged(true, true);
                        }
                        ContractCellEditor.this.focusLost();
                    }
                });
            }
        });
        this.editor.getViewer().getTextWidget().addTraverseListener(e -> {
            if (!this.popupOpen && e.keyCode == 27) {
                this.closing = true;
                this.focusLost();
            }
        });
        this.editor.getViewer().getContentAssistantFacade().addCompletionListener(new ICompletionListener(){

            public void selectionChanged(ICompletionProposal proposal, boolean smartToggle) {
            }

            public void assistSessionStarted(ContentAssistEvent event) {
                ContractCellEditor.this.popupOpen = true;
            }

            public void assistSessionEnded(ContentAssistEvent event) {
                ContractCellEditor.this.doSetFocus();
                ContractCellEditor.this.popupOpen = false;
            }
        });
        return this.editor.getViewer().getControl();
    }

    protected Object doGetValue() {
        return this.modelAccess.getEditablePart();
    }

    protected void doSetValue(Object value) {
        Assert.isTrue((boolean)(value instanceof String));
        this.modelAccess.updateModel((String)value);
    }

    protected void doSetFocus() {
        this.editor.getViewer().getTextWidget().setFocus();
    }

    public boolean isUndoEnabled() {
        return true;
    }

    public void performUndo() {
        this.editor.getViewer().getUndoManager().undo();
    }

    public boolean isRedoEnabled() {
        return true;
    }

    public void performRedo() {
        this.editor.getViewer().getUndoManager().redo();
    }
}

