/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.figures;

import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.Cursors;
import org.eclipse.draw2d.Figure;
import org.eclipse.draw2d.GridData;
import org.eclipse.draw2d.GridLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.LightweightSystem;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.draw2d.RoundedRectangle;
import org.eclipse.draw2d.ScrollBar;
import org.eclipse.draw2d.ScrollPane;
import org.eclipse.draw2d.ScrollPaneLayout;
import org.eclipse.draw2d.ScrollPaneSolver;
import org.eclipse.draw2d.Shape;
import org.eclipse.draw2d.ToolbarLayout;
import org.eclipse.draw2d.Viewport;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.fordiac.ide.application.editparts.EditorWithInterfaceEditPart;
import org.eclipse.fordiac.ide.application.editparts.SubAppForFBNetworkEditPart;
import org.eclipse.fordiac.ide.application.figures.ExpandedSubappInterfaceLayout;
import org.eclipse.fordiac.ide.application.figures.FBNetworkElementFigure;
import org.eclipse.fordiac.ide.application.figures.InstanceCommentFigure;
import org.eclipse.fordiac.ide.application.utilities.ExpandedInterfacePositionMap;
import org.eclipse.fordiac.ide.gef.draw2d.AdvancedLineBorder;
import org.eclipse.fordiac.ide.gef.figures.BorderedRoundedRectangle;
import org.eclipse.fordiac.ide.gef.figures.FBShapeShadowBorder;
import org.eclipse.fordiac.ide.gef.figures.RoundedRectangleShadowBorder;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class SubAppForFbNetworkFigure
extends FBNetworkElementFigure {
    private InstanceCommentFigure commentFigure;
    private RoundedRectangle expandedMainFigure;
    private Shape expandedInputFigure;
    private IFigure expandedContentArea;
    private Shape expandedOutputFigure;
    private final int minExpandedInterfaceBarWidth;
    private final ExpandedInterfacePositionMap interfacePositions;

    public SubAppForFbNetworkFigure(SubApp model, SubAppForFBNetworkEditPart editPart, int minExpandedInterfaceBarWidth, int maxTypeLabelSize) {
        super((FBNetworkElement)model, maxTypeLabelSize);
        this.minExpandedInterfaceBarWidth = minExpandedInterfaceBarWidth + 6;
        this.interfacePositions = editPart.getInterfacePositionMap();
        this.updateTypeLabel(model);
        this.updateExpandedFigure();
    }

    public InstanceCommentFigure getCommentFigure() {
        return this.commentFigure;
    }

    public void updateTypeLabel(SubApp model) {
        this.getTypeLabel().setText(model.isTyped() ? model.getTypeName() : "");
        if (!model.isTyped()) {
            this.getTypeLabel().setIcon(FordiacImage.ICON_SUB_APP.getImage());
        } else {
            this.getTypeLabel().setIcon(FordiacImage.ICON_SUB_APP_TYPE.getImage());
        }
    }

    protected SubApp getModel() {
        return (SubApp)super.getModel();
    }

    public void setBackgroundColor(Color bg) {
        this.setInterfaceBarAlpha(bg != null ? 100 : 255);
        super.setBackgroundColor(bg);
    }

    public RoundedRectangle getExpandedMainFigure() {
        return this.expandedMainFigure;
    }

    public IFigure getExpandedContentArea() {
        return this.expandedContentArea;
    }

    public IFigure getExpandedInputFigure() {
        return this.expandedInputFigure;
    }

    public IFigure getExpandedOutputFigure() {
        return this.expandedOutputFigure;
    }

    public void refreshComment() {
        if (this.commentFigure != null) {
            this.commentFigure.setText(this.getModel().getComment());
        }
    }

    public void layoutExpandedInterface() {
        if (this.getParent() != null) {
            this.interfacePositions.calculate();
            this.expandedInputFigure.getLayoutManager().layout((IFigure)this.expandedInputFigure);
            this.expandedOutputFigure.getLayoutManager().layout((IFigure)this.expandedOutputFigure);
        }
    }

    public final void updateExpandedFigure() {
        if (this.getModel().isUnfolded()) {
            if (this.expandedMainFigure == null) {
                this.transformToExpandedSubapp();
            }
            Display.getDefault().asyncExec(this::layoutExpandedInterface);
        } else if (this.expandedMainFigure != null) {
            this.transformToCollapsedSubapp();
        }
    }

    private void transformToExpandedSubapp() {
        this.setBorder(null);
        GridData layoutConstraint = new GridData(1808);
        this.setConstraint((IFigure)this.getFbFigureContainer(), layoutConstraint);
        this.createExpandedMainFigure();
        this.removeTopMiddleBottom();
        this.addComment();
        this.expandedInputFigure = this.createInterfaceBar((IFigure)this.expandedMainFigure, true);
        this.createContentContainer();
        this.expandedOutputFigure = this.createInterfaceBar((IFigure)this.expandedMainFigure, false);
        this.getFbFigureContainer().invalidateTree();
    }

    private void transformToCollapsedSubapp() {
        this.getFbFigureContainer().setBorder(null);
        this.setConstraint((IFigure)this.getFbFigureContainer(), SubAppForFbNetworkFigure.createDefaultFBContainerLayoutData());
        this.setBorder((Border)new FBShapeShadowBorder());
        this.getFbFigureContainer().remove((IFigure)this.expandedMainFigure);
        this.expandedMainFigure = null;
        this.addTop();
        this.addTopIOs();
        this.addMiddle();
        this.addBottom();
        this.addBottomIOs();
        this.getFbFigureContainer().invalidateTree();
    }

    private void createExpandedMainFigure() {
        this.expandedMainFigure = new BorderedRoundedRectangle();
        this.expandedMainFigure.setOutline(false);
        this.expandedMainFigure.setOpaque(false);
        this.expandedMainFigure.setCornerDimensions(new Dimension(6, 6));
        this.expandedMainFigure.setBorder((Border)new RoundedRectangleShadowBorder());
        this.expandedMainFigure.setLayoutManager((LayoutManager)SubAppForFbNetworkFigure.createExpandedMainFigureLayout());
        GridData gridData = new GridData(1808);
        this.getFbFigureContainer().add((IFigure)this.expandedMainFigure, (Object)gridData);
    }

    private void createContentContainer() {
        this.expandedContentArea = new Figure();
        GridLayout expContentLayout = new GridLayout();
        expContentLayout.marginHeight = 0;
        expContentLayout.marginWidth = 0;
        expContentLayout.verticalSpacing = 0;
        expContentLayout.horizontalSpacing = 0;
        this.expandedContentArea.setLayoutManager((LayoutManager)expContentLayout);
        GridData gridData = new GridData(1808);
        this.expandedMainFigure.add(this.expandedContentArea, (Object)gridData);
    }

    private Shape createInterfaceBar(IFigure parent, boolean isInput) {
        RoundedRectangle interfaceBar = new RoundedRectangle(){

            public Dimension getPreferredSize(int wHint, int hHint) {
                Dimension prefSize = super.getPreferredSize(wHint, hHint);
                prefSize.union(this.getMinimumSize());
                return prefSize;
            }
        };
        interfaceBar.setMinimumSize(new Dimension(this.minExpandedInterfaceBarWidth, -1));
        interfaceBar.setOutline(false);
        interfaceBar.setBackgroundColor(EditorWithInterfaceEditPart.INTERFACE_BAR_BG_COLOR);
        interfaceBar.setLayoutManager((LayoutManager)new ExpandedSubappInterfaceLayout(this.interfacePositions, isInput));
        Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();
        LightweightSystem lws = new LightweightSystem((Canvas)shell);
        ScrollPane scrollPane = new ScrollPane();
        scrollPane.setLayoutManager((LayoutManager)new ExpandedInterfaceScrollPaneLayout(isInput));
        scrollPane.setVerticalScrollBarVisibility(1);
        scrollPane.setHorizontalScrollBarVisibility(0);
        scrollPane.setContents((IFigure)interfaceBar);
        lws.setContents((IFigure)scrollPane);
        parent.add((IFigure)scrollPane, (Object)new GridData(1, 4, false, true));
        return interfaceBar;
    }

    private void removeTopMiddleBottom() {
        this.getFbFigureContainer().remove((IFigure)this.getTop());
        this.getFbFigureContainer().remove((IFigure)this.getMiddleContainer());
        this.getFbFigureContainer().remove((IFigure)this.getBottom());
    }

    private void addComment() {
        int top;
        Figure commentContainer = new Figure();
        commentContainer.setLayoutManager((LayoutManager)new ToolbarLayout());
        this.expandedMainFigure.add((IFigure)commentContainer, (Object)SubAppForFbNetworkFigure.createCommentLayoutData(), 0);
        this.commentFigure = new InstanceCommentFigure();
        AdvancedLineBorder commentLineSeperator = new AdvancedLineBorder(4);
        this.commentFigure.setBorder((Border)commentLineSeperator);
        this.commentFigure.setCursor(Cursors.SIZEALL);
        commentContainer.add((IFigure)this.commentFigure);
        this.refreshComment();
        int lineHeight = (int)CoordinateConverter.INSTANCE.getLineHeight();
        int bottom = top = lineHeight / 2;
        if (top + bottom != lineHeight) {
            top += lineHeight - (top + bottom);
        }
        commentContainer.setBorder((Border)new MarginBorder(top, 5, bottom, 5));
    }

    private static GridData createCommentLayoutData() {
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = 3;
        return gridData;
    }

    public int getExpandedIOHeight() {
        if (this.getModel().isUnfolded()) {
            return Math.max(this.expandedInputFigure.getPreferredSize().height, this.expandedOutputFigure.getPreferredSize().height);
        }
        return -1;
    }

    private void setInterfaceBarAlpha(int alpha) {
        if (this.expandedInputFigure != null) {
            this.expandedInputFigure.setAlpha(alpha);
        }
        if (this.expandedOutputFigure != null) {
            this.expandedOutputFigure.setAlpha(alpha);
        }
    }

    protected static GridLayout createExpandedMainFigureLayout() {
        GridLayout topLayout = new GridLayout(3, false);
        topLayout.marginHeight = 0;
        topLayout.marginWidth = 0;
        topLayout.verticalSpacing = 0;
        topLayout.horizontalSpacing = 0;
        return topLayout;
    }

    protected static GridData createInterfaceBarGroupLayoutData() {
        return new GridData(4, 128, true, false);
    }

    private static class ExpandedInterfaceScrollPaneLayout
    extends ScrollPaneLayout {
        private final boolean isInput;

        public ExpandedInterfaceScrollPaneLayout(boolean isInput) {
            this.isInput = isInput;
        }

        public void layout(IFigure parent) {
            ScrollPane scrollpane = (ScrollPane)parent;
            Viewport viewport = scrollpane.getViewport();
            ScrollBar hBar = scrollpane.getHorizontalScrollBar();
            ScrollBar vBar = scrollpane.getVerticalScrollBar();
            if (this.isInput) {
                ExpandedInterfaceScrollPaneLayout.layoutInput(parent, scrollpane, viewport, hBar, vBar);
            } else {
                ExpandedInterfaceScrollPaneLayout.layoutOutput(parent, scrollpane, viewport, hBar, vBar);
            }
            ExpandedInterfaceScrollPaneLayout.incrementPage(vBar);
        }

        private static void incrementPage(ScrollBar vBar) {
            int vStepInc = vBar.getStepIncrement();
            int vPageInc = vBar.getRangeModel().getExtent() - vStepInc;
            if (vPageInc < vStepInc) {
                vPageInc = vStepInc;
            }
            vBar.setPageIncrement(vPageInc);
        }

        private static ScrollPaneSolver.Result solve(Rectangle clientArea, ScrollPane scrollpane, Viewport viewport, ScrollBar hBar, ScrollBar vBar) {
            return ScrollPaneSolver.solve((Rectangle)clientArea, (Viewport)viewport, (int)scrollpane.getHorizontalScrollBarVisibility(), (int)scrollpane.getVerticalScrollBarVisibility(), (int)vBar.getPreferredSize().width, (int)hBar.getPreferredSize().height);
        }

        private static void layoutOutput(IFigure parent, ScrollPane scrollpane, Viewport viewport, ScrollBar hBar, ScrollBar vBar) {
            ScrollPaneSolver.Result result = ExpandedInterfaceScrollPaneLayout.solve(parent.getClientArea(), scrollpane, viewport, hBar, vBar);
            if (result.showV) {
                vBar.setBounds(new Rectangle(result.viewportArea.right(), result.viewportArea.y, result.insets.right, result.viewportArea.height));
            }
            vBar.setVisible(result.showV);
        }

        private static void layoutInput(IFigure parent, ScrollPane scrollpane, Viewport viewport, ScrollBar hBar, ScrollBar vBar) {
            Rectangle clientArea = parent.getClientArea().getCopy();
            ScrollPaneSolver.Result result = ExpandedInterfaceScrollPaneLayout.solve(clientArea, scrollpane, viewport, hBar, vBar);
            if (result.showV) {
                int scrollBarWidth = vBar.getPreferredSize().width;
                clientArea.x += scrollBarWidth;
                ScrollPaneSolver.Result scrollResult = ExpandedInterfaceScrollPaneLayout.solve(clientArea, scrollpane, viewport, hBar, vBar);
                vBar.setBounds(new Rectangle(scrollResult.viewportArea.left() - scrollBarWidth, scrollResult.viewportArea.y, scrollResult.insets.right, scrollResult.viewportArea.height));
            }
            vBar.setVisible(result.showV);
        }
    }
}

