/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.application.properties;

import java.util.ArrayList;
import java.util.Arrays;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.application.Messages;
import org.eclipse.fordiac.ide.application.editparts.AbstractStructManipulatorEditPart;
import org.eclipse.fordiac.ide.application.editparts.StructInterfaceEditPart;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.gef.widgets.TypeSelectionWidget;
import org.eclipse.fordiac.ide.model.AbstractStructTreeNode;
import org.eclipse.fordiac.ide.model.StructTreeContentProvider;
import org.eclipse.fordiac.ide.model.StructTreeLabelProvider;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.nat.StructuredTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.OpenStructMenu;
import org.eclipse.fordiac.ide.model.ui.widgets.StructuredTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.ui.FordiacMessages;
import org.eclipse.fordiac.ide.ui.editors.EditorUtils;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.viewers.CheckboxTreeViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.ICheckStateProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.TreeViewerColumn;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.MenuEvent;
import org.eclipse.swt.events.MenuListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.EditorPart;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public abstract class StructManipulatorSection
extends AbstractSection
implements CommandStackEventListener {
    private TypeSelectionWidget typeSelectionWidget;
    private CLabel muxLabel;
    private CheckboxTreeViewer memberVarViewer;
    protected boolean initTree = true;

    protected FBNetworkElement getInputType(Object input) {
        if (input instanceof AbstractStructManipulatorEditPart) {
            AbstractStructManipulatorEditPart structManEP = (AbstractStructManipulatorEditPart)((Object)input);
            return structManEP.getModel();
        }
        if (input instanceof StructManipulator) {
            StructManipulator structMan = (StructManipulator)input;
            return structMan;
        }
        if (input instanceof StructInterfaceEditPart) {
            StructInterfaceEditPart structIEEP = (StructInterfaceEditPart)((Object)input);
            return structIEEP.getModel().getFBNetworkElement();
        }
        return null;
    }

    protected StructManipulator getType() {
        Object object = this.type;
        if (object instanceof StructManipulator) {
            StructManipulator structMan = (StructManipulator)object;
            return structMan;
        }
        return null;
    }

    private void createStructSelector(Composite composite) {
        Composite structComp = this.getWidgetFactory().createComposite(composite);
        structComp.setLayout((Layout)new GridLayout(2, false));
        structComp.setLayoutData((Object)new GridData(4, 4, true, false));
        this.muxLabel = this.getWidgetFactory().createCLabel(structComp, Messages.StructManipulatorSection_STRUCTURED_TYPE);
        this.typeSelectionWidget = new TypeSelectionWidget(this.getWidgetFactory(), this::handleStructSelectionChanged);
        this.typeSelectionWidget.createControls(structComp);
        this.typeSelectionWidget.setEditable(true);
    }

    protected void refreshStructTypeTable() {
        if (this.memberVarViewer.getInput() == this.getType()) {
            return;
        }
        Object[] expandedElements = this.memberVarViewer.getExpandedElements();
        TreePath[] expandedTreePaths = this.memberVarViewer.getExpandedTreePaths();
        Tree memberViewerTree = this.memberVarViewer.getTree();
        TreePath topItemPath = StructManipulatorSection.getTreePath(memberViewerTree.getTopItem());
        this.memberVarViewer.setInput((Object)this.getType());
        this.memberVarViewer.setExpandedElements(expandedElements);
        this.memberVarViewer.setExpandedTreePaths(expandedTreePaths);
        if (topItemPath != null) {
            Display.getDefault().asyncExec(() -> {
                memberViewerTree.update();
                memberViewerTree.redraw();
                TreeItem topItem = this.getTreeItemFromPath(topItemPath);
                if (topItem != null && !topItem.isDisposed()) {
                    TreeItem[] originalSelection = memberViewerTree.getSelection();
                    memberViewerTree.setSelection(originalSelection);
                    memberViewerTree.setTopItem(topItem);
                }
            });
        }
    }

    private static TreePath getTreePath(TreeItem item) {
        if (item == null || item.isDisposed()) {
            return null;
        }
        ArrayList<Object> pathElements = new ArrayList<Object>();
        TreeItem currentItem = item;
        while (currentItem != null) {
            pathElements.add(0, currentItem.getData());
            currentItem = currentItem.getParentItem();
        }
        return new TreePath(pathElements.toArray());
    }

    private TreeItem getTreeItemFromPath(TreePath path) {
        if (path.getSegmentCount() == 0) {
            return null;
        }
        TreeItem currentItem = StructManipulatorSection.findItemByData(this.memberVarViewer.getTree().getItems(), path.getSegment(0));
        int i = 1;
        while (i < path.getSegmentCount() && currentItem != null) {
            currentItem = StructManipulatorSection.findItemByData(currentItem.getItems(), path.getSegment(i));
            ++i;
        }
        return currentItem;
    }

    private static TreeItem findItemByData(TreeItem[] items, Object data) {
        return Arrays.stream(items).filter(i -> i.getData() != null && i.getData().equals(data)).findAny().orElse(null);
    }

    protected void handleStructSelectionChanged(String newStructName) {
        if (this.getType() != null && this.newStructSelected(newStructName)) {
            EObject eObject;
            StructuredType packageStruct = (StructuredType)ImportHelper.resolveImport((String)PackageNameHelper.extractPlainTypeName((String)newStructName), (EObject)this.getType(), name -> {
                StructuredType temp = this.getDataTypeLib().getStructuredType(name);
                return IecTypes.GenericTypes.isAnyType((DataType)temp) ? null : temp;
            }, name -> null);
            StructuredType newStruct = this.getDataTypeLib().getStructuredType(newStructName);
            AddNewImportCommand importCommand = null;
            if (packageStruct == null && newStruct != IecTypes.GenericTypes.ANY_STRUCT && (eObject = EcoreUtil.getRootContainer((EObject)this.getType())) instanceof LibraryElement) {
                LibraryElement libraryElement = (LibraryElement)eObject;
                importCommand = new AddNewImportCommand(libraryElement, newStructName);
            }
            ChangeStructCommand cmd = new ChangeStructCommand(this.getType(), (DataType)newStruct);
            this.executeCommand(cmd.chain(importCommand));
            StructManipulatorSection.updateStructManipulatorFB(cmd.getNewMux());
        }
    }

    public boolean newStructSelected(String newStructName) {
        return !newStructName.equalsIgnoreCase(PackageNameHelper.getFullTypeName((LibraryElement)this.getType().getDataType())) && this.getDataTypeLib().getStructuredType(newStructName) != null;
    }

    protected static void updateStructManipulatorFB(StructManipulator newMux) {
        Display.getDefault().asyncExec(() -> {
            EditorPart activeEditor = (EditorPart)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor();
            GraphicalViewer viewer = (GraphicalViewer)activeEditor.getAdapter(GraphicalViewer.class);
            if (viewer != null) {
                viewer.flush();
                EditorUtils.refreshPropertySheetWithSelection((IEditorPart)activeEditor, (EditPartViewer)viewer, (Object)viewer.getEditPartForModel((Object)newMux));
            }
        });
    }

    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        this.createStructSelector(parent);
        Group memberVarGroup = this.getWidgetFactory().createGroup(parent, Messages.StructManipulatorSection_Contained_variables);
        this.createMemberVariableViewer((Composite)memberVarGroup);
        memberVarGroup.setLayout((Layout)new GridLayout(1, true));
        memberVarGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        if (this.getCheckStateProvider() != null) {
            this.getViewer().setCheckStateProvider(this.getCheckStateProvider());
        }
        if (this.getCheckStateListener() != null) {
            this.getViewer().addCheckStateListener(this.getCheckStateListener());
        }
    }

    protected abstract ICheckStateProvider getCheckStateProvider();

    protected abstract ICheckStateListener getCheckStateListener();

    private void createMemberVariableViewer(Composite parent) {
        this.memberVarViewer = StructManipulatorSection.createTreeViewer(parent);
        StructManipulatorSection.configureTreeLayout((TreeViewer)this.memberVarViewer);
        this.memberVarViewer.setContentProvider((IContentProvider)this.getContentProvider());
        this.memberVarViewer.setLabelProvider((IBaseLabelProvider)this.getLabelProvider());
        GridLayoutFactory.fillDefaults().generateLayout(parent);
        this.createContextMenu(this.memberVarViewer.getControl());
    }

    protected LabelProvider getLabelProvider() {
        return new StructTreeLabelProvider();
    }

    protected ITreeContentProvider getContentProvider() {
        return new StructTreeContentProvider();
    }

    private static CheckboxTreeViewer createTreeViewer(Composite parent) {
        CheckboxTreeViewer viewer = new CheckboxTreeViewer(parent);
        viewer.setUseHashlookup(true);
        return viewer;
    }

    private void createContextMenu(Control ctrl) {
        Menu openEditorMenu = new Menu((Control)this.memberVarViewer.getTree());
        final MenuItem openItem = new MenuItem(openEditorMenu, 0);
        openItem.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                StructuredType sel = StructManipulatorSection.this.getSelectedStructuredType();
                if (sel != null) {
                    OpenStructMenu.openStructEditor((IFile)sel.getTypeEntry().getFile());
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
                this.widgetSelected(e);
            }
        });
        openItem.setText(FordiacMessages.OPEN_TYPE_EDITOR_MESSAGE);
        openEditorMenu.addMenuListener(new MenuListener(){

            public void menuShown(MenuEvent e) {
                StructuredType type = StructManipulatorSection.this.getSelectedStructuredType();
                openItem.setEnabled(type != null && !type.getName().contentEquals("ANY_STRUCT"));
            }

            public void menuHidden(MenuEvent e) {
            }
        });
        ctrl.setMenu(openEditorMenu);
    }

    private StructuredType getSelectedStructuredType() {
        AbstractStructTreeNode selected;
        VarDeclaration varDecl;
        DataType dataType;
        ITreeSelection selection = this.memberVarViewer.getStructuredSelection();
        if (!selection.isEmpty() && (dataType = (varDecl = (selected = (AbstractStructTreeNode)selection.getFirstElement()).getVariable()).getType()) instanceof StructuredType) {
            StructuredType structType = (StructuredType)dataType;
            return structType;
        }
        return null;
    }

    private static void configureTreeLayout(TreeViewer viewer) {
        TreeViewerColumn variableName = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn variableType = new TreeViewerColumn(viewer, 16384);
        TreeViewerColumn comment = new TreeViewerColumn(viewer, 16384);
        viewer.getTree().setHeaderVisible(true);
        variableName.getColumn().setResizable(true);
        variableType.getColumn().setResizable(true);
        variableName.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_NAME);
        variableType.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_TYPE);
        comment.getColumn().setText(Messages.StructManipulatorSection_MEMBERVAR_COLUMN_COMMENT);
        variableName.getColumn().setWidth(200);
        variableType.getColumn().setWidth(100);
        comment.getColumn().setWidth(800);
    }

    protected void performRefresh() {
        if (this.getType().getFbNetwork() != null && !this.blockRefresh) {
            this.refreshStructTypeTable();
        }
    }

    public void setInput(IWorkbenchPart part, ISelection selection) {
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
        Assert.isTrue((boolean)(selection instanceof IStructuredSelection));
        Object input = ((IStructuredSelection)selection).getFirstElement();
        this.setCurrentCommandStack(part, input);
        if (this.getCurrentCommandStack() == null) {
            this.muxLabel.setEnabled(false);
            this.memberVarViewer.setInput(null);
        }
        this.setType(input);
        if (this.initTree) {
            this.initTree(this.getType(), (TreeViewer)this.memberVarViewer);
        }
        this.typeSelectionWidget.initialize((ConfigurableObject)this.getType(), (ITypeSelectionContentProvider)StructuredTypeSelectionContentProvider.INSTANCE, (ITreeContentProvider)StructuredTypeSelectionTreeContentProvider.INSTANCE);
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().addCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    protected abstract void initTree(StructManipulator var1, TreeViewer var2);

    public void dispose() {
        super.dispose();
        if (this.getCurrentCommandStack() != null) {
            this.getCurrentCommandStack().removeCommandStackEventListener((CommandStackEventListener)this);
        }
    }

    public void stackChanged(CommandStackEvent event) {
        ChangeStructCommand cmd;
        Command command;
        if (!(event.getDetail() != 32 && event.getDetail() != 16 || !((command = event.getCommand()) instanceof ChangeStructCommand) || (cmd = (ChangeStructCommand)command).getOldMux() != this.getType() && cmd.getNewMux() != this.getType())) {
            if (event.getDetail() == 32) {
                StructManipulatorSection.updateStructManipulatorFB(cmd.getOldMux());
            } else if (event.getDetail() == 16) {
                StructManipulatorSection.updateStructManipulatorFB(cmd.getNewMux());
            }
        }
    }

    protected void setInputCode() {
    }

    protected void setInputInit() {
    }

    protected CheckboxTreeViewer getViewer() {
        return this.memberVarViewer;
    }
}

