/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.commands.create;

import java.util.Set;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ConnectionLayoutTagger;
import org.eclipse.fordiac.ide.model.CoordinateConverter;
import org.eclipse.fordiac.ide.model.NameRepository;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.CreateSubAppInstanceCommand;
import org.eclipse.fordiac.ide.model.commands.create.FBCreateCommand;
import org.eclipse.fordiac.ide.model.helpers.FBNetworkHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.FBType;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.InterfaceList;
import org.eclipse.fordiac.ide.model.libraryElement.Position;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.gef.commands.Command;

public abstract class AbstractCreateFBNetworkElementCommand
extends Command
implements ConnectionLayoutTagger,
ScopedCommand {
    private final FBNetworkElement element;
    private final FBNetwork fbNetwork;
    private Position position;

    protected AbstractCreateFBNetworkElementCommand(FBNetwork fbNetwork, FBNetworkElement element, Position position) {
        this.fbNetwork = fbNetwork;
        this.element = element;
        this.position = position.eContainer() != null ? (Position)EcoreUtil.copy((EObject)position) : position;
    }

    protected AbstractCreateFBNetworkElementCommand(FBNetwork fbNetwork, FBNetworkElement element, int x, int y) {
        this(fbNetwork, element, CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(x, y));
    }

    public boolean canExecute() {
        return this.fbNetwork != null && this.element != null && FBNetworkHelper.isTypeInsertionSafe((FBType)this.element.getType(), (EObject)this.fbNetwork);
    }

    public void execute() {
        this.element.setInterface(this.createInterfaceList());
        if (this.element.getType() != null) {
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.element.getType().getInterfaceList().getInputVars());
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.element.getType().getInterfaceList().getOutputVars());
            this.transferVisibleAndVarConfigAttributes((EList<VarDeclaration>)this.element.getType().getInterfaceList().getInOutVars());
        }
        this.element.setPosition(this.position);
        this.insertFBNetworkElement();
        this.checkName();
    }

    protected void checkName() {
        this.element.setName(NameRepository.createUniqueName((INamedElement)this.element, (String)this.getInitialInstanceName()));
    }

    public void redo() {
        this.insertFBNetworkElement();
    }

    public void undo() {
        this.removeFBNetworkElement();
    }

    public FBNetworkElement getElement() {
        return this.element;
    }

    protected String getInitialInstanceName() {
        return this.element.getTypeName();
    }

    protected abstract InterfaceList createInterfaceList();

    public FBNetwork getFBNetwork() {
        return this.fbNetwork;
    }

    public static AbstractCreateFBNetworkElementCommand createCreateCommand(TypeEntry typeEntry, FBNetwork fbNetwork, int x, int y) {
        if (typeEntry instanceof FBTypeEntry) {
            FBTypeEntry fbEntry = (FBTypeEntry)typeEntry;
            return new FBCreateCommand(fbEntry, fbNetwork, x, y);
        }
        if (typeEntry instanceof SubAppTypeEntry) {
            SubAppTypeEntry subAppEntry = (SubAppTypeEntry)typeEntry;
            return new CreateSubAppInstanceCommand(subAppEntry, fbNetwork, x, y);
        }
        return null;
    }

    public void updateCreatePosition(Point createPos) {
        this.position = CoordinateConverter.INSTANCE.createPosFromScreenCoordinates(createPos.x, createPos.y);
    }

    private void insertFBNetworkElement() {
        if (this.fbNetwork != null) {
            this.fbNetwork.getNetworkElements().add((Object)this.element);
        }
    }

    private void removeFBNetworkElement() {
        if (this.fbNetwork != null) {
            this.fbNetwork.getNetworkElements().remove((Object)this.element);
        }
    }

    private void transferVisibleAndVarConfigAttributes(EList<VarDeclaration> varDeclList) {
        varDeclList.forEach(varDecl -> {
            VarDeclaration newDecl = (VarDeclaration)this.element.getInterfaceElement(varDecl.getName());
            newDecl.setVisible(varDecl.isVisible());
            if (newDecl.isInOutVar()) {
                newDecl.getInOutVarOpposite().setVisible(varDecl.getInOutVarOpposite().isVisible());
            }
            newDecl.setVarConfig(varDecl.isVarConfig());
        });
    }

    @Override
    public Set<EObject> getAffectedObjects() {
        if (this.fbNetwork != null) {
            return Set.of(this.fbNetwork);
        }
        return Set.of();
    }
}

