/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.debug.value;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugElement;
import org.eclipse.fordiac.ide.debug.EvaluatorDebugVariable;
import org.eclipse.fordiac.ide.debug.IEvaluatorDebugTarget;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugArrayValue;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugElementaryValue;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugFBValue;
import org.eclipse.fordiac.ide.debug.value.EvaluatorDebugStructValue;
import org.eclipse.fordiac.ide.debug.value.IEvaluatorDebugValue;
import org.eclipse.fordiac.ide.model.eval.value.ArrayValue;
import org.eclipse.fordiac.ide.model.eval.value.FBValue;
import org.eclipse.fordiac.ide.model.eval.value.StructValue;
import org.eclipse.fordiac.ide.model.eval.value.Value;

public abstract class EvaluatorDebugValue
extends EvaluatorDebugElement
implements IEvaluatorDebugValue {
    private final Value value;

    protected EvaluatorDebugValue(Value value, IEvaluatorDebugTarget target) {
        super(target);
        this.value = value;
    }

    public static EvaluatorDebugValue forValue(Value value, String expression, IEvaluatorDebugTarget target) {
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayValue.class, FBValue.class, StructValue.class}, (Object)value3, n)) {
            case 0 -> {
                ArrayValue arrayValue = (ArrayValue)value3;
                yield new EvaluatorDebugArrayValue(arrayValue, expression, target);
            }
            case 1 -> {
                FBValue arrayValue = (FBValue)value3;
                yield new EvaluatorDebugFBValue(arrayValue, expression, target);
            }
            case 2 -> {
                StructValue arrayValue = (StructValue)value3;
                yield new EvaluatorDebugStructValue(arrayValue, expression, target);
            }
            default -> new EvaluatorDebugElementaryValue(value, expression, target);
        };
    }

    public static EvaluatorDebugValue forValue(Value value, EvaluatorDebugVariable variable) {
        Value value2 = value;
        Objects.requireNonNull(value2);
        Value value3 = value2;
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayValue.class, FBValue.class, StructValue.class}, (Object)value3, n)) {
            case 0 -> {
                ArrayValue arrayValue = (ArrayValue)value3;
                yield new EvaluatorDebugArrayValue(arrayValue, variable);
            }
            case 1 -> {
                FBValue arrayValue = (FBValue)value3;
                yield new EvaluatorDebugFBValue(arrayValue, variable);
            }
            case 2 -> {
                StructValue arrayValue = (StructValue)value3;
                yield new EvaluatorDebugStructValue(arrayValue, variable);
            }
            default -> new EvaluatorDebugElementaryValue(value, variable);
        };
    }

    public Value getInternalValue() {
        return this.value;
    }

    @Override
    public final String getReferenceTypeName() {
        return this.value.getType().getName();
    }

    @Override
    public final String getValueString() {
        return this.value.toString();
    }

    @Override
    public final boolean isAllocated() {
        return true;
    }

    @Override
    public final IEvaluatorDebugTarget getDebugTarget() {
        return (IEvaluatorDebugTarget)super.getDebugTarget();
    }
}

