/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.library;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.runtime.SwitchBootstraps;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardWatchEventKinds;
import java.nio.file.WatchKey;
import java.nio.file.WatchService;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.core.runtime.jobs.IJobChangeListener;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.library.DependencyNode;
import org.eclipse.fordiac.ide.library.DownloadResult;
import org.eclipse.fordiac.ide.library.IArchiveDownloader;
import org.eclipse.fordiac.ide.library.InstanceUpdateDialog;
import org.eclipse.fordiac.ide.library.LibraryChangeListener;
import org.eclipse.fordiac.ide.library.LibraryRecord;
import org.eclipse.fordiac.ide.library.Messages;
import org.eclipse.fordiac.ide.library.ResolveNode;
import org.eclipse.fordiac.ide.library.model.library.Manifest;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.library.model.util.VersionComparator;
import org.eclipse.fordiac.ide.model.errormarker.ErrorMarkerBuilder;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.model.typelibrary.impl.TypeEntryFactory;
import org.eclipse.fordiac.ide.systemmanagement.SystemManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.FordiacResourceChangeListener;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.osgi.service.event.EventHandler;

public enum LibraryManager {
    INSTANCE;

    public static final String LIB_TYPELIB_FOLDER_NAME = "typelib";
    public static final String PACKAGE_DOWNLOAD_DIRECTORY = ".download";
    public static final String EXTRACTED_LIB_DIRECTORY = ".lib";
    public static final String MANIFEST = "MANIFEST.MF";
    public static final String DOWNLOADER_EXTENSION = "org.eclipse.fordiac.ide.library.ArchiveDownloaderExtension";
    public static final String MARKER_ATTRIBUTE = "LIB";
    private final URI workspaceLibraryURI = URI.create("WORKSPACE_LOC/.lib");
    private final Path workspacePath = ResourcesPlugin.getWorkspace().getRoot().getRawLocation().toPath();
    private final Path libraryPath = this.workspacePath.resolve(".lib");
    private final Path archivePath = this.workspacePath.resolve(".download");
    private final URI standardLibraryUri = URI.create("ECLIPSE_HOME/typelibrary");
    private final Path standardLibraryPath = LibraryManager.getStandardLibPath();
    public static final String ZIP_SUFFIX = ".zip";
    public static final Set<String> TYPE_ENDINGS;
    private static final DirectoryStream.Filter<Path> ARCHIVE_DIR_FILTER;
    private static final Path[] EMPTY_PATH_ARRAY;
    public static final VersionRange ALL_RANGE;
    private WatchService watchService;
    private final HashMap<String, List<LibraryRecord>> stdlibraries = new HashMap();
    private final HashMap<String, List<LibraryRecord>> libraries = new HashMap();
    public static final Object FAMILY_FORDIAC_LIBRARY;
    private IEventBroker eventBroker;
    private final IResourceChangeListener libraryListener = new LibraryChangeListener();
    private final Set<IProject> resolvingProjects = Collections.synchronizedSet(new HashSet());
    private final EventHandler handler = event -> {
        Object data = event.getProperty("org.eclipse.e4.data");
        if (data instanceof TypeLibrary) {
            TypeLibrary typeLibrary = (TypeLibrary)data;
            this.checkManifestFile(typeLibrary.getProject());
        }
    };

    static {
        TYPE_ENDINGS = Set.of("ADP", "ATP", "DTP", "DEV", "FBT", "FCT", "GCF", "RES", "SEG", "SUB", "SYS");
        ARCHIVE_DIR_FILTER = entry -> Files.isDirectory(entry, new LinkOption[0]) || entry.getFileName().toString().endsWith(ZIP_SUFFIX);
        EMPTY_PATH_ARRAY = new Path[0];
        ALL_RANGE = new VersionRange('[', Version.emptyVersion, null, ']');
        FAMILY_FORDIAC_LIBRARY = new Object();
    }

    private LibraryManager() {
        LibraryManager.initLibraryMap(this.stdlibraries, this.standardLibraryPath, this.standardLibraryUri);
        if (!Files.exists(this.libraryPath, new LinkOption[0])) {
            try {
                Files.createDirectory(this.libraryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)"Cannot create lib path!", (Throwable)e);
            }
        }
        LibraryManager.initLibraryMap(this.libraries, this.libraryPath, this.workspaceLibraryURI);
        try {
            this.watchService = FileSystems.getDefault().newWatchService();
            this.libraryPath.register(this.watchService, StandardWatchEventKinds.ENTRY_CREATE, StandardWatchEventKinds.ENTRY_DELETE);
        }
        catch (IOException e) {
            FordiacLogHelper.logError((String)"Cannot register watch watch service!", (Throwable)e);
        }
        this.addLibraryChangeListener();
    }

    private void checkLibChanges() {
        if (this.watchService == null) {
            return;
        }
        WatchKey watchKey = this.watchService.poll();
        if (watchKey == null) {
            return;
        }
        watchKey.pollEvents().forEach(event -> {
            block4: {
                try {
                    if (event.kind() == StandardWatchEventKinds.ENTRY_CREATE) {
                        LibraryManager.addLibrary(this.libraries, this.libraryPath.resolve((Path)event.context()), this.workspaceLibraryURI);
                        break block4;
                    }
                    if (event.kind() == StandardWatchEventKinds.ENTRY_DELETE) {
                        LibraryManager.removeLibrary(this.libraries, this.libraryPath.resolve((Path)event.context()));
                        break block4;
                    }
                    LibraryManager.initLibraryMap(this.libraries, this.libraryPath, this.workspaceLibraryURI);
                    return;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        watchKey.reset();
    }

    private static void initLibraryMap(Map<String, List<LibraryRecord>> map, Path path2, URI baseURI) {
        map.clear();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path2, path -> Files.isDirectory(path, new LinkOption[0]));){
                for (Path folder : stream) {
                    LibraryManager.addLibrary(map, folder, baseURI);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void addLibrary(Map<String, List<LibraryRecord>> map, Path path, URI baseUri) throws IOException {
        Throwable throwable = null;
        Object var4_5 = null;
        try (DirectoryStream<Path> folderStream = Files.newDirectoryStream(path, MANIFEST);){
            Manifest manifest;
            Iterator<Path> it = folderStream.iterator();
            if (it.hasNext() && (manifest = ManifestHelper.getManifest((Path)it.next())) != null && ManifestHelper.isLibrary((Manifest)manifest) && manifest.getProduct() != null && manifest.getProduct().getSymbolicName() != null) {
                map.computeIfAbsent(manifest.getProduct().getSymbolicName(), s -> new ArrayList()).add(new LibraryRecord(manifest.getProduct().getSymbolicName(), manifest.getProduct().getName(), manifest.getProduct().getVersionInfo().getVersion(), manifest.getProduct().getComment(), path, URIUtil.append((URI)baseUri, (String)path.getFileName().toString())));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private static void removeLibrary(Map<String, List<LibraryRecord>> map, Path path) {
        List<LibraryRecord> records;
        String folderName = path.getFileName().toString();
        int pos = folderName.lastIndexOf(45);
        if (pos > 0) {
            folderName = folderName.substring(0, pos);
        }
        if ((records = map.get(folderName)) != null) {
            records.removeIf(r -> r.path().equals(path));
            if (records.isEmpty()) {
                map.remove(folderName);
            }
        } else {
            map.values().forEach(rl -> {
                boolean bl = rl.removeIf(r -> r.path().equals(path));
            });
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public URI extractLibrary(Path path, IProject project, boolean autoImport, boolean resolve) throws IOException {
        String folderName;
        block29: {
            if (path == null) return null;
            if (Files.notExists(path, new LinkOption[0])) {
                return null;
            }
            FordiacLogHelper.logInfo((String)("Extracting library at " + String.valueOf(path)));
            byte[] buffer = new byte[1024];
            Throwable throwable = null;
            Object var8_8 = null;
            try {
                InputStream inputStream = Files.newInputStream(path, new OpenOption[0]);
                try {
                    try (ZipInputStream zipInputStream = new ZipInputStream(inputStream);){
                        ZipEntry entry = zipInputStream.getNextEntry();
                        String string = folderName = entry != null ? entry.getName() : "";
                        while (entry != null) {
                            Path newFile = LibraryManager.newPath(this.libraryPath, entry);
                            if (entry.isDirectory()) {
                                if (!Files.isDirectory(newFile, new LinkOption[0])) {
                                    Files.createDirectories(newFile, new FileAttribute[0]);
                                }
                            } else {
                                Path parent = newFile.getParent();
                                if (!Files.isDirectory(parent, new LinkOption[0])) {
                                    Files.createDirectories(parent, new FileAttribute[0]);
                                }
                                Throwable throwable2 = null;
                                Object var15_19 = null;
                                try (OutputStream fileOutputStream = Files.newOutputStream(newFile, new OpenOption[0]);){
                                    int len;
                                    while ((len = zipInputStream.read(buffer)) > 0) {
                                        fileOutputStream.write(buffer, 0, len);
                                    }
                                }
                                catch (Throwable throwable3) {
                                    if (throwable2 == null) {
                                        throwable2 = throwable3;
                                        throw throwable2;
                                    }
                                    if (throwable2 == throwable3) throw throwable2;
                                    throwable2.addSuppressed(throwable3);
                                    throw throwable2;
                                }
                            }
                            entry = zipInputStream.getNextEntry();
                        }
                    }
                    if (inputStream == null) break block29;
                }
                catch (Throwable throwable4) {
                    if (throwable == null) {
                        throwable = throwable4;
                    } else if (throwable != throwable4) {
                        throwable.addSuppressed(throwable4);
                    }
                    if (inputStream == null) throw throwable;
                    inputStream.close();
                    throw throwable;
                }
                inputStream.close();
            }
            catch (Throwable throwable5) {
                if (throwable == null) {
                    throwable = throwable5;
                    throw throwable;
                }
                if (throwable == throwable5) throw throwable;
                throwable.addSuppressed(throwable5);
                throw throwable;
            }
        }
        this.checkLibChanges();
        if (folderName.endsWith("/")) {
            folderName = folderName.substring(0, folderName.length() - 1);
        }
        URI importURI = URIUtil.append((URI)this.workspaceLibraryURI, (String)folderName);
        if (!autoImport) return importURI;
        if (project == null) return importURI;
        this.importLibrary(project, null, importURI, true, resolve);
        return importURI;
    }

    private static Path newPath(Path destinationDir, ZipEntry zipEntry) throws IOException {
        Path destPath = destinationDir.resolve(zipEntry.getName());
        if (!destPath.startsWith(destinationDir)) {
            throw new IOException("Entry is outside of the target dir: " + zipEntry.getName());
        }
        return destPath;
    }

    public void importLibrary(IProject project, TypeLibrary typeLibrary, URI uri, boolean update, boolean resolve) {
        boolean imported = false;
        FordiacLogHelper.logInfo((String)("Importing library at " + String.valueOf(uri) + " into project " + project.getName() + " (update=" + update + ", resolve=" + resolve + ")"));
        TypeLibrary typeLib = typeLibrary != null ? typeLibrary : TypeLibraryManager.INSTANCE.getTypeLibrary(project);
        this.checkLibChanges();
        IPathVariableManager varMan = project.getPathVariableManager();
        URI resolvedUri = varMan.resolveURI(uri);
        Path path = Paths.get(resolvedUri);
        if (!Files.isDirectory(path, new LinkOption[0]) || Files.notExists(path.resolve(LIB_TYPELIB_FOLDER_NAME), new LinkOption[0])) {
            return;
        }
        Manifest libManifest = ManifestHelper.getFolderManifest((Path)path);
        if (libManifest == null) {
            return;
        }
        Manifest projManifest = ManifestHelper.getOrCreateProjectManifest((IProject)project);
        if (projManifest == null) {
            return;
        }
        IFolder libDirectory = project.getFolder(uri.getPath().startsWith(this.standardLibraryUri.getPath()) ? "Standard Libraries" : "External Libraries").getFolder(libManifest.getProduct().getSymbolicName());
        this.removeLibraryChangeListener();
        SystemManager.INSTANCE.removeFordiacChangeListener();
        Map<String, TypeEntry> cachedTypes = LibraryManager.removeOldLibVersion(libDirectory, typeLib);
        URI libUri = URIUtil.append((URI)uri, (String)LIB_TYPELIB_FOLDER_NAME);
        URI manUri = URIUtil.append((URI)uri, (String)MANIFEST);
        try {
            libDirectory.createLink(libUri, 0, null);
            IFile man = libDirectory.getFile(MANIFEST);
            man.createLink(manUri, 4096, null);
            if (update) {
                ManifestHelper.updateDependency((Manifest)projManifest, (Required)ManifestHelper.createRequired((String)libManifest.getProduct().getSymbolicName(), (String)libManifest.getProduct().getVersionInfo().getVersion()));
                projManifest.eResource().save(null);
            }
            LibraryManager.createTypeEntriesManually(libDirectory, cachedTypes, typeLib);
            if (!cachedTypes.isEmpty()) {
                ArrayList<TypeEntry> affectedTypes = new ArrayList<TypeEntry>(cachedTypes.values());
                LibraryManager.cleanupOldLibraryVersion(cachedTypes, typeLib);
                LibraryManager.showUpdatedElements(affectedTypes);
            }
            imported = true;
        }
        catch (IOException | CoreException e) {
            Display.getDefault().syncExec(() -> LibraryManager.lambda$8((Exception)e));
        }
        SystemManager.INSTANCE.addFordiacChangeListener();
        this.addLibraryChangeListener();
        if (resolve && imported) {
            this.startResolveJob(project);
        }
    }

    public void importLibraries(IProject project, Collection<URI> uris, boolean resolve) {
        for (URI uri : uris) {
            this.importLibrary(project, null, uri, true, resolve);
        }
    }

    private static Map<String, TypeEntry> removeOldLibVersion(IFolder libDirectory, TypeLibrary typeLibrary) {
        if (libDirectory.exists()) {
            FordiacLogHelper.logInfo((String)("Removing old library version at " + String.valueOf(libDirectory)));
            try {
                Map<String, TypeEntry> existingTypes = LibraryManager.findExistingTypes(libDirectory, typeLibrary);
                libDirectory.delete(true, null);
                return existingTypes;
            }
            catch (CoreException e) {
                Display.getDefault().syncExec(() -> MessageDialog.openWarning(null, (String)Messages.Warning, (String)Messages.OldTypeLibVersionCouldNotBeDeleted));
            }
        }
        return Collections.emptyMap();
    }

    private static Map<String, TypeEntry> findExistingTypes(IFolder folder, TypeLibrary typeLibrary) {
        HashMap<String, TypeEntry> existingTypes = new HashMap<String, TypeEntry>();
        IResourceVisitor visitor = resource -> {
            boolean bl;
            IResource iResource = resource;
            Objects.requireNonNull(iResource);
            IResource iResource2 = iResource;
            int n = 0;
            block4: while (true) {
                switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IFolder.class, IFile.class}, (Object)iResource2, n)) {
                    case 0: {
                        IFolder f = (IFolder)iResource2;
                        bl = true;
                        break block4;
                    }
                    case 1: {
                        IFile file = (IFile)iResource2;
                        if (!TYPE_ENDINGS.contains(file.getFileExtension().toUpperCase())) {
                            n = 2;
                            continue block4;
                        }
                        TypeEntry entry = typeLibrary.getTypeEntry(file);
                        if (entry != null) {
                            existingTypes.put(entry.getFullTypeName(), entry);
                        }
                        bl = false;
                        break block4;
                    }
                    default: {
                        bl = false;
                    }
                }
                break;
            }
            return bl;
        };
        try {
            folder.accept(visitor);
            return existingTypes;
        }
        catch (CoreException coreException) {
            return Collections.emptyMap();
        }
    }

    private static void createTypeEntriesManually(IFolder folder, Map<String, TypeEntry> cachedTypes, TypeLibrary typeLibrary) {
        IResourceVisitor visitor = resource -> {
            IResource iResource = resource;
            Objects.requireNonNull(iResource);
            IResource iResource2 = iResource;
            int n = 0;
            return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{IFolder.class, IFile.class}, (Object)iResource2, n)) {
                case 0 -> {
                    IFolder f = (IFolder)iResource2;
                    yield true;
                }
                case 1 -> {
                    IFile file = (IFile)iResource2;
                    TypeEntry entry = TypeEntryFactory.INSTANCE.createTypeEntry(file);
                    if (entry != null) {
                        TypeEntry oldEntry = (TypeEntry)cachedTypes.get(entry.getFullTypeName());
                        if (oldEntry != null) {
                            FordiacResourceChangeListener.updateTypeEntry((IFile)file, (TypeEntry)oldEntry);
                            cachedTypes.remove(entry.getFullTypeName());
                        } else {
                            typeLibrary.createTypeEntry(file);
                        }
                    }
                    yield false;
                }
                default -> false;
            };
        };
        try {
            folder.accept(visitor);
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
    }

    private static void cleanupOldLibraryVersion(Map<String, TypeEntry> cachedTypes, TypeLibrary typeLibrary) {
        cachedTypes.values().forEach(arg_0 -> ((TypeLibrary)typeLibrary).removeTypeEntry(arg_0));
    }

    private static void showUpdatedElements(List<TypeEntry> affectedTypes) {
        if (affectedTypes.isEmpty()) {
            return;
        }
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(affectedTypes);
        List<FBNetworkElement> elements = search.performSearch().stream().filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).toList();
        Display.getDefault().syncExec(() -> {
            InstanceUpdateDialog updateDialog = new InstanceUpdateDialog(null, Messages.InstanceUpdate, null, Messages.UpdatedInstances, 0, new String[]{Messages.Confirm}, 0, elements);
            updateDialog.open();
        });
    }

    public Path[] listDirectoriesContainingArchives() {
        return this.listArchiveFolders(this.archivePath);
    }

    public Path[] listArchiveFolders(Path path) {
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return EMPTY_PATH_ARRAY;
        }
        LinkedList content = new LinkedList();
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (DirectoryStream<Path> stream = Files.newDirectoryStream(path, ARCHIVE_DIR_FILTER);){
                stream.forEach(content::add);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return content.toArray(EMPTY_PATH_ARRAY);
    }

    public Map<String, List<LibraryRecord>> getStandardLibraries() {
        return new HashMap<String, List<LibraryRecord>>(this.stdlibraries);
    }

    public Map<String, List<LibraryRecord>> getExtractedLibraries() {
        this.checkLibChanges();
        return new HashMap<String, List<LibraryRecord>>(this.libraries);
    }

    public void checkManifestFile(IProject project) {
        Manifest manifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (manifest == null || !ManifestHelper.isProject((Manifest)manifest)) {
            return;
        }
        ManifestHelper.sortAndSaveManifest((Manifest)manifest);
        this.startResolveJob(project);
    }

    public void startResolveJob(final IProject project) {
        if (this.resolvingProjects.contains(project)) {
            return;
        }
        this.resolvingProjects.add(project);
        WorkspaceJob job = new WorkspaceJob("Resolve dependencies: " + project.getName()){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                if (project.isAccessible()) {
                    LibraryManager.this.resolveDependencies(project, TypeLibraryManager.INSTANCE.getTypeLibrary(project));
                }
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == FAMILY_FORDIAC_LIBRARY;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.setPriority(30);
        job.addJobChangeListener(IJobChangeListener.onDone(c -> {
            boolean bl = this.resolvingProjects.remove(project);
        }));
        job.schedule();
    }

    private DownloadResult<URI> libraryDownload(String symbolicName, VersionRange versionRange, Version preferred, IProject project, boolean autoImport, boolean resolve) {
        FordiacLogHelper.logInfo((String)("Attempting to download library " + symbolicName + " with version " + String.valueOf(versionRange) + " preferring " + String.valueOf(preferred)));
        List downloaders = TypeLibraryManager.listExtensions((String)DOWNLOADER_EXTENSION, IArchiveDownloader.class);
        StringBuilder errors = new StringBuilder();
        VersionRange range = versionRange == null || versionRange.isEmpty() ? ALL_RANGE : versionRange;
        for (IArchiveDownloader downloader : downloaders) {
            if (!downloader.isActive()) continue;
            try {
                DownloadResult<Path> dlResult = downloader.downloadLibrary(symbolicName, range, preferred);
                if (dlResult.status() == DownloadResult.Status.OK) {
                    return new DownloadResult<URI>(this.extractLibrary(dlResult.result(), project, autoImport, resolve));
                }
                if (dlResult.status() != DownloadResult.Status.NOT_FOUND && dlResult.status() != DownloadResult.Status.CONFIG_ERROR && dlResult.status() != DownloadResult.Status.ERROR) continue;
                errors.append(" | ");
                errors.append(downloader.getName());
                errors.append(": ");
                errors.append(dlResult.message());
            }
            catch (IOException e) {
                FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
            }
        }
        return new DownloadResult<URI>(DownloadResult.Status.ERROR, errors.toString());
    }

    public void updateLibrary(final IProject project, final String symbolicName, final String versionRange) {
        WorkspaceJob job = new WorkspaceJob("Update Library package: " + symbolicName + " = " + versionRange){

            public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
                LibraryManager.this.libraryDownload(symbolicName, VersionComparator.parseVersionRange((String)versionRange), null, project, true, true);
                return Status.OK_STATUS;
            }

            public boolean belongsTo(Object family) {
                return family == FAMILY_FORDIAC_LIBRARY;
            }
        };
        job.setRule((ISchedulingRule)project);
        job.setPriority(30);
        job.schedule();
    }

    public void resolveDependencies(IProject project, TypeLibrary typeLibrary) {
        HashMap deps = new HashMap();
        HashMap<String, ResolveNode> res = new HashMap<String, ResolveNode>();
        HashMap<String, Version> preferred = new HashMap<String, Version>();
        HashMap<String, IFolder> linked = new HashMap<String, IFolder>();
        LinkedList queue = new LinkedList();
        Manifest projectManifest = ManifestHelper.getContainerManifest((IContainer)project);
        if (projectManifest == null) {
            return;
        }
        this.checkLibChanges();
        this.moveLinksToVirtualFolders(project);
        if (projectManifest.getDependencies() == null) {
            return;
        }
        LibraryManager.findPreferred(project, preferred, linked);
        projectManifest.getDependencies().getRequired().forEach(req -> {
            deps.put(req.getSymbolicName(), new DependencyNode(req.getSymbolicName(), "Project", VersionComparator.parseVersionRange((String)req.getVersion())));
            queue.add(req.getSymbolicName());
        });
        while (!queue.isEmpty()) {
            ResolveNode rnode;
            String symbolicName = (String)queue.poll();
            DependencyNode dnode = (DependencyNode)deps.get(symbolicName);
            if (!dnode.isChanged()) continue;
            if (!dnode.isValid()) {
                rnode = (ResolveNode)res.get(symbolicName);
                if (rnode == null) continue;
                rnode.getDependencies().keySet().forEach(symb -> {
                    DependencyNode dn = (DependencyNode)deps.get(symb);
                    if (dn != null) {
                        dn.removeCause(symbolicName);
                        if (dn.isChanged()) {
                            queue.add(symb);
                        }
                    }
                });
                continue;
            }
            rnode = this.resolveDependency(symbolicName, dnode.getRange(), (Version)preferred.get(symbolicName));
            if (res.containsKey(symbolicName)) {
                ResolveNode oldRNode = (ResolveNode)res.get(symbolicName);
                oldRNode.getDependencies().keySet().forEach(old -> {
                    if (!rnode.getDependencies().containsKey(old)) {
                        ((DependencyNode)deps.get(old)).removeCause(symbolicName);
                    }
                });
            }
            res.put(symbolicName, rnode);
            rnode.getDependencies().forEach((symb, val) -> {
                DependencyNode dn = deps.computeIfAbsent(symb, s -> new DependencyNode((String)symb));
                dn.putCause(symbolicName, (VersionRange)val);
                if (dn.isChanged()) {
                    queue.add(symb);
                }
            });
        }
        LinkedList<ErrorMarkerBuilder> markerList = new LinkedList<ErrorMarkerBuilder>();
        for (DependencyNode dnode : deps.values()) {
            if (dnode.isValid()) {
                ResolveNode rnode = (ResolveNode)res.get(dnode.getSymbolicName());
                if (rnode.isValid()) {
                    if (!linked.containsKey(rnode.getSymbolicName()) || !((Version)preferred.get(rnode.getSymbolicName())).equals((Object)rnode.getVersion())) {
                        this.importLibrary(project, typeLibrary, rnode.getUri(), false, false);
                    }
                    linked.remove(rnode.getSymbolicName());
                    continue;
                }
                markerList.add(LibraryManager.createDependencyMarker(projectManifest, rnode, dnode));
                continue;
            }
            if (!dnode.isRangeEmpty()) continue;
            markerList.add(LibraryManager.createDependencyMarker(projectManifest, dnode));
        }
        linked.values().forEach(f -> {
            try {
                f.delete(true, null);
            }
            catch (CoreException coreException) {
                // empty catch block
            }
        });
        FordiacMarkerHelper.updateMarkers((IResource)project.getFile(MANIFEST), (String)"org.eclipse.fordiac.ide.model.library", markerList, (boolean)true);
    }

    private static void findPreferred(IProject project, Map<String, Version> preferred, Map<String, IFolder> linked) {
        IFolder standardLibFolder = project.getFolder("Standard Libraries");
        IFolder externalLibFolder = project.getFolder("External Libraries");
        if (!standardLibFolder.exists() || !externalLibFolder.exists()) {
            return;
        }
        IResourceVisitor visitor = res -> {
            if (res instanceof IFolder) {
                IFolder libFolder = (IFolder)res;
                if (standardLibFolder.equals((Object)libFolder) || externalLibFolder.equals((Object)libFolder)) {
                    return true;
                }
                if (!libFolder.exists() || !libFolder.isLinked()) {
                    return false;
                }
                Manifest libManifest = ManifestHelper.getContainerManifest((IContainer)libFolder);
                if (libManifest != null) {
                    linked.put(libFolder.getName(), libFolder);
                    preferred.put(libFolder.getName(), new Version(libManifest.getProduct().getVersionInfo().getVersion()));
                } else {
                    IPath path = libFolder.getRawLocation();
                    String segment = path != null && path.segmentCount() >= 2 ? path.segment(path.segmentCount() - 2) : "";
                    int index = segment.lastIndexOf(45);
                    if (index > 0) {
                        preferred.put(libFolder.getName(), new Version(segment.substring(index + 1)));
                    }
                }
            }
            return false;
        };
        try {
            standardLibFolder.accept(visitor);
            externalLibFolder.accept(visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
    }

    private ResolveNode resolveDependency(String symbolicName, VersionRange range, Version prefVersion) {
        LibraryRecord rec;
        boolean usePref;
        boolean bl = usePref = prefVersion != null && range.includes(prefVersion);
        if (this.stdlibraries.containsKey(symbolicName)) {
            LibraryRecord rec2;
            if (usePref && (rec2 = LibraryManager.getLibraryRecord(this.stdlibraries, symbolicName, prefVersion)) != null) {
                return new ResolveNode(rec2);
            }
            rec2 = LibraryManager.getLibraryRecord(this.stdlibraries, symbolicName, range);
            if (rec2 != null) {
                return new ResolveNode(rec2);
            }
            return new ResolveNode(symbolicName, Messages.ErrorMarkerStandardLibNotAvailable);
        }
        if (usePref ? (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, prefVersion)) != null : (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, range)) != null) {
            return new ResolveNode(rec);
        }
        DownloadResult<URI> dlResult = this.libraryDownload(symbolicName, range, prefVersion, null, false, false);
        if (dlResult.status() == DownloadResult.Status.OK && (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, dlResult.result())) != null) {
            return new ResolveNode(rec);
        }
        if (usePref && (rec = LibraryManager.getLibraryRecord(this.libraries, symbolicName, range)) != null) {
            return new ResolveNode(rec);
        }
        return new ResolveNode(symbolicName, Messages.ErrorMarkerLibNotAvailable + dlResult.message());
    }

    private void moveLinksToVirtualFolders(IProject project) {
        if (project.getFolder("Standard Libraries").exists()) {
            return;
        }
        this.removeLibraryChangeListener();
        IResource[] members = null;
        try {
            project.getFolder("Standard Libraries").create(8193, true, null);
            project.getFolder("External Libraries").create(8193, true, null);
            members = project.getFolder("Type Library").members();
        }
        catch (CoreException e) {
            FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
        }
        if (members != null) {
            IResource[] iResourceArray = members;
            int n = members.length;
            int n2 = 0;
            while (n2 < n) {
                IFolder folder;
                IResource res = iResourceArray[n2];
                if (res instanceof IFolder && (folder = (IFolder)res).isLinked() && folder.getFile(MANIFEST).exists()) {
                    URI libURI = folder.getRawLocationURI();
                    IFolder libDirectory = project.getFolder(libURI.getPath().startsWith(this.standardLibraryUri.getPath()) ? "Standard Libraries" : "External Libraries").getFolder(folder.getName());
                    try {
                        folder.move(libDirectory.getFullPath(), 33, null);
                        IFile man = libDirectory.getFile(MANIFEST);
                        man.setHidden(true);
                    }
                    catch (CoreException e) {
                        FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                    }
                }
                ++n2;
            }
        }
        this.addLibraryChangeListener();
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, Version version) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> l.version().equals((Object)version)).findFirst().orElse(null);
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, VersionRange range) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> range.includes(l.version())).sorted((o1, o2) -> o2.version().compareTo(o1.version())).findFirst().orElse(null);
    }

    private static LibraryRecord getLibraryRecord(Map<String, List<LibraryRecord>> libs, String symbolicName, URI uri) {
        return libs.getOrDefault(symbolicName, Collections.emptyList()).stream().filter(l -> l.uri().equals(uri)).sorted((o1, o2) -> o2.version().compareTo(o1.version())).findFirst().orElse(null);
    }

    private static ErrorMarkerBuilder createDependencyMarker(Manifest manifest, ResolveNode rnode, DependencyNode dnode) {
        return ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(rnode.getError(), rnode.getSymbolicName(), VersionComparator.formatVersionRange((VersionRange)dnode.getRange()), String.join((CharSequence)", ", dnode.getCauses().keySet()))).setType("org.eclipse.fordiac.ide.model.library").setTarget((EObject)manifest.getDependencies()).addAdditionalAttributes(Map.of(MARKER_ATTRIBUTE, rnode.getSymbolicName()));
    }

    private static ErrorMarkerBuilder createDependencyMarker(Manifest manifest, DependencyNode dnode) {
        String causedBy = dnode.getCauses().entrySet().stream().map(entry -> (String)entry.getKey() + ": " + VersionComparator.formatVersionRange((VersionRange)((VersionRange)entry.getValue()))).collect(Collectors.joining(", "));
        return ErrorMarkerBuilder.createErrorMarkerBuilder((String)MessageFormat.format(Messages.ErrorMarkerVersionRangeEmpty, dnode.getSymbolicName(), causedBy)).setType("org.eclipse.fordiac.ide.model.library").setTarget((EObject)manifest.getDependencies()).addAdditionalAttributes(Map.of(MARKER_ATTRIBUTE, dnode.getSymbolicName()));
    }

    public void startEventBroker(BundleContext context) {
        this.eventBroker = (IEventBroker)EclipseContextFactory.getServiceContext((BundleContext)context).get(IEventBroker.class);
        this.eventBroker.subscribe("org/eclipse/fordiac/event/type_library_creation", null, this.handler, true);
    }

    void stopEventBroker() {
        this.eventBroker.unsubscribe(this.handler);
    }

    public void removeLibraryChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.libraryListener);
    }

    public void addLibraryChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.libraryListener);
    }

    private static Path getStandardLibPath() {
        File installLocationFile = new File(Platform.getInstallLocation().getURL().getPath());
        Path fordiacInstallPath = installLocationFile.toPath();
        return fordiacInstallPath.resolve("typelibrary");
    }

    private static /* synthetic */ void lambda$8(Exception exception) {
        MessageDialog.openWarning(null, (String)Messages.Warning, (String)MessageFormat.format(Messages.ImportFailedOnLinkCreation, exception.getMessage()));
    }
}

