/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.bulkeditor.Messages;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorInput;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorSettings;
import org.eclipse.fordiac.ide.bulkeditor.editors.CopyElementRecord;
import org.eclipse.fordiac.ide.bulkeditor.editors.FilterComposite;
import org.eclipse.fordiac.ide.bulkeditor.editors.SearchHelper;
import org.eclipse.fordiac.ide.gef.nat.AttributeColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.AttributeEditableRule;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.gef.nat.DefaultImportCopyPasteLayerConfiguration;
import org.eclipse.fordiac.ide.gef.nat.InitialValueEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.TypeDeclarationEditorConfiguration;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationDataLayer;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.commands.ScopedCommand;
import org.eclipse.fordiac.ide.model.commands.create.AddNewImportCommand;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.AttributeDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.ISearchContext;
import org.eclipse.fordiac.ide.model.search.types.IEC61499ElementSearch;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.ui.nat.DataTypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.nat.TypeSelectionTreeContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.AttributeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.DataTypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ITypeSelectionContentProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportContentProposal;
import org.eclipse.fordiac.ide.model.ui.widgets.ImportTypeSelectionProposalProvider;
import org.eclipse.fordiac.ide.model.ui.widgets.TypeSelectionButton;
import org.eclipse.fordiac.ide.ui.widget.ChangeableListDataProvider;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnEditableRule;
import org.eclipse.fordiac.ide.ui.widget.NatTableColumnProvider;
import org.eclipse.fordiac.ide.ui.widget.NatTableWidgetFactory;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.jface.bindings.keys.KeyStroke;
import org.eclipse.jface.fieldassist.ContentProposalAdapter;
import org.eclipse.jface.fieldassist.IContentProposal;
import org.eclipse.jface.fieldassist.IContentProposalProvider;
import org.eclipse.jface.fieldassist.IControlContentAdapter;
import org.eclipse.jface.fieldassist.TextContentAdapter;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.nebula.widgets.nattable.NatTable;
import org.eclipse.nebula.widgets.nattable.config.AbstractRegistryConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IConfigRegistry;
import org.eclipse.nebula.widgets.nattable.config.IConfiguration;
import org.eclipse.nebula.widgets.nattable.config.IEditableRule;
import org.eclipse.nebula.widgets.nattable.data.IColumnAccessor;
import org.eclipse.nebula.widgets.nattable.data.IDataProvider;
import org.eclipse.nebula.widgets.nattable.edit.EditConfigAttributes;
import org.eclipse.nebula.widgets.nattable.edit.editor.ICellEditor;
import org.eclipse.nebula.widgets.nattable.edit.editor.TextCellEditor;
import org.eclipse.nebula.widgets.nattable.layer.DataLayer;
import org.eclipse.nebula.widgets.nattable.layer.cell.IConfigLabelAccumulator;
import org.eclipse.nebula.widgets.nattable.style.DisplayMode;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IWorkbenchPartSite;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.forms.widgets.Twistie;
import org.eclipse.ui.part.EditorPart;

public class BulkEditor
extends EditorPart
implements CommandExecutor,
CommandStackEventListener {
    private static final List<String> DEFAULT_LIST = List.of(Messages.Name, Messages.Type, Messages.Comment, Messages.InitialValue);
    private static final List<String> LIST_WITHOUT_VALUE = List.of(Messages.Name, Messages.Type, Messages.Comment);
    private IProject project;
    private final CommandStack commandStack = new CommandStack();
    private final Map<TypeEntry, CopyElementRecord> map = new HashMap<TypeEntry, CopyElementRecord>();
    private BulkEditorSettings settings;
    private Combo modeSelectionDropDown;
    private FilterComposite searchFilter;
    private FilterComposite fbSubappTypesFilter;
    private FilterComposite fbTypedSubappInstanceFilter;
    private FilterComposite untypedSubappFilter;
    private FilterComposite dataTypesFilter;
    private FilterComposite attributeTypesFilter;
    private Button workspaceScopeButton;
    private Button projectScopeButton;
    private NatTable natTable;
    private ChangeableListDataProvider<Attribute> attributeProvider;
    private ChangeableListDataProvider<VarDeclaration> varDeclProvider;

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        this.setSite((IWorkbenchPartSite)site);
        this.setInput(input);
        this.commandStack.addCommandStackEventListener((CommandStackEventListener)this);
        if (input instanceof BulkEditorInput) {
            BulkEditorInput bulkEditorInput = (BulkEditorInput)input;
            this.settings = bulkEditorInput.getSettings();
            this.project = bulkEditorInput.getProject();
            this.setPartName(this.getPartName() + ": " + this.project.getName());
        }
    }

    public void createPartControl(Composite parent) {
        ScrolledComposite scrolledComposite = new ScrolledComposite(parent, 512);
        scrolledComposite.setExpandVertical(true);
        scrolledComposite.setExpandHorizontal(true);
        scrolledComposite.setBackground(parent.getBackground());
        scrolledComposite.setBackgroundMode(1);
        Composite composite = new Composite((Composite)scrolledComposite, 0);
        scrolledComposite.setContent((Control)composite);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(20, 20).generateLayout(composite);
        WidgetFactory.label((int)0).text(Messages.SearchFor).create((Widget)composite);
        this.modeSelectionDropDown = new Combo(composite, 12);
        this.modeSelectionDropDown.setItems(new String[]{Messages.Variable, Messages.Attribute});
        this.modeSelectionDropDown.select(this.settings.modeSelection);
        this.modeSelectionDropDown.addListener(13, event -> {
            this.changeNatTable(this.natTable.getParent(), this.modeSelectionDropDown.getSelectionIndex());
            this.settings.modeSelection = this.modeSelectionDropDown.getSelectionIndex();
            this.natTable.getParent().layout();
        });
        Group searchGroup = (Group)WidgetFactory.group((int)0).text(Messages.SearchWhere).create((Widget)composite);
        searchGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        searchGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(2).create());
        this.searchFilter = new FilterComposite((Composite)searchGroup, 0, DEFAULT_LIST, this.settings, BulkEditorSettings.whereSearchList);
        this.createSearchInGroup(composite);
        this.createScopeGroup(composite);
        this.createSearchButton(composite);
        this.createNatTable(composite, this.settings.modeSelection);
        scrolledComposite.setMinSize(composite.computeSize(-1, -1));
        composite.layout();
    }

    private static <T> List<T> mapList(List<EObject> ori, Class<T> clazz) {
        ArrayList<T> result = new ArrayList<T>();
        for (EObject obj : ori) {
            if (!clazz.isInstance(obj)) continue;
            result.add(clazz.cast(obj));
        }
        return result;
    }

    private void createSearchInGroup(Composite parent) {
        Group searchGroup = new Group(parent, 0);
        searchGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        searchGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        searchGroup.setText(Messages.SearchIn);
        this.fbSubappTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.FBandSubappTypes, BulkEditorSettings.inFBTypesSearchList, this.settings.fbSubappTypes, b -> {
            boolean bl = this.settings.fbSubappTypes = b.booleanValue();
        });
        this.fbTypedSubappInstanceFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.FBandSubappInstances, BulkEditorSettings.inFBInstanceSearchList, this.settings.fbTypedSubappInstance, b -> {
            boolean bl = this.settings.fbTypedSubappInstance = b.booleanValue();
        });
        this.untypedSubappFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.UntypedSubapps, BulkEditorSettings.inUntypedSubAppSearchList, this.settings.untypedSubapp, b -> {
            boolean bl = this.settings.untypedSubapp = b.booleanValue();
        });
        this.dataTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.DataTypes, BulkEditorSettings.inDataTypesSearchList, this.settings.dataTypes, b -> {
            boolean bl = this.settings.dataTypes = b.booleanValue();
        });
        this.attributeTypesFilter = this.createSearchFilterInGroup((Composite)searchGroup, Messages.AttributeTypes, BulkEditorSettings.inAttributeTypesSearchList, this.settings.attributeTypes, b -> {
            boolean bl = this.settings.attributeTypes = b.booleanValue();
        });
    }

    private FilterComposite createSearchFilterInGroup(Composite parent, String name, List<String> subSettingsReferencesNames, boolean initalSelection, Consumer<Boolean> buttonListener) {
        Composite searchInCategoryComposite = new Composite(parent, 0);
        searchInCategoryComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        searchInCategoryComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        Composite searchInCategorySubComposite = new Composite(searchInCategoryComposite, 0);
        searchInCategorySubComposite.setLayoutData((Object)new GridData(4, 4, true, false));
        searchInCategorySubComposite.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(3).create());
        Button categorySelectionButton = (Button)WidgetFactory.button((int)32).text(name).create((Widget)searchInCategorySubComposite);
        categorySelectionButton.addListener(13, event -> buttonListener.accept(categorySelectionButton.getSelection()));
        categorySelectionButton.setSelection(initalSelection);
        FilterComposite filterComposite = new FilterComposite(searchInCategoryComposite, 0, LIST_WITHOUT_VALUE, this.settings, subSettingsReferencesNames);
        Twistie expandFilterCompositeTwistie = new Twistie(searchInCategorySubComposite, 0);
        expandFilterCompositeTwistie.addListener(4, event -> BulkEditor.updateVisibility(expandFilterCompositeTwistie.isExpanded(), filterComposite));
        BulkEditor.updateVisibility(false, filterComposite);
        Label stateLabel = new Label(searchInCategorySubComposite, 16384);
        stateLabel.setLayoutData((Object)new GridData(4, 4, true, false));
        filterComposite.addTextChangedListener(arg_0 -> ((Label)stateLabel).setText(arg_0));
        return filterComposite;
    }

    private static void updateVisibility(boolean visible, FilterComposite filter) {
        filter.setVisible(visible);
        ((GridData)filter.getLayoutData()).exclude = !visible;
        filter.layout();
        Composite composite = filter.getParent().getParent();
        composite.layout();
        Composite composite2 = composite.getParent().getParent();
        if (composite2 instanceof ScrolledComposite) {
            ScrolledComposite sc = (ScrolledComposite)composite2;
            sc.setMinSize(composite.getParent().computeSize(-1, -1));
        }
        composite.getParent().layout();
    }

    private void createScopeGroup(Composite parent) {
        Group scopeGroup = new Group(parent, 0);
        scopeGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        scopeGroup.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(4).create());
        scopeGroup.setText(Messages.Scope);
        this.projectScopeButton = (Button)WidgetFactory.button((int)16).text(MessageFormat.format(Messages.Project, this.project.getName())).create((Widget)scopeGroup);
        this.projectScopeButton.setSelection(this.settings.projectScope);
        this.projectScopeButton.addListener(13, event -> {
            boolean bl = this.settings.projectScope = this.projectScopeButton.getSelection();
        });
        this.workspaceScopeButton = (Button)WidgetFactory.button((int)16).text(Messages.Workspace).create((Widget)scopeGroup);
        this.workspaceScopeButton.setSelection(!this.projectScopeButton.getSelection());
    }

    private void createSearchButton(Composite parent) {
        WidgetFactory.button((int)8).text(Messages.Search).onSelect(event -> {
            SearchHelper helper = new SearchHelper(new SearchHelper.FilterRecordClass(this.settings.fbSubappTypes, this.fbSubappTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(0)), this.fbSubappTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(1)), this.fbSubappTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.fbTypedSubappInstance, this.fbTypedSubappInstanceFilter.getFilter(LIST_WITHOUT_VALUE.get(0)), this.fbTypedSubappInstanceFilter.getFilter(LIST_WITHOUT_VALUE.get(1)), this.fbTypedSubappInstanceFilter.getFilter(LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.untypedSubapp, this.untypedSubappFilter.getFilter(LIST_WITHOUT_VALUE.get(0)), this.untypedSubappFilter.getFilter(LIST_WITHOUT_VALUE.get(1)), this.untypedSubappFilter.getFilter(LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.dataTypes, this.dataTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(0)), this.dataTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(1)), this.dataTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(2))), new SearchHelper.FilterRecordClass(this.settings.attributeTypes, this.attributeTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(0)), this.attributeTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(1)), this.attributeTypesFilter.getFilter(LIST_WITHOUT_VALUE.get(2))));
            List<ISearchContext> contexts = helper.createSearchContextList(this.workspaceScopeButton.getSelection(), this.projectScopeButton.getSelection(), this.project);
            List result = contexts.stream().flatMap(context -> new IEC61499ElementSearch(context, SearchHelper.createSearchFilter(this.modeSelectionDropDown.getSelectionIndex(), DEFAULT_LIST.stream().map(this.searchFilter::getFilter).toList()), helper.createChildrenSearchProvider()).performSearch().stream()).toList();
            List<EObject> mappedList = this.createMappedList(result);
            if (this.modeSelectionDropDown.getSelectionIndex() == 0 && (mappedList.isEmpty() || mappedList.getFirst() instanceof VarDeclaration)) {
                this.varDeclProvider.setInput(BulkEditor.mapList(mappedList, VarDeclaration.class));
            } else if (this.modeSelectionDropDown.getSelectionIndex() == 1 && (mappedList.isEmpty() || mappedList.getFirst() instanceof Attribute)) {
                this.attributeProvider.setInput(BulkEditor.mapList(mappedList, Attribute.class));
            }
            this.natTable.refresh();
        }).create((Widget)parent);
    }

    private List<EObject> createMappedList(List<? extends EObject> list) {
        ArrayList<EObject> mappedList = new ArrayList<EObject>();
        this.map.clear();
        for (EObject eObject : list) {
            EObject eObject2 = EcoreUtil.getRootContainer((EObject)eObject);
            if (!(eObject2 instanceof LibraryElement)) continue;
            LibraryElement rootLibE = (LibraryElement)eObject2;
            TypeEntry entry = rootLibE.getTypeEntry();
            this.map.computeIfAbsent(entry, e -> new CopyElementRecord(e.copyType(), new ArrayList<EObject>()));
            EObject copyLibE = EcoreUtil.getEObject((EObject)this.map.get(entry).copiedElement(), (String)EcoreUtil.getRelativeURIFragmentPath((EObject)rootLibE, (EObject)eObject));
            this.map.get(entry).addToList(copyLibE);
            mappedList.add(copyLibE);
        }
        return mappedList;
    }

    private void createNatTable(Composite parent, int selectionIndex) {
        Composite comp = new Composite(parent, 0);
        GridData gridData = new GridData(4, 4, true, true);
        gridData.minimumHeight = (parent.computeSize((int)-1, (int)-1).y / 20 + 1) * 20;
        comp.setLayoutData((Object)gridData);
        GridLayoutFactory.fillDefaults().numColumns(1).margins(0, 0).generateLayout(comp);
        this.changeNatTable(comp, selectionIndex);
    }

    private void changeNatTable(Composite parent, int selectionIndex) {
        if (this.natTable != null) {
            this.natTable.dispose();
        }
        if (selectionIndex == 0) {
            this.varDeclProvider = new ChangeableListDataProvider((IColumnAccessor)new VarDeclarationColumnAccessor((CommandExecutor)this, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION));
            VarDeclarationDataLayer inputDataLayer = new VarDeclarationDataLayer(this.varDeclProvider, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
            inputDataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new VarDeclarationConfigLabelAccumulator(this.varDeclProvider, () -> null, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION));
            NatTableColumnProvider columnProvider = new NatTableColumnProvider(VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
            this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)parent, (DataLayer)inputDataLayer, (IDataProvider)columnProvider, (IEditableRule)new NatTableColumnEditableRule(IEditableRule.ALWAYS_EDITABLE, VarDeclarationTableColumn.DEFAULT_COLUMNS_WITH_LOCATION, VarDeclarationTableColumn.EDITABLE_NO_LOCATION), null, null, (boolean)false);
            this.natTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.varDeclProvider));
            this.natTable.addConfiguration((IConfiguration)new TypeDeclarationEditorConfiguration(this.varDeclProvider));
            this.natTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, (CommandExecutor)this));
        } else {
            this.attributeProvider = new ChangeableListDataProvider((IColumnAccessor)new AttributeColumnAccessor((CommandExecutor)this, AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION));
            DataLayer dataLayer = new DataLayer(this.attributeProvider);
            dataLayer.setConfigLabelAccumulator((IConfigLabelAccumulator)new AttributeConfigLabelAccumulator(this.attributeProvider, () -> null, AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION));
            NatTableColumnProvider columnProvider = new NatTableColumnProvider(AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION);
            this.natTable = NatTableWidgetFactory.createRowNatTable((Composite)parent, (DataLayer)dataLayer, (IDataProvider)columnProvider, (IEditableRule)new AttributeEditableRule(IEditableRule.ALWAYS_EDITABLE, AttributeTableColumn.DEFAULT_COLUMNS_WITH_LOCATION, AttributeTableColumn.EDITABLE_NO_LOCATION, this.attributeProvider), (ICellEditor)new TypeSelectionButton(() -> {
                int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
                EObject eObject = EcoreUtil.getRootContainer((EObject)((EObject)this.attributeProvider.getRowObject(relevantRowIndex)));
                if (eObject instanceof LibraryElement) {
                    LibraryElement libElement = (LibraryElement)eObject;
                    return libElement.getTypeLibrary();
                }
                return null;
            }, (ITypeSelectionContentProvider)DataTypeSelectionContentProvider.INSTANCE, (TypeSelectionTreeContentProvider)DataTypeSelectionTreeContentProvider.INSTANCE), null, (boolean)false);
            this.natTable.addConfiguration((IConfiguration)new InitialValueEditorConfiguration(this.attributeProvider));
            this.natTable.addConfiguration((IConfiguration)new DefaultImportCopyPasteLayerConfiguration(columnProvider, (CommandExecutor)this));
            Predicate<TypeEntry> targetFilter = entry -> {
                LibraryElement libraryElement = entry.getType();
                if (libraryElement instanceof AttributeDeclaration) {
                    AttributeDeclaration decl = (AttributeDeclaration)libraryElement;
                    int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
                    EObject eObject = ((Attribute)this.attributeProvider.getRowObject(relevantRowIndex)).eContainer();
                    if (eObject instanceof ConfigurableObject) {
                        ConfigurableObject configurableObject = (ConfigurableObject)eObject;
                        return decl.isValidObject(configurableObject);
                    }
                }
                return true;
            };
            final AttributeNameCellEditor attributeNameCellEditor = new AttributeNameCellEditor();
            attributeNameCellEditor.enableContentProposal((IControlContentAdapter)new TextContentAdapter(), (IContentProposalProvider)new ImportTypeSelectionProposalProvider(() -> {
                int relevantRowIndex = NatTableWidgetFactory.getSelectionLayer((NatTable)this.natTable).getLastSelectedCellPosition().getRowPosition();
                return ((Attribute)this.attributeProvider.getRowObject(relevantRowIndex)).eContainer();
            }, TypeLibrary::getAttributeTypeEntry, (ITypeSelectionContentProvider)AttributeSelectionContentProvider.INSTANCE, targetFilter), KeyStroke.getInstance((int)262144, (int)32), null);
            this.natTable.addConfiguration((IConfiguration)new AbstractRegistryConfiguration(){

                public void configureRegistry(IConfigRegistry configRegistry) {
                    configRegistry.registerConfigAttribute(EditConfigAttributes.CELL_EDITOR, (Object)attributeNameCellEditor, DisplayMode.EDIT, "ATTRIBUTE_PROPOSAL_CELL");
                }
            });
        }
        this.natTable.configure();
    }

    public boolean isDirty() {
        return this.commandStack.isDirty();
    }

    public boolean isSaveAsAllowed() {
        return true;
    }

    public void setFocus() {
    }

    public void doSave(IProgressMonitor monitor) {
        List<TypeEntry> affect = Arrays.stream(this.commandStack.getCommands()).filter(ScopedCommand.class::isInstance).flatMap(cmd -> ((ScopedCommand)cmd).getAffectedObjects().stream()).map(eobj -> {
            EObject eObject = EcoreUtil.getRootContainer((EObject)eobj);
            if (eObject instanceof LibraryElement) {
                LibraryElement rootLibE = (LibraryElement)eObject;
                return rootLibE.getTypeEntry();
            }
            return null;
        }).filter(Objects::nonNull).distinct().toList();
        affect.forEach(entry -> {
            try {
                if (this.map.containsKey(entry)) {
                    entry.save(this.map.get(entry).copiedElement());
                }
            }
            catch (CoreException e) {
                e.printStackTrace();
            }
        });
        this.commandStack.markSaveLocation();
    }

    public void doSaveAs() {
    }

    public void executeCommand(Command cmd) {
        this.commandStack.execute(cmd);
    }

    public void stackChanged(CommandStackEvent event) {
        this.firePropertyChange(257);
    }

    protected class AttributeNameCellEditor
    extends TextCellEditor {
        protected AttributeNameCellEditor() {
        }

        protected void configureContentProposalAdapter(ContentProposalAdapter contentProposalAdapter) {
            contentProposalAdapter.addContentProposalListener(this::proposalAccepted);
            super.configureContentProposalAdapter(contentProposalAdapter);
        }

        protected void proposalAccepted(IContentProposal proposal) {
            if (proposal instanceof ImportContentProposal) {
                ImportContentProposal importProposal = (ImportContentProposal)proposal;
                EObject eObject = EcoreUtil.getRootContainer((EObject)((Attribute)BulkEditor.this.attributeProvider.getRowObject(this.getRowIndex())).eContainer());
                if (eObject instanceof LibraryElement) {
                    LibraryElement libraryElement = (LibraryElement)eObject;
                    if (!ImportHelper.matchesImports((String)importProposal.getImportedNamespace(), (LibraryElement)libraryElement)) {
                        BulkEditor.this.executeCommand((Command)new AddNewImportCommand(libraryElement, importProposal.getImportedNamespace()));
                    }
                }
            }
        }
    }
}

