/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.ui.IMemento;

public class BulkEditorSettings {
    private static final String TAG_BULKEDITOR_SETTINGS = "BULKEDITOR_SETTINGS";
    private static final String MODE_TAG = "_mode";
    public int modeSelection = 0;
    private static final String FB_TYPES_TAG = "_fbTypes";
    public boolean fbSubappTypes = true;
    private static final String FB_INSTANCES_TAG = "_fbInstances";
    public boolean fbTypedSubappInstance = true;
    private static final String UNTYPED_SUBAPPS_TAG = "_untypedSubapps";
    public boolean untypedSubapp = true;
    private static final String DATA_TYPES_TAG = "_dataTypes";
    public boolean dataTypes = true;
    private static final String ATTRIBUTE_TYPES_TAG = "_attributeTypes";
    public boolean attributeTypes = true;
    private static final String SCOPE_TAG = "_scope";
    public boolean projectScope = true;
    public static final List<String> whereSearchList = List.of("_where-name", "_where-type", "_where-comment", "_where-value");
    public static final List<String> inFBTypesSearchList = List.of("_inFBType-name", "_inFBType-type", "_inFBType-comment");
    public static final List<String> inFBInstanceSearchList = List.of("_inFBInstance-name", "_inFBInstance-type", "_inFBInstance-comment");
    public static final List<String> inUntypedSubAppSearchList = List.of("_inUntypedSubApp-name", "_inUntypedSubApp-type", "_inUntypedSubApp-comment");
    public static final List<String> inDataTypesSearchList = List.of("_inDT-name", "_inDT-type", "_inDT-comment");
    public static final List<String> inAttributeTypesSearchList = List.of("_inAT-name", "_inAT-type", "_inAT-comment");
    private final Map<String, BulkEditorSubSettings> subSettingsMap = Stream.of(whereSearchList, inFBTypesSearchList, inFBInstanceSearchList, inUntypedSubAppSearchList, inDataTypesSearchList, inAttributeTypesSearchList).flatMap(Collection::stream).map(BulkEditorSettings::createSubSettingEntry).collect(Collectors.toUnmodifiableMap(Map.Entry::getKey, Map.Entry::getValue));

    private static Map.Entry<String, BulkEditorSubSettings> createSubSettingEntry(String ref) {
        return Map.entry(ref, new BulkEditorSubSettings(ref));
    }

    public BulkEditorSubSettings getSubSettings(String ref) {
        return this.subSettingsMap.get(ref);
    }

    public void saveState(IMemento memento) {
        IMemento childMemento = memento.createChild(TAG_BULKEDITOR_SETTINGS);
        this.subSettingsMap.values().forEach(subSetting -> subSetting.saveState(childMemento));
        childMemento.putInteger(MODE_TAG, this.modeSelection);
        childMemento.putBoolean(FB_TYPES_TAG, this.fbSubappTypes);
        childMemento.putBoolean(FB_INSTANCES_TAG, this.fbTypedSubappInstance);
        childMemento.putBoolean(UNTYPED_SUBAPPS_TAG, this.untypedSubapp);
        childMemento.putBoolean(DATA_TYPES_TAG, this.dataTypes);
        childMemento.putBoolean(ATTRIBUTE_TYPES_TAG, this.attributeTypes);
        childMemento.putBoolean(SCOPE_TAG, this.projectScope);
    }

    public static BulkEditorSettings createFromMemento(IMemento memento) {
        BulkEditorSettings settings = new BulkEditorSettings();
        IMemento childMemento = memento.getChild(TAG_BULKEDITOR_SETTINGS);
        settings.subSettingsMap.values().forEach(subSetting -> subSetting.changeFromMemento(childMemento));
        settings.modeSelection = childMemento.getInteger(MODE_TAG);
        settings.fbSubappTypes = childMemento.getBoolean(FB_TYPES_TAG);
        settings.fbTypedSubappInstance = childMemento.getBoolean(FB_INSTANCES_TAG);
        settings.untypedSubapp = childMemento.getBoolean(UNTYPED_SUBAPPS_TAG);
        settings.dataTypes = childMemento.getBoolean(DATA_TYPES_TAG);
        settings.attributeTypes = childMemento.getBoolean(ATTRIBUTE_TYPES_TAG);
        settings.projectScope = childMemento.getBoolean(SCOPE_TAG);
        return settings;
    }

    public static class BulkEditorSubSettings {
        private static final String SELECTED_TAG = "_selected";
        private static final String NAME_TAG = "_name";
        private static final String CASE_SENSITIVE_TAG = "_caseSensitve";
        private static final String WHOLE_WORD_TAG = "_wholeWord";
        private static final String EXACT_MATCH_TAG = "_exactMatch";
        private static final String REGULAR_EXPRESSION_TAG = "_regularExpression";
        private final String tagBulkEditorSubSettings;
        public boolean selected = false;
        public String textField = "";
        public boolean caseSensitive = false;
        public boolean wholeWord = false;
        public boolean exactMatch = false;
        public boolean regularExpression = false;

        public BulkEditorSubSettings(String nameAddition) {
            this.tagBulkEditorSubSettings = nameAddition;
        }

        public void saveState(IMemento memento) {
            IMemento childMemento = memento.createChild(this.tagBulkEditorSubSettings);
            childMemento.putBoolean(SELECTED_TAG, this.selected);
            childMemento.putString(NAME_TAG, this.textField);
            childMemento.putBoolean(CASE_SENSITIVE_TAG, this.caseSensitive);
            childMemento.putBoolean(WHOLE_WORD_TAG, this.wholeWord);
            childMemento.putBoolean(EXACT_MATCH_TAG, this.exactMatch);
            childMemento.putBoolean(REGULAR_EXPRESSION_TAG, this.regularExpression);
        }

        public void changeFromMemento(IMemento memento) {
            IMemento childMemento = memento.getChild(this.tagBulkEditorSubSettings);
            this.selected = childMemento.getBoolean(SELECTED_TAG);
            this.textField = childMemento.getString(NAME_TAG);
            this.caseSensitive = childMemento.getBoolean(CASE_SENSITIVE_TAG);
            this.wholeWord = childMemento.getBoolean(WHOLE_WORD_TAG);
            this.exactMatch = childMemento.getBoolean(EXACT_MATCH_TAG);
            this.regularExpression = childMemento.getBoolean(REGULAR_EXPRESSION_TAG);
        }
    }
}

