/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.bulkeditor.editors;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.bulkeditor.Messages;
import org.eclipse.fordiac.ide.bulkeditor.editors.BulkEditorSettings;
import org.eclipse.fordiac.ide.ui.imageprovider.FordiacImage;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.layout.GridLayoutFactory;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.widgets.ButtonFactory;
import org.eclipse.jface.widgets.TextFactory;
import org.eclipse.jface.widgets.WidgetFactory;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.osgi.framework.Bundle;

public class FilterComposite
extends Composite {
    private final List<Filter> filterList = new ArrayList<Filter>();
    private final List<String> filterNames;
    private final int firstItemWidth;
    private final List<Consumer<String>> textChangedListeners = new ArrayList<Consumer<String>>();

    public FilterComposite(Composite parent, int style, List<String> filterNames, BulkEditorSettings settings, List<String> subSettingsReferencesNames) {
        super(parent, style);
        this.setLayoutData(new GridData(4, 4, true, false));
        this.setLayout((Layout)GridLayoutFactory.swtDefaults().numColumns(1).create());
        this.firstItemWidth = FilterComposite.calculateMaxCheckboxWidth(parent, filterNames);
        this.filterNames = filterNames;
        int i = 0;
        while (i < filterNames.size()) {
            Filter filter = new Filter(this, style, filterNames.get(i));
            this.filterList.add(filter);
            if (i < subSettingsReferencesNames.size()) {
                filter.addListenerSubSetting(settings.getSubSettings(subSettingsReferencesNames.get(i)));
            }
            ++i;
        }
    }

    private static int calculateMaxCheckboxWidth(Composite parent, List<String> names) {
        int maxWidth = 0;
        GC gc = new GC((Drawable)parent);
        for (String name : names) {
            int textWidth = gc.textExtent((String)name).x + 20;
            if (textWidth <= maxWidth) continue;
            maxWidth = textWidth;
        }
        gc.dispose();
        return maxWidth;
    }

    public void addTextChangedListener(Consumer<String> listener) {
        this.textChangedListeners.add(listener);
        listener.accept(this.createFiltersText());
    }

    private String createFiltersText() {
        StringBuilder sb = new StringBuilder();
        String text = this.filterList.stream().filter(filter -> filter.selected.getSelection()).map(filter -> filter.name + ": " + filter.textField.getText()).collect(Collectors.joining(", "));
        if (!text.isEmpty()) {
            sb.append('(');
            sb.append(text);
            sb.append(')');
        }
        return sb.toString();
    }

    public Filter getFilter(String filterName) {
        int index = this.filterNames.indexOf(filterName);
        if (index >= 0 && index < this.filterList.size()) {
            return this.filterList.get(index);
        }
        return null;
    }

    public class Filter
    extends Composite {
        private static final String IMAGE_BUNDLE = "org.eclipse.ui.workbench.texteditor";
        private static final String CASE_SENSITVE_IMAGE = "icons/full/elcl16/case_sensitive.png";
        private static final String EXACT_MATCH_IMAGE = "icons/full/elcl16/whole_word.png";
        private static final String REGULAR_EXPRESSION_IMAGE = "icons/full/elcl16/regex.png";
        public final String name;
        public final Button selected;
        public final Text textField;
        public final Button caseSensitive;
        public final Button wholeWord;
        public final Button exactMatch;
        public final Button regularExpression;

        public Filter(Composite parent, int style, String name) {
            super(parent, style);
            this.name = name;
            this.setLayoutData(new GridData(4, 4, true, false));
            this.setLayout((Layout)GridLayoutFactory.swtDefaults().margins(0, 0).numColumns(6).create());
            this.selected = (Button)WidgetFactory.button((int)32).text(name).create((Widget)this);
            this.selected.setLayoutData((Object)GridDataFactory.swtDefaults().hint(FilterComposite.this.firstItemWidth, -1).create());
            this.textField = (Text)((TextFactory)WidgetFactory.text((int)2048).layoutData((Object)new GridData(4, 4, true, false))).create((Widget)this);
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(CASE_SENSITVE_IMAGE)));
            this.caseSensitive = (Button)((ButtonFactory)WidgetFactory.button((int)2).image(descriptor.createImage()).tooltip(Messages.CaseSensitve)).create((Widget)this);
            descriptor = FordiacImage.ICON_WHOLE_WORD.getImageDescriptor();
            this.wholeWord = (Button)((ButtonFactory)WidgetFactory.button((int)2).image(descriptor.createImage()).tooltip(Messages.WholeWord)).create((Widget)this);
            descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(EXACT_MATCH_IMAGE)));
            this.exactMatch = (Button)((ButtonFactory)WidgetFactory.button((int)2).image(descriptor.createImage()).tooltip(Messages.ExactMatch)).create((Widget)this);
            descriptor = ImageDescriptor.createFromURL((URL)FileLocator.find((Bundle)Platform.getBundle((String)IMAGE_BUNDLE), (IPath)new Path(REGULAR_EXPRESSION_IMAGE)));
            this.regularExpression = (Button)((ButtonFactory)WidgetFactory.button((int)2).image(descriptor.createImage()).tooltip(Messages.RegularExpression)).create((Widget)this);
            this.selected.addListener(13, event -> {
                this.textField.setEnabled(this.selected.getSelection());
                this.caseSensitive.setEnabled(this.selected.getSelection());
                this.wholeWord.setEnabled(this.selected.getSelection() && !this.exactMatch.getSelection() && !this.regularExpression.getSelection());
                this.exactMatch.setEnabled(this.selected.getSelection() && !this.wholeWord.getSelection());
                this.regularExpression.setEnabled(this.selected.getSelection() && !this.wholeWord.getSelection());
            });
        }

        private void addListenerSubSetting(BulkEditorSettings.BulkEditorSubSettings subSetting) {
            boolean isSelected = subSetting.selected;
            this.selected.setSelection(isSelected);
            this.selected.addListener(13, event -> {
                bulkEditorSubSettings.selected = this.selected.getSelection();
                this.fireTextChanged();
            });
            this.textField.setText(subSetting.textField);
            this.textField.setEnabled(isSelected);
            this.textField.addModifyListener(event -> {
                bulkEditorSubSettings.textField = this.textField.getText();
                this.fireTextChanged();
            });
            this.caseSensitive.setSelection(subSetting.caseSensitive);
            this.caseSensitive.setEnabled(isSelected);
            this.caseSensitive.addListener(13, event -> {
                boolean bl = bulkEditorSubSettings.caseSensitive = this.caseSensitive.getSelection();
            });
            this.wholeWord.setSelection(subSetting.wholeWord);
            this.wholeWord.setEnabled(isSelected && !subSetting.exactMatch && !subSetting.regularExpression);
            this.wholeWord.addListener(13, event -> {
                bulkEditorSubSettings.wholeWord = this.wholeWord.getSelection();
                this.exactMatch.setEnabled(!this.wholeWord.getSelection());
                this.regularExpression.setEnabled(!this.wholeWord.getSelection());
            });
            this.exactMatch.setSelection(subSetting.exactMatch);
            this.exactMatch.setEnabled(isSelected && !subSetting.wholeWord);
            this.exactMatch.addListener(13, event -> {
                bulkEditorSubSettings.exactMatch = this.exactMatch.getSelection();
                this.wholeWord.setEnabled(!this.exactMatch.getSelection() && !this.regularExpression.getSelection());
            });
            this.regularExpression.setSelection(subSetting.regularExpression);
            this.regularExpression.setEnabled(isSelected && !subSetting.wholeWord);
            this.regularExpression.addListener(13, event -> {
                bulkEditorSubSettings.regularExpression = this.regularExpression.getSelection();
                this.wholeWord.setEnabled(!this.exactMatch.getSelection() && !this.regularExpression.getSelection());
            });
        }

        private void fireTextChanged() {
            String newText = FilterComposite.this.createFiltersText();
            FilterComposite.this.textChangedListeners.forEach(listener -> listener.accept(newText));
        }
    }
}

