/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import com.google.inject.Inject;
import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EClassifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.data.AnyBitType;
import org.eclipse.fordiac.ide.model.data.AnyCharsType;
import org.eclipse.fordiac.ide.model.data.AnyIntType;
import org.eclipse.fordiac.ide.model.data.AnyRealType;
import org.eclipse.fordiac.ide.model.data.AnySignedType;
import org.eclipse.fordiac.ide.model.data.AnyStringType;
import org.eclipse.fordiac.ide.model.data.AnyUnsignedType;
import org.eclipse.fordiac.ide.model.data.ArrayType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.DirectlyDerivedType;
import org.eclipse.fordiac.ide.model.data.Subrange;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.eval.value.Value;
import org.eclipse.fordiac.ide.model.eval.value.ValueOperations;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.value.NumericValueConverter;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.converter.STStringValueConverter;
import org.eclipse.fordiac.ide.structuredtextcore.resource.LibraryElementXtextResource;
import org.eclipse.fordiac.ide.structuredtextcore.scoping.STStandardFunctionProvider;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STArrayInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAssignment;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STAttribute;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBinaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeature;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STBuiltinFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCallUnnamedArgument;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCaseCases;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STContinue;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STCorePackage;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STElementaryInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExit;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpressionSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STIfStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STInitializerExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMemberAccessExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STMultibitPartialExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STNumericLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STPragma;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STRepeatStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STSource;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStandardFunction;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STString;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STStringLiteral;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STTypeDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STUnaryOperator;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclaration;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STWhileStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.validation.AbstractSTCoreValidator;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.diagnostics.Severity;
import org.eclipse.xtext.nodemodel.ICompositeNode;
import org.eclipse.xtext.nodemodel.INode;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STCoreValidator
extends AbstractSTCoreValidator {
    @Inject
    private STStandardFunctionProvider standardFunctionProvider;
    @Inject
    private STStringValueConverter stringValueConverter;
    public static final String ISSUE_CODE_PREFIX = "org.eclipse.fordiac.ide.structuredtextcore.";
    public static final String CONSECUTIVE_UNDERSCORE_IN_IDENTIFIER_ERROR = "org.eclipse.fordiac.ide.structuredtextcore.consecutiveUnderscoreInIdentifierError";
    public static final String TRAILING_UNDERSCORE_IN_IDENTIFIER_ERROR = "org.eclipse.fordiac.ide.structuredtextcore.identiferEndsInUnderscoreError";
    public static final String VALUE_NOT_ASSIGNABLE = "org.eclipse.fordiac.ide.structuredtextcore.valueNotAssignable";
    public static final String NON_COMPATIBLE_TYPES = "org.eclipse.fordiac.ide.structuredtextcore.nonCompatibleTypes";
    public static final String NON_COMPARABLE_TYPES = "org.eclipse.fordiac.ide.structuredtextcore.nonComparableTypes";
    public static final String WRONG_NAME_CASE = "org.eclipse.fordiac.ide.structuredtextcore.wrongNameCase";
    public static final String RESERVED_IDENTIFIER_ERROR = "org.eclipse.fordiac.ide.structuredtextcore.reservedIdentifierError";
    public static final String UNQUALIFIED_FB_CALL_ON_FB_WITH_INPUT_EVENT_SIZE_NOT_ONE = "org.eclipse.fordiac.ide.structuredtextcore.UnqualifiedFbCallOnFbWithInputEventSizeNotOne";
    public static final String MIXING_FORMAL_AND_NON_FORMAL_ARGUMENTS = "org.eclipse.fordiac.ide.structuredtextcore.mixingFormalAndNonFormal";
    public static final String FEATURE_NOT_CALLABLE = "org.eclipse.fordiac.ide.structuredtextcore.featureNotCallable";
    public static final String WRONG_NUMBER_OF_ARGUMENTS = "org.eclipse.fordiac.ide.structuredtextcore.wrongNumberOfArguments";
    public static final String OPERATOR_NOT_APPLICABLE = "org.eclipse.fordiac.ide.structuredtextcore.operatorNotApplicable";
    public static final String FOR_VARIABLE_NOT_INTEGRAL_TYPE = "org.eclipse.fordiac.ide.structuredtextcore.forVariableNotIntegralType";
    public static final String INVALID_NUMERIC_LITERAL = "org.eclipse.fordiac.ide.structuredtextcore.invalidNumericLiteral";
    public static final String INVALID_STRING_LITERAL = "org.eclipse.fordiac.ide.structuredtextcore.invalidStringLiteral";
    public static final String STANDARD_FUNCTION_WITH_FORMAL_ARGUMENTS = "org.eclipse.fordiac.ide.structuredtextcore.standardFunctionWithFormalArguments";
    public static final String LITERAL_IMPLICIT_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.literalImplicitConversion";
    public static final String ICALLABLE_NOT_VISIBLE = "org.eclipse.fordiac.ide.structuredtextcore.iCallableNotVisible";
    public static final String ICALLABLE_HAS_NO_RETURN_TYPE = "org.eclipse.fordiac.ide.structuredtextcore.iCallableHasNoReturnType";
    public static final String BIT_ACCESS_INDEX_OUT_OF_RANGE = "org.eclipse.fordiac.ide.structuredtextcore.bitAccessIndexOutOfRange";
    public static final String BIT_ACCESS_INDEX_INVALID_EXPRESSION = "org.eclipse.fordiac.ide.structuredtextcore.bitAccessInvalidExpression";
    public static final String BIT_ACCESS_INVALID_FOR_TYPE = "org.eclipse.fordiac.ide.structuredtextcore.bitAccessInvalidForType";
    public static final String BIT_ACCESS_INVALID_RECEIVER = "org.eclipse.fordiac.ide.structuredtextcore.bitAccessInvalidForReceiver";
    public static final String BIT_ACCESS_EXPRESSION_NOT_OF_TYPE_ANY_INT = "org.eclipse.fordiac.ide.structuredtextcore.bitAccessExpressionNotOfTypeAnyInt";
    public static final String DUPLICATE_VARIABLE_NAME = "org.eclipse.fordiac.ide.structuredtextcore.duplicateVariableName";
    public static final String INDEX_RANGE_TYPE_INVALID = "org.eclipse.fordiac.ide.structuredtextcore.indexRangeTypeInvalid";
    public static final String INDEX_RANGE_EXPRESSION_INVALID = "org.eclipse.fordiac.ide.structuredtextcore.indexRangeExpressionInvalid";
    public static final String MAX_LENGTH_NOT_ALLOWED = "org.eclipse.fordiac.ide.structuredtextcore.maxLengthNotAllowed";
    public static final String MAX_LENGTH_TYPE_INVALID = "org.eclipse.fordiac.ide.structuredtextcore.maxLengthTypeInvalid";
    public static final String TOO_MANY_INDICES_GIVEN = "org.eclipse.fordiac.ide.structuredtextcore.tooManyIndicesGiven";
    public static final String ARRAY_ACCESS_INVALID = "org.eclipse.fordiac.ide.structuredtextcore.arrayAccessInvalid";
    public static final String ARRAY_ACCESS_RECEIVER_INVALID = "org.eclipse.fordiac.ide.structuredtextcore.arrayAccessReceiverInvalid";
    public static final String ARRAY_INDEX_OUT_OF_BOUNDS = "org.eclipse.fordiac.ide.structuredtextcore.arrayIndexOutOfBounds";
    public static final String TRUNCATED_LITERAL = "org.eclipse.fordiac.ide.structuredtextcore.truncatedLiteral";
    public static final String STRING_INDEX_OUT_OF_BOUNDS = "org.eclipse.fordiac.ide.structuredtextcore.stringIndexOutOfBounds";
    public static final String RETURNED_TYPE_IS_VOID = "org.eclipse.fordiac.ide.structuredtextcore.returnedTypeIsVoid";
    public static final String LITERAL_REQUIRES_TYPE_SPECIFIER = "org.eclipse.fordiac.ide.structuredtextcore.literalRequiresTypeSpecifier";
    public static final String INSUFFICIENT_ARRAY_DIMENSIONS = "org.eclipse.fordiac.ide.structuredtextcore.insufficientArrayDimensions";
    public static final String UNNECESSARY_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.unnecessaryConversion";
    public static final String UNNECESSARY_WIDE_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.unnecessaryWideConversion";
    public static final String UNNECESSARY_NARROW_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.unnecessaryNarrowConversion";
    public static final String UNNECESSARY_LITERAL_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.unnecessaryLiteralConversion";
    public static final String TRUNCATING_LITERAL_CONVERSION = "org.eclipse.fordiac.ide.structuredtextcore.truncatingLiteralConversion";
    public static final String NON_CONSTANT_DECLARATION = "org.eclipse.fordiac.ide.structuredtextcore.nonConstantInInitializer";
    public static final String MAYBE_NOT_INITIALIZED = "org.eclipse.fordiac.ide.structuredtextcore.maybeNotInitialized";
    public static final String FOR_CONTROL_VARIABLE_MODIFICATION = "org.eclipse.fordiac.ide.structuredtextcore.forControlVariableModification";
    public static final String FOR_CONTROL_VARIABLE_NON_TEMPORARY = "org.eclipse.fordiac.ide.structuredtextcore.forControlVariableNonTemporary";
    public static final String FOR_CONTROL_VARIABLE_UNDEFINED = "org.eclipse.fordiac.ide.structuredtextcore.forControlVariableUndefined";
    public static final String EXIT_NOT_IN_LOOP = "org.eclipse.fordiac.ide.structuredtextcore.exitNotInLoop";
    public static final String CONTINUE_NOT_IN_LOOP = "org.eclipse.fordiac.ide.structuredtextcore.continueNotInLoop";
    public static final String NESTED_ASSIGNMENT = "org.eclipse.fordiac.ide.structuredtextcore.nestedAssignment";
    public static final String INVALID_IMPORT = "org.eclipse.fordiac.ide.structuredtextcore.invalidImport";
    public static final String WILDCARD_IMPORT = "org.eclipse.fordiac.ide.structuredtextcore.wildcardImport";
    public static final String UNUSED_IMPORT = "org.eclipse.fordiac.ide.structuredtextcore.unusedImport";
    public static final String DUPLICATE_ATTRIBUTE = "org.eclipse.fordiac.ide.structuredtextcore.duplicateAttribute";
    public static final String PACKAGE_NAME_MISMATCH = "org.eclipse.fordiac.ide.structuredtextcore.packageNameMismatch";
    public static final String UNUSED_VARIABLE = "org.eclipse.fordiac.ide.structuredtextcore.unusedVariable";
    public static final String UNREAD_VARIABLE = "org.eclipse.fordiac.ide.structuredtextcore.unreadVariable";
    public static final String UNWRITTEN_VARIABLE = "org.eclipse.fordiac.ide.structuredtextcore.unwrittenVariable";
    private static final Pattern CONVERSION_FUNCTION_PATTERN = Pattern.compile("[a-zA-Z]+_TO_[a-zA-Z]+");
    private static final Pattern IDENTIFIER_CONSECUTIVE_UNDERSCORES_PATTERN = Pattern.compile("_{2,}[^_]");

    private void checkRangeOnValidity(STExpression expression) {
        if (expression instanceof STBinaryExpression) {
            DataType rightType;
            STBinaryExpression subRangeExpression = (STBinaryExpression)expression;
            DataType leftType = (DataType)subRangeExpression.getLeft().getResultType();
            if (!(leftType instanceof AnyIntType)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_IndexRangeTypeInvalid, leftType.getName()), (EObject)subRangeExpression, (EStructuralFeature)STCorePackage.Literals.ST_BINARY_EXPRESSION__LEFT, INDEX_RANGE_TYPE_INVALID, new String[]{leftType.getName()});
            }
            if (!((rightType = (DataType)subRangeExpression.getRight().getResultType()) instanceof AnyIntType)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_IndexRangeTypeInvalid, rightType.getName()), (EObject)subRangeExpression, (EStructuralFeature)STCorePackage.Literals.ST_BINARY_EXPRESSION__RIGHT, INDEX_RANGE_TYPE_INVALID, new String[]{rightType.getName()});
            }
        } else {
            this.error(Messages.STCoreValidator_IndexRangeExpressionInvalid, (EObject)expression, null, INDEX_RANGE_EXPRESSION_INVALID, new String[0]);
        }
    }

    @Check
    public void checkIndexRangeValueType(STVarDeclaration varDeclaration) {
        if (varDeclaration.isArray()) {
            varDeclaration.getRanges().stream().forEach(this::checkRangeOnValidity);
        }
    }

    @Check
    public void checkIndexRangeValueType(STTypeDeclaration typeDeclaration) {
        if (typeDeclaration.isArray()) {
            typeDeclaration.getRanges().stream().forEach(this::checkRangeOnValidity);
        }
    }

    @Check
    public void checkIfMaxSizeOnVarDeclarationAllowed(STVarDeclaration varDeclaration) {
        if (varDeclaration.getMaxLength() != null && !(varDeclaration.getType() instanceof AnyStringType)) {
            this.error(Messages.STCoreValidator_NonAnyStringNotMaxLengthSettingNotAllowed, (EObject)varDeclaration, (EStructuralFeature)STCorePackage.Literals.ST_VAR_DECLARATION__MAX_LENGTH, MAX_LENGTH_NOT_ALLOWED, new String[0]);
        }
    }

    @Check
    public void checkIfMaxSizeOnVarDeclarationAllowed(STTypeDeclaration typeDeclaration) {
        if (typeDeclaration.getMaxLength() != null && !(typeDeclaration.getType() instanceof AnyStringType)) {
            this.error(Messages.STCoreValidator_NonAnyStringNotMaxLengthSettingNotAllowed, (EObject)typeDeclaration, (EStructuralFeature)STCorePackage.Literals.ST_TYPE_DECLARATION__MAX_LENGTH, MAX_LENGTH_NOT_ALLOWED, new String[0]);
        }
    }

    @Check
    public void checkTypeofStringSizeValue(STVarDeclaration varDeclaration) {
        if (varDeclaration.getType() instanceof AnyStringType && varDeclaration.getMaxLength() != null && !(varDeclaration.getMaxLength().getResultType() instanceof AnyIntType)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_MaxLengthTypeInvalid, varDeclaration.getMaxLength().getResultType().getName()), (EObject)varDeclaration, (EStructuralFeature)STCorePackage.Literals.ST_VAR_DECLARATION__MAX_LENGTH, MAX_LENGTH_TYPE_INVALID, new String[]{varDeclaration.getMaxLength().getResultType().getName()});
        }
    }

    @Check
    public void checkTypeofStringSizeValue(STTypeDeclaration typeDeclaration) {
        if (typeDeclaration.getType() instanceof AnyStringType && typeDeclaration.getMaxLength() != null && !(typeDeclaration.getMaxLength().getResultType() instanceof AnyIntType)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_MaxLengthTypeInvalid, typeDeclaration.getMaxLength().getResultType().getName()), (EObject)typeDeclaration, (EStructuralFeature)STCorePackage.Literals.ST_TYPE_DECLARATION__MAX_LENGTH, MAX_LENGTH_TYPE_INVALID, new String[]{typeDeclaration.getMaxLength().getResultType().getName()});
        }
    }

    @Check
    public void checkArrayAccessExpression(STArrayAccessExpression accessExpression) {
        INamedElement receiverType;
        INamedElement iNamedElement = receiverType = accessExpression.getReceiver().getResultType();
        Objects.requireNonNull(iNamedElement);
        INamedElement iNamedElement2 = iNamedElement;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{ArrayType.class, AnyStringType.class}, (Object)iNamedElement2, n)) {
            case 0: {
                ArrayType arrayType = (ArrayType)iNamedElement2;
                this.checkArrayAccessIndices(accessExpression, arrayType);
                break;
            }
            case 1: {
                AnyStringType stringType = (AnyStringType)iNamedElement2;
                this.checkStringAccessIndices(accessExpression, stringType);
                break;
            }
            default: {
                this.error(Messages.STCoreValidator_ArrayAccessReceiverIsInvalid, (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__RECEIVER, ARRAY_ACCESS_RECEIVER_INVALID, new String[0]);
            }
        }
    }

    protected void checkArrayAccessIndices(STArrayAccessExpression accessExpression, ArrayType receiverType) {
        IntStream.range(0, accessExpression.getIndex().size()).forEachOrdered(index -> {
            STExpression indexExpression = (STExpression)accessExpression.getIndex().get(index);
            INamedElement resultType = indexExpression.getResultType();
            this.checkTypeCompatibility((INamedElement)IecTypes.GenericTypes.ANY_INT, resultType, (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index);
            if (index < receiverType.getSubranges().size()) {
                try {
                    int indexValue = STCoreUtil.asConstantInt((STExpression)indexExpression);
                    Subrange subrange = (Subrange)receiverType.getSubranges().get(index);
                    if (STCoreValidator.isArrayIndexOutOfBounds(indexValue, subrange)) {
                        this.error(MessageFormat.format(Messages.STCoreValidator_ArrayIndexOutOfBounds, Integer.toString(indexValue), Integer.toString(subrange.getLowerLimit()), Integer.toString(subrange.getUpperLimit())), (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index, ARRAY_INDEX_OUT_OF_BOUNDS, new String[0]);
                    }
                }
                catch (ArithmeticException arithmeticException) {}
            } else {
                this.error(MessageFormat.format(Messages.STCoreValidator_TooManyIndicesGiven, Integer.toString(accessExpression.getIndex().size()), Integer.toString(receiverType.getSubranges().size()), receiverType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index, TOO_MANY_INDICES_GIVEN, new String[0]);
            }
        });
    }

    protected static boolean isArrayIndexOutOfBounds(int indexValue, Subrange subrange) {
        return subrange.isSetLowerLimit() && indexValue < subrange.getLowerLimit() || subrange.isSetUpperLimit() && indexValue > subrange.getUpperLimit();
    }

    protected void checkStringAccessIndices(STArrayAccessExpression accessExpression, AnyStringType receiverType) {
        IntStream.range(0, accessExpression.getIndex().size()).forEachOrdered(index -> {
            STExpression indexExpression = (STExpression)accessExpression.getIndex().get(index);
            INamedElement resultType = indexExpression.getResultType();
            this.checkTypeCompatibility((INamedElement)IecTypes.GenericTypes.ANY_INT, resultType, (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index);
            if (index < 1) {
                try {
                    int indexValue = STCoreUtil.asConstantInt((STExpression)indexExpression);
                    if (STCoreValidator.isStringIndexOutOfBounds(indexValue, receiverType)) {
                        this.addIssue(MessageFormat.format(Messages.STCoreValidator_StringIndexOutOfBounds, Integer.toString(indexValue), receiverType.getName()), (EObject)accessExpression, (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index, STRING_INDEX_OUT_OF_BOUNDS, new String[0]);
                    }
                }
                catch (ArithmeticException arithmeticException) {}
            } else {
                this.error(MessageFormat.format(Messages.STCoreValidator_TooManyIndicesGiven, Integer.toString(accessExpression.getIndex().size()), Integer.toString(1), receiverType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_ARRAY_ACCESS_EXPRESSION__INDEX, index, TOO_MANY_INDICES_GIVEN, new String[0]);
            }
        });
    }

    protected static boolean isStringIndexOutOfBounds(int indexValue, AnyStringType receiverType) {
        return indexValue < 1 || receiverType.isSetMaxLength() && indexValue > receiverType.getMaxLength();
    }

    @Check
    public void checkConsecutiveUnderscoresInIdentifier(INamedElement iNamedElement) {
        if (IDENTIFIER_CONSECUTIVE_UNDERSCORES_PATTERN.matcher(iNamedElement.getName()).find()) {
            this.error(Messages.STCoreValidator_Consecutive_Underscores_In_Identifier, (EObject)iNamedElement, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, CONSECUTIVE_UNDERSCORE_IN_IDENTIFIER_ERROR, new String[]{iNamedElement.getName()});
        }
    }

    @Check
    public void checkIdentiferForTrailingUnderscore(INamedElement iNamedElement) {
        if (iNamedElement.getName().endsWith("_")) {
            this.error(Messages.STCoreValidator_Trailing_Underscore_In_Identifier, (EObject)iNamedElement, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, TRAILING_UNDERSCORE_IN_IDENTIFIER_ERROR, new String[]{iNamedElement.getName()});
        }
    }

    @Check
    public void checkReservedIdentifer(INamedElement iNamedElement) {
        if (StreamSupport.stream(this.standardFunctionProvider.get().spliterator(), false).anyMatch(func -> func.getName().equalsIgnoreCase(iNamedElement.getName()))) {
            this.error(Messages.STCoreValidator_Identifier_Is_Reserved, (EObject)iNamedElement, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, RESERVED_IDENTIFIER_ERROR, new String[]{iNamedElement.getName()});
        }
    }

    @Check
    public void checkValidLHS(STAssignment expression) {
        this.accept(STCoreValidator.isAssignable(expression.getLeft()), (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_ASSIGNMENT__LEFT, new String[0]);
    }

    @Check
    public void checkCallWithoutReturnIsOnlyInCallStatement(STFeatureExpression expression) {
        ICallable callable;
        INamedElement iNamedElement = expression.getFeature();
        if (iNamedElement instanceof ICallable && (callable = (ICallable)iNamedElement).getReturnType() == null && expression.isCall() && STCoreUtil.getAccessMode((STExpression)expression) != AccessMode.NONE) {
            this.error(MessageFormat.format(Messages.STCoreValidator_AssignmentOfCallWithoutReturnType, callable.getName()), (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, RETURNED_TYPE_IS_VOID, new String[0]);
        }
    }

    @Check
    public void checkFeatureExpression(STFeatureExpression featureExpression) {
        INode node;
        String nameInText;
        List nodes;
        String originalName;
        INamedElement feature = featureExpression.getFeature();
        if (feature != null && !feature.eIsProxy() && (originalName = feature.getName()) != null && !(nodes = NodeModelUtils.findNodesForFeature((EObject)featureExpression, (EStructuralFeature)STCorePackage.eINSTANCE.getSTFeatureExpression_Feature())).isEmpty() && !originalName.equals(nameInText = (node = (INode)nodes.get(0)).getRootNode().getText().substring(node.getOffset(), node.getEndOffset())) && originalName.equalsIgnoreCase(nameInText)) {
            this.addIssue(Messages.STCoreValidator_Wrong_Name_Case, (EObject)featureExpression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, WRONG_NAME_CASE, new String[]{nameInText, originalName});
        }
    }

    @Check
    public void checkUnnecessaryConversion(STFeatureExpression featureExpression) {
        INamedElement feature = featureExpression.getFeature();
        if (feature instanceof STStandardFunction) {
            STStandardFunction standardFunction = (STStandardFunction)feature;
            if (CONVERSION_FUNCTION_PATTERN.matcher(feature.getName()).matches() && standardFunction.getInputParameters().size() == 1 && featureExpression.getParameters().size() == 1) {
                STCallArgument argument = (STCallArgument)featureExpression.getParameters().get(0);
                INamedElement argumentType = argument.getResultType();
                INamedElement expectedArgumentType = STCoreUtil.getExpectedType((STExpression)argument.getArgument());
                INamedElement returnType = featureExpression.getResultType();
                INamedElement expectedReturnType = STCoreUtil.getExpectedType((STExpression)featureExpression);
                if (argumentType instanceof DataType) {
                    DataType argumentDataType = (DataType)argumentType;
                    if (expectedArgumentType instanceof DataType) {
                        DataType expectedArgumentDataType = (DataType)expectedArgumentType;
                        if (returnType instanceof DataType) {
                            DataType returnDataType = (DataType)returnType;
                            if (expectedReturnType instanceof DataType) {
                                DataType expectedReturnDataType = (DataType)expectedReturnType;
                                this.checkUnnecessaryConversion(argument, argumentDataType, expectedArgumentDataType, returnDataType, expectedReturnDataType);
                            }
                        }
                    }
                }
            }
        }
    }

    protected void checkUnnecessaryConversion(STCallArgument argument, DataType argumentDataType, DataType expectedArgumentDataType, DataType returnDataType, DataType expectedReturnDataType) {
        if (expectedReturnDataType.isAssignableFrom(argumentDataType) && !STCoreValidator.isCastSemanticallyRelevant(argumentDataType, returnDataType)) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_UnnecessaryConversion, expectedArgumentDataType.getName(), returnDataType.getName()), this.getCurrentObject(), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, UNNECESSARY_CONVERSION, new String[]{expectedArgumentDataType.getName(), returnDataType.getName()});
        } else if (!expectedArgumentDataType.eClass().equals(argumentDataType.eClass()) && expectedArgumentDataType.isAssignableFrom(argumentDataType) && this.isBetterCastPossible(argumentDataType, expectedReturnDataType)) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_UnnecessaryWideConversion, expectedArgumentDataType.getName()), this.getCurrentObject(), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, UNNECESSARY_WIDE_CONVERSION, new String[]{expectedArgumentDataType.getName(), argumentDataType.getName(), expectedReturnDataType.getName()});
        } else if (!expectedReturnDataType.eClass().equals(returnDataType.eClass()) && expectedReturnDataType.isAssignableFrom(returnDataType) && this.isBetterCastPossible(argumentDataType, expectedReturnDataType)) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_UnnecessaryNarrowConversion, returnDataType.getName()), this.getCurrentObject(), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, UNNECESSARY_NARROW_CONVERSION, new String[]{returnDataType.getName(), argumentDataType.getName(), expectedReturnDataType.getName()});
        } else {
            STExpression sTExpression = argument.getArgument();
            if (sTExpression instanceof STNumericLiteral) {
                STNumericLiteral numericLiteral = (STNumericLiteral)sTExpression;
                this.checkUnnecessaryLiteralConversion(numericLiteral.getValue(), argumentDataType, returnDataType, expectedReturnDataType);
            } else {
                STExpression sTExpression2 = argument.getArgument();
                if (sTExpression2 instanceof STStringLiteral) {
                    STStringLiteral stringLiteral = (STStringLiteral)sTExpression2;
                    this.checkUnnecessaryLiteralConversion(stringLiteral.getValue(), argumentDataType, returnDataType, expectedReturnDataType);
                }
            }
        }
    }

    protected void checkUnnecessaryLiteralConversion(Object value, DataType argumentDataType, DataType returnDataType, DataType expectedReturnDataType) {
        if (STCoreValidator.isLiteralCastSemanticallyRelevant(argumentDataType, returnDataType)) {
            return;
        }
        try {
            Value argumentValue = ValueOperations.wrapValue((Object)value, (INamedElement)argumentDataType);
            Value returnValue = ValueOperations.castValue((Value)argumentValue, (INamedElement)expectedReturnDataType);
            if (ValueOperations.equals((Value)argumentValue, (Value)returnValue)) {
                this.addIssue(MessageFormat.format(Messages.STCoreValidator_UnnecessaryLiteralConversion, returnDataType.getName()), this.getCurrentObject(), null, UNNECESSARY_LITERAL_CONVERSION, new String[]{returnDataType.getName(), expectedReturnDataType.getName(), returnValue.toString()});
            } else {
                this.addIssue(MessageFormat.format(Messages.STCoreValidator_TruncatingLiteralConversion, returnDataType.getName()), this.getCurrentObject(), null, TRUNCATING_LITERAL_CONVERSION, new String[]{returnDataType.getName(), expectedReturnDataType.getName(), returnValue.toString()});
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    private static boolean isCastSemanticallyRelevant(DataType argumentDataType, DataType returnDataType) {
        return argumentDataType instanceof AnySignedType && returnDataType instanceof AnyUnsignedType || argumentDataType instanceof AnyIntType && returnDataType instanceof AnyRealType || argumentDataType instanceof AnyBitType || returnDataType instanceof AnyBitType;
    }

    private static boolean isLiteralCastSemanticallyRelevant(DataType argumentDataType, DataType returnDataType) {
        return argumentDataType instanceof AnyCharsType && !(returnDataType instanceof AnyCharsType) || argumentDataType instanceof AnyBitType && !(returnDataType instanceof AnyBitType) || argumentDataType instanceof AnyRealType && returnDataType instanceof AnyBitType;
    }

    protected boolean isBetterCastPossible(DataType argumentDataType, DataType expectedReturnDataType) {
        if (argumentDataType instanceof AnyBitType || expectedReturnDataType instanceof AnyBitType) {
            return false;
        }
        String castName = argumentDataType.getName() + "_TO_" + expectedReturnDataType.getName();
        return this.standardFunctionProvider.find(castName, List.of(argumentDataType)).isPresent();
    }

    @Check
    public void checkVariableReference(STFeatureExpression featureExpression) {
        INamedElement iNamedElement;
        STVarDeclaration declaration = (STVarDeclaration)EcoreUtil2.getContainerOfType((EObject)featureExpression, STVarDeclaration.class);
        if (declaration != null && (iNamedElement = featureExpression.getFeature()) instanceof STVarDeclaration) {
            STVarDeclarationBlock referencedVariableBlock;
            STVarDeclaration referencedVariable = (STVarDeclaration)iNamedElement;
            EObject eObject = referencedVariable.eContainer();
            if (eObject instanceof STVarDeclarationBlock && !(referencedVariableBlock = (STVarDeclarationBlock)eObject).isConstant()) {
                this.error(Messages.STCoreValidator_NonConstantExpressionInVariableDeclaration, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, NON_CONSTANT_DECLARATION, new String[0]);
            } else if (STCoreUtil.getVariableScope((STVarDeclaration)declaration) == STCoreUtil.getVariableScope((STVarDeclaration)referencedVariable)) {
                ICompositeNode declarationNode = NodeModelUtils.getNode((EObject)declaration);
                ICompositeNode referencedVariableNode = NodeModelUtils.getNode((EObject)referencedVariable);
                if (declarationNode != null && referencedVariableNode != null && declarationNode.getOffset() < referencedVariableNode.getOffset()) {
                    if (EcoreUtil2.getContainerOfType((EObject)featureExpression, ICallable.class) != null) {
                        this.error(Messages.STCoreValidator_VariableMaybeNotInitialized, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, MAYBE_NOT_INITIALIZED, new String[0]);
                    } else {
                        this.warning(Messages.STCoreValidator_VariableMaybeNotInitialized, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, MAYBE_NOT_INITIALIZED, new String[0]);
                    }
                }
            }
        }
    }

    @Check
    public void checkNestedAssignment(STAssignment expression) {
        if (expression.eContainer() instanceof STAssignment) {
            this.error(Messages.STCoreValidator_NestedAssignment, null, NESTED_ASSIGNMENT, new String[0]);
        }
    }

    @Check
    public void checkAssignmentTypeCompatibility(STAssignment expression) {
        INamedElement leftType = expression.getLeft().getResultType();
        INamedElement rightType = expression.getRight().getResultType();
        this.checkTypeCompatibility(leftType, rightType, (EStructuralFeature)STCorePackage.Literals.ST_ASSIGNMENT__RIGHT, STCoreUtil.isAnyVariableReference((STExpression)expression.getRight()));
    }

    @Check
    public void checkInitializerTypeCompatibility(STElementaryInitializerExpression initializerExpression) {
        INamedElement type = STCoreUtil.getExpectedType((STInitializerExpression)initializerExpression);
        INamedElement initializerType = initializerExpression.getValue().getResultType();
        this.checkTypeCompatibility(type, initializerType, (EStructuralFeature)STCorePackage.Literals.ST_ELEMENTARY_INITIALIZER_EXPRESSION__VALUE);
    }

    @Check
    public void checkInitializerTypeCompatibility(STArrayInitializerExpression initializerExpression) {
        INamedElement type = STCoreUtil.getExpectedType((STInitializerExpression)initializerExpression);
        if (type != null && !(type instanceof ArrayType)) {
            this.error(Messages.STCoreValidator_InsufficientArrayDimensions, null, INSUFFICIENT_ARRAY_DIMENSIONS, new String[0]);
        }
    }

    @Check
    public void checkExpressionSourceTypeCompatibility(STExpressionSource source) {
        if (source.getExpression() != null) {
            INamedElement type = STCoreUtil.getExpectedType((STExpression)source.getExpression());
            INamedElement initializerType = source.getExpression().getResultType();
            this.checkTypeCompatibility(type, initializerType, (EStructuralFeature)STCorePackage.Literals.ST_EXPRESSION_SOURCE__EXPRESSION);
        }
    }

    @Check
    public void checkIfConditionType(STIfStatement stmt) {
        if (stmt.getCondition() != null) {
            this.checkTypeCompatibility((INamedElement)IecTypes.ElementaryTypes.BOOL, stmt.getCondition().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_IF_STATEMENT__CONDITION);
        }
    }

    @Check
    public void checkWhileConditionType(STWhileStatement stmt) {
        if (stmt.getCondition() != null) {
            this.checkTypeCompatibility((INamedElement)IecTypes.ElementaryTypes.BOOL, stmt.getCondition().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_WHILE_STATEMENT__CONDITION);
        }
    }

    @Check
    public void checkRepeatConditionType(STRepeatStatement stmt) {
        if (stmt.getCondition() != null) {
            this.checkTypeCompatibility((INamedElement)IecTypes.ElementaryTypes.BOOL, stmt.getCondition().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_REPEAT_STATEMENT__CONDITION);
        }
    }

    @Check
    public void checkForTypes(STForStatement stmt) {
        this.accept(STCoreValidator.isAssignable(stmt.getVariable()), (EObject)stmt, (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE, new String[0]);
        INamedElement type = stmt.getVariable().getResultType();
        if (!(type instanceof AnyIntType)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_For_Variable_Not_Integral_Type, type.getName()), (EObject)stmt, (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE, FOR_VARIABLE_NOT_INTEGRAL_TYPE, new String[0]);
        }
        if (stmt.getFrom() != null) {
            this.checkTypeCompatibility(type, stmt.getFrom().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__FROM);
        }
        if (stmt.getTo() != null) {
            this.checkTypeCompatibility(type, stmt.getTo().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__TO);
        }
        if (stmt.getBy() != null) {
            this.checkTypeCompatibility((INamedElement)IecTypes.GenericTypes.ANY_NUM, stmt.getBy().getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__BY);
        }
    }

    @Check
    public void checkForControlVariable(STForStatement stmt) {
        List featurePath = STCoreUtil.getFeaturePath((STExpression)stmt.getVariable());
        featurePath.stream().filter(Predicate.not(STCoreUtil::isTemporary)).findFirst().ifPresent(variable -> this.addIssue(MessageFormat.format(Messages.STCoreValidator_UsingNonTemporaryAsControlVariable, variable.getName()), (EObject)stmt, (EStructuralFeature)STCorePackage.Literals.ST_FOR_STATEMENT__VARIABLE, FOR_CONTROL_VARIABLE_NON_TEMPORARY, new String[0]));
    }

    @Check
    public void checkForControlVariableModification(STFeatureExpression expression) {
        if (STCoreUtil.getAccessMode((STExpression)expression) == AccessMode.WRITE) {
            if (StreamSupport.stream(EcoreUtil2.getAllContainers((EObject)expression).spliterator(), false).filter(STForStatement.class::isInstance).map(STForStatement.class::cast).map(STForStatement::getVariable).filter(variable -> !EcoreUtil.isAncestor((EObject)variable, (EObject)expression)).map(STCoreUtil::getFeaturePath).anyMatch(path -> path.contains(expression.getFeature()))) {
                this.error(Messages.STCoreValidator_AttemptingToModifyControlVariable, (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, FOR_CONTROL_VARIABLE_MODIFICATION, new String[0]);
            }
        }
    }

    @Check
    public void checkCaseConditionType(STCaseCases stmt) {
        INamedElement type = stmt.getStatement().getSelector().getResultType();
        IntStream.range(0, stmt.getConditions().size()).forEachOrdered(index -> {
            STExpression condition = (STExpression)stmt.getConditions().get(index);
            INamedElement resultType = condition.getResultType();
            if (!STCoreUtil.hasCommonSupertype((INamedElement)type, (INamedElement)resultType)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_NonComparableTypes, resultType.getName(), type.getName()), (EStructuralFeature)STCorePackage.Literals.ST_CASE_CASES__CONDITIONS, index, NON_COMPARABLE_TYPES, new String[]{resultType.getName(), type.getName()});
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    @Check
    public void checkCallArguments(STFeatureExpression expression) {
        void callable;
        INamedElement feature = expression.getFeature();
        if (feature == null || feature.eIsProxy() || !expression.isCall()) {
            return;
        }
        if (!(feature instanceof ICallable)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Feature_Not_Callable, feature.getName()), (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, FEATURE_NOT_CALLABLE, new String[0]);
            return;
        }
        ICallable iCallable = (ICallable)feature;
        if (expression.getParameters().stream().anyMatch(STCallUnnamedArgument.class::isInstance)) {
            if (!expression.getParameters().stream().allMatch(STCallUnnamedArgument.class::isInstance)) {
                this.error(Messages.STCoreValidator_Mixing_Formal_And_NonFormal, (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, MIXING_FORMAL_AND_NON_FORMAL_ARGUMENTS, new String[0]);
                return;
            }
            int parameterCount = callable.getInputParameters().size() + callable.getInOutParameters().size() + callable.getOutputParameters().size();
            if (!(expression.getParameters().size() == parameterCount || callable.isVarargs() && expression.getParameters().size() >= parameterCount)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_Wrong_Number_Of_Arguments, callable.getName(), Integer.toString(parameterCount), Integer.toString(expression.getParameters().size())), (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, WRONG_NUMBER_OF_ARGUMENTS, new String[0]);
                return;
            }
        } else if (callable instanceof STStandardFunction && !expression.getParameters().isEmpty()) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Attempting_To_Call_Standard_Function_With_Formal_Arguments, callable.getName()), (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, STANDARD_FUNCTION_WITH_FORMAL_ARGUMENTS, new String[0]);
            return;
        }
        expression.getMappedInputArguments().forEach((param, arg) -> {
            if (arg != null) {
                this.checkTypeCompatibility(STCoreUtil.getFeatureType((INamedElement)param), arg.getResultType(), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, expression.getParameters().indexOf(arg));
            }
        });
        expression.getMappedOutputArguments().forEach((param, arg) -> {
            if (arg != null) {
                this.checkTypeCompatibility(arg.getResultType(), STCoreUtil.getFeatureType((INamedElement)param), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, expression.getParameters().indexOf(arg), STCoreUtil.isAnyTypeVariable((INamedElement)param));
                if (STCoreValidator.isAssignable(arg.getArgument()) != IsAssignableResult.ASSIGNABLE) {
                    this.error(Messages.STCoreValidator_Argument_Not_Assignable, (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, expression.getParameters().indexOf(arg), VALUE_NOT_ASSIGNABLE, new String[0]);
                }
            }
        });
        expression.getMappedInOutArguments().forEach((param, arg) -> {
            if (arg != null) {
                this.checkTypeStrictCompatibility(arg.getResultType(), STCoreUtil.getFeatureType((INamedElement)param), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, expression.getParameters().indexOf(arg));
                if (STCoreValidator.isAssignable(arg.getArgument()) != IsAssignableResult.ASSIGNABLE) {
                    this.error(Messages.STCoreValidator_Argument_Not_Assignable, (EObject)expression, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__PARAMETERS, expression.getParameters().indexOf(arg), VALUE_NOT_ASSIGNABLE, new String[0]);
                }
            }
        });
    }

    @Check
    public void checkUnaryExpressionOperator(STUnaryExpression expression) {
        INamedElement resultType = expression.getExpression().getResultType();
        if (!STCoreUtil.isApplicableTo((STUnaryOperator)expression.getOp(), (INamedElement)resultType)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_UnaryOperator_Not_Applicable, expression.getOp().getLiteral(), resultType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_UNARY_EXPRESSION__OP, OPERATOR_NOT_APPLICABLE, new String[0]);
        }
    }

    @Check
    public void checkBinaryExpressionOperator(STBinaryExpression expression) {
        INamedElement leftResultType = expression.getLeft().getResultType();
        INamedElement rightResultType = expression.getRight().getResultType();
        if (!STCoreUtil.isApplicableTo((STBinaryOperator)expression.getOp(), (INamedElement)leftResultType, (INamedElement)rightResultType)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_BinaryOperator_Not_Applicable, expression.getOp().getLiteral(), leftResultType.getName(), rightResultType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_BINARY_EXPRESSION__OP, OPERATOR_NOT_APPLICABLE, new String[0]);
        }
    }

    @Check
    public void checkCalledFBWithoutEventSpecificerHasOnlyOneInputEvent(STFeatureExpression expression) {
        FB functionBlock;
        INamedElement iNamedElement;
        if (expression.isCall() && (iNamedElement = expression.getFeature()) instanceof FB && (functionBlock = (FB)iNamedElement).getInterface().getEventInputs().size() != 1) {
            this.error(Messages.STCoreValidator_Unqualified_FB_Call_On_FB_With_Input_Event_Size_Not_One, (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, UNQUALIFIED_FB_CALL_ON_FB_WITH_INPUT_EVENT_SIZE_NOT_ONE, new String[0]);
        }
    }

    @Check
    public void checkNumericLiteral(STNumericLiteral expression) {
        DataType expectedDataType;
        DataType expectedDataType2;
        DataType type = (DataType)expression.getResultType();
        INamedElement expectedType = STCoreUtil.getExpectedType((STExpression)expression);
        if (!STCoreUtil.isNumericValueValid((DataType)type, (Object)expression.getValue())) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Invalid_Literal, type.getName(), NumericValueConverter.INSTANCE.toString(expression.getValue())), (EStructuralFeature)STCorePackage.Literals.ST_NUMERIC_LITERAL__VALUE, INVALID_NUMERIC_LITERAL, new String[0]);
        } else if (expectedType instanceof DataType && IecTypes.GenericTypes.isAnyType((DataType)(expectedDataType2 = (DataType)expectedType)) && expression.getType() == null && STCoreUtil.isAncestor((EClassifier)STCorePackage.Literals.ST_ELEMENTARY_INITIALIZER_EXPRESSION, (EObject)expression)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Literal_Requires_Type_Specifier, expectedDataType2.getName()), (EStructuralFeature)STCorePackage.Literals.ST_NUMERIC_LITERAL__VALUE, LITERAL_REQUIRES_TYPE_SPECIFIER, new String[0]);
        } else if (expectedType instanceof DataType && !IecTypes.GenericTypes.isAnyType((DataType)(expectedDataType = (DataType)expectedType)) && !(expectedDataType instanceof DirectlyDerivedType) && !type.eClass().equals(expectedDataType.eClass()) && expectedDataType.isAssignableFrom(type)) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_Implicit_Conversion_In_Literal, type.getName(), expectedType.getName()), (EObject)expression, null, LITERAL_IMPLICIT_CONVERSION, new String[0]);
        }
    }

    @Check
    public void checkStringLiteral(STStringLiteral expression) {
        DataType expectedDataType;
        AnyStringType expectedAnyStringType;
        DataType expectedDataType2;
        DataType type = (DataType)expression.getResultType();
        INamedElement expectedType = STCoreUtil.getExpectedType((STExpression)expression);
        if (!STCoreUtil.isStringValueValid((DataType)type, (STString)expression.getValue())) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Invalid_Literal, type.getName(), this.stringValueConverter.toString(expression.getValue())), (EStructuralFeature)STCorePackage.Literals.ST_STRING_LITERAL__VALUE, INVALID_STRING_LITERAL, new String[0]);
        } else if (expectedType instanceof DataType && IecTypes.GenericTypes.isAnyType((DataType)(expectedDataType2 = (DataType)expectedType)) && expression.getType() == null && STCoreUtil.isAncestor((EClassifier)STCorePackage.Literals.ST_ELEMENTARY_INITIALIZER_EXPRESSION, (EObject)expression)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Literal_Requires_Type_Specifier, expectedDataType2.getName()), (EStructuralFeature)STCorePackage.Literals.ST_STRING_LITERAL__VALUE, LITERAL_REQUIRES_TYPE_SPECIFIER, new String[0]);
        } else if (expectedType instanceof AnyStringType && (expectedAnyStringType = (AnyStringType)expectedType).isSetMaxLength() && expression.getValue().length() > ((AnyStringType)expectedType).getMaxLength()) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_String_Literal_Truncated, Integer.toString(expectedAnyStringType.getMaxLength())), (EObject)expression, null, TRUNCATED_LITERAL, new String[0]);
        } else if (expectedType instanceof DataType && !IecTypes.GenericTypes.isAnyType((DataType)(expectedDataType = (DataType)expectedType)) && !(expectedDataType instanceof DirectlyDerivedType) && !type.eClass().equals(expectedDataType.eClass()) && expectedDataType.isAssignableFrom(type)) {
            this.addIssue(MessageFormat.format(Messages.STCoreValidator_Implicit_Conversion_In_Literal, type.getName(), expectedDataType.getName()), (EObject)expression, null, LITERAL_IMPLICIT_CONVERSION, new String[0]);
        }
    }

    @Check
    public void checkReturnValueCanOnlyBeAssignedToCurrentICallable(STFeatureExpression expression) {
        INamedElement feature = expression.getFeature();
        if (feature instanceof ICallable) {
            ICallable callable = (ICallable)feature;
            if (!expression.isCall() && !(feature instanceof FB)) {
                ICallable containingElement = STCoreValidator.getICallableContainer((EObject)expression);
                if (callable != containingElement) {
                    this.error(MessageFormat.format(Messages.STCoreValidator_NameNotVisible, callable.getName()), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, ICALLABLE_NOT_VISIBLE, new String[0]);
                } else if (callable.getReturnType() == null) {
                    this.error(MessageFormat.format(Messages.STCoreValidator_CallableHasNoReturnType, callable.getName()), (EStructuralFeature)STCorePackage.Literals.ST_FEATURE_EXPRESSION__FEATURE, ICALLABLE_HAS_NO_RETURN_TYPE, new String[0]);
                }
            }
        }
    }

    @Check
    public void checkIndexOfBitwiseAccessExpression(STMultibitPartialExpression expression) {
        STFeatureExpression featureExpression;
        STExpression sTExpression;
        STMemberAccessExpression memberAccessExpr = (STMemberAccessExpression)expression.eContainer();
        STExpression receiverExpression = memberAccessExpr.getReceiver();
        DataType accessType = (DataType)memberAccessExpr.getResultType();
        DataType receiverType = (DataType)receiverExpression.getResultType();
        if (memberAccessExpr.getReceiver() instanceof STMemberAccessExpression || memberAccessExpr.getReceiver() instanceof STArrayAccessExpression || (sTExpression = memberAccessExpr.getReceiver()) instanceof STFeatureExpression && !(featureExpression = (STFeatureExpression)sTExpression).isCall()) {
            this.checkMultibitPartialExpression(expression, accessType, receiverType);
        } else {
            this.error(Messages.STCoreValidator_BitAccessInvalidForReciever, (EStructuralFeature)STCorePackage.Literals.ST_MULTIBIT_PARTIAL_EXPRESSION__EXPRESSION, BIT_ACCESS_INVALID_RECEIVER, new String[0]);
        }
    }

    @Check
    public void checkDuplicateVariableNames(STVarDeclaration varDeclaration) {
        List varDeclarations = EcoreUtil2.getAllContentsOfType((EObject)varDeclaration.eContainer().eContainer(), STVarDeclaration.class);
        for (STVarDeclaration declaration : varDeclarations) {
            if (declaration == varDeclaration || !declaration.getName().equalsIgnoreCase(varDeclaration.getName())) continue;
            this.error(MessageFormat.format(Messages.STCoreValidator_Duplicate_Variable_Name, varDeclaration.getName()), (EObject)varDeclaration, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, DUPLICATE_VARIABLE_NAME, new String[0]);
        }
    }

    @Check
    public void checkExitIsInLoop(STExit exitStatement) {
        if (StreamSupport.stream(EcoreUtil2.getAllContainers((EObject)exitStatement).spliterator(), false).filter(STStatement.class::isInstance).map(STStatement.class::cast).noneMatch(this::isLoopStatement)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_ControlFlowStatementNeedsToBeInsideALoop, "EXIT"), null, EXIT_NOT_IN_LOOP, new String[0]);
        }
    }

    @Check
    public void checkContinueIsInLoop(STContinue continueStatement) {
        if (StreamSupport.stream(EcoreUtil2.getAllContainers((EObject)continueStatement).spliterator(), false).filter(STStatement.class::isInstance).map(STStatement.class::cast).noneMatch(this::isLoopStatement)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_ControlFlowStatementNeedsToBeInsideALoop, "CONTINUE"), null, CONTINUE_NOT_IN_LOOP, new String[0]);
        }
    }

    private boolean isLoopStatement(STStatement statement) {
        return statement instanceof STForStatement || statement instanceof STWhileStatement || statement instanceof STRepeatStatement;
    }

    @Check
    public void checkDuplicateAttribute(STPragma pragma) {
        pragma.getAttributes().stream().filter(attribute -> attribute.getDeclaration() != null).collect(Collectors.groupingBy(STAttribute::getDeclaration)).values().stream().filter(list -> list.size() > 1).flatMap(Collection::stream).forEach(attribute -> this.error(MessageFormat.format(Messages.STCoreValidator_DuplicateAttribute, PackageNameHelper.getFullTypeName((LibraryElement)attribute.getDeclaration())), (EObject)attribute, (EStructuralFeature)STCorePackage.Literals.ST_ATTRIBUTE__DECLARATION, DUPLICATE_ATTRIBUTE, new String[]{PackageNameHelper.getFullTypeName((LibraryElement)attribute.getDeclaration())}));
    }

    private void checkMultibitPartialExpression(STMultibitPartialExpression expression, DataType accessorType, DataType receiverType) {
        if (receiverType instanceof AnyBitType) {
            DataType multiBitAccessExpressionType;
            if (expression.getIndex() != null && expression.getIndex().intValue() > STCoreValidator.getBitAccessMaxIndex(accessorType, receiverType)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_BitAccessOutOfRange, expression.getSpecifier().getLiteral() + String.valueOf(expression.getIndex())), (EStructuralFeature)STCorePackage.Literals.ST_MULTIBIT_PARTIAL_EXPRESSION__EXPRESSION, BIT_ACCESS_INDEX_OUT_OF_RANGE, new String[0]);
            } else if (expression.getExpression() != null && !((multiBitAccessExpressionType = (DataType)expression.getExpression().getResultType()) instanceof AnyIntType)) {
                this.error(MessageFormat.format(Messages.STCoreValidator_BitAccessExpressionNotOfTypeAnyInt, multiBitAccessExpressionType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_MULTIBIT_PARTIAL_EXPRESSION__EXPRESSION, BIT_ACCESS_EXPRESSION_NOT_OF_TYPE_ANY_INT, new String[0]);
            }
        } else {
            this.error(MessageFormat.format(Messages.STCoreValidator_BitAccessInvalidForType, receiverType.getName()), (EStructuralFeature)STCorePackage.Literals.ST_MULTIBIT_PARTIAL_EXPRESSION__EXPRESSION, BIT_ACCESS_INVALID_FOR_TYPE, new String[0]);
        }
    }

    protected static int getBitAccessMaxIndex(DataType accessorType, DataType receiverType) {
        if (accessorType instanceof AnyBitType) {
            AnyBitType accessorBitType = (AnyBitType)accessorType;
            if (receiverType instanceof AnyBitType) {
                AnyBitType receiverBitType = (AnyBitType)receiverType;
                int bitSize = receiverBitType.getBitSize();
                int bitFactor = accessorBitType.getBitSize();
                return bitFactor > 0 && bitSize > bitFactor ? bitSize / bitFactor - 1 : -1;
            }
        }
        return -1;
    }

    protected static ICallable getICallableContainer(EObject eObject) {
        EObject parent = eObject.eContainer();
        while (parent != null) {
            if (parent instanceof ICallable) {
                ICallable callable = (ICallable)parent;
                return callable;
            }
            parent = parent.eContainer();
        }
        return null;
    }

    protected void checkPackageDeclaration(STSource source, EStructuralFeature feature, String packageName) {
        Resource resource = source.eResource();
        if (resource != null) {
            String expectedPackageName = PackageNameHelper.getPackageNameFromURI((URI)resource.getURI());
            if (!Objects.requireNonNullElse(packageName, "").equals(expectedPackageName)) {
                this.addIssue(MessageFormat.format(Messages.STCoreValidator_PackageNameMismatch, packageName, expectedPackageName), (EObject)source, feature, PACKAGE_NAME_MISMATCH, new String[]{expectedPackageName});
            }
        }
    }

    protected void checkTypeCompatibility(INamedElement destination, INamedElement source, EStructuralFeature feature) {
        this.checkTypeCompatibility(destination, source, feature, false);
    }

    protected void checkTypeCompatibility(INamedElement destination, INamedElement source, EStructuralFeature feature, int index) {
        this.checkTypeCompatibility(destination, source, feature, index, false);
    }

    protected void checkTypeCompatibility(INamedElement destination, INamedElement source, EStructuralFeature feature, boolean allowAnyAssignment) {
        this.checkTypeCompatibility(destination, source, feature, -1, allowAnyAssignment);
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkTypeCompatibility(INamedElement destination, INamedElement source, EStructuralFeature feature, int index, boolean allowAnyAssignment) {
        if (destination instanceof DataType) {
            DataType destinationDataType = (DataType)destination;
            if (source instanceof DataType) {
                DataType sourceDataType = (DataType)source;
                this.checkTypeCompatibility(destinationDataType, sourceDataType, feature, index, allowAnyAssignment);
                return;
            }
        }
        if (source == null) return;
        if (destination == null) return;
        this.error(MessageFormat.format(Messages.STCoreValidator_Non_Compatible_Types, source.getName(), destination.getName()), feature, index, NON_COMPATIBLE_TYPES, new String[]{source.getName(), destination.getName()});
    }

    protected void checkTypeCompatibility(DataType destination, DataType source, EStructuralFeature feature, int index, boolean allowAnyAssignment) {
        if (!(destination.isAssignableFrom(source) || allowAnyAssignment && IecTypes.GenericTypes.isAnyType((DataType)source) && source.isAssignableFrom(destination))) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Non_Compatible_Types, source.getName(), destination.getName()), feature, index, NON_COMPATIBLE_TYPES, new String[]{source.getName(), destination.getName()});
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void checkTypeStrictCompatibility(INamedElement destination, INamedElement source, EStructuralFeature feature, int index) {
        if (destination instanceof DataType) {
            DataType destinationDataType = (DataType)destination;
            if (source instanceof DataType) {
                DataType sourceDataType = (DataType)source;
                this.checkTypeStrictCompatibility(destinationDataType, sourceDataType, feature, index);
                return;
            }
        }
        if (source == null) return;
        if (destination == null) return;
        this.error(MessageFormat.format(Messages.STCoreValidator_Non_Compatible_Types, source.getName(), destination.getName()), feature, index, NON_COMPATIBLE_TYPES, new String[]{source.getName(), destination.getName()});
    }

    protected void checkTypeStrictCompatibility(DataType destination, DataType source, EStructuralFeature feature, int index) {
        if (!destination.isAssignableFrom(source) || !source.isAssignableFrom(destination)) {
            this.error(MessageFormat.format(Messages.STCoreValidator_Non_Compatible_Types, source.getName(), destination.getName()), feature, index, NON_COMPATIBLE_TYPES, new String[]{source.getName(), destination.getName()});
        }
    }

    protected static IsAssignableResult isAssignable(STExpression expression) {
        if (expression instanceof STMultibitPartialExpression) {
            return IsAssignableResult.ASSIGNABLE;
        }
        if (expression instanceof STFeatureExpression) {
            STFeatureExpression featureExpression = (STFeatureExpression)expression;
            return STCoreValidator.isFeatureExpressionAssignable(featureExpression);
        }
        if (expression instanceof STBuiltinFeatureExpression) {
            STBuiltinFeatureExpression featureExpression = (STBuiltinFeatureExpression)expression;
            return STCoreValidator.isBuiltinFeatureExpressionAssignable(featureExpression);
        }
        if (expression instanceof STArrayAccessExpression) {
            STArrayAccessExpression arrayAccessExpression = (STArrayAccessExpression)expression;
            return STCoreValidator.isAssignable(arrayAccessExpression.getReceiver());
        }
        if (expression instanceof STMemberAccessExpression) {
            STMemberAccessExpression memberAccessExpression = (STMemberAccessExpression)expression;
            return STCoreValidator.isMemberExpressionAssignable(memberAccessExpression);
        }
        return IsAssignableResult.NOT_ASSIGNABLE;
    }

    private static IsAssignableResult isMemberExpressionAssignable(STMemberAccessExpression memberAccessExpression) {
        IsAssignableResult receiverResult = STCoreValidator.isAssignable(memberAccessExpression.getReceiver());
        IsAssignableResult memberResult = STCoreValidator.isAssignable(memberAccessExpression.getMember());
        if (receiverResult != IsAssignableResult.ASSIGNABLE) {
            return receiverResult;
        }
        if (memberResult != IsAssignableResult.ASSIGNABLE) {
            return memberResult;
        }
        return IsAssignableResult.ASSIGNABLE;
    }

    private static IsAssignableResult isFeatureExpressionAssignable(STFeatureExpression featureExpression) {
        STVarDeclaration varDeclaration;
        EObject eObject;
        if (featureExpression.isCall()) {
            return IsAssignableResult.CALL_NOT_ASSIGNABLE;
        }
        INamedElement feature = featureExpression.getFeature();
        if (feature instanceof VarDeclaration) {
            Resource resource;
            if (feature.eContainmentFeature() == LibraryElementPackage.Literals.BASE_FB_TYPE__INTERNAL_CONST_VARS) {
                return IsAssignableResult.CONST_NOT_ASSIGNABLE;
            }
            if (feature.eContainmentFeature() == LibraryElementPackage.Literals.INTERFACE_LIST__INPUT_VARS && (resource = featureExpression.eResource()) instanceof LibraryElementXtextResource) {
                LibraryElementXtextResource libResource = (LibraryElementXtextResource)resource;
                if (EcoreUtil2.getContainerOfType((EObject)feature, LibraryElement.class) == libResource.getInternalLibraryElement()) {
                    return IsAssignableResult.INPUT_NOT_ASSIGNABLE;
                }
            }
        } else if (feature instanceof STVarDeclaration && (eObject = (varDeclaration = (STVarDeclaration)feature).eContainer()) instanceof STVarDeclarationBlock) {
            STVarDeclarationBlock varBlock = (STVarDeclarationBlock)eObject;
            if (varBlock.isConstant()) {
                return IsAssignableResult.CONST_NOT_ASSIGNABLE;
            }
            if (varBlock instanceof STVarInputDeclarationBlock && EcoreUtil2.getContainerOfType((EObject)varBlock, ICallable.class) == EcoreUtil2.getContainerOfType((EObject)featureExpression, ICallable.class)) {
                return IsAssignableResult.INPUT_NOT_ASSIGNABLE;
            }
        }
        return IsAssignableResult.ASSIGNABLE;
    }

    private static IsAssignableResult isBuiltinFeatureExpressionAssignable(STBuiltinFeatureExpression featureExpression) {
        if (featureExpression.isCall()) {
            return IsAssignableResult.CALL_NOT_ASSIGNABLE;
        }
        return switch (featureExpression.getFeature()) {
            case STBuiltinFeature.THIS -> IsAssignableResult.ASSIGNABLE;
            default -> IsAssignableResult.NOT_ASSIGNABLE;
        };
    }

    protected void accept(IsAssignableResult assignability, EObject source, EStructuralFeature feature, String ... issueData) {
        switch (assignability.getSeverity()) {
            case ERROR: {
                this.error(assignability.getMessage(), source, feature, assignability.getCode(), issueData);
                break;
            }
            case WARNING: {
                this.warning(assignability.getMessage(), source, feature, assignability.getCode(), issueData);
                break;
            }
            case INFO: {
                this.info(assignability.getMessage(), source, feature, assignability.getCode(), issueData);
                break;
            }
        }
    }

    public static void addIssue(ValidationMessageAcceptor acceptor, IssueSeverities severities, String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        Severity severity = severities.getSeverity(issueCode);
        if (severity != null) {
            switch (severity) {
                case WARNING: {
                    acceptor.acceptWarning(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case INFO: {
                    acceptor.acceptInfo(message, source, feature, index, issueCode, issueData);
                    break;
                }
                case ERROR: {
                    acceptor.acceptError(message, source, feature, index, issueCode, issueData);
                    break;
                }
            }
        }
    }

    private static enum IsAssignableResult {
        ASSIGNABLE(Severity.IGNORE, null, null),
        NOT_ASSIGNABLE(Severity.ERROR, "org.eclipse.fordiac.ide.structuredtextcore.valueNotAssignable", Messages.STCoreValidator_Assignment_Invalid_Left_Side),
        CALL_NOT_ASSIGNABLE(Severity.ERROR, "org.eclipse.fordiac.ide.structuredtextcore.valueNotAssignable", Messages.STCoreValidator_CallsCannotBeAssignedTo),
        CONST_NOT_ASSIGNABLE(Severity.ERROR, "org.eclipse.fordiac.ide.structuredtextcore.valueNotAssignable", Messages.STCoreValidator_ConstantsCannotBeAssigned),
        INPUT_NOT_ASSIGNABLE(Severity.WARNING, "org.eclipse.fordiac.ide.structuredtextcore.valueNotAssignable", Messages.STCoreValidator_InputsCannotBeAssigned);

        private final Severity severity;
        private final String code;
        private final String message;

        private IsAssignableResult(Severity severity, String code, String message) {
            this.severity = severity;
            this.code = code;
            this.message = message;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getCode() {
            return this.code;
        }

        public String getMessage() {
            return this.message;
        }
    }
}

