/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.structuredtextcore.validation;

import java.lang.runtime.SwitchBootstraps;
import java.text.MessageFormat;
import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterators;
import java.util.stream.StreamSupport;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.libraryElement.ICallable;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.structuredtextcore.Messages;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STFeatureExpression;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STForStatement;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInOutDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarInputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarOutputDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarPlainDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.STVarTempDeclarationBlock;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.AccessMode;
import org.eclipse.fordiac.ide.structuredtextcore.stcore.util.STCoreUtil;
import org.eclipse.fordiac.ide.structuredtextcore.validation.STCoreValidator;
import org.eclipse.xtext.validation.IssueSeverities;
import org.eclipse.xtext.validation.ValidationMessageAcceptor;

public class STCoreVariableUsageValidator {
    private final ValidationMessageAcceptor acceptor;
    private final IssueSeverities severities;
    private final Map<INamedElement, EnumSet<VariableState>> variables = new HashMap<INamedElement, EnumSet<VariableState>>();
    private final Map<URI, EnumSet<VariableState>> variableUris = new HashMap<URI, EnumSet<VariableState>>();

    public STCoreVariableUsageValidator(ValidationMessageAcceptor acceptor, IssueSeverities severities) {
        this.acceptor = acceptor;
        this.severities = severities;
    }

    public void addVariables(ICallable callable) {
        this.addVariables((List<? extends INamedElement>)callable.getInputParameters(), EnumSet.of(VariableState.UNUSED, VariableState.UNREAD));
        this.addVariables((List<? extends INamedElement>)callable.getOutputParameters(), EnumSet.of(VariableState.UNUSED, VariableState.UNWRITTEN));
        this.addVariables((List<? extends INamedElement>)callable.getInOutParameters(), EnumSet.of(VariableState.UNUSED));
        this.addReturnVariable(callable);
    }

    public void addVariableBlocks(List<? extends STVarDeclarationBlock> blocks) {
        blocks.forEach(this::addVariableBlock);
    }

    public void addVariableBlock(STVarDeclarationBlock block) {
        EnumSet<VariableState> enumSet;
        EList eList = block.getVarDeclarations();
        STVarDeclarationBlock sTVarDeclarationBlock = block;
        Objects.requireNonNull(sTVarDeclarationBlock);
        STVarDeclarationBlock sTVarDeclarationBlock2 = sTVarDeclarationBlock;
        int n = 0;
        block7: while (true) {
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STVarInputDeclarationBlock.class, STVarOutputDeclarationBlock.class, STVarInOutDeclarationBlock.class, STVarPlainDeclarationBlock.class, STVarTempDeclarationBlock.class}, (Object)sTVarDeclarationBlock2, n)) {
                case 0: {
                    STVarInputDeclarationBlock unused = (STVarInputDeclarationBlock)sTVarDeclarationBlock2;
                    enumSet = EnumSet.of(VariableState.UNUSED, VariableState.UNREAD);
                    break block7;
                }
                case 1: {
                    STVarOutputDeclarationBlock unused = (STVarOutputDeclarationBlock)sTVarDeclarationBlock2;
                    enumSet = EnumSet.of(VariableState.UNUSED, VariableState.UNWRITTEN);
                    break block7;
                }
                case 2: {
                    STVarInOutDeclarationBlock unused = (STVarInOutDeclarationBlock)sTVarDeclarationBlock2;
                    enumSet = EnumSet.of(VariableState.UNUSED);
                    break block7;
                }
                case 3: {
                    STVarPlainDeclarationBlock unused = (STVarPlainDeclarationBlock)sTVarDeclarationBlock2;
                    if (!block.isConstant()) {
                        n = 4;
                        continue block7;
                    }
                    enumSet = EnumSet.of(VariableState.UNUSED, VariableState.UNREAD);
                    break block7;
                }
                case 4: {
                    STVarTempDeclarationBlock unused = (STVarTempDeclarationBlock)sTVarDeclarationBlock2;
                    if (!block.isConstant()) {
                        n = 5;
                        continue block7;
                    }
                    enumSet = EnumSet.of(VariableState.UNUSED, VariableState.UNREAD);
                    break block7;
                }
                default: {
                    enumSet = EnumSet.of(VariableState.UNUSED, VariableState.UNREAD, VariableState.UNWRITTEN);
                }
            }
            break;
        }
        this.addVariables((List<? extends INamedElement>)eList, enumSet);
    }

    public void addReturnVariable(ICallable callable) {
        if (callable.getReturnType() != null) {
            this.setState((INamedElement)callable, EnumSet.of(VariableState.UNUSED, VariableState.UNWRITTEN));
        }
    }

    public void addVariables(List<? extends INamedElement> declarations) {
        declarations.forEach(declaration -> this.addVariable((INamedElement)declaration, (Set<VariableState>)EnumSet.of(VariableState.UNUSED, VariableState.UNREAD, VariableState.UNWRITTEN)));
    }

    public void addVariables(List<? extends INamedElement> declarations, Set<VariableState> initialState) {
        declarations.forEach(declaration -> this.addVariable((INamedElement)declaration, initialState));
    }

    protected void addVariable(INamedElement declaration, Set<VariableState> initialState) {
        this.setState(declaration, EnumSet.copyOf(initialState));
    }

    public void addReferences(EObject container) {
        if (container != null) {
            StreamSupport.stream(Spliterators.spliteratorUnknownSize(container.eAllContents(), 0), false).forEach(this::addReference);
        }
    }

    protected void addReference(EObject object) {
        EObject eObject = object;
        Objects.requireNonNull(eObject);
        EObject eObject2 = eObject;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{STForStatement.class, STFeatureExpression.class}, (Object)eObject2, n)) {
            case 0: {
                STForStatement forStatement = (STForStatement)eObject2;
                this.addReference(forStatement);
                break;
            }
            case 1: {
                STFeatureExpression featureExpression = (STFeatureExpression)eObject2;
                this.addReference(featureExpression);
                break;
            }
        }
    }

    protected void addReference(STFeatureExpression expression) {
        this.addAccess(expression.getFeature(), STCoreUtil.getAccessMode((STExpression)expression));
    }

    protected void addReference(STForStatement statement) {
        STCoreUtil.getFeaturePath((STExpression)statement.getVariable()).stream().findFirst().map(this::getState).ifPresent(state -> {
            state.remove((Object)VariableState.UNUSED);
            state.remove((Object)VariableState.UNREAD);
            state.remove((Object)VariableState.UNWRITTEN);
        });
    }

    protected void addAccess(INamedElement feature, AccessMode mode) {
        EnumSet<VariableState> state = this.getState(feature);
        if (state != null) {
            state.remove((Object)VariableState.UNUSED);
            switch (mode) {
                case READ: {
                    state.remove((Object)VariableState.UNREAD);
                    break;
                }
                case WRITE: {
                    state.remove((Object)VariableState.UNWRITTEN);
                    break;
                }
                case READ_WRITE: {
                    state.remove((Object)VariableState.UNREAD);
                    state.remove((Object)VariableState.UNWRITTEN);
                    break;
                }
            }
        }
    }

    protected EnumSet<VariableState> getState(INamedElement feature) {
        EnumSet<VariableState> state = this.variables.get(feature);
        if (state != null) {
            return state;
        }
        return this.variableUris.get(EcoreUtil.getURI((EObject)feature).trimQuery());
    }

    protected void setState(INamedElement element, EnumSet<VariableState> state) {
        this.variables.put(element, state);
        this.variableUris.put(EcoreUtil.getURI((EObject)element), state);
    }

    public void validateUnused() {
        this.variables.forEach(this::validateUnused);
    }

    protected void validateUnused(INamedElement feature, EnumSet<VariableState> state) {
        if (state.contains((Object)VariableState.UNUSED)) {
            this.addIssue(MessageFormat.format(Messages.STCoreVariableUsageValidator_UnusedVariable, feature.getName()), (EObject)feature, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, -1, "org.eclipse.fordiac.ide.structuredtextcore.unusedVariable", new String[0]);
        } else if (state.contains((Object)VariableState.UNREAD)) {
            this.addIssue(MessageFormat.format(Messages.STCoreVariableUsageValidator_UnreadVariable, feature.getName()), (EObject)feature, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, -1, "org.eclipse.fordiac.ide.structuredtextcore.unreadVariable", new String[0]);
        } else if (state.contains((Object)VariableState.UNWRITTEN)) {
            this.addIssue(MessageFormat.format(Messages.STCoreVariableUsageValidator_UnwrittenVariable, feature.getName()), (EObject)feature, (EStructuralFeature)LibraryElementPackage.Literals.INAMED_ELEMENT__NAME, -1, "org.eclipse.fordiac.ide.structuredtextcore.unwrittenVariable", new String[0]);
        }
    }

    protected void addIssue(String message, EObject source, EStructuralFeature feature, int index, String issueCode, String ... issueData) {
        STCoreValidator.addIssue(this.acceptor, this.severities, message, source, feature, index, issueCode, issueData);
    }

    protected static EnumSet<VariableState> merge(EnumSet<VariableState> first, EnumSet<VariableState> second) {
        Object result = first.clone();
        ((AbstractCollection)result).retainAll(second);
        return result;
    }

    public static enum VariableState {
        UNUSED,
        UNREAD,
        UNWRITTEN;

    }
}

