/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.edit;

import java.text.MessageFormat;
import java.util.List;
import java.util.Objects;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeDeclarationCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeDataTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeStructCommand;
import org.eclipse.fordiac.ide.model.commands.change.ConfigureFBCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateFBTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.UpdateInternalFBCommand;
import org.eclipse.fordiac.ide.model.data.AnyDerivedType;
import org.eclipse.fordiac.ide.model.data.DataType;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.ITypeEntryEditor;
import org.eclipse.fordiac.ide.model.edit.Messages;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableFB;
import org.eclipse.fordiac.ide.model.libraryElement.ConfigurableObject;
import org.eclipse.fordiac.ide.model.libraryElement.FB;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetwork;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.libraryElement.StructManipulator;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.search.types.AttributeTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.BlockTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.search.types.DataTypeInstanceSearch;
import org.eclipse.fordiac.ide.model.typelibrary.AttributeTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.DataTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.FBTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.SubAppTypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.INavigationLocation;
import org.eclipse.ui.INavigationLocationProvider;
import org.eclipse.ui.part.FileEditorInput;

public class TypeEntryAdapter
extends AdapterImpl {
    private final ITypeEntryEditor editor;
    private boolean reloadPending;

    public TypeEntryAdapter(ITypeEntryEditor editor) {
        this.editor = editor;
    }

    public void notifyChanged(Notification notification) {
        super.notifyChanged(notification);
        String feature = "";
        Object object = notification.getFeature();
        if (object instanceof String) {
            String string;
            feature = string = (String)object;
        }
        switch (feature) {
            case "TYPE_ENTRY_FILE_CONTENT_FEATURE": {
                this.handleFileContentChange();
                break;
            }
            case "TYPE_ENTRY_FILE_FEATURE": {
                Display.getDefault().asyncExec(() -> {
                    Object object;
                    if (!this.editorClosed() && (object = notification.getNewValue()) instanceof IFile) {
                        IFile newFile = (IFile)object;
                        this.editor.setInput((IEditorInput)new FileEditorInput(newFile));
                    }
                });
                break;
            }
            case "TYPE_ENTRY_EDITOR_INSTANCE_UPDATE_FEATURE": {
                Assert.isTrue((boolean)(notification.getNotifier() instanceof TypeEntry));
                Assert.isTrue((boolean)(notification.getNewValue() instanceof TypeEntry));
                TypeEntry typeEntry = (TypeEntry)notification.getNewValue();
                this.handleDependencyUpdate(typeEntry);
                break;
            }
        }
    }

    public void checkFileReload() {
        if (this.reloadPending) {
            this.performReload();
        }
    }

    private void handleFileContentChange() {
        if (this.editor.equals(this.editor.getSite().getPage().getActiveEditor())) {
            this.performReload();
        } else {
            this.reloadPending = true;
        }
    }

    private void performReload() {
        Display.getDefault().asyncExec(() -> {
            if (!(this.editorClosed() || this.editor.isDirty() && this.openFileChangedDialog() != 0)) {
                this.editor.reloadType();
            }
        });
        this.reloadPending = false;
    }

    private int openFileChangedDialog() {
        String message = MessageFormat.format(Messages.TypeEntryEditor_filedchanged_message, this.editor.getEditorInput().getName());
        MessageDialog dialog = new MessageDialog(this.editor.getSite().getShell(), Messages.TypeEntryEditor_FileChangedTitle, null, message, 3, new String[]{Messages.TypeEntryEditor_replace_button_label, Messages.TypeEntryEditor_dontreplace_button_label}, 0);
        return dialog.open();
    }

    private void handleDependencyUpdate(TypeEntry typeEntry) {
        LibraryElement editedElement = (LibraryElement)this.editor.getAdapter(LibraryElement.class);
        if (editedElement != null) {
            Display.getDefault().asyncExec(() -> {
                if (this.editorClosed()) {
                    return;
                }
                if (typeEntry instanceof FBTypeEntry || typeEntry instanceof SubAppTypeEntry) {
                    this.handleBlockTypeDependencyUpdate(editedElement, typeEntry);
                }
                if (typeEntry instanceof DataTypeEntry) {
                    DataTypeEntry dtEntry = (DataTypeEntry)typeEntry;
                    TypeEntryAdapter.handleDataTypeEntryUpdate(editedElement, dtEntry);
                }
                if (typeEntry instanceof AttributeTypeEntry) {
                    AttributeTypeEntry atEntry = (AttributeTypeEntry)typeEntry;
                    TypeEntryAdapter.handleAttributeTypeEntryUpdate(editedElement, atEntry);
                }
            });
        }
    }

    private boolean editorClosed() {
        return this.editor.getSite().getPage() == null;
    }

    private static void handleAttributeTypeEntryUpdate(LibraryElement editedElement, AttributeTypeEntry atEntry) {
        AttributeTypeInstanceSearch search = new AttributeTypeInstanceSearch(editedElement, atEntry);
        List result = search.performSearch();
        result.forEach(at -> {
            if (at instanceof ConfigurableObject) {
                ConfigurableObject co = (ConfigurableObject)at;
                Attribute attribute = co.getAttribute(atEntry.getTypeName());
                ChangeAttributeDeclarationCommand.forEntry((Attribute)attribute, (AttributeTypeEntry)atEntry).execute();
            }
        });
    }

    private void handleBlockTypeDependencyUpdate(LibraryElement editedElement, TypeEntry typeEntry) {
        BlockTypeInstanceSearch search = new BlockTypeInstanceSearch(editedElement, typeEntry);
        INavigationLocation location = this.getEditorLocation();
        search.performSearch().stream().filter(FBNetworkElement.class::isInstance).map(FBNetworkElement.class::cast).map(fbnEl -> {
            if (fbnEl instanceof FB) {
                FB fb = (FB)fbnEl;
                if (fbnEl.eContainer() == editedElement) {
                    return new UpdateInternalFBCommand(fb, typeEntry);
                }
            }
            return new UpdateFBTypeCommand(fbnEl, typeEntry);
        }).forEach(command -> command.execute());
        if (location != null) {
            location.restoreLocation();
        }
    }

    private INavigationLocation getEditorLocation() {
        ITypeEntryEditor iTypeEntryEditor;
        if (this.editor.getAdapter(FBNetwork.class) == null && (iTypeEntryEditor = this.editor) instanceof INavigationLocationProvider) {
            INavigationLocationProvider provider = (INavigationLocationProvider)iTypeEntryEditor;
            return provider.createNavigationLocation();
        }
        return null;
    }

    private static void handleDataTypeEntryUpdate(LibraryElement editedElement, DataTypeEntry dtEntry) {
        DataTypeInstanceSearch search = new DataTypeInstanceSearch(editedElement, dtEntry);
        AnyDerivedType dataType = dtEntry.getType();
        search.performSearch().stream().map(item -> {
            if (item instanceof Attribute) {
                Attribute attr = (Attribute)item;
                return ChangeAttributeTypeCommand.forDataType((Attribute)attr, (DataType)dataType);
            }
            if (item instanceof VarDeclaration) {
                VarDeclaration varDecl = (VarDeclaration)item;
                return ChangeDataTypeCommand.forDataType((IInterfaceElement)varDecl, (DataType)dataType);
            }
            if (item instanceof ConfigurableFB) {
                ConfigurableFB configFB = (ConfigurableFB)item;
                if (item instanceof StructManipulator) {
                    StructManipulator structMan = (StructManipulator)item;
                    if (dataType instanceof StructuredType) {
                        StructuredType struct = (StructuredType)dataType;
                        return new ChangeStructCommand(structMan, (DataType)struct);
                    }
                }
                return new ConfigureFBCommand(configFB, (DataType)dataType);
            }
            return null;
        }).filter(Objects::nonNull).forEach(command -> command.execute());
    }
}

