/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.model.typelibrary;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.e4.core.contexts.EclipseContextFactory;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.model.ModelPlugin;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.ITypeLibraryStarter;
import org.eclipse.fordiac.ide.model.typelibrary.TypeEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.ui.FordiacLogHelper;
import org.osgi.framework.BundleContext;

public enum TypeLibraryManager {
    INSTANCE;

    private final Map<IProject, TypeLibrary> typeLibraryList = new HashMap<IProject, TypeLibrary>();
    private final IEventBroker eventBroker = TypeLibraryManager.initEventBroker();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TypeLibrary getTypeLibrary(IProject proj) {
        Map<IProject, TypeLibrary> map = this.typeLibraryList;
        synchronized (map) {
            return this.typeLibraryList.computeIfAbsent(proj, this::createTypeLibrary);
        }
    }

    public TypeLibrary getTypeLibraryFromContext(EObject context) {
        EObject eObject = EcoreUtil.getRootContainer((EObject)context);
        if (eObject instanceof LibraryElement) {
            LibraryElement libraryElement = (LibraryElement)eObject;
            return libraryElement.getTypeLibrary();
        }
        Resource resource = context.eResource();
        if (resource != null) {
            return this.getTypeLibraryFromURI(resource.getURI());
        }
        return null;
    }

    public TypeLibrary getTypeLibraryFromURI(URI uri) {
        if (uri != null) {
            IFile file;
            if (uri.isPlatformResource()) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true)));
            } else if (uri.isFile() && uri.segmentCount() >= 2) {
                file = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toFileString()));
            } else {
                return null;
            }
            if (file.getProject() != null) {
                return this.getTypeLibrary(file.getProject());
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasTypeLibrary(IProject proj) {
        Map<IProject, TypeLibrary> map = this.typeLibraryList;
        synchronized (map) {
            return this.typeLibraryList.get(proj) != null;
        }
    }

    public Collection<TypeLibrary> getTypeLibraries() {
        return Collections.unmodifiableCollection(this.typeLibraryList.values());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeProject(IProject project) {
        Map<IProject, TypeLibrary> map = this.typeLibraryList;
        synchronized (map) {
            this.typeLibraryList.remove(project);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameProject(IProject oldProject, IProject newProject) {
        Map<IProject, TypeLibrary> map = this.typeLibraryList;
        synchronized (map) {
            TypeLibrary typelib = this.typeLibraryList.remove(oldProject);
            if (typelib != null) {
                typelib.setProject(newProject);
                this.typeLibraryList.put(newProject, typelib);
            }
        }
    }

    public TypeEntry getTypeEntryForFile(IFile typeFile) {
        TypeLibrary typeLib = this.getTypeLibrary(typeFile.getProject());
        return typeLib.getTypeEntry(typeFile);
    }

    public TypeEntry getTypeEntryForURI(URI uri) {
        if (uri.isPlatformResource()) {
            return this.getTypeEntryForFile(ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)new Path(uri.toPlatformString(true))));
        }
        return null;
    }

    private TypeLibrary createTypeLibrary(IProject project) {
        TypeLibrary library = new TypeLibrary(project);
        this.eventBroker.send("org/eclipse/fordiac/event/type_library_creation", (Object)library);
        return library;
    }

    public void resendCreateEvent(IProject project) {
        if (project == null) {
            return;
        }
        TypeLibrary library = this.getTypeLibrary(project);
        if (library != null) {
            this.eventBroker.send("org/eclipse/fordiac/event/type_library_creation", (Object)library);
        }
    }

    private static IEventBroker initEventBroker() {
        TypeLibraryManager.useExtensions("org.eclipse.fordiac.ide.model.TypeLibraryStarter", ITypeLibraryStarter.class, ITypeLibraryStarter::start);
        return (IEventBroker)EclipseContextFactory.getServiceContext((BundleContext)ModelPlugin.getDefault().getBundle().getBundleContext()).get(IEventBroker.class);
    }

    public static <T> List<T> listExtensions(String extensionPoint, Class<T> type) {
        LinkedList classes = new LinkedList();
        TypeLibraryManager.useExtensions(extensionPoint, type, classes::add);
        return classes;
    }

    public static <T> void useExtensions(String extensionPoint, Class<T> type, Consumer<T> consumer) {
        IExtension[] extensions;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint(extensionPoint);
        IExtension[] iExtensionArray = extensions = point.getExtensions();
        int n = extensions.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement[] elements;
            IExtension extension = iExtensionArray[n2];
            IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
            int n3 = elements.length;
            int n4 = 0;
            while (n4 < n3) {
                IConfigurationElement element = iConfigurationElementArray[n4];
                try {
                    Object obj = element.createExecutableExtension("class");
                    if (type.isInstance(obj)) {
                        consumer.accept(type.cast(obj));
                    }
                }
                catch (Exception e) {
                    FordiacLogHelper.logError((String)e.getMessage(), (Throwable)e);
                }
                ++n4;
            }
            ++n2;
        }
    }
}

