/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.ArrayList;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.draw2d.BendpointConnectionRouter;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionLayer;
import org.eclipse.draw2d.ConnectionRouter;
import org.eclipse.draw2d.FreeformLayer;
import org.eclipse.draw2d.FreeformLayout;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.LayoutManager;
import org.eclipse.draw2d.MarginBorder;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.ui.preferences.FixedScopedPreferenceStore;
import org.eclipse.gef.CompoundSnapToHelper;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.SnapToGrid;
import org.eclipse.gef.SnapToHelper;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.editpolicies.SnapFeedbackPolicy;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;

public abstract class AbstractDiagramEditPart
extends AbstractGraphicalEditPart {
    private final IPreferenceStore preferenceStore = new FixedScopedPreferenceStore(InstanceScope.INSTANCE, "org.eclipse.fordiac.ide.gef");
    private IPropertyChangeListener listener;

    protected AbstractDiagramEditPart() {
    }

    protected IFigure createFigure() {
        FreeformLayer newFigure = new FreeformLayer();
        newFigure.setBorder((Border)new MarginBorder(10));
        newFigure.setLayoutManager((LayoutManager)new FreeformLayout());
        newFigure.setOpaque(false);
        ConnectionLayer connLayer = (ConnectionLayer)this.getLayer("Connection Layer");
        connLayer.setConnectionRouter(this.createConnectionRouter((IFigure)newFigure));
        return newFigure;
    }

    public void refresh() {
        super.refresh();
        this.showGrid();
        this.updateRuler();
    }

    private void updateRuler() {
        this.getViewer().setProperty("ruler$visibility", (Object)this.preferenceStore.getBoolean("ShowRulers"));
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            if (this.getPreferenceChangeListener() != null) {
                this.preferenceStore.addPropertyChangeListener(this.getPreferenceChangeListener());
            }
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            if (this.getPreferenceChangeListener() != null) {
                this.preferenceStore.removePropertyChangeListener(this.getPreferenceChangeListener());
            }
        }
    }

    protected void showGrid() {
        this.getViewer().setProperty("SnapToGrid.isVisible", (Object)this.preferenceStore.getBoolean("ShowGrid"));
    }

    public IPropertyChangeListener getPreferenceChangeListener() {
        if (this.listener == null) {
            this.listener = event -> {
                if (event.getProperty().equals("ShowGrid")) {
                    this.showGrid();
                }
                if (event.getProperty().equals("ShowRulers")) {
                    this.updateRuler();
                }
            };
        }
        return this.listener;
    }

    protected ConnectionRouter createConnectionRouter(IFigure figure) {
        return new BendpointConnectionRouter();
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == SnapToHelper.class) {
            ArrayList<SnapToGrid> snapStrategies = new ArrayList<SnapToGrid>();
            if (((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().isSnapToGrid()) {
                snapStrategies.add(new SnapToGrid((GraphicalEditPart)this));
            }
            if (snapStrategies.isEmpty()) {
                return null;
            }
            if (snapStrategies.size() == 1) {
                return key.cast(snapStrategies.get(0));
            }
            SnapToHelper[] ss = new SnapToHelper[snapStrategies.size()];
            snapStrategies.toArray(ss);
            return key.cast(new CompoundSnapToHelper(ss));
        }
        return (T)super.getAdapter(key);
    }

    protected void createEditPolicies() {
        this.installEditPolicy("Snap Feedback", (EditPolicy)new SnapFeedbackPolicy());
    }
}

