/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.editparts;

import java.util.Collections;
import java.util.List;
import org.eclipse.draw2d.Border;
import org.eclipse.draw2d.ConnectionAnchor;
import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.MouseEvent;
import org.eclipse.draw2d.MouseMotionListener;
import org.eclipse.draw2d.PolylineConnection;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Insets;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.util.EList;
import org.eclipse.fordiac.ide.gef.FixedAnchor;
import org.eclipse.fordiac.ide.gef.annotation.AnnotableGraphicalEditPart;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModelEvent;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationStyles;
import org.eclipse.fordiac.ide.gef.draw2d.ConnectorBorder;
import org.eclipse.fordiac.ide.gef.draw2d.SetableAlphaLabel;
import org.eclipse.fordiac.ide.gef.editparts.AbstractConnectableEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ConnCreateDirectEditDragTrackerProxy;
import org.eclipse.fordiac.ide.gef.editparts.IDeactivatableConnectionHandleRoleEditPart;
import org.eclipse.fordiac.ide.gef.editparts.ValueEditPart;
import org.eclipse.fordiac.ide.gef.figures.ToolTipFigure;
import org.eclipse.fordiac.ide.gef.policies.DataInterfaceLayoutEditPolicy;
import org.eclipse.fordiac.ide.gef.policies.InterfaceElementSelectionPolicy;
import org.eclipse.fordiac.ide.gef.policies.ValueEditPartChangeEditPolicy;
import org.eclipse.fordiac.ide.model.libraryElement.AdapterDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.ErrorMarkerInterface;
import org.eclipse.fordiac.ide.model.libraryElement.Event;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElementPackage;
import org.eclipse.fordiac.ide.model.libraryElement.MemberVarDeclaration;
import org.eclipse.fordiac.ide.model.libraryElement.SubApp;
import org.eclipse.fordiac.ide.model.libraryElement.Value;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.fordiac.ide.model.ui.editors.AdvancedScrollingGraphicalViewer;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.gef.ConnectionEditPart;
import org.eclipse.gef.DragTracker;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPolicy;
import org.eclipse.gef.NodeEditPart;
import org.eclipse.gef.Request;
import org.eclipse.gef.editpolicies.GraphicalNodeEditPolicy;
import org.eclipse.gef.editpolicies.LayoutEditPolicy;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.swt.widgets.Display;

public abstract class InterfaceEditPart
extends AbstractConnectableEditPart
implements NodeEditPart,
IDeactivatableConnectionHandleRoleEditPart,
AnnotableGraphicalEditPart {
    private int mouseState;
    private Adapter contentAdapter = null;
    private IInterfaceElement sourcePin = null;
    private Adapter sourcePinAdapter = null;
    private String pinLabelStyle = "";
    private final IPropertyChangeListener preferenceListener = event -> {
        if (event.getProperty().equals("PinLabelStyle") || event.getProperty().equals("ProjectStoreActive")) {
            this.pinLabelStyle = ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getStoreProvider().getStore().getString("PinLabelStyle");
            this.refreshLabelText();
        }
    };
    private ConnectionAnchor sourceConAnchor = null;
    private ConnectionAnchor destinationConAnchor = null;

    protected InterfaceEditPart() {
    }

    protected int getMinWidth() {
        return ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMinPinLabelSize();
    }

    protected int getMaxWidth() {
        return ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getMaxPinLabelSize();
    }

    @Override
    public DragTracker getDragTracker(Request request) {
        return new ConnCreateDirectEditDragTrackerProxy((EditPart)this);
    }

    public int getMouseState() {
        return this.mouseState;
    }

    protected void refreshTargetConnections() {
        this.updateSourcePinAdapter();
        super.refreshTargetConnections();
        if (this.getReferencedValueEditPart() != null) {
            this.getReferencedValueEditPart().refreshValue();
        }
    }

    @Override
    public boolean isConnectable() {
        return true;
    }

    protected String getLabelText() {
        String altText = this.getAlternativePinLabelText();
        return !altText.isBlank() ? altText : InterfaceEditPart.getPinName(this.getModel());
    }

    private String getAlternativePinLabelText() {
        switch (this.pinLabelStyle) {
            case "PinLabelStyle_PinComment": {
                if (this.getModel().getFBNetworkElement() == null) break;
                return this.getModel().getComment();
            }
            case "PinLabelStyle_SourcePinName": {
                if (!this.isShowInput()) break;
                return this.getSourcePinInstanceName();
            }
        }
        return "";
    }

    private void refreshLabelText() {
        ((InterfaceFigure)this.getFigure()).setText(this.getLabelText());
    }

    private boolean isShowInput() {
        return "PinLabelStyle_SourcePinName".equals(this.pinLabelStyle) && this.isInput() && !this.getModel().getInputConnections().isEmpty();
    }

    private String getSourcePinInstanceName() {
        IInterfaceElement refPin = this.getSourcePin();
        if (refPin != null) {
            FBNetworkElement source = refPin.getFBNetworkElement();
            String pinName = InterfaceEditPart.getPinName(refPin);
            if (source != null && !this.isSubAppPin(source)) {
                String elementName = source.getName();
                return elementName + "." + pinName;
            }
            return pinName;
        }
        return "";
    }

    private static String getPinName(IInterfaceElement pin) {
        if (pin instanceof MemberVarDeclaration) {
            MemberVarDeclaration memberVarDecl = (MemberVarDeclaration)pin;
            return memberVarDecl.getDisplayName();
        }
        return pin.getName();
    }

    private IInterfaceElement getSourcePin() {
        EList inputConnections = this.getModel().getInputConnections();
        if (!inputConnections.isEmpty()) {
            return ((Connection)inputConnections.get(0)).getSource();
        }
        return null;
    }

    private boolean isSubAppPin(FBNetworkElement connSource) {
        if (connSource instanceof SubApp) {
            SubApp subapp = (SubApp)connSource;
            if (this.getModel().getFBNetworkElement() != null) {
                return subapp.getSubAppNetwork() == this.getModel().getFBNetworkElement().getFbNetwork();
            }
        }
        return false;
    }

    protected IFigure createFigure() {
        InterfaceFigure figure = new InterfaceFigure();
        figure.setToolTip((IFigure)new ToolTipFigure((INamedElement)this.getModel(), FordiacAnnotationUtil.getAnnotationModel((EditPart)this)));
        return figure;
    }

    protected void refreshVisuals() {
        this.refreshLabelText();
    }

    protected abstract GraphicalNodeEditPolicy getNodeEditPolicy();

    public void setInOutConnectionsWidth(int width) {
        this.getSourceConnections().forEach(cep -> InterfaceEditPart.checkConnection(width, cep));
        this.getTargetConnections().forEach(cep -> InterfaceEditPart.checkConnection(width, cep));
    }

    private static void checkConnection(int width, ConnectionEditPart cep) {
        IFigure iFigure = cep.getFigure();
        if (iFigure instanceof PolylineConnection) {
            PolylineConnection plc = (PolylineConnection)iFigure;
            plc.setLineWidth(width);
        }
    }

    @Override
    protected void createEditPolicies() {
        GraphicalNodeEditPolicy nodeEditPolicy = this.getNodeEditPolicy();
        if (nodeEditPolicy != null) {
            this.installEditPolicy("GraphicalNodeEditPolicy", (EditPolicy)nodeEditPolicy);
        }
        this.installEditPolicy("Selection Feedback", (EditPolicy)new InterfaceElementSelectionPolicy(this));
        if (this.isVariable()) {
            this.installEditPolicy("LayoutEditPolicy", (EditPolicy)this.getLayoutPolicy());
            this.installEditPolicy("DirectEditPolicy", (EditPolicy)new ValueEditPartChangeEditPolicy(){

                @Override
                protected ValueEditPart getValueEditPart() {
                    return InterfaceEditPart.this.getReferencedValueEditPart();
                }
            });
        }
    }

    protected LayoutEditPolicy getLayoutPolicy() {
        return new DataInterfaceLayoutEditPolicy();
    }

    @Override
    public void setConnectionHandleRoleEnabled(boolean enabled) {
    }

    public <T> T getAdapter(Class<T> key) {
        if (key == IInterfaceElement.class) {
            return key.cast(this.getModel());
        }
        return (T)super.getAdapter(key);
    }

    public IInterfaceElement getModel() {
        return (IInterfaceElement)super.getModel();
    }

    public boolean isInput() {
        return this.getModel().isIsInput();
    }

    public boolean isEvent() {
        return this.getModel() instanceof Event;
    }

    public boolean isAdapter() {
        return this.getModel() instanceof AdapterDeclaration;
    }

    public boolean isVariable() {
        return this.getModel() instanceof VarDeclaration;
    }

    protected void addChildVisual(EditPart childEditPart, int index) {
    }

    protected Adapter getContentAdapter() {
        if (this.contentAdapter == null) {
            this.contentAdapter = this.createContentAdapter();
        }
        return this.contentAdapter;
    }

    protected Adapter createContentAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getIInterfaceElement_InputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getIInterfaceElement_OutputConnections().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature) || LibraryElementPackage.eINSTANCE.getINamedElement_Comment().equals(feature)) {
                    Display.getDefault().execute(() -> InterfaceEditPart.this.refresh());
                }
                super.notifyChanged(notification);
            }
        };
    }

    public void activate() {
        if (!this.isActive()) {
            super.activate();
            PreferenceStoreProvider storeProvider = ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getStoreProvider();
            storeProvider.addPropertyChangeListener(this.preferenceListener);
            this.pinLabelStyle = storeProvider.getStore().getString("PinLabelStyle");
            this.getModel().eAdapters().add((Object)this.getContentAdapter());
            this.addSourcePinAdapter();
        }
    }

    public void deactivate() {
        if (this.isActive()) {
            super.deactivate();
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            ((AdvancedScrollingGraphicalViewer)this.getViewer()).getPreferencesCache().getStoreProvider().removePropertyChangeListener(this.preferenceListener);
            this.getModel().eAdapters().remove((Object)this.getContentAdapter());
            this.removeSourcePinAdapter();
        }
    }

    public final ConnectionAnchor getSourceConnectionAnchor(ConnectionEditPart connection) {
        if (this.sourceConAnchor == null) {
            this.sourceConAnchor = this.createSourceConAnchor();
        }
        return this.sourceConAnchor;
    }

    public final ConnectionAnchor getSourceConnectionAnchor(Request request) {
        if (this.sourceConAnchor == null) {
            this.sourceConAnchor = this.createSourceConAnchor();
        }
        return this.sourceConAnchor;
    }

    public final ConnectionAnchor getTargetConnectionAnchor(ConnectionEditPart connection) {
        if (this.destinationConAnchor == null) {
            this.destinationConAnchor = this.createTargetConAnchor();
        }
        return this.destinationConAnchor;
    }

    public final ConnectionAnchor getTargetConnectionAnchor(Request request) {
        if (this.destinationConAnchor == null) {
            this.destinationConAnchor = this.createTargetConAnchor();
        }
        return this.destinationConAnchor;
    }

    protected FixedAnchor createSourceConAnchor() {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    protected FixedAnchor createTargetConAnchor() {
        return new FixedAnchor(this.getFigure(), this.isInput());
    }

    protected List<?> getModelSourceConnections() {
        if (!this.isInput()) {
            return this.getModel().getOutputConnections();
        }
        return Collections.emptyList();
    }

    protected List<?> getModelTargetConnections() {
        if (this.isInput()) {
            return this.getModel().getInputConnections();
        }
        return Collections.emptyList();
    }

    public void performRequest(Request request) {
        request.getType();
        if (request.getType() == "direct edit" || request.getType() == "open") {
            ValueEditPart part = this.getReferencedValueEditPart();
            if (part != null && this.isVariable()) {
                part.performRequest(request);
            }
        } else {
            super.performRequest(request);
        }
    }

    public ValueEditPart getReferencedValueEditPart() {
        EditPart editPart;
        Value value = this.getValue();
        if (value != null && (editPart = this.getViewer().getEditPartForModel((Object)value)) instanceof ValueEditPart) {
            ValueEditPart vep = (ValueEditPart)editPart;
            return vep;
        }
        return null;
    }

    private Value getValue() {
        IInterfaceElement iInterfaceElement = this.getModel();
        if (iInterfaceElement instanceof VarDeclaration) {
            VarDeclaration varDecl = (VarDeclaration)iInterfaceElement;
            return varDecl.getValue();
        }
        IInterfaceElement iInterfaceElement2 = this.getModel();
        if (iInterfaceElement2 instanceof ErrorMarkerInterface) {
            ErrorMarkerInterface emi = (ErrorMarkerInterface)iInterfaceElement2;
            return emi.getValue();
        }
        return null;
    }

    private void addSourcePinAdapter() {
        if (this.isShowInput()) {
            this.sourcePin = this.getSourcePin();
            if (this.sourcePin != null) {
                this.sourcePin.eAdapters().add((Object)this.getSourcePinAdapter());
                FBNetworkElement sourceElement = this.sourcePin.getFBNetworkElement();
                if (sourceElement != null) {
                    sourceElement.eAdapters().add((Object)this.getSourcePinAdapter());
                }
            }
        }
    }

    private void removeSourcePinAdapter() {
        if (this.sourcePin != null) {
            this.sourcePin.eAdapters().remove((Object)this.getSourcePinAdapter());
            FBNetworkElement sourceElement = this.sourcePin.getFBNetworkElement();
            if (sourceElement != null) {
                sourceElement.eAdapters().remove((Object)this.getSourcePinAdapter());
            }
            this.sourcePin = null;
        }
    }

    private void updateSourcePinAdapter() {
        if (this.sourcePin != this.getSourcePin()) {
            this.removeSourcePinAdapter();
            this.addSourcePinAdapter();
        }
    }

    private Adapter getSourcePinAdapter() {
        if (this.sourcePinAdapter == null) {
            this.sourcePinAdapter = this.createSourcePinAdapter();
        }
        return this.sourcePinAdapter;
    }

    private Adapter createSourcePinAdapter() {
        return new AdapterImpl(){

            public void notifyChanged(Notification notification) {
                Object feature = notification.getFeature();
                if (LibraryElementPackage.eINSTANCE.getINamedElement_Name().equals(feature)) {
                    InterfaceEditPart.this.refreshLabelText();
                }
            }
        };
    }

    protected void updatePadding(int yPosition) {
        IFigure paddingFigure = (IFigure)this.getFigure().getParent().getChildren().get(0);
        int textHeight = ((InterfaceFigure)this.getFigure()).getTextBounds().height();
        paddingFigure.setMinimumSize(new Dimension(-1, yPosition - textHeight));
    }

    protected static int getYPositionFromAttribute(IInterfaceElement ie) {
        Attribute attribute = ie.getAttribute("YPOSITION");
        if (attribute != null) {
            return Integer.parseInt(attribute.getValue());
        }
        return 0;
    }

    @Override
    public void updateAnnotations(GraphicalAnnotationModelEvent event) {
        GraphicalAnnotationStyles.updateAnnotationFeedback(this.getFigure(), this.getModel(), event);
        this.getFigure().setToolTip((IFigure)new ToolTipFigure((INamedElement)this.getModel(), event.getModel()));
    }

    public class InterfaceFigure
    extends SetableAlphaLabel {
        public InterfaceFigure() {
            this.setOpaque(false);
            this.setText(InterfaceEditPart.this.getLabelText());
            this.setBorder((Border)new ConnectorBorder(InterfaceEditPart.this.getModel()));
            if (InterfaceEditPart.this.isInput()) {
                this.setLabelAlignment(1);
                this.setTextAlignment(1);
            } else {
                this.setLabelAlignment(4);
                this.setTextAlignment(4);
            }
            if (InterfaceEditPart.this.isAdapter()) {
                this.addMouseMotionListener(new MouseMotionListener(){

                    public void mouseDragged(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseEntered(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseExited(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseHover(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }

                    public void mouseMoved(MouseEvent me) {
                        ((InterfaceFigure)InterfaceFigure.this).InterfaceEditPart.this.mouseState = me.getState();
                    }
                });
            }
        }

        public String getSubStringText() {
            if (InterfaceEditPart.this.getLabelText().length() < InterfaceEditPart.this.getMinWidth()) {
                int diff = InterfaceEditPart.this.getMinWidth() - InterfaceEditPart.this.getLabelText().length();
                return InterfaceEditPart.this.isInput() ? InterfaceEditPart.this.getLabelText() + " ".repeat(diff) : " ".repeat(diff) + InterfaceEditPart.this.getLabelText();
            }
            if (InterfaceEditPart.this.getLabelText().length() > InterfaceEditPart.this.getMaxWidth()) {
                return InterfaceEditPart.this.getLabelText().substring(0, InterfaceEditPart.this.getMaxWidth()) + this.getTruncationString();
            }
            return InterfaceEditPart.this.getLabelText();
        }

        public Dimension getPreferredSize(int wHint, int hHint) {
            if (this.prefSize == null) {
                this.prefSize = this.calculateLabelSize(this.getSubStringTextSize());
                Insets insets = this.getInsets();
                this.prefSize.expand(insets.getWidth(), insets.getHeight());
                if (this.getLayoutManager() != null) {
                    this.prefSize.union(this.getLayoutManager().getPreferredSize((IFigure)this, wHint, hHint));
                }
            }
            if (wHint >= 0 && wHint < this.prefSize.width) {
                Dimension minSize = this.getMinimumSize(wHint, hHint);
                Dimension result = this.prefSize.getCopy();
                result.width = Math.min(result.width, wHint);
                result.width = Math.max(minSize.width, result.width);
                return result;
            }
            return this.prefSize;
        }

        public Dimension getMinimumSize(int wHint, int hHint) {
            return this.getPreferredSize(-1, -1);
        }

        public Dimension getTextSize() {
            super.getTextSize();
            return this.getSubStringTextSize();
        }
    }
}

