/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.Objects;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.fordiac.ide.gef.nat.AbstractColumnAccessor;
import org.eclipse.fordiac.ide.gef.nat.AttributeTableColumn;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeTypeCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeAttributeValueCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.ChangeNameCommand;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.errormarker.FordiacMarkerHelper;
import org.eclipse.fordiac.ide.model.helpers.ImportHelper;
import org.eclipse.fordiac.ide.model.helpers.PackageNameHelper;
import org.eclipse.fordiac.ide.model.libraryElement.Attribute;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.ui.widget.CommandExecutor;
import org.eclipse.gef.commands.Command;

public class AttributeColumnAccessor
extends AbstractColumnAccessor<Attribute, AttributeTableColumn> {
    private static final String NULL_DEFAULT = "";

    public AttributeColumnAccessor(CommandExecutor commandExecutor) {
        this(commandExecutor, AttributeTableColumn.DEFAULT_COLUMNS);
    }

    public AttributeColumnAccessor(CommandExecutor commandExecutor, List<AttributeTableColumn> columns) {
        super(commandExecutor, columns);
    }

    @Override
    public Object getDataValue(Attribute rowObject, AttributeTableColumn column) {
        return switch (column) {
            case AttributeTableColumn.NAME -> {
                if (rowObject.getAttributeDeclaration() != null) {
                    yield ImportHelper.deresolveImport((LibraryElement)rowObject.getAttributeDeclaration(), (EObject)rowObject);
                }
                yield rowObject.getName();
            }
            case AttributeTableColumn.TYPE -> {
                if (rowObject.getAttributeDeclaration() != null) {
                    yield PackageNameHelper.getFullTypeName((LibraryElement)rowObject.getAttributeDeclaration());
                }
                yield ImportHelper.deresolveImport((LibraryElement)rowObject.getType(), (EObject)rowObject);
            }
            case AttributeTableColumn.VALUE -> InitialValueHelper.getInitialOrDefaultValue((Object)rowObject);
            case AttributeTableColumn.COMMENT -> CommentHelper.getInstanceComment((INamedElement)rowObject);
            case AttributeTableColumn.LOCATION -> EcoreUtil.getURI((EObject)rowObject).toPlatformString(true);
            case AttributeTableColumn.PATH -> FordiacMarkerHelper.getLocation((EObject)rowObject);
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }

    @Override
    public Command createCommand(Attribute rowObject, AttributeTableColumn column, Object newValue) {
        return switch (column) {
            case AttributeTableColumn.NAME -> ChangeNameCommand.forName((INamedElement)rowObject, (String)Objects.toString(newValue, NULL_DEFAULT));
            case AttributeTableColumn.TYPE -> ChangeAttributeTypeCommand.forTypeName((Attribute)rowObject, (String)Objects.toString(newValue, NULL_DEFAULT));
            case AttributeTableColumn.VALUE -> new ChangeAttributeValueCommand(rowObject, Objects.toString(newValue, NULL_DEFAULT));
            case AttributeTableColumn.COMMENT -> new ChangeCommentCommand((INamedElement)rowObject, Objects.toString(newValue, NULL_DEFAULT));
            default -> throw new IllegalArgumentException("Unexpected value: " + String.valueOf((Object)column));
        };
    }
}

