/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.nat;

import java.util.List;
import java.util.function.Supplier;
import org.eclipse.fordiac.ide.gef.annotation.FordiacAnnotationUtil;
import org.eclipse.fordiac.ide.gef.annotation.GraphicalAnnotationModel;
import org.eclipse.fordiac.ide.gef.nat.AbstractAnnotatedConfigLabelAccumulator;
import org.eclipse.fordiac.ide.gef.nat.VarDeclarationTableColumn;
import org.eclipse.fordiac.ide.model.data.StructuredType;
import org.eclipse.fordiac.ide.model.edit.helper.CommentHelper;
import org.eclipse.fordiac.ide.model.edit.helper.InitialValueHelper;
import org.eclipse.fordiac.ide.model.libraryElement.INamedElement;
import org.eclipse.fordiac.ide.model.libraryElement.VarDeclaration;
import org.eclipse.nebula.widgets.nattable.data.IRowDataProvider;
import org.eclipse.nebula.widgets.nattable.layer.LabelStack;

public class VarDeclarationConfigLabelAccumulator
extends AbstractAnnotatedConfigLabelAccumulator<VarDeclaration> {
    private final List<VarDeclarationTableColumn> columns;

    public VarDeclarationConfigLabelAccumulator(IRowDataProvider<VarDeclaration> dataProvider) {
        this(dataProvider, () -> null);
    }

    public VarDeclarationConfigLabelAccumulator(IRowDataProvider<VarDeclaration> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier) {
        this(dataProvider, annotationModelSupplier, VarDeclarationTableColumn.DEFAULT_COLUMNS);
    }

    public VarDeclarationConfigLabelAccumulator(IRowDataProvider<VarDeclaration> dataProvider, Supplier<GraphicalAnnotationModel> annotationModelSupplier, List<VarDeclarationTableColumn> columns) {
        super(dataProvider, annotationModelSupplier);
        this.columns = columns;
    }

    public List<VarDeclarationTableColumn> getColumns() {
        return this.columns;
    }

    public void accumulateConfigLabels(LabelStack configLabels, int columnPosition, int rowPosition) {
        VarDeclaration rowItem = (VarDeclaration)this.getDataProvider().getRowObject(rowPosition);
        switch (this.columns.get(columnPosition)) {
            case NAME: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetName);
                break;
            }
            case TYPE: {
                configLabels.addLabel("TYPE_DECLARATION_CELL");
                this.accumulateAttributeConfigLabels(configLabels, rowItem, FordiacAnnotationUtil::showOnTargetType);
                if (!rowItem.isArray()) break;
                this.accumulateAttributeConfigLabels(configLabels, rowItem.getArraySize());
                break;
            }
            case COMMENT: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                if (CommentHelper.hasComment((INamedElement)rowItem)) break;
                configLabels.addLabelOnTop("DEFAULT_CELL");
                break;
            }
            case INITIAL_VALUE: {
                if (rowItem.getType() instanceof StructuredType || rowItem.isArray()) {
                    configLabels.addLabel("INITIAL_VALUE_STRUCTURED_CELL");
                } else {
                    configLabels.addLabel("INITIAL_VALUE_CELL");
                }
                if (InitialValueHelper.hasInitalValue((Object)rowItem)) {
                    this.accumulateAttributeConfigLabels(configLabels, rowItem.getValue());
                    break;
                }
                configLabels.addLabelOnTop("DEFAULT_CELL");
                break;
            }
            case VAR_CONFIG: {
                configLabels.addLabelOnTop("CHECKBOX_CELL");
                break;
            }
            case VISIBLE: 
            case VISIBLEIN: 
            case VISIBLEOUT: {
                configLabels.addLabelOnTop("CHECKBOX_CELL");
                break;
            }
            case RETAIN: {
                configLabels.addLabelOnTop("RETAIN_CONFIG_CELL");
                break;
            }
            case LOCATION: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                break;
            }
            case PATH: {
                configLabels.addLabelOnTop("LEFT_ALIGNMENT");
                break;
            }
        }
    }
}

