/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.preferences;

import org.eclipse.core.resources.IProject;
import org.eclipse.draw2d.FigureUtilities;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.fordiac.ide.model.ui.preferences.IGraphicalPreferencesCache;
import org.eclipse.fordiac.ide.ui.preferences.PreferenceStoreProvider;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.graphics.Font;

public class GefPreferenceConstantsCache
implements IGraphicalPreferencesCache {
    private final IProject project;
    private final PreferenceStoreProvider storeProvider;
    private final int maxDefaultValueLength;
    private final int maxHiddenConnectionLabelSize;
    private final int maxInterfaceBarSize;
    private final int maxPinLabelSize;
    private final int maxTypeLabelSize;
    private final int maxValueLabelSize;
    private final int minInterfaceBarSize;
    private final int minPinLabelSize;
    private final String pinLabelStyle;
    private final boolean snapToGrid;
    private static final int LEFT_RIGHT_MARGIN = 5;

    public GefPreferenceConstantsCache(IProject project) {
        this.project = project;
        this.storeProvider = new PreferenceStoreProvider("org.eclipse.fordiac.ide.gef", project);
        IPreferenceStore store = this.storeProvider.getStore();
        Dimension singleCharLength = FigureUtilities.getStringExtents((String)" ", (Font)JFaceResources.getFontRegistry().get("org.eclipse.fordiac.ide.preferences.diagramFontDefinition"));
        this.minInterfaceBarSize = singleCharLength.width * store.getInt("MinInterfaceBarSize") + 6 + 5;
        this.maxInterfaceBarSize = store.getInt("MaxInterfaceBarSize");
        this.maxHiddenConnectionLabelSize = singleCharLength.width * store.getInt("MaxHiddenConnectionLabelSize");
        this.maxDefaultValueLength = store.getInt("MaxDefaultValueLength");
        this.maxTypeLabelSize = store.getInt("MaxTypeLabelSize");
        this.maxValueLabelSize = store.getInt("MaxValueLabelSize");
        this.minPinLabelSize = store.getInt("MinPinLabelSize");
        this.maxPinLabelSize = store.getInt("MaxPinLabelSize");
        this.pinLabelStyle = store.getString("PinLabelStyle");
        this.snapToGrid = store.getBoolean("SnapToGrid");
    }

    public PreferenceStoreProvider getStoreProvider() {
        return this.storeProvider;
    }

    public IProject getProject() {
        return this.project;
    }

    public int getMaxDefaultValueLength() {
        return this.maxDefaultValueLength;
    }

    public int getMaxHiddenConnectionLabelSize() {
        return this.maxHiddenConnectionLabelSize;
    }

    public int getMaxInterfaceBarSize() {
        return this.maxInterfaceBarSize;
    }

    public int getMaxPinLabelSize() {
        return this.maxPinLabelSize;
    }

    public int getMaxTypeLabelSize() {
        return this.maxTypeLabelSize;
    }

    public int getMaxValueLabelSize() {
        return this.maxValueLabelSize;
    }

    public int getMinInterfaceBarSize() {
        return this.minInterfaceBarSize;
    }

    public int getMinPinLabelSize() {
        return this.minPinLabelSize;
    }

    public String getPinLabelStyle() {
        return this.pinLabelStyle;
    }

    public boolean isSnapToGrid() {
        return this.snapToGrid;
    }
}

