/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.gef.properties;

import org.eclipse.emf.ecore.EObject;
import org.eclipse.fordiac.ide.gef.Messages;
import org.eclipse.fordiac.ide.gef.properties.AbstractSection;
import org.eclipse.fordiac.ide.model.commands.change.ChangeConnectionCommentCommand;
import org.eclipse.fordiac.ide.model.commands.change.HideConnectionCommand;
import org.eclipse.fordiac.ide.model.commands.change.NegateConnectionCommand;
import org.eclipse.fordiac.ide.model.datatype.helper.IecTypes;
import org.eclipse.fordiac.ide.model.libraryElement.CompositeFBType;
import org.eclipse.fordiac.ide.model.libraryElement.Connection;
import org.eclipse.fordiac.ide.model.libraryElement.FBNetworkElement;
import org.eclipse.fordiac.ide.model.libraryElement.IInterfaceElement;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.commands.Command;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.views.properties.tabbed.TabbedPropertySheetPage;

public class ConnectionSection
extends AbstractSection {
    private Text commentText;
    private Text sourceText;
    private Text targetText;
    private Button showConnectionButton;
    private Button negateConnectionButton;
    private CLabel negateConnectionLabel;

    protected Connection getType() {
        return (Connection)this.type;
    }

    private Connection getConnection() {
        return this.getType();
    }

    @Override
    public void createControls(Composite parent, TabbedPropertySheetPage tabbedPropertySheetPage) {
        super.createControls(parent, tabbedPropertySheetPage);
        Composite composite = this.getWidgetFactory().createComposite(parent);
        composite.setLayout((Layout)new GridLayout(2, false));
        composite.setLayoutData((Object)new GridData(4, 0, true, false));
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Source);
        this.sourceText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Target);
        this.targetText = this.createGroupText(composite, false);
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_Comment);
        this.commentText = this.createGroupText(composite, true);
        this.commentText.addModifyListener(event -> {
            this.removeContentAdapter();
            this.executeCommand((Command)new ChangeConnectionCommentCommand(this.getType(), this.commentText.getText()));
            this.addContentAdapter();
        });
        this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_ShowConnection);
        this.showConnectionButton = this.getWidgetFactory().createButton(composite, "", 32);
        this.showConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Button btn = (Button)e.getSource();
                boolean visible = btn.getSelection();
                ConnectionSection.this.executeCommand((Command)new HideConnectionCommand(ConnectionSection.this.getConnection(), visible));
            }
        });
        this.negateConnectionLabel = this.getWidgetFactory().createCLabel(composite, Messages.ConnectionSection_NegateConnection);
        this.negateConnectionButton = this.getWidgetFactory().createButton(composite, "", 32);
        this.negateConnectionButton.setEnabled(false);
        this.negateConnectionButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                boolean negated = ConnectionSection.this.negateConnectionButton.getSelection();
                ConnectionSection.this.executeCommand((Command)new NegateConnectionCommand(ConnectionSection.this.getConnection(), negated));
            }
        });
    }

    @Override
    protected void performRefresh() {
        this.commentText.setText(this.getType().getComment() != null ? this.getType().getComment() : "");
        if (this.getType().getSource() != null) {
            this.sourceText.setText(ConnectionSection.getFBNameFromIInterfaceElement(this.getType().getSource()) + "." + this.getType().getSource().getName());
            if (this.isViewer()) {
                this.commentText.setEditable(false);
                this.commentText.setEnabled(false);
            } else {
                this.commentText.setEditable(true);
                this.commentText.setEnabled(true);
            }
        }
        if (this.getType().getDestination() != null) {
            this.targetText.setText(ConnectionSection.getFBNameFromIInterfaceElement(this.getType().getDestination()) + "." + this.getType().getDestination().getName());
        }
        this.showConnectionButton.setSelection(this.getConnection().isVisible());
        boolean isBooleanConnection = false;
        if (this.getConnection().getSource() != null && this.getConnection().getDestination() != null) {
            isBooleanConnection = this.getConnection().getSource().getType() == IecTypes.ElementaryTypes.BOOL && this.getConnection().getDestination().getType() == IecTypes.ElementaryTypes.BOOL;
        }
        this.negateConnectionLabel.setVisible(isBooleanConnection);
        this.negateConnectionButton.setVisible(isBooleanConnection);
        this.negateConnectionButton.setSelection(this.getConnection().isNegated());
        this.negateConnectionButton.setEnabled(isBooleanConnection);
    }

    private boolean isViewer() {
        FBNetworkElement fbne;
        EObject sourceBlock = this.getType().getSource().eContainer().eContainer();
        return sourceBlock instanceof CompositeFBType || sourceBlock instanceof FBNetworkElement && (fbne = (FBNetworkElement)sourceBlock).isContainedInTypedInstance();
    }

    protected Connection getInputType(Object input) {
        Connection con;
        Object inputHelper;
        if (input instanceof EditPart) {
            EditPart ep = (EditPart)input;
            v0 = ep.getModel();
        } else {
            v0 = inputHelper = input;
        }
        if (inputHelper instanceof Connection && ConnectionSection.isValidConnection(con = (Connection)inputHelper)) {
            return con;
        }
        return null;
    }

    private static boolean isValidConnection(Connection con) {
        return con.eContainer() != null && con.getSource() != null && con.getDestination() != null && con.getSource().eContainer() != null && con.getDestination().eContainer() != null;
    }

    private static String getFBNameFromIInterfaceElement(IInterfaceElement element) {
        String string;
        EObject eObject = element.eContainer().eContainer();
        if (eObject instanceof FBNetworkElement) {
            FBNetworkElement fbne = (FBNetworkElement)eObject;
            string = fbne.getName();
        } else {
            string = "";
        }
        return string;
    }

    @Override
    protected void setInputCode() {
    }

    @Override
    protected void setInputInit() {
    }
}

