/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fordiac.ide.systemmanagement;

import java.net.URI;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.eclipse.core.resources.ICommand;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.fordiac.ide.library.model.library.Required;
import org.eclipse.fordiac.ide.library.model.util.ManifestHelper;
import org.eclipse.fordiac.ide.model.dataimport.SystemImporter;
import org.eclipse.fordiac.ide.model.libraryElement.AutomationSystem;
import org.eclipse.fordiac.ide.model.libraryElement.LibraryElement;
import org.eclipse.fordiac.ide.model.typelibrary.SystemEntry;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibrary;
import org.eclipse.fordiac.ide.model.typelibrary.TypeLibraryManager;
import org.eclipse.fordiac.ide.systemmanagement.changelistener.FordiacResourceChangeListener;

public enum SystemManager {
    INSTANCE;

    public static final String FORDIAC_PROJECT_NATURE_ID = "org.eclipse.fordiac.ide.systemmanagement.FordiacNature";
    public static final String FORDIAC_EXPORT_BUILDER_ID = "org.eclipse.fordiac.ide.export.builder";
    public static final String ROBOT_PROJECT_NATURE_ID = "org.robotframework.ide.eclipse.main.plugin.robotNature";
    public static final String OLD_DISTRIBUTED_PROJECT_NATURE_ID = "org.fordiac.systemManagement.DistributedNature";
    public static final String SYSTEM_FILE_ENDING = "sys";
    public static final String SYSTEM_FILE_ENDING_WITH_DOT = ".sys";
    private final IResourceChangeListener fordiacListener = new FordiacResourceChangeListener();

    private SystemManager() {
        this.addFordiacChangeListener();
    }

    public static boolean isSystemFile(Object entry) {
        IFile file;
        IPath path;
        return entry instanceof IPath && SYSTEM_FILE_ENDING.equalsIgnoreCase((path = (IPath)entry).getFileExtension()) || entry instanceof IFile && SYSTEM_FILE_ENDING.equalsIgnoreCase((file = (IFile)entry).getFileExtension());
    }

    public IProject createNew4diacProject(String projectName, IPath location, Map<Required, URI> includedLibraries, IProgressMonitor monitor) throws CoreException {
        IWorkspaceRoot root = ResourcesPlugin.getWorkspace().getRoot();
        IProject project = root.getProject(projectName);
        IProjectDescription description = ResourcesPlugin.getWorkspace().newProjectDescription(project.getName());
        HashMap includes = new HashMap();
        includedLibraries.forEach((key, value) -> {
            URI uRI = includes.put(key.getSymbolicName(), value);
        });
        if (!Platform.getLocation().equals((Object)location)) {
            description.setLocation(location);
        }
        description.setNatureIds(SystemManager.getNatureIDs());
        List<ICommand> commands = Stream.of(SystemManager.getBuilderIDs()).map(builder -> {
            ICommand command = description.newCommand();
            command.setBuilderName(builder);
            return command;
        }).toList();
        description.setBuildSpec(commands.toArray(new ICommand[commands.size()]));
        project.create(description, monitor);
        project.open(monitor);
        project.getFolder("Type Library").create(true, true, monitor);
        project.getFolder("Standard Libraries").create(8193, true, monitor);
        project.getFolder("External Libraries").create(8193, true, monitor);
        ManifestHelper.createProjectManifest((IProject)project, includedLibraries.keySet());
        TypeLibraryManager.INSTANCE.getTypeLibrary(project);
        project.refreshLocal(1, monitor);
        return project;
    }

    public synchronized AutomationSystem createNewSystem(IContainer location, String name, IProgressMonitor monitor) throws CoreException {
        IFile systemFile = location.getFile((IPath)new Path(name + SYSTEM_FILE_ENDING_WITH_DOT));
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(systemFile.getProject());
        AutomationSystem system = SystemImporter.createAutomationSystem();
        system.setName(name);
        typeLibrary.createTypeEntry(systemFile).save((LibraryElement)system, monitor);
        return system;
    }

    private static SystemEntry initSystem(IFile systemFile) {
        if (systemFile.exists()) {
            return (SystemEntry)TypeLibraryManager.INSTANCE.getTypeLibrary(systemFile.getProject()).createTypeEntry(systemFile);
        }
        return null;
    }

    public synchronized AutomationSystem getSystem(IFile systemFile) {
        TypeLibrary typeLibrary = TypeLibraryManager.INSTANCE.getTypeLibrary(systemFile.getProject());
        SystemEntry sysEntry = (SystemEntry)typeLibrary.getTypeEntry(systemFile);
        if (sysEntry == null) {
            sysEntry = SystemManager.initSystem(systemFile);
        }
        return sysEntry != null ? sysEntry.getSystem() : null;
    }

    public synchronized List<AutomationSystem> getProjectSystems(IProject project) {
        return TypeLibraryManager.INSTANCE.getTypeLibrary(project).getSystems().stream().map(SystemEntry::getSystem).toList();
    }

    private static String[] getNatureIDs() {
        return new String[]{FORDIAC_PROJECT_NATURE_ID, "org.eclipse.xtext.ui.shared.xtextNature"};
    }

    private static String[] getBuilderIDs() {
        return new String[]{"org.eclipse.xtext.ui.shared.xtextBuilder", FORDIAC_EXPORT_BUILDER_ID};
    }

    public void removeFordiacChangeListener() {
        ResourcesPlugin.getWorkspace().removeResourceChangeListener(this.fordiacListener);
    }

    public void addFordiacChangeListener() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.fordiacListener);
    }
}

